/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;

public final class UnsupportedDateTimeField
extends DateTimeField
implements Serializable {
    private static HashMap<DateTimeFieldType, UnsupportedDateTimeField> cCache;
    private final DateTimeFieldType iType;
    private final DurationField iDurationField;

    public static synchronized UnsupportedDateTimeField getInstance(DateTimeFieldType dateTimeFieldType, DurationField durationField) {
        UnsupportedDateTimeField unsupportedDateTimeField;
        if (cCache == null) {
            cCache = new HashMap(7);
            unsupportedDateTimeField = null;
        } else {
            unsupportedDateTimeField = cCache.get(dateTimeFieldType);
            if (unsupportedDateTimeField != null) {
                UnsupportedDateTimeField unsupportedDateTimeField2 = unsupportedDateTimeField;
                if (unsupportedDateTimeField2.iDurationField != durationField) {
                    unsupportedDateTimeField = null;
                }
            }
        }
        if (unsupportedDateTimeField == null) {
            unsupportedDateTimeField = new UnsupportedDateTimeField(dateTimeFieldType, durationField);
            cCache.put(dateTimeFieldType, unsupportedDateTimeField);
        }
        return unsupportedDateTimeField;
    }

    private UnsupportedDateTimeField(DateTimeFieldType dateTimeFieldType, DurationField durationField) {
        if (dateTimeFieldType == null || durationField == null) {
            throw new IllegalArgumentException();
        }
        this.iType = dateTimeFieldType;
        this.iDurationField = durationField;
    }

    public final DateTimeFieldType getType() {
        return this.iType;
    }

    public final String getName() {
        return this.iType.getName();
    }

    public final boolean isSupported() {
        return false;
    }

    public final boolean isLenient() {
        return false;
    }

    public final int get(long l) {
        throw this.unsupported();
    }

    public final String getAsText(long l, Locale locale) {
        throw this.unsupported();
    }

    public final String getAsText(int n, Locale locale) {
        throw this.unsupported();
    }

    public final String getAsShortText(long l, Locale locale) {
        throw this.unsupported();
    }

    public final String getAsShortText(int n, Locale locale) {
        throw this.unsupported();
    }

    public final long add(long l, int n) {
        UnsupportedDateTimeField unsupportedDateTimeField = this;
        return unsupportedDateTimeField.iDurationField.add(l, n);
    }

    public final long add(long l, long l2) {
        UnsupportedDateTimeField unsupportedDateTimeField = this;
        return unsupportedDateTimeField.iDurationField.add(l, l2);
    }

    public final int getDifference(long l, long l2) {
        UnsupportedDateTimeField unsupportedDateTimeField = this;
        return unsupportedDateTimeField.iDurationField.getDifference(l, l2);
    }

    public final long getDifferenceAsLong(long l, long l2) {
        UnsupportedDateTimeField unsupportedDateTimeField = this;
        return unsupportedDateTimeField.iDurationField.getDifferenceAsLong(l, l2);
    }

    public final long set(long l, int n) {
        throw this.unsupported();
    }

    public final long set(long l, String string, Locale locale) {
        throw this.unsupported();
    }

    public final DurationField getDurationField() {
        return this.iDurationField;
    }

    public final DurationField getRangeDurationField() {
        return null;
    }

    public final boolean isLeap(long l) {
        throw this.unsupported();
    }

    public final DurationField getLeapDurationField() {
        return null;
    }

    public final int getMinimumValue() {
        throw this.unsupported();
    }

    public final int getMaximumValue() {
        throw this.unsupported();
    }

    public final int getMaximumValue(long l) {
        throw this.unsupported();
    }

    public final int getMaximumTextLength(Locale locale) {
        throw this.unsupported();
    }

    public final long roundFloor(long l) {
        throw this.unsupported();
    }

    public final long remainder(long l) {
        throw this.unsupported();
    }

    public final String toString() {
        return "UnsupportedDateTimeField";
    }

    private UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException(this.iType + " field is unsupported");
    }
}

