/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.format.ISODateTimeFormat;

public final class ZeroIsMaxDateTimeField
extends DecoratedDateTimeField {
    public ZeroIsMaxDateTimeField(DateTimeField dateTimeField, DateTimeFieldType dateTimeFieldType) {
        super(dateTimeField, dateTimeFieldType);
        if (dateTimeField.getMinimumValue() != 0) {
            throw new IllegalArgumentException("Wrapped field's minumum value must be zero");
        }
    }

    public final int get(long l) {
        int n = this.getWrappedField().get(l);
        if (n == 0) {
            n = this.getMaximumValue();
        }
        return n;
    }

    public final long add(long l, int n) {
        return this.getWrappedField().add(l, n);
    }

    public final long add(long l, long l2) {
        return this.getWrappedField().add(l, l2);
    }

    public final int getDifference(long l, long l2) {
        return this.getWrappedField().getDifference(l, l2);
    }

    public final long getDifferenceAsLong(long l, long l2) {
        return this.getWrappedField().getDifferenceAsLong(l, l2);
    }

    public final long set(long l, int n) {
        int n2 = this.getMaximumValue();
        ISODateTimeFormat.verifyValueBounds(this, n, 1, n2);
        if (n == n2) {
            n = 0;
        }
        return this.getWrappedField().set(l, n);
    }

    public final boolean isLeap(long l) {
        return this.getWrappedField().isLeap(l);
    }

    public final DurationField getLeapDurationField() {
        return this.getWrappedField().getLeapDurationField();
    }

    public final int getMinimumValue() {
        return 1;
    }

    public final int getMaximumValue() {
        return this.getWrappedField().getMaximumValue() + 1;
    }

    public final int getMaximumValue(long l) {
        return this.getWrappedField().getMaximumValue(l) + 1;
    }

    public final long roundFloor(long l) {
        return this.getWrappedField().roundFloor(l);
    }

    public final long remainder(long l) {
        return this.getWrappedField().remainder(l);
    }
}

