/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public final class DateTimeFormat {
    private static final ConcurrentHashMap<String, DateTimeFormatter> cPatternCache = new ConcurrentHashMap();

    public static DateTimeFormatter forPattern(String object) {
        if (object == null || ((String)object).length() == 0) {
            throw new IllegalArgumentException("Invalid pattern specification");
        }
        Object object2 = cPatternCache.get(object);
        if (object2 == null) {
            object2 = new DateTimeFormatterBuilder();
            DateTimeFormat.parsePatternTo((DateTimeFormatterBuilder)object2, (String)object);
            object2 = ((DateTimeFormatterBuilder)object2).toFormatter();
            if (cPatternCache.size() < 500 && (object = cPatternCache.putIfAbsent((String)object, (DateTimeFormatter)object2)) != null) {
                object2 = object;
            }
        }
        return object2;
    }

    private static void parsePatternTo(DateTimeFormatterBuilder dateTimeFormatterBuilder, String string) {
        int n = string.length();
        int[] nArray = new int[1];
        block30: for (int i = 0; i < n; ++i) {
            nArray[0] = i;
            String string2 = DateTimeFormat.parseToken(string, nArray);
            i = nArray[0];
            int n2 = string2.length();
            if (n2 == 0) break;
            int n3 = string2.charAt(0);
            switch (n3) {
                case 71: {
                    DateTimeFormatterBuilder dateTimeFormatterBuilder2 = dateTimeFormatterBuilder;
                    dateTimeFormatterBuilder2.appendText(DateTimeFieldType.era());
                    continue block30;
                }
                case 67: {
                    int n4 = n3 = n2;
                    DateTimeFormatterBuilder dateTimeFormatterBuilder3 = dateTimeFormatterBuilder;
                    dateTimeFormatterBuilder3.appendSignedDecimal(DateTimeFieldType.centuryOfEra(), n4, n3);
                    continue block30;
                }
                case 89: 
                case 120: 
                case 121: {
                    if (n2 == 2) {
                        boolean bl = true;
                        if (i + 1 < n) {
                            nArray[0] = nArray[0] + 1;
                            if (DateTimeFormat.isNumericToken(DateTimeFormat.parseToken(string, nArray))) {
                                bl = false;
                            }
                            nArray[0] = nArray[0] - 1;
                        }
                        switch (n3) {
                            case 120: {
                                DateTime dateTime = new DateTime();
                                dateTimeFormatterBuilder.appendTwoDigitWeekyear(dateTime.getChronology().weekyear().get(dateTime.getMillis()) - 30, bl);
                                continue block30;
                            }
                        }
                        DateTime dateTime = new DateTime();
                        dateTimeFormatterBuilder.appendTwoDigitYear(dateTime.getChronology().year().get(dateTime.getMillis()) - 30, bl);
                        continue block30;
                    }
                    int n5 = 9;
                    if (i + 1 < n) {
                        nArray[0] = nArray[0] + 1;
                        if (DateTimeFormat.isNumericToken(DateTimeFormat.parseToken(string, nArray))) {
                            n5 = n2;
                        }
                        nArray[0] = nArray[0] - 1;
                    }
                    switch (n3) {
                        case 120: {
                            dateTimeFormatterBuilder.appendWeekyear(n2, n5);
                            break;
                        }
                        case 121: {
                            dateTimeFormatterBuilder.appendYear(n2, n5);
                            break;
                        }
                        case 89: {
                            n3 = n5;
                            n5 = n2;
                            DateTimeFormatterBuilder dateTimeFormatterBuilder4 = dateTimeFormatterBuilder;
                            dateTimeFormatterBuilder4.appendDecimal(DateTimeFieldType.yearOfEra(), n5, n3);
                        }
                    }
                    continue block30;
                }
                case 77: {
                    if (n2 >= 3) {
                        if (n2 >= 4) {
                            DateTimeFormatterBuilder dateTimeFormatterBuilder5 = dateTimeFormatterBuilder;
                            dateTimeFormatterBuilder5.appendText(DateTimeFieldType.monthOfYear());
                            continue block30;
                        }
                        DateTimeFormatterBuilder dateTimeFormatterBuilder6 = dateTimeFormatterBuilder;
                        dateTimeFormatterBuilder6.appendShortText(DateTimeFieldType.monthOfYear());
                        continue block30;
                    }
                    dateTimeFormatterBuilder.appendMonthOfYear(n2);
                    continue block30;
                }
                case 100: {
                    dateTimeFormatterBuilder.appendDayOfMonth(n2);
                    continue block30;
                }
                case 97: {
                    DateTimeFormatterBuilder dateTimeFormatterBuilder7 = dateTimeFormatterBuilder;
                    dateTimeFormatterBuilder7.appendText(DateTimeFieldType.halfdayOfDay());
                    continue block30;
                }
                case 104: {
                    int n6 = n2;
                    DateTimeFormatterBuilder dateTimeFormatterBuilder8 = dateTimeFormatterBuilder;
                    dateTimeFormatterBuilder8.appendDecimal(DateTimeFieldType.clockhourOfHalfday(), n6, 2);
                    continue block30;
                }
                case 72: {
                    dateTimeFormatterBuilder.appendHourOfDay(n2);
                    continue block30;
                }
                case 107: {
                    int n7 = n2;
                    DateTimeFormatterBuilder dateTimeFormatterBuilder9 = dateTimeFormatterBuilder;
                    dateTimeFormatterBuilder9.appendDecimal(DateTimeFieldType.clockhourOfDay(), n7, 2);
                    continue block30;
                }
                case 75: {
                    int n8 = n2;
                    DateTimeFormatterBuilder dateTimeFormatterBuilder10 = dateTimeFormatterBuilder;
                    dateTimeFormatterBuilder10.appendDecimal(DateTimeFieldType.hourOfHalfday(), n8, 2);
                    continue block30;
                }
                case 109: {
                    dateTimeFormatterBuilder.appendMinuteOfHour(n2);
                    continue block30;
                }
                case 115: {
                    dateTimeFormatterBuilder.appendSecondOfMinute(n2);
                    continue block30;
                }
                case 83: {
                    int n9 = n2;
                    dateTimeFormatterBuilder.appendFractionOfSecond(n9, n9);
                    continue block30;
                }
                case 101: {
                    dateTimeFormatterBuilder.appendDayOfWeek(n2);
                    continue block30;
                }
                case 69: {
                    if (n2 >= 4) {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder11 = dateTimeFormatterBuilder;
                        dateTimeFormatterBuilder11.appendText(DateTimeFieldType.dayOfWeek());
                        continue block30;
                    }
                    DateTimeFormatterBuilder dateTimeFormatterBuilder12 = dateTimeFormatterBuilder;
                    dateTimeFormatterBuilder12.appendShortText(DateTimeFieldType.dayOfWeek());
                    continue block30;
                }
                case 68: {
                    dateTimeFormatterBuilder.appendDayOfYear(n2);
                    continue block30;
                }
                case 119: {
                    dateTimeFormatterBuilder.appendWeekOfWeekyear(n2);
                    continue block30;
                }
                case 122: {
                    if (n2 >= 4) {
                        dateTimeFormatterBuilder.appendTimeZoneName();
                        continue block30;
                    }
                    dateTimeFormatterBuilder.appendTimeZoneShortName(null);
                    continue block30;
                }
                case 90: {
                    if (n2 == 1) {
                        dateTimeFormatterBuilder.appendTimeZoneOffset(null, "Z", false, 2, 2);
                        continue block30;
                    }
                    if (n2 == 2) {
                        dateTimeFormatterBuilder.appendTimeZoneOffset(null, "Z", true, 2, 2);
                        continue block30;
                    }
                    dateTimeFormatterBuilder.appendTimeZoneId();
                    continue block30;
                }
                case 39: {
                    string2 = string2.substring(1);
                    if (string2.length() == 1) {
                        dateTimeFormatterBuilder.appendLiteral(string2.charAt(0));
                        continue block30;
                    }
                    dateTimeFormatterBuilder.appendLiteral(new String(string2));
                    continue block30;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + string2);
                }
            }
        }
    }

    private static String parseToken(String string, int[] nArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        char c = string.charAt(n);
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            char c2;
            stringBuilder.append(c);
            while (n + 1 < n2 && (c2 = string.charAt(n + 1)) == c) {
                stringBuilder.append(c);
                ++n;
            }
        } else {
            stringBuilder.append('\'');
            boolean bl = false;
            for (n = nArray[0]; n < n2; ++n) {
                c = string.charAt(n);
                if (c == '\'') {
                    if (n + 1 < n2 && string.charAt(n + 1) == '\'') {
                        ++n;
                        stringBuilder.append(c);
                        continue;
                    }
                    bl = !bl;
                    continue;
                }
                if (bl || (c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) {
                    stringBuilder.append(c);
                    continue;
                }
                break;
            }
        }
        nArray[0] = --n;
        return stringBuilder.toString();
    }

    private static boolean isNumericToken(String string) {
        int n = string.length();
        if (n > 0) {
            char c = string.charAt(0);
            switch (c) {
                case 'C': 
                case 'D': 
                case 'F': 
                case 'H': 
                case 'K': 
                case 'S': 
                case 'W': 
                case 'Y': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'h': 
                case 'k': 
                case 'm': 
                case 's': 
                case 'w': 
                case 'x': 
                case 'y': {
                    return true;
                }
                case 'M': {
                    if (n > 2) break;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        new AtomicReferenceArray(25);
    }
}

