/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.FormatUtils;
import org.joda.time.format.InternalParser;
import org.joda.time.format.InternalParserDateTimeParser;
import org.joda.time.format.InternalPrinter;

public final class DateTimeFormatter {
    private final InternalPrinter iPrinter;
    private final InternalParser iParser;
    private final Locale iLocale;
    private final boolean iOffsetParsed;
    private final Chronology iChrono;
    private final DateTimeZone iZone;
    private final Integer iPivotYear;
    private final int iDefaultYear;

    DateTimeFormatter(InternalPrinter internalPrinter, InternalParser internalParser) {
        this.iPrinter = internalPrinter;
        this.iParser = internalParser;
        this.iLocale = null;
        this.iOffsetParsed = false;
        this.iChrono = null;
        this.iZone = null;
        this.iPivotYear = null;
        this.iDefaultYear = 2000;
    }

    private DateTimeFormatter(InternalPrinter internalPrinter, InternalParser internalParser, Locale locale, boolean bl, Chronology chronology, DateTimeZone dateTimeZone, Integer n, int n2) {
        this.iPrinter = internalPrinter;
        this.iParser = internalParser;
        this.iLocale = locale;
        this.iOffsetParsed = bl;
        this.iChrono = chronology;
        this.iZone = dateTimeZone;
        this.iPivotYear = n;
        this.iDefaultYear = n2;
    }

    final InternalPrinter getPrinter0() {
        return this.iPrinter;
    }

    public final DateTimeParser getParser() {
        return InternalParserDateTimeParser.of(this.iParser);
    }

    final InternalParser getParser0() {
        return this.iParser;
    }

    public final DateTimeFormatter withChronology(Chronology chronology) {
        if (this.iChrono == chronology) {
            return this;
        }
        return new DateTimeFormatter(this.iPrinter, this.iParser, this.iLocale, this.iOffsetParsed, chronology, this.iZone, this.iPivotYear, this.iDefaultYear);
    }

    public final DateTimeFormatter withZoneUTC() {
        DateTimeZone dateTimeZone = DateTimeZone.UTC;
        DateTimeFormatter dateTimeFormatter = this;
        if (dateTimeFormatter.iZone == dateTimeZone) {
            return dateTimeFormatter;
        }
        return new DateTimeFormatter(dateTimeFormatter.iPrinter, dateTimeFormatter.iParser, dateTimeFormatter.iLocale, false, dateTimeFormatter.iChrono, dateTimeZone, dateTimeFormatter.iPivotYear, dateTimeFormatter.iDefaultYear);
    }

    public final String print(ReadableInstant object) {
        StringBuilder stringBuilder = new StringBuilder(this.requirePrinter().estimatePrintedLength());
        try {
            Object object2 = object;
            StringBuilder stringBuilder2 = stringBuilder;
            object = this;
            long l = DateTimeUtils.getInstantMillis((ReadableInstant)object2);
            object2 = DateTimeUtils.getInstantChronology((ReadableInstant)object2);
            long l2 = l;
            InternalPrinter internalPrinter = super.requirePrinter();
            object2 = super.selectChronology((Chronology)object2);
            DateTimeZone dateTimeZone = ((Chronology)object2).getZone();
            int n = dateTimeZone.getOffset(l2);
            long l3 = l2 + (long)n;
            if ((l2 ^ l3) < 0L && (l2 ^ (long)n) >= 0L) {
                dateTimeZone = DateTimeZone.UTC;
                n = 0;
                l3 = l2;
            }
            internalPrinter.printTo(stringBuilder2, l3, ((Chronology)object2).withUTC(), n, dateTimeZone, ((DateTimeFormatter)object).iLocale);
        }
        catch (IOException iOException) {}
        return stringBuilder.toString();
    }

    private InternalPrinter requirePrinter() {
        InternalPrinter internalPrinter = this.iPrinter;
        if (internalPrinter == null) {
            throw new UnsupportedOperationException("Printing not supported");
        }
        return internalPrinter;
    }

    public final long parseMillis(String string) {
        Object object = this;
        Object object2 = ((DateTimeFormatter)object).iParser;
        if (object2 == null) {
            throw new UnsupportedOperationException("Parsing not supported");
        }
        object = object2;
        DateTimeFormatter dateTimeFormatter = this;
        object2 = dateTimeFormatter.selectChronology(dateTimeFormatter.iChrono);
        object2 = new DateTimeParserBucket(0L, (Chronology)object2, this.iLocale, this.iPivotYear, this.iDefaultYear);
        object2 = object;
        int n = object2.parseInto((DateTimeParserBucket)(object = object2), string, 0);
        if (n >= 0) {
            if (n >= string.length()) {
                return ((DateTimeParserBucket)object).computeMillis(true, string);
            }
        } else {
            n ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(string.toString(), n));
    }

    private Chronology selectChronology(Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        if (this.iChrono != null) {
            chronology = this.iChrono;
        }
        if (this.iZone != null) {
            chronology = chronology.withZone(this.iZone);
        }
        return chronology;
    }
}

