/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.field.AbstractReadableInstantFieldProperty;
import org.joda.time.field.MillisDurationField;
import org.joda.time.field.PreciseDateTimeField;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimeParserInternalParser;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.DateTimePrinterInternalPrinter;
import org.joda.time.format.FormatUtils;
import org.joda.time.format.InternalParser;
import org.joda.time.format.InternalParserDateTimeParser;
import org.joda.time.format.InternalPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DateTimeFormatterBuilder {
    private ArrayList<Object> iElementPairs = new ArrayList();
    private Object iFormatter;

    public final DateTimeFormatter toFormatter() {
        Object object = this.getFormatter();
        InternalPrinter internalPrinter = null;
        Object object2 = object;
        boolean bl = object2 instanceof InternalPrinter ? (object2 instanceof Composite ? ((Composite)object2).isPrinter() : true) : false;
        if (bl) {
            internalPrinter = (InternalPrinter)object;
        }
        object2 = null;
        if (DateTimeFormatterBuilder.isParser(object)) {
            object2 = (InternalParser)object;
        }
        if (internalPrinter != null || object2 != null) {
            return new DateTimeFormatter(internalPrinter, (InternalParser)object2);
        }
        throw new UnsupportedOperationException("Both printing and parsing not supported");
    }

    public final DateTimeParser toParser() {
        Object object = this.getFormatter();
        if (DateTimeFormatterBuilder.isParser(object)) {
            object = (InternalParser)object;
            return InternalParserDateTimeParser.of((InternalParser)object);
        }
        throw new UnsupportedOperationException("Parsing is not supported");
    }

    public final DateTimeFormatterBuilder append(DateTimeFormatter dateTimeFormatter) {
        if (dateTimeFormatter == null) {
            throw new IllegalArgumentException("No formatter supplied");
        }
        return this.append0(dateTimeFormatter.getPrinter0(), dateTimeFormatter.getParser0());
    }

    public final DateTimeFormatterBuilder append(DateTimeParser dateTimeParser) {
        DateTimeFormatterBuilder.checkParser(dateTimeParser);
        return this.append0(null, DateTimeParserInternalParser.of(dateTimeParser));
    }

    public final DateTimeFormatterBuilder append(DateTimePrinter dateTimePrinter, DateTimeParser[] dateTimeParserArray) {
        int n;
        DateTimePrinter dateTimePrinter2;
        if (dateTimePrinter != null && (dateTimePrinter2 = dateTimePrinter) == null) {
            throw new IllegalArgumentException("No printer supplied");
        }
        int n2 = dateTimeParserArray.length;
        if (n2 == 1) {
            if (dateTimeParserArray[0] == null) {
                throw new IllegalArgumentException("No parser supplied");
            }
            return this.append0(DateTimePrinterInternalPrinter.of(dateTimePrinter), DateTimeParserInternalParser.of(dateTimeParserArray[0]));
        }
        InternalParser[] internalParserArray = new InternalParser[n2];
        for (n = 0; n < n2 - 1; ++n) {
            internalParserArray[n] = DateTimeParserInternalParser.of(dateTimeParserArray[n]);
            if (internalParserArray[n] != null) continue;
            throw new IllegalArgumentException("Incomplete parser array");
        }
        internalParserArray[n] = DateTimeParserInternalParser.of(dateTimeParserArray[n]);
        return this.append0(DateTimePrinterInternalPrinter.of(dateTimePrinter), new MatchingParser(internalParserArray));
    }

    public final DateTimeFormatterBuilder appendOptional(DateTimeParser internalParserArray) {
        DateTimeFormatterBuilder.checkParser((DateTimeParser)internalParserArray);
        internalParserArray = new InternalParser[]{DateTimeParserInternalParser.of((DateTimeParser)internalParserArray), null};
        return this.append0(null, new MatchingParser(internalParserArray));
    }

    private static void checkParser(DateTimeParser dateTimeParser) {
        if (dateTimeParser == null) {
            throw new IllegalArgumentException("No parser supplied");
        }
    }

    private DateTimeFormatterBuilder append0(Object object) {
        this.iFormatter = null;
        this.iElementPairs.add(object);
        this.iElementPairs.add(object);
        return this;
    }

    private DateTimeFormatterBuilder append0(InternalPrinter internalPrinter, InternalParser internalParser) {
        this.iFormatter = null;
        this.iElementPairs.add(internalPrinter);
        this.iElementPairs.add(internalParser);
        return this;
    }

    public final DateTimeFormatterBuilder appendLiteral(char c) {
        return this.append0(new CharacterLiteral(c));
    }

    public final DateTimeFormatterBuilder appendLiteral(String string) {
        switch (string.length()) {
            case 0: {
                return this;
            }
            case 1: {
                return this.append0(new CharacterLiteral(string.charAt(0)));
            }
        }
        return this.append0(new StringLiteral(string));
    }

    public final DateTimeFormatterBuilder appendDecimal(DateTimeFieldType dateTimeFieldType, int n, int n2) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n2 < n) {
            n2 = n;
        }
        if (n < 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n <= 1) {
            return this.append0(new UnpaddedNumber(dateTimeFieldType, n2, false));
        }
        return this.append0(new PaddedNumber(dateTimeFieldType, n2, false, n));
    }

    public final DateTimeFormatterBuilder appendFixedDecimal(DateTimeFieldType dateTimeFieldType, int n) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Illegal number of digits: " + n);
        }
        return this.append0(new FixedNumber(dateTimeFieldType, n, false));
    }

    public final DateTimeFormatterBuilder appendSignedDecimal(DateTimeFieldType dateTimeFieldType, int n, int n2) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n2 < n) {
            n2 = n;
        }
        if (n < 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n <= 1) {
            return this.append0(new UnpaddedNumber(dateTimeFieldType, n2, true));
        }
        return this.append0(new PaddedNumber(dateTimeFieldType, n2, true, n));
    }

    public final DateTimeFormatterBuilder appendText(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        return this.append0(new TextField(dateTimeFieldType, false));
    }

    public final DateTimeFormatterBuilder appendShortText(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        return this.append0(new TextField(dateTimeFieldType, true));
    }

    private DateTimeFormatterBuilder appendFraction(DateTimeFieldType dateTimeFieldType, int n, int n2) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n2 < n) {
            n2 = n;
        }
        if (n < 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        return this.append0(new Fraction(dateTimeFieldType, n, n2));
    }

    public final DateTimeFormatterBuilder appendFractionOfSecond(int n, int n2) {
        return this.appendFraction(DateTimeFieldType.secondOfDay(), n, n2);
    }

    public final DateTimeFormatterBuilder appendFractionOfMinute(int n, int n2) {
        return this.appendFraction(DateTimeFieldType.minuteOfDay(), 1, 9);
    }

    public final DateTimeFormatterBuilder appendFractionOfHour(int n, int n2) {
        return this.appendFraction(DateTimeFieldType.hourOfDay(), 1, 9);
    }

    public final DateTimeFormatterBuilder appendSecondOfMinute(int n) {
        return this.appendDecimal(DateTimeFieldType.secondOfMinute(), n, 2);
    }

    public final DateTimeFormatterBuilder appendMinuteOfHour(int n) {
        return this.appendDecimal(DateTimeFieldType.minuteOfHour(), n, 2);
    }

    public final DateTimeFormatterBuilder appendHourOfDay(int n) {
        return this.appendDecimal(DateTimeFieldType.hourOfDay(), n, 2);
    }

    public final DateTimeFormatterBuilder appendDayOfWeek(int n) {
        return this.appendDecimal(DateTimeFieldType.dayOfWeek(), n, 1);
    }

    public final DateTimeFormatterBuilder appendDayOfMonth(int n) {
        return this.appendDecimal(DateTimeFieldType.dayOfMonth(), n, 2);
    }

    public final DateTimeFormatterBuilder appendDayOfYear(int n) {
        return this.appendDecimal(DateTimeFieldType.dayOfYear(), n, 3);
    }

    public final DateTimeFormatterBuilder appendWeekOfWeekyear(int n) {
        return this.appendDecimal(DateTimeFieldType.weekOfWeekyear(), n, 2);
    }

    public final DateTimeFormatterBuilder appendWeekyear(int n, int n2) {
        return this.appendSignedDecimal(DateTimeFieldType.weekyear(), n, n2);
    }

    public final DateTimeFormatterBuilder appendMonthOfYear(int n) {
        return this.appendDecimal(DateTimeFieldType.monthOfYear(), n, 2);
    }

    public final DateTimeFormatterBuilder appendYear(int n, int n2) {
        return this.appendSignedDecimal(DateTimeFieldType.year(), n, n2);
    }

    public final DateTimeFormatterBuilder appendTwoDigitYear(int n, boolean bl) {
        return this.append0(new TwoDigitYear(DateTimeFieldType.year(), n, bl));
    }

    public final DateTimeFormatterBuilder appendTwoDigitWeekyear(int n, boolean bl) {
        return this.append0(new TwoDigitYear(DateTimeFieldType.weekyear(), n, bl));
    }

    public final DateTimeFormatterBuilder appendTimeZoneName() {
        return this.append0(new TimeZoneName(0, null), null);
    }

    public final DateTimeFormatterBuilder appendTimeZoneShortName(Map<String, DateTimeZone> object) {
        Object object2 = object = new TimeZoneName(1, (Map<String, DateTimeZone>)object);
        return this.append0((InternalPrinter)object2, (InternalParser)object2);
    }

    public final DateTimeFormatterBuilder appendTimeZoneId() {
        TimeZoneId timeZoneId = TimeZoneId.INSTANCE;
        return this.append0(timeZoneId, timeZoneId);
    }

    public final DateTimeFormatterBuilder appendTimeZoneOffset(String string, boolean bl, int n, int n2) {
        String string2 = string;
        return this.append0(new TimeZoneOffset(string2, string2, bl, 2, n2));
    }

    public final DateTimeFormatterBuilder appendTimeZoneOffset(String string, String string2, boolean bl, int n, int n2) {
        return this.append0(new TimeZoneOffset(string, string2, bl, 2, 2));
    }

    private Object getFormatter() {
        Object object = this.iFormatter;
        if (object == null) {
            if (this.iElementPairs.size() == 2) {
                Object object2 = this.iElementPairs.get(0);
                Object object3 = this.iElementPairs.get(1);
                if (object2 != null) {
                    if (object2 == object3 || object3 == null) {
                        object = object2;
                    }
                } else {
                    object = object3;
                }
            }
            if (object == null) {
                object = new Composite(this.iElementPairs);
            }
            this.iFormatter = object;
        }
        return object;
    }

    private static boolean isParser(Object object) {
        if (object instanceof InternalParser) {
            if (object instanceof Composite) {
                return ((Composite)object).isParser();
            }
            return true;
        }
        return false;
    }

    static void appendUnknownString(Appendable appendable, int n) throws IOException {
        while (--n >= 0) {
            appendable.append('\ufffd');
        }
    }

    static boolean csStartsWith(CharSequence charSequence, int n, String string) {
        int n2 = string.length();
        if (charSequence.length() - n < n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (charSequence.charAt(n + i) == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    static boolean csStartsWithIgnoreCase(CharSequence charSequence, int n, String string) {
        int n2 = string.length();
        if (charSequence.length() - n < n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            char c;
            char c2 = charSequence.charAt(n + i);
            if (c2 == (c = string.charAt(i)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    static final class MatchingParser
    implements InternalParser {
        private final InternalParser[] iParsers;
        private final int iParsedLengthEstimate;

        MatchingParser(InternalParser[] internalParserArray) {
            this.iParsers = internalParserArray;
            int n = 0;
            int n2 = internalParserArray.length;
            while (--n2 >= 0) {
                int n3;
                InternalParser internalParser = internalParserArray[n2];
                if (internalParser == null || (n3 = internalParser.estimateParsedLength()) <= n) continue;
                n = n3;
            }
            this.iParsedLengthEstimate = n;
        }

        public final int estimateParsedLength() {
            return this.iParsedLengthEstimate;
        }

        public final int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n) {
            InternalParser[] internalParserArray = this.iParsers;
            int n2 = this.iParsers.length;
            Object object = dateTimeParserBucket.saveState();
            boolean bl = false;
            int n3 = n;
            Object object2 = null;
            int n4 = n;
            for (int i = 0; i < n2; ++i) {
                InternalParser internalParser = internalParserArray[i];
                if (internalParser == null) {
                    if (n3 <= n) {
                        return n;
                    }
                    bl = true;
                    break;
                }
                int n5 = internalParser.parseInto(dateTimeParserBucket, charSequence, n);
                if (n5 >= n) {
                    if (n5 > n3) {
                        if (n5 >= charSequence.length() || i + 1 >= n2 || internalParserArray[i + 1] == null) {
                            return n5;
                        }
                        n3 = n5;
                        object2 = dateTimeParserBucket.saveState();
                    }
                } else if (n5 < 0 && (n5 ^= 0xFFFFFFFF) > n4) {
                    n4 = n5;
                }
                dateTimeParserBucket.restoreState(object);
            }
            if (n3 > n || n3 == n && bl) {
                if (object2 != null) {
                    dateTimeParserBucket.restoreState(object2);
                }
                return n3;
            }
            return ~n4;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Composite
    implements InternalParser,
    InternalPrinter {
        private final InternalPrinter[] iPrinters;
        private final InternalParser[] iParsers;
        private final int iPrintedLengthEstimate;
        private final int iParsedLengthEstimate;

        Composite(List<Object> list) {
            Object object;
            int n;
            int n2;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            this.decompose(list, arrayList, arrayList2);
            if (arrayList.contains(null) || arrayList.isEmpty()) {
                this.iPrinters = null;
                this.iPrintedLengthEstimate = 0;
            } else {
                int n3 = arrayList.size();
                this.iPrinters = new InternalPrinter[n3];
                n2 = 0;
                for (n = 0; n < n3; ++n) {
                    object = (InternalPrinter)arrayList.get(n);
                    n2 += object.estimatePrintedLength();
                    this.iPrinters[n] = object;
                }
                this.iPrintedLengthEstimate = n2;
            }
            if (arrayList2.contains(null) || arrayList2.isEmpty()) {
                this.iParsers = null;
                this.iParsedLengthEstimate = 0;
                return;
            }
            int n4 = arrayList2.size();
            this.iParsers = new InternalParser[n4];
            n2 = 0;
            for (n = 0; n < n4; ++n) {
                object = (InternalParser)arrayList2.get(n);
                n2 += object.estimateParsedLength();
                this.iParsers[n] = object;
            }
            this.iParsedLengthEstimate = n2;
        }

        @Override
        public final int estimatePrintedLength() {
            return this.iPrintedLengthEstimate;
        }

        @Override
        public final void printTo(Appendable appendable, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            InternalPrinter[] internalPrinterArray = this.iPrinters;
            if (this.iPrinters == null) {
                throw new UnsupportedOperationException();
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            int n2 = internalPrinterArray.length;
            for (int i = 0; i < n2; ++i) {
                internalPrinterArray[i].printTo(appendable, l, chronology, n, dateTimeZone, locale);
            }
        }

        @Override
        public final int estimateParsedLength() {
            return this.iParsedLengthEstimate;
        }

        @Override
        public final int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n) {
            InternalParser[] internalParserArray = this.iParsers;
            if (this.iParsers == null) {
                throw new UnsupportedOperationException();
            }
            int n2 = internalParserArray.length;
            for (int i = 0; i < n2 && n >= 0; ++i) {
                n = internalParserArray[i].parseInto(dateTimeParserBucket, charSequence, n);
            }
            return n;
        }

        final boolean isPrinter() {
            return this.iPrinters != null;
        }

        final boolean isParser() {
            return this.iParsers != null;
        }

        private void decompose(List<Object> list, List<Object> list2, List<Object> list3) {
            int n = list.size();
            for (int i = 0; i < n; i += 2) {
                Object object = list.get(i);
                if (object instanceof Composite) {
                    Composite.addArrayToList(list2, ((Composite)object).iPrinters);
                } else {
                    list2.add(object);
                }
                object = list.get(i + 1);
                if (object instanceof Composite) {
                    Composite.addArrayToList(list3, ((Composite)object).iParsers);
                    continue;
                }
                list3.add(object);
            }
        }

        private static void addArrayToList(List<Object> list, Object[] objectArray) {
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    list.add(objectArray[i]);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TimeZoneId
    extends Enum<TimeZoneId>
    implements InternalParser,
    InternalPrinter {
        public static final /* enum */ TimeZoneId INSTANCE;
        private static final List<String> ALL_IDS;
        private static final Map<String, List<String>> GROUPED_IDS;
        private static final List<String> BASE_GROUPED_IDS;
        private static int MAX_LENGTH;
        private static int MAX_PREFIX_LENGTH;

        @Override
        public final int estimatePrintedLength() {
            return MAX_LENGTH;
        }

        @Override
        public final void printTo(Appendable appendable, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            appendable.append(dateTimeZone != null ? dateTimeZone.getID() : "");
        }

        @Override
        public final int estimateParsedLength() {
            return MAX_LENGTH;
        }

        @Override
        public final int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n) {
            List<String> list = BASE_GROUPED_IDS;
            int n2 = charSequence.length();
            int n3 = Math.min(n2, n + MAX_PREFIX_LENGTH);
            int n4 = n;
            String string = "";
            for (int i = n4; i < n3; ++i) {
                if (charSequence.charAt(i) != '/') continue;
                string = charSequence.subSequence(n4, i + 1).toString();
                n4 += string.length();
                String string2 = string;
                if (i < n2 - 1) {
                    string2 = string2 + charSequence.charAt(i + 1);
                }
                if ((list = GROUPED_IDS.get(string2)) != null) break;
                return ~n;
            }
            String string3 = null;
            for (n3 = 0; n3 < list.size(); ++n3) {
                String string4 = list.get(n3);
                if (!DateTimeFormatterBuilder.csStartsWith(charSequence, n4, string4) || string3 != null && string4.length() <= string3.length()) continue;
                string3 = string4;
            }
            if (string3 != null) {
                dateTimeParserBucket.setZone(DateTimeZone.forID(string + string3));
                return n4 + string3.length();
            }
            return ~n;
        }

        static {
            (new TimeZoneId[1])[0] = INSTANCE = new TimeZoneId();
            BASE_GROUPED_IDS = new ArrayList<String>();
            ALL_IDS = new ArrayList<String>(DateTimeZone.getAvailableIDs());
            Collections.sort(ALL_IDS);
            GROUPED_IDS = new HashMap<String, List<String>>();
            int n = 0;
            int n2 = 0;
            for (String string : ALL_IDS) {
                int n3 = string.indexOf(47);
                if (n3 >= 0) {
                    if (n3 < string.length()) {
                        ++n3;
                    }
                    n2 = Math.max(n2, n3);
                    String string2 = string.substring(0, n3 + 1);
                    String string3 = string.substring(n3);
                    if (!GROUPED_IDS.containsKey(string2)) {
                        GROUPED_IDS.put(string2, new ArrayList());
                    }
                    GROUPED_IDS.get(string2).add(string3);
                } else {
                    BASE_GROUPED_IDS.add(string);
                }
                n = Math.max(n, string.length());
            }
            MAX_LENGTH = n;
            MAX_PREFIX_LENGTH = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TimeZoneName
    implements InternalParser,
    InternalPrinter {
        private final Map<String, DateTimeZone> iParseLookup;
        private final int iType;

        TimeZoneName(int n, Map<String, DateTimeZone> map) {
            this.iType = n;
            this.iParseLookup = map;
        }

        @Override
        public final int estimatePrintedLength() {
            if (this.iType == 1) {
                return 4;
            }
            return 20;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public final void printTo(Appendable var1_1, long var2_2, Chronology var4_4, int var5_5, DateTimeZone var6_6, Locale var7_7) throws IOException {
            v0 = var1_1;
            var3_8 = var7_7;
            var2_3 = var6_6;
            var9_9 = var2_2 - (long)var5_5;
            var1_1 = this;
            if (var2_3 == null) ** GOTO lbl-1000
            switch (var1_1.iType) {
                case 0: {
                    v1 = var2_3.getName(var9_9, var3_8);
                    break;
                }
                case 1: {
                    v1 = var2_3.getShortName(var9_9, var3_8);
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v1 = "";
                }
            }
            v0.append(v1);
        }

        @Override
        public final int estimateParsedLength() {
            if (this.iType == 1) {
                return 4;
            }
            return 20;
        }

        @Override
        public final int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n) {
            Map<String, DateTimeZone> map = this.iParseLookup;
            map = map != null ? map : DateTimeUtils.getDefaultTimeZoneNames();
            String string = null;
            for (String string2 : map.keySet()) {
                if (!DateTimeFormatterBuilder.csStartsWith(charSequence, n, string2) || string != null && string2.length() <= string.length()) continue;
                string = string2;
            }
            if (string != null) {
                dateTimeParserBucket.setZone(map.get(string));
                return n + string.length();
            }
            return ~n;
        }
    }

    static final class TimeZoneOffset
    implements InternalParser,
    InternalPrinter {
        private final String iZeroOffsetPrintText;
        private final String iZeroOffsetParseText;
        private final boolean iShowSeparators;
        private final int iMinFields;
        private final int iMaxFields;

        TimeZoneOffset(String string, String string2, boolean bl, int n, int n2) {
            this.iZeroOffsetPrintText = string;
            this.iZeroOffsetParseText = string2;
            this.iShowSeparators = bl;
            if (n <= 0 || n2 < n) {
                throw new IllegalArgumentException();
            }
            if (n > 4) {
                n = 4;
                n2 = 4;
            }
            this.iMinFields = n;
            this.iMaxFields = n2;
        }

        public final int estimatePrintedLength() {
            int n = 1 + this.iMinFields << 1;
            if (this.iShowSeparators) {
                n += this.iMinFields - 1;
            }
            if (this.iZeroOffsetPrintText != null && this.iZeroOffsetPrintText.length() > n) {
                n = this.iZeroOffsetPrintText.length();
            }
            return n;
        }

        public final void printTo(Appendable appendable, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            if (dateTimeZone == null) {
                return;
            }
            if (n == 0 && this.iZeroOffsetPrintText != null) {
                appendable.append(this.iZeroOffsetPrintText);
                return;
            }
            if (n >= 0) {
                appendable.append('+');
            } else {
                appendable.append('-');
                n = -n;
            }
            int n2 = n / 3600000;
            FormatUtils.appendPaddedInteger(appendable, n2, 2);
            if (this.iMaxFields == 1) {
                return;
            }
            if ((n -= n2 * 3600000) == 0 && this.iMinFields <= 1) {
                return;
            }
            n2 = n / 60000;
            if (this.iShowSeparators) {
                appendable.append(':');
            }
            FormatUtils.appendPaddedInteger(appendable, n2, 2);
            if (this.iMaxFields == 2) {
                return;
            }
            if ((n -= n2 * 60000) == 0 && this.iMinFields <= 2) {
                return;
            }
            n2 = n / 1000;
            if (this.iShowSeparators) {
                appendable.append(':');
            }
            FormatUtils.appendPaddedInteger(appendable, n2, 2);
            if (this.iMaxFields == 3) {
                return;
            }
            if ((n -= n2 * 1000) == 0 && this.iMinFields <= 3) {
                return;
            }
            if (this.iShowSeparators) {
                appendable.append('.');
            }
            FormatUtils.appendPaddedInteger(appendable, n, 3);
        }

        public final int estimateParsedLength() {
            return this.estimatePrintedLength();
        }

        public final int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n) {
            int n2;
            char c;
            block24: {
                int n3;
                int n4;
                block28: {
                    block27: {
                        int n5;
                        block26: {
                            block25: {
                                n5 = charSequence.length() - n;
                                if (this.iZeroOffsetParseText != null) {
                                    if (this.iZeroOffsetParseText.length() == 0) {
                                        if (n5 <= 0 || (c = charSequence.charAt(n)) != '-' && c != '+') {
                                            dateTimeParserBucket.setOffset(0);
                                            return n;
                                        }
                                    } else if (DateTimeFormatterBuilder.csStartsWithIgnoreCase(charSequence, n, this.iZeroOffsetParseText)) {
                                        dateTimeParserBucket.setOffset(0);
                                        return n + this.iZeroOffsetParseText.length();
                                    }
                                }
                                if (n5 <= 1) {
                                    return ~n;
                                }
                                n4 = charSequence.charAt(n);
                                if (n4 == 45) {
                                    c = '\u0001';
                                } else if (n4 == 43) {
                                    c = '\u0000';
                                } else {
                                    return ~n;
                                }
                                --n5;
                                if (TimeZoneOffset.digitCount(charSequence, ++n, 2) < 2) {
                                    return ~n;
                                }
                                n4 = FormatUtils.parseTwoDigits(charSequence, n);
                                if (n4 > 23) {
                                    return ~n;
                                }
                                n2 = n4 * 3600000;
                                n += 2;
                                if ((n5 -= 2) <= 0) break block24;
                                char c2 = charSequence.charAt(n);
                                n4 = c2;
                                if (c2 != ':') break block25;
                                n4 = 1;
                                --n5;
                                ++n;
                                break block26;
                            }
                            if (n4 < 48 || n4 > 57) break block24;
                            n4 = 0;
                        }
                        n3 = TimeZoneOffset.digitCount(charSequence, n, 2);
                        if (n3 == 0 && n4 == 0) break block24;
                        if (n3 < 2) {
                            return ~n;
                        }
                        n3 = FormatUtils.parseTwoDigits(charSequence, n);
                        if (n3 > 59) {
                            return ~n;
                        }
                        n2 += n3 * 60000;
                        n += 2;
                        if ((n5 -= 2) <= 0) break block24;
                        if (n4 == 0) break block27;
                        if (charSequence.charAt(n) != ':') break block24;
                        --n5;
                        ++n;
                    }
                    if ((n3 = TimeZoneOffset.digitCount(charSequence, n, 2)) == 0 && n4 == 0) break block24;
                    if (n3 < 2) {
                        return ~n;
                    }
                    n3 = FormatUtils.parseTwoDigits(charSequence, n);
                    if (n3 > 59) {
                        return ~n;
                    }
                    n2 += n3 * 1000;
                    n += 2;
                    if ((n5 -= 2) <= 0) break block24;
                    if (n4 == 0) break block28;
                    if (charSequence.charAt(n) != '.' && charSequence.charAt(n) != ',') break block24;
                    ++n;
                }
                if ((n3 = TimeZoneOffset.digitCount(charSequence, n, 3)) != 0 || n4 != 0) {
                    if (n3 <= 0) {
                        return ~n;
                    }
                    n2 += (charSequence.charAt(n++) - 48) * 100;
                    if (n3 > 1) {
                        n2 += (charSequence.charAt(n++) - 48) * 10;
                        if (n3 > 2) {
                            n2 += charSequence.charAt(n++) - 48;
                        }
                    }
                }
            }
            dateTimeParserBucket.setOffset(c != '\u0000' ? -n2 : n2);
            return n;
        }

        private static int digitCount(CharSequence charSequence, int n, int n2) {
            char c;
            int n3 = Math.min(charSequence.length() - n, n2);
            n2 = 0;
            while (n3 > 0 && (c = charSequence.charAt(n + n2)) >= '0' && c <= '9') {
                ++n2;
                --n3;
            }
            return n2;
        }
    }

    static final class Fraction
    implements InternalParser,
    InternalPrinter {
        private final DateTimeFieldType iFieldType;
        private int iMinDigits;
        private int iMaxDigits;

        protected Fraction(DateTimeFieldType dateTimeFieldType, int n, int n2) {
            this.iFieldType = dateTimeFieldType;
            if (n2 > 18) {
                n2 = 18;
            }
            this.iMinDigits = n;
            this.iMaxDigits = n2;
        }

        public final int estimatePrintedLength() {
            return this.iMaxDigits;
        }

        public final void printTo(Appendable object, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            long l2;
            long l3;
            Object object2 = chronology;
            long l4 = l;
            Appendable appendable = object;
            object = this;
            object2 = ((Fraction)object).iFieldType.getField((Chronology)object2);
            int n2 = ((Fraction)object).iMinDigits;
            try {
                l3 = ((DateTimeField)object2).remainder(l4);
            }
            catch (RuntimeException runtimeException) {
                DateTimeFormatterBuilder.appendUnknownString(appendable, n2);
                return;
            }
            if (l3 == 0L) {
                while (--n2 >= 0) {
                    appendable.append('0');
                }
                return;
            }
            long l5 = l3;
            long l6 = ((DateTimeField)object2).getDurationField().getUnitMillis();
            int n3 = ((Fraction)object).iMaxDigits;
            while (true) {
                switch (n3) {
                    default: {
                        l2 = 1L;
                        break;
                    }
                    case 1: {
                        l2 = 10L;
                        break;
                    }
                    case 2: {
                        l2 = 100L;
                        break;
                    }
                    case 3: {
                        l2 = 1000L;
                        break;
                    }
                    case 4: {
                        l2 = 10000L;
                        break;
                    }
                    case 5: {
                        l2 = 100000L;
                        break;
                    }
                    case 6: {
                        l2 = 1000000L;
                        break;
                    }
                    case 7: {
                        l2 = 10000000L;
                        break;
                    }
                    case 8: {
                        l2 = 100000000L;
                        break;
                    }
                    case 9: {
                        l2 = 1000000000L;
                        break;
                    }
                    case 10: {
                        l2 = 10000000000L;
                        break;
                    }
                    case 11: {
                        l2 = 100000000000L;
                        break;
                    }
                    case 12: {
                        l2 = 1000000000000L;
                        break;
                    }
                    case 13: {
                        l2 = 10000000000000L;
                        break;
                    }
                    case 14: {
                        l2 = 100000000000000L;
                        break;
                    }
                    case 15: {
                        l2 = 1000000000000000L;
                        break;
                    }
                    case 16: {
                        l2 = 10000000000000000L;
                        break;
                    }
                    case 17: {
                        l2 = 100000000000000000L;
                        break;
                    }
                    case 18: {
                        l2 = 1000000000000000000L;
                    }
                }
                if (l6 * l2 / l2 == l6) break;
                --n3;
            }
            Object object3 = new long[]{l5 * l2 / l6, n3};
            long l7 = object3[0];
            int n4 = (int)object3[1];
            object3 = (l7 & Integer.MAX_VALUE) == l7 ? (Object)Integer.toString((int)l7) : (Object)Long.toString(l7);
            n = ((String)object3).length();
            while (n < n4) {
                appendable.append('0');
                --n2;
                --n4;
            }
            if (n2 < n4) {
                while (n2 < n4 && n > 1 && ((String)object3).charAt(n - 1) == '0') {
                    --n4;
                    --n;
                }
                if (n < ((String)object3).length()) {
                    for (n4 = 0; n4 < n; ++n4) {
                        appendable.append(((String)object3).charAt(n4));
                    }
                    return;
                }
            }
            appendable.append((CharSequence)object3);
        }

        public final int estimateParsedLength() {
            return this.iMaxDigits;
        }

        public final int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n) {
            char c;
            DateTimeField dateTimeField = this.iFieldType.getField(dateTimeParserBucket.getChronology());
            int n2 = Math.min(this.iMaxDigits, charSequence.length() - n);
            long l = 0L;
            long l2 = dateTimeField.getDurationField().getUnitMillis() * 10L;
            int n3 = 0;
            while (n3 < n2 && (c = charSequence.charAt(n + n3)) >= '0' && c <= '9') {
                ++n3;
                long l3 = l2 / 10L;
                l += (long)(c - 48) * l3;
                l2 = l3;
            }
            l /= 10L;
            if (n3 == 0) {
                return ~n;
            }
            if (l > Integer.MAX_VALUE) {
                return ~n;
            }
            PreciseDateTimeField preciseDateTimeField = new PreciseDateTimeField(DateTimeFieldType.millisOfSecond(), MillisDurationField.INSTANCE, dateTimeField.getDurationField());
            dateTimeParserBucket.saveField(preciseDateTimeField, (int)l);
            return n + n3;
        }
    }

    static final class TextField
    implements InternalParser,
    InternalPrinter {
        private static Map<Locale, Map<DateTimeFieldType, Object[]>> cParseCache = new ConcurrentHashMap<Locale, Map<DateTimeFieldType, Object[]>>();
        private final DateTimeFieldType iFieldType;
        private final boolean iShort;

        TextField(DateTimeFieldType dateTimeFieldType, boolean bl) {
            this.iFieldType = dateTimeFieldType;
            this.iShort = bl;
        }

        public final int estimatePrintedLength() {
            if (this.iShort) {
                return 6;
            }
            return 20;
        }

        public final void printTo(Appendable appendable, long l, Chronology object, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            try {
                Chronology chronology = object;
                object = locale;
                Object object2 = chronology;
                long l2 = l;
                TextField textField = this;
                object2 = textField.iFieldType.getField((Chronology)object2);
                appendable.append(textField.iShort ? ((DateTimeField)object2).getAsShortText(l2, (Locale)object) : ((DateTimeField)object2).getAsText(l2, (Locale)object));
                return;
            }
            catch (RuntimeException runtimeException) {
                appendable.append('\ufffd');
                return;
            }
        }

        public final int estimateParsedLength() {
            return this.estimatePrintedLength();
        }

        public final int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n) {
            int n2;
            Map<String, Boolean> map;
            Object object;
            Locale locale = dateTimeParserBucket.getLocale();
            Map<DateTimeFieldType, Object[]> map2 = cParseCache.get(locale);
            if (map2 == null) {
                map2 = new ConcurrentHashMap<DateTimeFieldType, Object[]>();
                cParseCache.put(locale, map2);
            }
            if ((object = map2.get(this.iFieldType)) == null) {
                map = new ConcurrentHashMap(32);
                Object object2 = new MutableDateTime(0L, DateTimeZone.UTC);
                object2 = object = ((MutableDateTime)object2).property(this.iFieldType);
                int n3 = ((AbstractReadableInstantFieldProperty)object).getField().getMinimumValue();
                object2 = object;
                int n4 = ((AbstractReadableInstantFieldProperty)object2).getField().getMaximumValue();
                if (n4 - n3 > 32) {
                    return ~n;
                }
                Locale locale2 = locale;
                object2 = object;
                n2 = ((AbstractReadableInstantFieldProperty)object2).getField().getMaximumTextLength(locale2);
                while (n3 <= n4) {
                    ((MutableDateTime.Property)object).set(n3);
                    map.put(((AbstractReadableInstantFieldProperty)object).getAsShortText(locale), Boolean.TRUE);
                    map.put(((AbstractReadableInstantFieldProperty)object).getAsShortText(locale).toLowerCase(locale), Boolean.TRUE);
                    map.put(((AbstractReadableInstantFieldProperty)object).getAsShortText(locale).toUpperCase(locale), Boolean.TRUE);
                    map.put(((AbstractReadableInstantFieldProperty)object).getAsText(locale), Boolean.TRUE);
                    map.put(((AbstractReadableInstantFieldProperty)object).getAsText(locale).toLowerCase(locale), Boolean.TRUE);
                    map.put(((AbstractReadableInstantFieldProperty)object).getAsText(locale).toUpperCase(locale), Boolean.TRUE);
                    ++n3;
                }
                if ("en".equals(locale.getLanguage()) && this.iFieldType == DateTimeFieldType.era()) {
                    map.put("BCE", Boolean.TRUE);
                    map.put("bce", Boolean.TRUE);
                    map.put("CE", Boolean.TRUE);
                    map.put("ce", Boolean.TRUE);
                    n2 = 3;
                }
                object = new Object[]{map, n2};
                map2.put(this.iFieldType, (Object[])object);
            } else {
                map = (Map)object[0];
                n2 = (Integer)object[1];
            }
            for (int i = n2 = Math.min(charSequence.length(), n + n2); i > n; --i) {
                String string = charSequence.subSequence(n, i).toString();
                if (!map.containsKey(string)) continue;
                dateTimeParserBucket.saveField(this.iFieldType, string, locale);
                return i;
            }
            return ~n;
        }
    }

    static final class TwoDigitYear
    implements InternalParser,
    InternalPrinter {
        private final DateTimeFieldType iType;
        private final int iPivot;
        private final boolean iLenientParse;

        TwoDigitYear(DateTimeFieldType dateTimeFieldType, int n, boolean bl) {
            this.iType = dateTimeFieldType;
            this.iPivot = n;
            this.iLenientParse = bl;
        }

        public final int estimateParsedLength() {
            if (this.iLenientParse) {
                return 4;
            }
            return 2;
        }

        public final int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n) {
            int n2;
            int n3;
            char c;
            int n4;
            int n5 = charSequence.length() - n;
            if (!this.iLenientParse) {
                if ((n5 = Math.min(2, n5)) < 2) {
                    return ~n;
                }
            } else {
                n4 = 0;
                c = '\u0000';
                n3 = 0;
                while (n3 < n5) {
                    n2 = charSequence.charAt(n + n3);
                    if (n3 == 0 && (n2 == 45 || n2 == 43)) {
                        n4 = 1;
                        c = n2 == 45 ? (char)'\u0001' : '\u0000';
                        if (c != '\u0000') {
                            ++n3;
                            continue;
                        }
                        ++n;
                        --n5;
                        continue;
                    }
                    if (n2 < 48 || n2 > 57) break;
                    ++n3;
                }
                if (n3 == 0) {
                    return ~n;
                }
                if (n4 != 0 || n3 != 2) {
                    if (n3 >= 9) {
                        int n6 = n;
                        n = n6 + n3;
                        n2 = Integer.parseInt(charSequence.subSequence(n6, n).toString());
                    } else {
                        n5 = n;
                        if (c != '\u0000') {
                            ++n5;
                        }
                        try {
                            n2 = charSequence.charAt(n5++) - 48;
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                            return ~n;
                        }
                        n += n3;
                        while (n5 < n) {
                            n2 = (n2 << 3) + (n2 << 1) + charSequence.charAt(n5++) - 48;
                        }
                        if (c != '\u0000') {
                            n2 = -n2;
                        }
                    }
                    dateTimeParserBucket.saveField(this.iType, n2);
                    return n;
                }
            }
            if ((c = charSequence.charAt(n)) < '0' || c > '9') {
                return ~n;
            }
            n4 = c - 48;
            c = charSequence.charAt(n + 1);
            if (c < '0' || c > '9') {
                return ~n;
            }
            n4 = (n4 << 3) + (n4 << 1) + c - 48;
            n3 = this.iPivot;
            if (dateTimeParserBucket.getPivotYear() != null) {
                n3 = dateTimeParserBucket.getPivotYear();
            }
            n5 = (n2 = n3 - 50) >= 0 ? n2 % 100 : 99 + (n2 + 1) % 100;
            dateTimeParserBucket.saveField(this.iType, n4 += n2 + (n4 < n5 ? 100 : 0) - n5);
            return n + 2;
        }

        public final int estimatePrintedLength() {
            return 2;
        }

        public final void printTo(Appendable appendable, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            int n2 = this.getTwoDigitYear(l, chronology);
            if (n2 < 0) {
                appendable.append('\ufffd');
                appendable.append('\ufffd');
                return;
            }
            FormatUtils.appendPaddedInteger(appendable, n2, 2);
        }

        private int getTwoDigitYear(long l, Chronology chronology) {
            try {
                int n = this.iType.getField(chronology).get(l);
                if (n < 0) {
                    n = -n;
                }
                return n % 100;
            }
            catch (RuntimeException runtimeException) {
                return -1;
            }
        }
    }

    static final class FixedNumber
    extends PaddedNumber {
        protected FixedNumber(DateTimeFieldType dateTimeFieldType, int n, boolean bl) {
            super(dateTimeFieldType, n, false, n);
        }

        public final int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n) {
            int n2 = super.parseInto(dateTimeParserBucket, charSequence, n);
            if (n2 < 0) {
                return n2;
            }
            int n3 = n + this.iMaxParsedDigits;
            if (n2 != n3) {
                char c;
                if (this.iSigned && ((c = charSequence.charAt(n)) == '-' || c == '+')) {
                    ++n3;
                }
                if (n2 > n3) {
                    return ~(n3 + 1);
                }
                if (n2 < n3) {
                    return ~n2;
                }
            }
            return n2;
        }
    }

    static class PaddedNumber
    extends NumberFormatter {
        private int iMinPrintedDigits;

        protected PaddedNumber(DateTimeFieldType dateTimeFieldType, int n, boolean bl, int n2) {
            super(dateTimeFieldType, n, bl);
            this.iMinPrintedDigits = n2;
        }

        public final int estimatePrintedLength() {
            return this.iMaxParsedDigits;
        }

        public final void printTo(Appendable appendable, long l, Chronology object, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            try {
                object = this.iFieldType.getField((Chronology)object);
                FormatUtils.appendPaddedInteger(appendable, ((DateTimeField)object).get(l), this.iMinPrintedDigits);
                return;
            }
            catch (RuntimeException runtimeException) {
                DateTimeFormatterBuilder.appendUnknownString(appendable, this.iMinPrintedDigits);
                return;
            }
        }
    }

    static final class UnpaddedNumber
    extends NumberFormatter {
        protected UnpaddedNumber(DateTimeFieldType dateTimeFieldType, int n, boolean bl) {
            super(dateTimeFieldType, n, bl);
        }

        public final int estimatePrintedLength() {
            return this.iMaxParsedDigits;
        }

        public final void printTo(Appendable appendable, long l, Chronology object, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            try {
                object = this.iFieldType.getField((Chronology)object);
                FormatUtils.appendUnpaddedInteger(appendable, ((DateTimeField)object).get(l));
                return;
            }
            catch (RuntimeException runtimeException) {
                appendable.append('\ufffd');
                return;
            }
        }
    }

    static abstract class NumberFormatter
    implements InternalParser,
    InternalPrinter {
        protected final DateTimeFieldType iFieldType;
        protected final int iMaxParsedDigits;
        protected final boolean iSigned;

        NumberFormatter(DateTimeFieldType dateTimeFieldType, int n, boolean bl) {
            this.iFieldType = dateTimeFieldType;
            this.iMaxParsedDigits = n;
            this.iSigned = bl;
        }

        public final int estimateParsedLength() {
            return this.iMaxParsedDigits;
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n) {
            int n2;
            int n3 = Math.min(this.iMaxParsedDigits, charSequence.length() - n);
            boolean bl = false;
            boolean bl2 = false;
            int n4 = 0;
            while (n4 < n3) {
                n2 = charSequence.charAt(n + n4);
                if (n4 == 0 && (n2 == 45 || n2 == 43) && this.iSigned) {
                    bl = n2 == 45;
                    boolean bl3 = bl2 = n2 == 43;
                    if (n4 + 1 >= n3) break;
                    char c = charSequence.charAt(n + n4 + 1);
                    n2 = c;
                    if (c < '0' || n2 > 57) break;
                    ++n4;
                    n3 = Math.min(n3 + 1, charSequence.length() - n);
                    continue;
                }
                if (n2 < 48 || n2 > 57) break;
                ++n4;
            }
            if (n4 == 0) {
                return ~n;
            }
            if (n4 >= 9) {
                if (bl2) {
                    n2 = Integer.parseInt(charSequence.subSequence(n + 1, n += n4).toString());
                } else {
                    int n5 = n;
                    n = n5 + n4;
                    n2 = Integer.parseInt(charSequence.subSequence(n5, n).toString());
                }
            } else {
                n3 = n;
                if (bl || bl2) {
                    ++n3;
                }
                try {
                    n2 = charSequence.charAt(n3++) - 48;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    return ~n;
                }
                n += n4;
                while (n3 < n) {
                    n2 = (n2 << 3) + (n2 << 1) + charSequence.charAt(n3++) - 48;
                }
                if (bl) {
                    n2 = -n2;
                }
            }
            dateTimeParserBucket.saveField(this.iFieldType, n2);
            return n;
        }
    }

    static final class StringLiteral
    implements InternalParser,
    InternalPrinter {
        private final String iValue;

        StringLiteral(String string) {
            this.iValue = string;
        }

        public final int estimatePrintedLength() {
            return this.iValue.length();
        }

        public final void printTo(Appendable appendable, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            appendable.append(this.iValue);
        }

        public final int estimateParsedLength() {
            return this.iValue.length();
        }

        public final int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n) {
            if (DateTimeFormatterBuilder.csStartsWithIgnoreCase(charSequence, n, this.iValue)) {
                return n + this.iValue.length();
            }
            return ~n;
        }
    }

    static final class CharacterLiteral
    implements InternalParser,
    InternalPrinter {
        private final char iValue;

        CharacterLiteral(char c) {
            this.iValue = c;
        }

        public final int estimatePrintedLength() {
            return 1;
        }

        public final void printTo(Appendable appendable, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            appendable.append(this.iValue);
        }

        public final int estimateParsedLength() {
            return 1;
        }

        public final int parseInto(DateTimeParserBucket dateTimeParserBucket, CharSequence charSequence, int n) {
            char c;
            if (n >= charSequence.length()) {
                return ~n;
            }
            char c2 = charSequence.charAt(n);
            if (c2 != (c = this.iValue) && (c2 = Character.toUpperCase(c2)) != (c = Character.toUpperCase(c)) && (c2 = Character.toLowerCase(c2)) != (c = Character.toLowerCase(c))) {
                return ~n;
            }
            return n + 1;
        }
    }
}

