/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.util.Arrays;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.IllegalInstantException;

public final class DateTimeParserBucket {
    private final Chronology iChrono;
    private final long iMillis;
    private final Locale iLocale;
    private final int iDefaultYear;
    private final DateTimeZone iDefaultZone;
    private final Integer iDefaultPivotYear;
    private DateTimeZone iZone;
    private Integer iOffset;
    private Integer iPivotYear;
    private SavedField[] iSavedFields;
    private int iSavedFieldsCount;
    private boolean iSavedFieldsShared;
    private Object iSavedState;

    public DateTimeParserBucket(long l, Chronology chronology, Locale locale, Integer n, int n2) {
        chronology = DateTimeUtils.getChronology(chronology);
        this.iMillis = 0L;
        this.iDefaultZone = chronology.getZone();
        this.iChrono = chronology.withUTC();
        this.iLocale = locale == null ? Locale.getDefault() : locale;
        this.iDefaultYear = n2;
        this.iDefaultPivotYear = n;
        this.iZone = this.iDefaultZone;
        this.iPivotYear = this.iDefaultPivotYear;
        this.iSavedFields = new SavedField[8];
    }

    public final Chronology getChronology() {
        return this.iChrono;
    }

    public final Locale getLocale() {
        return this.iLocale;
    }

    public final void setZone(DateTimeZone dateTimeZone) {
        this.iSavedState = null;
        this.iZone = dateTimeZone;
    }

    public final void setOffset(Integer n) {
        this.iSavedState = null;
        this.iOffset = n;
    }

    public final Integer getPivotYear() {
        return this.iPivotYear;
    }

    public final void saveField(DateTimeField dateTimeField, int n) {
        this.obtainSaveField().init(dateTimeField, n);
    }

    public final void saveField(DateTimeFieldType dateTimeFieldType, int n) {
        this.obtainSaveField().init(dateTimeFieldType.getField(this.iChrono), n);
    }

    public final void saveField(DateTimeFieldType object, String object2, Locale object3) {
        Locale locale = object3;
        object3 = object2;
        object2 = ((DateTimeFieldType)object).getField(this.iChrono);
        object = this.obtainSaveField();
        this.obtainSaveField().iField = object2;
        ((SavedField)object).iValue = 0;
        ((SavedField)object).iText = object3;
        ((SavedField)object).iLocale = locale;
    }

    private SavedField obtainSaveField() {
        Object object;
        int n = this.iSavedFieldsCount;
        SavedField[] savedFieldArray = this.iSavedFields;
        if (n == savedFieldArray.length || this.iSavedFieldsShared) {
            object = new SavedField[n == savedFieldArray.length ? n << 1 : savedFieldArray.length];
            System.arraycopy(savedFieldArray, 0, object, 0, n);
            savedFieldArray = object;
            this.iSavedFields = object;
            this.iSavedFieldsShared = false;
        }
        this.iSavedState = null;
        object = savedFieldArray[n];
        if (object == null) {
            savedFieldArray[n] = new SavedField();
            object = savedFieldArray[n];
        }
        this.iSavedFieldsCount = n + 1;
        return object;
    }

    public final Object saveState() {
        if (this.iSavedState == null) {
            this.iSavedState = new SavedState();
        }
        return this.iSavedState;
    }

    public final boolean restoreState(Object object) {
        if (object instanceof SavedState) {
            boolean bl;
            DateTimeParserBucket dateTimeParserBucket = this;
            SavedState savedState = (SavedState)object;
            if (dateTimeParserBucket != savedState.DateTimeParserBucket.this) {
                bl = false;
            } else {
                SavedField[] savedFieldArray = savedState.iZone;
                DateTimeParserBucket dateTimeParserBucket2 = dateTimeParserBucket;
                dateTimeParserBucket.iZone = savedFieldArray;
                savedFieldArray = savedState.iOffset;
                dateTimeParserBucket2 = dateTimeParserBucket;
                dateTimeParserBucket.iOffset = savedFieldArray;
                savedFieldArray = savedState.iSavedFields;
                dateTimeParserBucket2 = dateTimeParserBucket;
                dateTimeParserBucket.iSavedFields = savedFieldArray;
                dateTimeParserBucket2 = dateTimeParserBucket;
                if (savedState.iSavedFieldsCount < dateTimeParserBucket2.iSavedFieldsCount) {
                    boolean bl2 = true;
                    dateTimeParserBucket2 = dateTimeParserBucket;
                    dateTimeParserBucket.iSavedFieldsShared = true;
                }
                int n = savedState.iSavedFieldsCount;
                dateTimeParserBucket2 = dateTimeParserBucket;
                dateTimeParserBucket.iSavedFieldsCount = n;
                bl = true;
            }
            if (bl) {
                this.iSavedState = object;
                return true;
            }
        }
        return false;
    }

    public final long computeMillis(boolean bl, CharSequence charSequence) {
        int n;
        int n2;
        Object[] objectArray;
        while (true) {
            objectArray = this.iSavedFields;
            n2 = this.iSavedFieldsCount;
            if (this.iSavedFieldsShared) {
                objectArray = (SavedField[])this.iSavedFields.clone();
                this.iSavedFields = objectArray;
                this.iSavedFieldsShared = false;
            }
            int n3 = n2;
            Object object = objectArray;
            if (n3 > 10) {
                Arrays.sort(object, 0, n3);
            } else {
                for (n = 0; n < n3; ++n) {
                    for (int i = n; i > 0 && ((SavedField)object[i - 1]).compareTo((SavedField)object[i]) > 0; --i) {
                        Object object2 = object[i];
                        object[i] = object[i - 1];
                        object[i - 1] = object2;
                    }
                }
            }
            if (n2 <= 0) break;
            object = DurationFieldType.months().getField(this.iChrono);
            DurationField durationField = DurationFieldType.days().getField(this.iChrono);
            DurationField durationField2 = ((SavedField)objectArray[0]).iField.getDurationField();
            if (DateTimeParserBucket.compareReverse(durationField2, (DurationField)object) < 0 || DateTimeParserBucket.compareReverse(durationField2, durationField) > 0) break;
            this.saveField(DateTimeFieldType.year(), this.iDefaultYear);
        }
        long l = this.iMillis;
        try {
            for (n = 0; n < n2; ++n) {
                l = ((SavedField)objectArray[n]).set(l, bl);
            }
            if (bl) {
                for (n = 0; n < n2; ++n) {
                    if (((SavedField)objectArray[n]).iField.isLenient()) continue;
                    l = ((SavedField)objectArray[n]).set(l, n == n2 - 1);
                }
            }
        }
        catch (IllegalFieldValueException illegalFieldValueException) {
            if (charSequence != null) {
                illegalFieldValueException.prependMessage("Cannot parse \"" + charSequence + '\"');
            }
            throw illegalFieldValueException;
        }
        if (this.iOffset != null) {
            l -= (long)this.iOffset.intValue();
        } else if (this.iZone != null && (n = this.iZone.getOffsetFromLocal(l)) != this.iZone.getOffset(l -= (long)n)) {
            String string = "Illegal instant due to time zone offset transition (" + this.iZone + ')';
            if (charSequence != null) {
                string = "Cannot parse \"" + charSequence + "\": " + string;
            }
            throw new IllegalInstantException(string);
        }
        return l;
    }

    static int compareReverse(DurationField durationField, DurationField durationField2) {
        if (durationField == null || !durationField.isSupported()) {
            if (durationField2 == null || !durationField2.isSupported()) {
                return 0;
            }
            return -1;
        }
        if (durationField2 == null || !durationField2.isSupported()) {
            return 1;
        }
        return -durationField.compareTo(durationField2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SavedField
    implements Comparable<SavedField> {
        DateTimeField iField;
        int iValue;
        String iText;
        Locale iLocale;

        SavedField() {
        }

        final void init(DateTimeField dateTimeField, int n) {
            this.iField = dateTimeField;
            this.iValue = n;
            this.iText = null;
            this.iLocale = null;
        }

        final long set(long l, boolean bl) {
            l = this.iText == null ? this.iField.setExtended(l, this.iValue) : this.iField.set(l, this.iText, this.iLocale);
            if (bl) {
                l = this.iField.roundFloor(l);
            }
            return l;
        }

        @Override
        public final int compareTo(SavedField object) {
            object = ((SavedField)object).iField;
            int n = DateTimeParserBucket.compareReverse(this.iField.getRangeDurationField(), ((DateTimeField)object).getRangeDurationField());
            if (n != 0) {
                return n;
            }
            return DateTimeParserBucket.compareReverse(this.iField.getDurationField(), ((DateTimeField)object).getDurationField());
        }
    }

    final class SavedState {
        final DateTimeZone iZone;
        final Integer iOffset;
        final SavedField[] iSavedFields;
        final int iSavedFieldsCount;

        SavedState() {
            this.iZone = DateTimeParserBucket.this.iZone;
            this.iOffset = DateTimeParserBucket.this.iOffset;
            this.iSavedFields = DateTimeParserBucket.this.iSavedFields;
            this.iSavedFieldsCount = DateTimeParserBucket.this.iSavedFieldsCount;
        }
    }
}

