/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;

public final class FormatUtils {
    private static final double LOG_10 = Math.log(10.0);

    public static void appendPaddedInteger(StringBuffer stringBuffer, int n, int n2) {
        try {
            FormatUtils.appendPaddedInteger((Appendable)stringBuffer, n, n2);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void appendPaddedInteger(Appendable appendable, int n, int n2) throws IOException {
        if (n < 0) {
            appendable.append('-');
            if (n != Integer.MIN_VALUE) {
                n = -n;
            } else {
                while (n2 > 10) {
                    appendable.append('0');
                    --n2;
                }
                appendable.append("2147483648");
                return;
            }
        }
        if (n < 10) {
            while (n2 > 1) {
                appendable.append('0');
                --n2;
            }
            appendable.append((char)(n + 48));
            return;
        }
        if (n < 100) {
            while (n2 > 2) {
                appendable.append('0');
                --n2;
            }
            int n3 = (n + 1) * 0xCCCCCC >> 27;
            appendable.append((char)(n3 + 48));
            appendable.append((char)(n - (n3 << 3) - (n3 << 1) + 48));
            return;
        }
        int n4 = n < 1000 ? 3 : (n < 10000 ? 4 : (int)(Math.log(n) / LOG_10) + 1);
        while (n2 > n4) {
            appendable.append('0');
            --n2;
        }
        appendable.append(Integer.toString(n));
    }

    public static void appendUnpaddedInteger(StringBuffer stringBuffer, int n) {
        try {
            FormatUtils.appendUnpaddedInteger((Appendable)stringBuffer, n);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void appendUnpaddedInteger(Appendable appendable, int n) throws IOException {
        if (n < 0) {
            appendable.append('-');
            if (n != Integer.MIN_VALUE) {
                n = -n;
            } else {
                appendable.append("2147483648");
                return;
            }
        }
        if (n < 10) {
            appendable.append((char)(n + 48));
            return;
        }
        if (n < 100) {
            int n2 = (n + 1) * 0xCCCCCC >> 27;
            appendable.append((char)(n2 + 48));
            appendable.append((char)(n - (n2 << 3) - (n2 << 1) + 48));
            return;
        }
        appendable.append(Integer.toString(n));
    }

    public static int calculateDigitCount(long l) {
        if (l < 0L) {
            if (l != Long.MIN_VALUE) {
                return FormatUtils.calculateDigitCount(-l) + 1;
            }
            return 20;
        }
        if (l < 10L) {
            return 1;
        }
        if (l < 100L) {
            return 2;
        }
        if (l < 1000L) {
            return 3;
        }
        if (l < 10000L) {
            return 4;
        }
        return (int)(Math.log(l) / LOG_10) + 1;
    }

    static int parseTwoDigits(CharSequence charSequence, int n) {
        int n2 = charSequence.charAt(n) - 48;
        return (n2 << 3) + (n2 << 1) + charSequence.charAt(n + 1) - 48;
    }

    static String createErrorMessage(String string, int n) {
        int n2 = n + 32;
        String string2 = string.length() <= n2 + 3 ? string : string.substring(0, n2).concat("...");
        if (n <= 0) {
            return "Invalid format: \"" + string2 + '\"';
        }
        if (n >= string.length()) {
            return "Invalid format: \"" + string2 + "\" is too short";
        }
        return "Invalid format: \"" + string2 + "\" is malformed at \"" + string2.substring(n) + '\"';
    }
}

