/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.PeriodFormatterBuilder;
import org.joda.time.format.PeriodParser;
import org.joda.time.format.PeriodPrinter;

public class ISODateTimeFormat {
    private static ISODateTimeFormat cStandard$1a68c47e;
    private final PeriodPrinter iPrinter;
    private final PeriodParser iParser;
    private final Locale iLocale;

    public static DateTimeFormatter dateTime() {
        return Constants.dt;
    }

    public static long safeAdd(long l, long l2) {
        long l3 = l + l2;
        if ((l ^ l3) < 0L && (l ^ l2) >= 0L) {
            throw new ArithmeticException("The calculation caused an overflow: " + l + " + " + l2);
        }
        return l3;
    }

    public static long safeSubtract(long l, long l2) {
        long l3 = l - l2;
        if ((l ^ l3) < 0L && (l ^ l2) < 0L) {
            throw new ArithmeticException("The calculation caused an overflow: " + l + " - " + l2);
        }
        return l3;
    }

    public static int safeToInt(long l) {
        if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            return (int)l;
        }
        throw new ArithmeticException("Value cannot fit in an int: " + l);
    }

    public static void verifyValueBounds(DateTimeField dateTimeField, int n, int n2, int n3) {
        if (n < n2 || n > n3) {
            throw new IllegalFieldValueException(dateTimeField.getType(), n, n2, n3);
        }
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static ISODateTimeFormat standard$17c1ff41() {
        if (cStandard$1a68c47e == null) {
            cStandard$1a68c47e = new PeriodFormatterBuilder().appendLiteral("P").appendYears().appendSuffix("Y").appendMonths().appendSuffix("M").appendWeeks().appendSuffix("W").appendDays().appendSuffix("D").appendSeparatorIfFieldsAfter("T").appendHours().appendSuffix("H").appendMinutes().appendSuffix("M").appendSecondsWithOptionalMillis().appendSuffix("S").toFormatter$17c1ff41();
        }
        return cStandard$1a68c47e;
    }

    public ISODateTimeFormat(PeriodPrinter periodPrinter, PeriodParser periodParser) {
        this.iPrinter = periodPrinter;
        this.iParser = periodParser;
        this.iLocale = null;
    }

    public PeriodPrinter getPrinter() {
        return this.iPrinter;
    }

    public PeriodParser getParser() {
        return this.iParser;
    }

    public String print(ReadablePeriod readablePeriod) {
        Object object = this;
        if (((ISODateTimeFormat)object).iPrinter == null) {
            throw new UnsupportedOperationException("Printing not supported");
        }
        object = readablePeriod;
        if (object == null) {
            throw new IllegalArgumentException("Period must not be null");
        }
        object = this.getPrinter();
        StringBuffer stringBuffer = new StringBuffer(object.calculatePrintedLength(readablePeriod, this.iLocale));
        object.printTo(stringBuffer, readablePeriod, this.iLocale);
        return stringBuffer.toString();
    }

    public static Throwable getThrowableCandidate(Object[] argArray) {
        if (argArray == null || argArray.length == 0) {
            return null;
        }
        Object lastEntry = argArray[argArray.length - 1];
        if (lastEntry instanceof Throwable) {
            Object object;
            return (Throwable)object;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Object[] trimmedCopy(Object[] argArray) {
        void var2_2;
        if (argArray == null || argArray.length == 0) {
            throw new IllegalStateException("non-sensical empty or null argument array");
        }
        int trimmedLen = argArray.length - 1;
        Object[] trimmed = new Object[trimmedLen];
        if (trimmedLen > 0) {
            void var1_1;
            Object[] objectArray;
            System.arraycopy(objectArray, 0, trimmed, 0, (int)var1_1);
        }
        return var2_2;
    }

    static final class Constants {
        private static final DateTimeFormatter ye;
        private static final DateTimeFormatter mye;
        private static final DateTimeFormatter dme;
        private static final DateTimeFormatter we;
        private static final DateTimeFormatter wwe;
        private static final DateTimeFormatter dwe;
        private static final DateTimeFormatter dye;
        private static final DateTimeFormatter hde;
        private static final DateTimeFormatter mhe;
        private static final DateTimeFormatter sme;
        private static final DateTimeFormatter fse;
        private static final DateTimeFormatter ze;
        private static final DateTimeFormatter lte;
        private static final DateTimeFormatter ym;
        private static final DateTimeFormatter ymd;
        private static final DateTimeFormatter ww;
        private static final DateTimeFormatter wwd;
        private static final DateTimeFormatter hm;
        private static final DateTimeFormatter hms;
        private static final DateTimeFormatter hmsl;
        private static final DateTimeFormatter hmsf;
        private static final DateTimeFormatter dh;
        private static final DateTimeFormatter dhm;
        private static final DateTimeFormatter dhms;
        private static final DateTimeFormatter dhmsl;
        private static final DateTimeFormatter dhmsf;
        private static final DateTimeFormatter t;
        private static final DateTimeFormatter tx;
        private static final DateTimeFormatter tt;
        private static final DateTimeFormatter ttx;
        private static final DateTimeFormatter dt;
        private static final DateTimeFormatter dtx;
        private static final DateTimeFormatter wdt;
        private static final DateTimeFormatter wdtx;
        private static final DateTimeFormatter od;
        private static final DateTimeFormatter odt;
        private static final DateTimeFormatter odtx;
        private static final DateTimeFormatter bd;
        private static final DateTimeFormatter bt;
        private static final DateTimeFormatter btx;
        private static final DateTimeFormatter btt;
        private static final DateTimeFormatter bttx;
        private static final DateTimeFormatter bdt;
        private static final DateTimeFormatter bdtx;
        private static final DateTimeFormatter bod;
        private static final DateTimeFormatter bodt;
        private static final DateTimeFormatter bodtx;
        private static final DateTimeFormatter bwd;
        private static final DateTimeFormatter bwdt;
        private static final DateTimeFormatter bwdtx;
        private static final DateTimeFormatter dpe;
        private static final DateTimeFormatter tpe;
        private static final DateTimeFormatter dp;
        private static final DateTimeFormatter ldp;
        private static final DateTimeFormatter tp;
        private static final DateTimeFormatter ltp;
        private static final DateTimeFormatter dtp;
        private static final DateTimeFormatter dotp;
        private static final DateTimeFormatter ldotp;

        private static DateTimeFormatter dateElementParser() {
            if (dpe == null) {
                return new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().append(Constants.yearElement()).appendOptional(new DateTimeFormatterBuilder().append(Constants.monthElement()).appendOptional(Constants.dayOfMonthElement().getParser()).toParser()).toParser(), new DateTimeFormatterBuilder().append(Constants.weekyearElement()).append(Constants.weekElement()).appendOptional(Constants.dayOfWeekElement().getParser()).toParser(), new DateTimeFormatterBuilder().append(Constants.yearElement()).append(Constants.dayOfYearElement()).toParser()}).toFormatter();
            }
            return dpe;
        }

        private static DateTimeFormatter timeElementParser() {
            if (tpe == null) {
                DateTimeParser dateTimeParser = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().appendLiteral('.').toParser(), new DateTimeFormatterBuilder().appendLiteral(',').toParser()}).toParser();
                return new DateTimeFormatterBuilder().append(Constants.hourElement()).append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().append(Constants.minuteElement()).append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().append(Constants.secondElement()).appendOptional(new DateTimeFormatterBuilder().append(dateTimeParser).appendFractionOfSecond(1, 9).toParser()).toParser(), new DateTimeFormatterBuilder().append(dateTimeParser).appendFractionOfMinute(1, 9).toParser(), null}).toParser(), new DateTimeFormatterBuilder().append(dateTimeParser).appendFractionOfHour(1, 9).toParser(), null}).toFormatter();
            }
            return tpe;
        }

        private static DateTimeFormatter dateOptionalTimeParser() {
            if (dotp == null) {
                DateTimeParser dateTimeParser = new DateTimeFormatterBuilder().appendLiteral('T').appendOptional(Constants.timeElementParser().getParser()).appendOptional(Constants.offsetElement().getParser()).toParser();
                return new DateTimeFormatterBuilder().append(Constants.dateElementParser()).appendOptional(dateTimeParser).toFormatter();
            }
            return dotp;
        }

        private static DateTimeFormatter time() {
            if (t == null) {
                return new DateTimeFormatterBuilder().append(Constants.hourMinuteSecondFraction()).append(Constants.offsetElement()).toFormatter();
            }
            return t;
        }

        private static DateTimeFormatter timeNoMillis() {
            if (tx == null) {
                return new DateTimeFormatterBuilder().append(Constants.hourMinuteSecond()).append(Constants.offsetElement()).toFormatter();
            }
            return tx;
        }

        private static DateTimeFormatter tTime() {
            if (tt == null) {
                return new DateTimeFormatterBuilder().append(Constants.literalTElement()).append(Constants.time()).toFormatter();
            }
            return tt;
        }

        private static DateTimeFormatter tTimeNoMillis() {
            if (ttx == null) {
                return new DateTimeFormatterBuilder().append(Constants.literalTElement()).append(Constants.timeNoMillis()).toFormatter();
            }
            return ttx;
        }

        private static DateTimeFormatter ordinalDate() {
            if (od == null) {
                return new DateTimeFormatterBuilder().append(Constants.yearElement()).append(Constants.dayOfYearElement()).toFormatter();
            }
            return od;
        }

        private static DateTimeFormatter basicDate() {
            if (bd == null) {
                return new DateTimeFormatterBuilder().appendYear(4, 4).appendFixedDecimal(DateTimeFieldType.monthOfYear(), 2).appendFixedDecimal(DateTimeFieldType.dayOfMonth(), 2).toFormatter();
            }
            return bd;
        }

        private static DateTimeFormatter basicTime() {
            if (bt == null) {
                return new DateTimeFormatterBuilder().appendFixedDecimal(DateTimeFieldType.hourOfDay(), 2).appendFixedDecimal(DateTimeFieldType.minuteOfHour(), 2).appendFixedDecimal(DateTimeFieldType.secondOfMinute(), 2).appendLiteral('.').appendFractionOfSecond(3, 9).appendTimeZoneOffset("Z", false, 2, 2).toFormatter();
            }
            return bt;
        }

        private static DateTimeFormatter basicTimeNoMillis() {
            if (btx == null) {
                return new DateTimeFormatterBuilder().appendFixedDecimal(DateTimeFieldType.hourOfDay(), 2).appendFixedDecimal(DateTimeFieldType.minuteOfHour(), 2).appendFixedDecimal(DateTimeFieldType.secondOfMinute(), 2).appendTimeZoneOffset("Z", false, 2, 2).toFormatter();
            }
            return btx;
        }

        private static DateTimeFormatter basicTTime() {
            if (btt == null) {
                return new DateTimeFormatterBuilder().append(Constants.literalTElement()).append(Constants.basicTime()).toFormatter();
            }
            return btt;
        }

        private static DateTimeFormatter basicTTimeNoMillis() {
            if (bttx == null) {
                return new DateTimeFormatterBuilder().append(Constants.literalTElement()).append(Constants.basicTimeNoMillis()).toFormatter();
            }
            return bttx;
        }

        private static DateTimeFormatter basicOrdinalDate() {
            if (bod == null) {
                return new DateTimeFormatterBuilder().appendYear(4, 4).appendFixedDecimal(DateTimeFieldType.dayOfYear(), 3).toFormatter();
            }
            return bod;
        }

        private static DateTimeFormatter basicWeekDate() {
            if (bwd == null) {
                return new DateTimeFormatterBuilder().appendWeekyear(4, 4).appendLiteral('W').appendFixedDecimal(DateTimeFieldType.weekOfWeekyear(), 2).appendFixedDecimal(DateTimeFieldType.dayOfWeek(), 1).toFormatter();
            }
            return bwd;
        }

        private static DateTimeFormatter hourMinute() {
            if (hm == null) {
                return new DateTimeFormatterBuilder().append(Constants.hourElement()).append(Constants.minuteElement()).toFormatter();
            }
            return hm;
        }

        private static DateTimeFormatter hourMinuteSecond() {
            if (hms == null) {
                return new DateTimeFormatterBuilder().append(Constants.hourElement()).append(Constants.minuteElement()).append(Constants.secondElement()).toFormatter();
            }
            return hms;
        }

        private static DateTimeFormatter hourMinuteSecondMillis() {
            if (hmsl == null) {
                return new DateTimeFormatterBuilder().append(Constants.hourElement()).append(Constants.minuteElement()).append(Constants.secondElement()).appendLiteral('.').appendFractionOfSecond(3, 3).toFormatter();
            }
            return hmsl;
        }

        private static DateTimeFormatter hourMinuteSecondFraction() {
            if (hmsf == null) {
                return new DateTimeFormatterBuilder().append(Constants.hourElement()).append(Constants.minuteElement()).append(Constants.secondElement()).append(Constants.fractionElement()).toFormatter();
            }
            return hmsf;
        }

        private static DateTimeFormatter yearElement() {
            if (ye == null) {
                return new DateTimeFormatterBuilder().appendYear(4, 9).toFormatter();
            }
            return ye;
        }

        private static DateTimeFormatter monthElement() {
            if (mye == null) {
                return new DateTimeFormatterBuilder().appendLiteral('-').appendMonthOfYear(2).toFormatter();
            }
            return mye;
        }

        private static DateTimeFormatter dayOfMonthElement() {
            if (dme == null) {
                return new DateTimeFormatterBuilder().appendLiteral('-').appendDayOfMonth(2).toFormatter();
            }
            return dme;
        }

        private static DateTimeFormatter weekyearElement() {
            if (we == null) {
                return new DateTimeFormatterBuilder().appendWeekyear(4, 9).toFormatter();
            }
            return we;
        }

        private static DateTimeFormatter weekElement() {
            if (wwe == null) {
                return new DateTimeFormatterBuilder().appendLiteral("-W").appendWeekOfWeekyear(2).toFormatter();
            }
            return wwe;
        }

        private static DateTimeFormatter dayOfWeekElement() {
            if (dwe == null) {
                return new DateTimeFormatterBuilder().appendLiteral('-').appendDayOfWeek(1).toFormatter();
            }
            return dwe;
        }

        private static DateTimeFormatter dayOfYearElement() {
            if (dye == null) {
                return new DateTimeFormatterBuilder().appendLiteral('-').appendDayOfYear(3).toFormatter();
            }
            return dye;
        }

        private static DateTimeFormatter literalTElement() {
            if (lte == null) {
                return new DateTimeFormatterBuilder().appendLiteral('T').toFormatter();
            }
            return lte;
        }

        private static DateTimeFormatter hourElement() {
            if (hde == null) {
                return new DateTimeFormatterBuilder().appendHourOfDay(2).toFormatter();
            }
            return hde;
        }

        private static DateTimeFormatter minuteElement() {
            if (mhe == null) {
                return new DateTimeFormatterBuilder().appendLiteral(':').appendMinuteOfHour(2).toFormatter();
            }
            return mhe;
        }

        private static DateTimeFormatter secondElement() {
            if (sme == null) {
                return new DateTimeFormatterBuilder().appendLiteral(':').appendSecondOfMinute(2).toFormatter();
            }
            return sme;
        }

        private static DateTimeFormatter fractionElement() {
            if (fse == null) {
                return new DateTimeFormatterBuilder().appendLiteral('.').appendFractionOfSecond(3, 9).toFormatter();
            }
            return fse;
        }

        private static DateTimeFormatter offsetElement() {
            if (ze == null) {
                return new DateTimeFormatterBuilder().appendTimeZoneOffset("Z", true, 2, 4).toFormatter();
            }
            return ze;
        }

        static {
            DateTimeFormatter dateTimeFormatter;
            DateTimeFormatter dateTimeFormatter2;
            DateTimeFormatter dateTimeFormatter3;
            DateTimeParser dateTimeParser;
            ye = Constants.yearElement();
            mye = Constants.monthElement();
            dme = Constants.dayOfMonthElement();
            we = Constants.weekyearElement();
            wwe = Constants.weekElement();
            dwe = Constants.dayOfWeekElement();
            dye = Constants.dayOfYearElement();
            hde = Constants.hourElement();
            mhe = Constants.minuteElement();
            sme = Constants.secondElement();
            fse = Constants.fractionElement();
            ze = Constants.offsetElement();
            lte = Constants.literalTElement();
            ym = ym == null ? new DateTimeFormatterBuilder().append(Constants.yearElement()).append(Constants.monthElement()).toFormatter() : ym;
            ymd = ymd == null ? new DateTimeFormatterBuilder().append(Constants.yearElement()).append(Constants.monthElement()).append(Constants.dayOfMonthElement()).toFormatter() : ymd;
            ww = ww == null ? new DateTimeFormatterBuilder().append(Constants.weekyearElement()).append(Constants.weekElement()).toFormatter() : ww;
            wwd = wwd == null ? new DateTimeFormatterBuilder().append(Constants.weekyearElement()).append(Constants.weekElement()).append(Constants.dayOfWeekElement()).toFormatter() : wwd;
            hm = Constants.hourMinute();
            hms = Constants.hourMinuteSecond();
            hmsl = Constants.hourMinuteSecondMillis();
            hmsf = Constants.hourMinuteSecondFraction();
            dh = dh == null ? new DateTimeFormatterBuilder().append(ymd).append(Constants.literalTElement()).append(hde).toFormatter() : dh;
            dhm = dhm == null ? new DateTimeFormatterBuilder().append(ymd).append(Constants.literalTElement()).append(Constants.hourMinute()).toFormatter() : dhm;
            dhms = dhms == null ? new DateTimeFormatterBuilder().append(ymd).append(Constants.literalTElement()).append(Constants.hourMinuteSecond()).toFormatter() : dhms;
            dhmsl = dhmsl == null ? new DateTimeFormatterBuilder().append(ymd).append(Constants.literalTElement()).append(Constants.hourMinuteSecondMillis()).toFormatter() : dhmsl;
            dhmsf = dhmsf == null ? new DateTimeFormatterBuilder().append(ymd).append(Constants.literalTElement()).append(Constants.hourMinuteSecondFraction()).toFormatter() : dhmsf;
            t = Constants.time();
            tx = Constants.timeNoMillis();
            tt = Constants.tTime();
            ttx = Constants.tTimeNoMillis();
            dt = dt == null ? new DateTimeFormatterBuilder().append(ymd).append(Constants.tTime()).toFormatter() : dt;
            dtx = dtx == null ? new DateTimeFormatterBuilder().append(ymd).append(Constants.tTimeNoMillis()).toFormatter() : dtx;
            wdt = wdt == null ? new DateTimeFormatterBuilder().append(wwd).append(Constants.tTime()).toFormatter() : wdt;
            wdtx = wdtx == null ? new DateTimeFormatterBuilder().append(wwd).append(Constants.tTimeNoMillis()).toFormatter() : wdtx;
            od = Constants.ordinalDate();
            odt = odt == null ? new DateTimeFormatterBuilder().append(Constants.ordinalDate()).append(Constants.tTime()).toFormatter() : odt;
            odtx = odtx == null ? new DateTimeFormatterBuilder().append(Constants.ordinalDate()).append(Constants.tTimeNoMillis()).toFormatter() : odtx;
            bd = Constants.basicDate();
            bt = Constants.basicTime();
            btx = Constants.basicTimeNoMillis();
            btt = Constants.basicTTime();
            bttx = Constants.basicTTimeNoMillis();
            bdt = bdt == null ? new DateTimeFormatterBuilder().append(Constants.basicDate()).append(Constants.basicTTime()).toFormatter() : bdt;
            bdtx = bdtx == null ? new DateTimeFormatterBuilder().append(Constants.basicDate()).append(Constants.basicTTimeNoMillis()).toFormatter() : bdtx;
            bod = Constants.basicOrdinalDate();
            bodt = bodt == null ? new DateTimeFormatterBuilder().append(Constants.basicOrdinalDate()).append(Constants.basicTTime()).toFormatter() : bodt;
            bodtx = bodtx == null ? new DateTimeFormatterBuilder().append(Constants.basicOrdinalDate()).append(Constants.basicTTimeNoMillis()).toFormatter() : bodtx;
            bwd = Constants.basicWeekDate();
            bwdt = bwdt == null ? new DateTimeFormatterBuilder().append(Constants.basicWeekDate()).append(Constants.basicTTime()).toFormatter() : bwdt;
            bwdtx = bwdtx == null ? new DateTimeFormatterBuilder().append(Constants.basicWeekDate()).append(Constants.basicTTimeNoMillis()).toFormatter() : bwdtx;
            dpe = Constants.dateElementParser();
            tpe = Constants.timeElementParser();
            if (dp == null) {
                dateTimeParser = new DateTimeFormatterBuilder().appendLiteral('T').append(Constants.offsetElement()).toParser();
                dateTimeFormatter3 = new DateTimeFormatterBuilder().append(Constants.dateElementParser()).appendOptional(dateTimeParser).toFormatter();
            } else {
                dateTimeFormatter3 = dp;
            }
            dp = dateTimeFormatter3;
            ldp = ldp == null ? Constants.dateElementParser().withZoneUTC() : ldp;
            tp = tp == null ? new DateTimeFormatterBuilder().appendOptional(Constants.literalTElement().getParser()).append(Constants.timeElementParser()).appendOptional(Constants.offsetElement().getParser()).toFormatter() : tp;
            DateTimeFormatter dateTimeFormatter4 = ltp = ltp == null ? new DateTimeFormatterBuilder().appendOptional(Constants.literalTElement().getParser()).append(Constants.timeElementParser()).toFormatter().withZoneUTC() : ltp;
            if (dtp == null) {
                dateTimeParser = new DateTimeFormatterBuilder().appendLiteral('T').append(Constants.timeElementParser()).appendOptional(Constants.offsetElement().getParser()).toParser();
                dateTimeFormatter2 = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{dateTimeParser, Constants.dateOptionalTimeParser().getParser()}).toFormatter();
            } else {
                dateTimeFormatter2 = dtp;
            }
            dtp = dateTimeFormatter2;
            dotp = Constants.dateOptionalTimeParser();
            if (ldotp == null) {
                dateTimeParser = new DateTimeFormatterBuilder().appendLiteral('T').append(Constants.timeElementParser()).toParser();
                dateTimeFormatter = new DateTimeFormatterBuilder().append(Constants.dateElementParser()).appendOptional(dateTimeParser).toFormatter().withZoneUTC();
            } else {
                dateTimeFormatter = ldotp;
            }
            ldotp = dateTimeFormatter;
        }
    }
}

