/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DurationFieldType;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.FormatUtils;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.format.PeriodParser;
import org.joda.time.format.PeriodPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PeriodFormatterBuilder {
    private int iMinPrintedDigits;
    private int iPrintZeroSetting;
    private int iMaxParsedDigits;
    private boolean iRejectSignedValues;
    private PeriodFieldAffix iPrefix;
    private List<Object> iElementPairs;
    private boolean iNotPrinter;
    private boolean iNotParser;
    private FieldFormatter[] iFieldFormatters;

    public PeriodFormatterBuilder() {
        PeriodFormatterBuilder periodFormatterBuilder = this;
        this.iMinPrintedDigits = 1;
        periodFormatterBuilder.iPrintZeroSetting = 2;
        periodFormatterBuilder.iMaxParsedDigits = 10;
        periodFormatterBuilder.iRejectSignedValues = false;
        periodFormatterBuilder.iPrefix = null;
        if (periodFormatterBuilder.iElementPairs == null) {
            periodFormatterBuilder.iElementPairs = new ArrayList<Object>();
        } else {
            periodFormatterBuilder.iElementPairs.clear();
        }
        periodFormatterBuilder.iNotPrinter = false;
        periodFormatterBuilder.iNotParser = false;
        periodFormatterBuilder.iFieldFormatters = new FieldFormatter[10];
    }

    public final ISODateTimeFormat toFormatter$17c1ff41() {
        ISODateTimeFormat iSODateTimeFormat = PeriodFormatterBuilder.toFormatter$6cecf76e(this.iElementPairs, this.iNotPrinter, this.iNotParser);
        FieldFormatter[] fieldFormatterArray = this.iFieldFormatters;
        int n = this.iFieldFormatters.length;
        for (int i = 0; i < n; ++i) {
            FieldFormatter fieldFormatter = fieldFormatterArray[i];
            if (fieldFormatter == null) continue;
            fieldFormatter.finish(this.iFieldFormatters);
        }
        this.iFieldFormatters = (FieldFormatter[])this.iFieldFormatters.clone();
        return iSODateTimeFormat;
    }

    public final PeriodFormatterBuilder appendLiteral(String object) {
        this.clearPrefix();
        Object object2 = object = new Literal((String)object);
        this.append0((PeriodPrinter)object2, (PeriodParser)object2);
        return this;
    }

    public final PeriodFormatterBuilder printZeroAlways() {
        this.iPrintZeroSetting = 4;
        return this;
    }

    public final PeriodFormatterBuilder appendYears() {
        this.appendField(0);
        return this;
    }

    public final PeriodFormatterBuilder appendMonths() {
        this.appendField(1);
        return this;
    }

    public final PeriodFormatterBuilder appendWeeks() {
        this.appendField(2);
        return this;
    }

    public final PeriodFormatterBuilder appendDays() {
        this.appendField(3);
        return this;
    }

    public final PeriodFormatterBuilder appendHours() {
        this.appendField(4);
        return this;
    }

    public final PeriodFormatterBuilder appendMinutes() {
        this.appendField(5);
        return this;
    }

    public final PeriodFormatterBuilder appendSeconds() {
        this.appendField(6);
        return this;
    }

    public final PeriodFormatterBuilder appendSecondsWithOptionalMillis() {
        this.appendField(9);
        return this;
    }

    private void appendField(int n) {
        this.appendField(n, this.iMinPrintedDigits);
    }

    private void appendField(int n, int n2) {
        FieldFormatter fieldFormatter;
        FieldFormatter fieldFormatter2 = fieldFormatter = new FieldFormatter(n2, this.iPrintZeroSetting, this.iMaxParsedDigits, false, n, this.iFieldFormatters, this.iPrefix, null);
        this.append0(fieldFormatter2, fieldFormatter2);
        this.iFieldFormatters[n] = fieldFormatter;
        this.iPrefix = null;
    }

    public final PeriodFormatterBuilder appendSuffix(String string) {
        return this.appendSuffix(new SimpleAffix(string));
    }

    public final PeriodFormatterBuilder appendSuffix(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        return this.appendSuffix(new PluralAffix(string, string2));
    }

    private PeriodFormatterBuilder appendSuffix(PeriodFieldAffix object) {
        Object object2;
        Object object3;
        if (this.iElementPairs.size() > 0) {
            object3 = this.iElementPairs.get(this.iElementPairs.size() - 2);
            object2 = this.iElementPairs.get(this.iElementPairs.size() - 1);
        } else {
            object3 = null;
            object2 = null;
        }
        if (object3 == null || object2 == null || object3 != object2 || !(object3 instanceof FieldFormatter)) {
            throw new IllegalStateException("No field to apply suffix to");
        }
        this.clearPrefix();
        object = new FieldFormatter((FieldFormatter)object3, (PeriodFieldAffix)object);
        this.iElementPairs.set(this.iElementPairs.size() - 2, object);
        this.iElementPairs.set(this.iElementPairs.size() - 1, object);
        this.iFieldFormatters[((FieldFormatter)object).getFieldType()] = object;
        return this;
    }

    public final PeriodFormatterBuilder appendSeparator(String string) {
        String string2 = string;
        return this.appendSeparator(string2, string2, null, true, true);
    }

    public final PeriodFormatterBuilder appendSeparatorIfFieldsAfter(String string) {
        String string2 = string;
        return this.appendSeparator(string2, string2, null, false, true);
    }

    private PeriodFormatterBuilder appendSeparator(String object, String string, String[] stringArray, boolean bl, boolean bl2) {
        if (object == null || string == null) {
            throw new IllegalArgumentException();
        }
        this.clearPrefix();
        List<Object> list = this.iElementPairs;
        if (list.size() == 0) {
            if (!bl) {
                Separator separator;
                Literal literal = Literal.EMPTY;
                Separator separator2 = separator = new Separator((String)object, string, stringArray, literal, literal, bl, true);
                this.append0(separator2, separator2);
            }
            return this;
        }
        Separator separator = null;
        int n = list.size();
        while (--n >= 0) {
            if (list.get(n) instanceof Separator) {
                separator = (Separator)list.get(n);
                list = list.subList(n + 1, list.size());
                break;
            }
            --n;
        }
        if (separator != null && list.size() == 0) {
            throw new IllegalStateException("Cannot have two adjacent separators");
        }
        Object[] objectArray = PeriodFormatterBuilder.createComposite(list);
        list.clear();
        object = new Separator((String)object, string, stringArray, (PeriodPrinter)objectArray[0], (PeriodParser)objectArray[1], bl, true);
        list.add(object);
        list.add(object);
        return this;
    }

    private void clearPrefix() throws IllegalStateException {
        if (this.iPrefix != null) {
            throw new IllegalStateException("Prefix not followed by field");
        }
        this.iPrefix = null;
    }

    private PeriodFormatterBuilder append0(PeriodPrinter periodPrinter, PeriodParser periodParser) {
        this.iElementPairs.add(periodPrinter);
        this.iElementPairs.add(periodParser);
        this.iNotPrinter = this.iNotPrinter;
        this.iNotParser = this.iNotParser;
        return this;
    }

    private static ISODateTimeFormat toFormatter$6cecf76e(List<Object> object, boolean bl, boolean bl2) {
        Object object2;
        if (bl && bl2) {
            throw new IllegalStateException("Builder has created neither a printer nor a parser");
        }
        int n = object.size();
        if (n >= 2 && object.get(0) instanceof Separator && ((Separator)(object2 = (Separator)object.get(0))).iAfterParser == null && ((Separator)object2).iAfterPrinter == null) {
            object = PeriodFormatterBuilder.toFormatter$6cecf76e(object.subList(2, n), bl, bl2);
            Object object3 = object2 = ((Separator)object2).finish(((ISODateTimeFormat)object).getPrinter(), ((ISODateTimeFormat)object).getParser());
            return new ISODateTimeFormat((PeriodPrinter)object3, (PeriodParser)object3);
        }
        object2 = PeriodFormatterBuilder.createComposite(object);
        if (bl) {
            return new ISODateTimeFormat(null, (PeriodParser)object2[1]);
        }
        if (bl2) {
            return new ISODateTimeFormat((PeriodPrinter)object2[0], null);
        }
        return new ISODateTimeFormat((PeriodPrinter)object2[0], (PeriodParser)object2[1]);
    }

    private static Object[] createComposite(List<Object> object) {
        switch (object.size()) {
            case 0: {
                return new Object[]{Literal.EMPTY, Literal.EMPTY};
            }
            case 1: {
                return new Object[]{object.get(0), object.get(1)};
            }
        }
        object = new Composite((List<Object>)object);
        return new Object[]{object, object};
    }

    static {
        new ConcurrentHashMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Composite
    implements PeriodParser,
    PeriodPrinter {
        private final PeriodPrinter[] iPrinters;
        private final PeriodParser[] iParsers;

        Composite(List<Object> list) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            this.decompose(list, arrayList, arrayList2);
            if (arrayList.size() <= 0) {
                this.iPrinters = null;
            } else {
                ArrayList<Object> arrayList3 = arrayList;
                this.iPrinters = arrayList3.toArray(new PeriodPrinter[arrayList3.size()]);
            }
            if (arrayList2.size() <= 0) {
                this.iParsers = null;
                return;
            }
            ArrayList<Object> arrayList4 = arrayList2;
            this.iParsers = arrayList4.toArray(new PeriodParser[arrayList4.size()]);
        }

        @Override
        public final int countFieldsToPrint(ReadablePeriod readablePeriod, int n, Locale locale) {
            int n2;
            PeriodPrinter[] periodPrinterArray = this.iPrinters;
            int n3 = this.iPrinters.length;
            for (n2 = 0; n2 < n && --n3 >= 0; n2 += periodPrinterArray[n3].countFieldsToPrint(readablePeriod, Integer.MAX_VALUE, locale)) {
            }
            return n2;
        }

        @Override
        public final int calculatePrintedLength(ReadablePeriod readablePeriod, Locale locale) {
            int n = 0;
            PeriodPrinter[] periodPrinterArray = this.iPrinters;
            int n2 = this.iPrinters.length;
            while (--n2 >= 0) {
                n += periodPrinterArray[n2].calculatePrintedLength(readablePeriod, locale);
            }
            return n;
        }

        @Override
        public final void printTo(StringBuffer stringBuffer, ReadablePeriod readablePeriod, Locale locale) {
            PeriodPrinter[] periodPrinterArray = this.iPrinters;
            int n = this.iPrinters.length;
            for (int i = 0; i < n; ++i) {
                periodPrinterArray[i].printTo(stringBuffer, readablePeriod, locale);
            }
        }

        private void decompose(List<Object> list, List<Object> list2, List<Object> list3) {
            int n = list.size();
            for (int i = 0; i < n; i += 2) {
                Object object = list.get(i);
                if (object instanceof PeriodPrinter) {
                    if (object instanceof Composite) {
                        Composite.addArrayToList(list2, ((Composite)object).iPrinters);
                    } else {
                        list2.add(object);
                    }
                }
                if (!((object = list.get(i + 1)) instanceof PeriodParser)) continue;
                if (object instanceof Composite) {
                    Composite.addArrayToList(list3, ((Composite)object).iParsers);
                    continue;
                }
                list3.add(object);
            }
        }

        private static void addArrayToList(List<Object> list, Object[] objectArray) {
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    list.add(objectArray[i]);
                }
            }
        }
    }

    static final class Separator
    implements PeriodParser,
    PeriodPrinter {
        private final String iText;
        private final String iFinalText;
        private final boolean iUseBefore;
        private final boolean iUseAfter;
        private final PeriodPrinter iBeforePrinter;
        private volatile PeriodPrinter iAfterPrinter;
        private volatile PeriodParser iAfterParser;

        Separator(String object, String string, String[] stringArray, PeriodPrinter periodPrinter, PeriodParser object2, boolean bl, boolean bl2) {
            this.iText = object;
            this.iFinalText = string;
            if (!(string != null && !((String)object).equals(string) || stringArray != null && stringArray.length != 0)) {
                (new String[1])[0] = object;
            } else {
                object2 = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                ((TreeSet)object2).add(object);
                ((TreeSet)object2).add(string);
                if (stringArray != null) {
                    int n = stringArray.length;
                    while (--n >= 0) {
                        ((TreeSet)object2).add(stringArray[n]);
                    }
                }
                object = new ArrayList(object2);
                Collections.reverse(object);
                Object object3 = object;
                ((ArrayList)object3).toArray(new String[((ArrayList)object3).size()]);
            }
            this.iBeforePrinter = periodPrinter;
            this.iUseBefore = bl;
            this.iUseAfter = bl2;
        }

        public final int countFieldsToPrint(ReadablePeriod readablePeriod, int n, Locale locale) {
            int n2 = this.iBeforePrinter.countFieldsToPrint(readablePeriod, n, locale);
            if (n2 < n) {
                n2 += this.iAfterPrinter.countFieldsToPrint(readablePeriod, n, locale);
            }
            return n2;
        }

        public final int calculatePrintedLength(ReadablePeriod readablePeriod, Locale locale) {
            PeriodPrinter periodPrinter = this.iBeforePrinter;
            PeriodPrinter periodPrinter2 = this.iAfterPrinter;
            int n = periodPrinter.calculatePrintedLength(readablePeriod, locale) + periodPrinter2.calculatePrintedLength(readablePeriod, locale);
            if (this.iUseBefore) {
                if (periodPrinter.countFieldsToPrint(readablePeriod, 1, locale) > 0) {
                    if (this.iUseAfter) {
                        int n2 = periodPrinter2.countFieldsToPrint(readablePeriod, 2, locale);
                        if (n2 > 0) {
                            n += (n2 > 1 ? this.iText : this.iFinalText).length();
                        }
                    } else {
                        n += this.iText.length();
                    }
                }
            } else if (this.iUseAfter && periodPrinter2.countFieldsToPrint(readablePeriod, 1, locale) > 0) {
                n += this.iText.length();
            }
            return n;
        }

        public final void printTo(StringBuffer stringBuffer, ReadablePeriod readablePeriod, Locale locale) {
            PeriodPrinter periodPrinter = this.iBeforePrinter;
            PeriodPrinter periodPrinter2 = this.iAfterPrinter;
            periodPrinter.printTo(stringBuffer, readablePeriod, locale);
            if (this.iUseBefore) {
                if (periodPrinter.countFieldsToPrint(readablePeriod, 1, locale) > 0) {
                    if (this.iUseAfter) {
                        int n = periodPrinter2.countFieldsToPrint(readablePeriod, 2, locale);
                        if (n > 0) {
                            stringBuffer.append(n > 1 ? this.iText : this.iFinalText);
                        }
                    } else {
                        stringBuffer.append(this.iText);
                    }
                }
            } else if (this.iUseAfter && periodPrinter2.countFieldsToPrint(readablePeriod, 1, locale) > 0) {
                stringBuffer.append(this.iText);
            }
            periodPrinter2.printTo(stringBuffer, readablePeriod, locale);
        }

        final Separator finish(PeriodPrinter periodPrinter, PeriodParser periodParser) {
            this.iAfterPrinter = periodPrinter;
            this.iAfterParser = periodParser;
            return this;
        }
    }

    static final class Literal
    implements PeriodParser,
    PeriodPrinter {
        static final Literal EMPTY = new Literal("");
        private final String iText;

        Literal(String string) {
            this.iText = string;
        }

        public final int countFieldsToPrint(ReadablePeriod readablePeriod, int n, Locale locale) {
            return 0;
        }

        public final int calculatePrintedLength(ReadablePeriod readablePeriod, Locale locale) {
            return this.iText.length();
        }

        public final void printTo(StringBuffer stringBuffer, ReadablePeriod readablePeriod, Locale locale) {
            stringBuffer.append(this.iText);
        }
    }

    static final class FieldFormatter
    implements PeriodParser,
    PeriodPrinter {
        private final int iMinPrintedDigits;
        private final int iPrintZeroSetting;
        private final int iMaxParsedDigits;
        private final boolean iRejectSignedValues;
        private final int iFieldType;
        private final FieldFormatter[] iFieldFormatters;
        private final PeriodFieldAffix iPrefix;
        private final PeriodFieldAffix iSuffix;

        FieldFormatter(int n, int n2, int n3, boolean bl, int n4, FieldFormatter[] fieldFormatterArray, PeriodFieldAffix periodFieldAffix, PeriodFieldAffix periodFieldAffix2) {
            this.iMinPrintedDigits = n;
            this.iPrintZeroSetting = n2;
            this.iMaxParsedDigits = n3;
            this.iRejectSignedValues = bl;
            this.iFieldType = n4;
            this.iFieldFormatters = fieldFormatterArray;
            this.iPrefix = periodFieldAffix;
            this.iSuffix = periodFieldAffix2;
        }

        FieldFormatter(FieldFormatter fieldFormatter, PeriodFieldAffix periodFieldAffix) {
            this.iMinPrintedDigits = fieldFormatter.iMinPrintedDigits;
            this.iPrintZeroSetting = fieldFormatter.iPrintZeroSetting;
            this.iMaxParsedDigits = fieldFormatter.iMaxParsedDigits;
            this.iRejectSignedValues = fieldFormatter.iRejectSignedValues;
            this.iFieldType = fieldFormatter.iFieldType;
            this.iFieldFormatters = fieldFormatter.iFieldFormatters;
            this.iPrefix = fieldFormatter.iPrefix;
            if (fieldFormatter.iSuffix != null) {
                periodFieldAffix = new CompositeAffix(fieldFormatter.iSuffix, periodFieldAffix);
            }
            this.iSuffix = periodFieldAffix;
        }

        public final void finish(FieldFormatter[] fieldFormatterArray) {
            HashSet<PeriodFieldAffix> hashSet = new HashSet<PeriodFieldAffix>();
            HashSet<PeriodFieldAffix> hashSet2 = new HashSet<PeriodFieldAffix>();
            for (FieldFormatter fieldFormatter : fieldFormatterArray) {
                if (fieldFormatter == null || this.equals(fieldFormatter)) continue;
                hashSet.add(fieldFormatter.iPrefix);
                hashSet2.add(fieldFormatter.iSuffix);
            }
            if (this.iPrefix != null) {
                this.iPrefix.finish(hashSet);
            }
            if (this.iSuffix != null) {
                this.iSuffix.finish(hashSet2);
            }
        }

        public final int countFieldsToPrint(ReadablePeriod readablePeriod, int n, Locale locale) {
            if (n <= 0) {
                return 0;
            }
            if (this.iPrintZeroSetting == 4 || this.getFieldValue(readablePeriod) != Long.MAX_VALUE) {
                return 1;
            }
            return 0;
        }

        public final int calculatePrintedLength(ReadablePeriod readablePeriod, Locale locale) {
            long l = this.getFieldValue(readablePeriod);
            if (l == Long.MAX_VALUE) {
                return 0;
            }
            int n = Math.max(FormatUtils.calculateDigitCount(l), this.iMinPrintedDigits);
            if (this.iFieldType >= 8) {
                n = l < 0L ? Math.max(n, 5) : Math.max(n, 4);
                ++n;
                if (this.iFieldType == 9 && Math.abs(l) % 1000L == 0L) {
                    n -= 4;
                }
                l /= 1000L;
            }
            int n2 = (int)l;
            if (this.iPrefix != null) {
                n += this.iPrefix.calculatePrintedLength(n2);
            }
            if (this.iSuffix != null) {
                n += this.iSuffix.calculatePrintedLength(n2);
            }
            return n;
        }

        public final void printTo(StringBuffer stringBuffer, ReadablePeriod readablePeriod, Locale locale) {
            long l = this.getFieldValue(readablePeriod);
            if (l == Long.MAX_VALUE) {
                return;
            }
            int n = (int)l;
            if (this.iFieldType >= 8) {
                n = (int)(l / 1000L);
            }
            if (this.iPrefix != null) {
                this.iPrefix.printTo(stringBuffer, n);
            }
            int n2 = stringBuffer.length();
            int n3 = this.iMinPrintedDigits;
            if (n3 <= 1) {
                FormatUtils.appendUnpaddedInteger(stringBuffer, n);
            } else {
                FormatUtils.appendPaddedInteger(stringBuffer, n, n3);
            }
            if (this.iFieldType >= 8) {
                n3 = (int)(Math.abs(l) % 1000L);
                if (this.iFieldType == 8 || n3 > 0) {
                    if (l < 0L && l > -1000L) {
                        stringBuffer.insert(n2, '-');
                    }
                    stringBuffer.append('.');
                    FormatUtils.appendPaddedInteger(stringBuffer, n3, 3);
                }
            }
            if (this.iSuffix != null) {
                this.iSuffix.printTo(stringBuffer, n);
            }
        }

        private long getFieldValue(ReadablePeriod readablePeriod) {
            int n;
            long l;
            PeriodType periodType = this.iPrintZeroSetting == 4 ? null : readablePeriod.getPeriodType();
            if (periodType != null && !FieldFormatter.isSupported(periodType, this.iFieldType)) {
                return Long.MAX_VALUE;
            }
            switch (this.iFieldType) {
                default: {
                    return Long.MAX_VALUE;
                }
                case 0: {
                    l = readablePeriod.get(DurationFieldType.years());
                    break;
                }
                case 1: {
                    l = readablePeriod.get(DurationFieldType.months());
                    break;
                }
                case 2: {
                    l = readablePeriod.get(DurationFieldType.weeks());
                    break;
                }
                case 3: {
                    l = readablePeriod.get(DurationFieldType.days());
                    break;
                }
                case 4: {
                    l = readablePeriod.get(DurationFieldType.hours());
                    break;
                }
                case 5: {
                    l = readablePeriod.get(DurationFieldType.minutes());
                    break;
                }
                case 6: {
                    l = readablePeriod.get(DurationFieldType.seconds());
                    break;
                }
                case 7: {
                    l = readablePeriod.get(DurationFieldType.millis());
                    break;
                }
                case 8: 
                case 9: {
                    n = readablePeriod.get(DurationFieldType.seconds());
                    int n2 = readablePeriod.get(DurationFieldType.millis());
                    l = (long)n * 1000L + (long)n2;
                }
            }
            if (l == 0L) {
                switch (this.iPrintZeroSetting) {
                    case 5: {
                        return Long.MAX_VALUE;
                    }
                    case 2: {
                        if (FieldFormatter.isZero(readablePeriod) && this.iFieldFormatters[this.iFieldType] == this) {
                            for (n = this.iFieldType + 1; n <= 9; ++n) {
                                if (!FieldFormatter.isSupported(periodType, n) || this.iFieldFormatters[n] == null) continue;
                                return Long.MAX_VALUE;
                            }
                            break;
                        }
                        return Long.MAX_VALUE;
                    }
                    case 1: {
                        if (FieldFormatter.isZero(readablePeriod) && this.iFieldFormatters[this.iFieldType] == this) {
                            n = Math.min(this.iFieldType, 8);
                            --n;
                            while (n >= 0) {
                                if (FieldFormatter.isSupported(periodType, n) && this.iFieldFormatters[n] != null) {
                                    return Long.MAX_VALUE;
                                }
                                --n;
                            }
                            break;
                        }
                        return Long.MAX_VALUE;
                    }
                }
            }
            return l;
        }

        private static boolean isZero(ReadablePeriod readablePeriod) {
            int n = readablePeriod.size();
            for (int i = 0; i < n; ++i) {
                if (readablePeriod.getValue(i) == 0) continue;
                return false;
            }
            return true;
        }

        private static boolean isSupported(PeriodType periodType, int n) {
            switch (n) {
                default: {
                    return false;
                }
                case 0: {
                    return periodType.isSupported(DurationFieldType.years());
                }
                case 1: {
                    return periodType.isSupported(DurationFieldType.months());
                }
                case 2: {
                    return periodType.isSupported(DurationFieldType.weeks());
                }
                case 3: {
                    return periodType.isSupported(DurationFieldType.days());
                }
                case 4: {
                    return periodType.isSupported(DurationFieldType.hours());
                }
                case 5: {
                    return periodType.isSupported(DurationFieldType.minutes());
                }
                case 6: {
                    return periodType.isSupported(DurationFieldType.seconds());
                }
                case 7: {
                    return periodType.isSupported(DurationFieldType.millis());
                }
                case 8: 
                case 9: 
            }
            return periodType.isSupported(DurationFieldType.seconds()) || periodType.isSupported(DurationFieldType.millis());
        }

        final int getFieldType() {
            return this.iFieldType;
        }
    }

    static final class CompositeAffix
    extends IgnorableAffix {
        private final PeriodFieldAffix iLeft;
        private final PeriodFieldAffix iRight;
        private final String[] iLeftRightCombinations;

        CompositeAffix(PeriodFieldAffix object, PeriodFieldAffix stringArray) {
            this.iLeft = object;
            this.iRight = stringArray;
            object = new HashSet();
            for (String string : this.iLeft.getAffixes()) {
                for (String string2 : this.iRight.getAffixes()) {
                    object.add(string + string2);
                }
            }
            Object object2 = object;
            this.iLeftRightCombinations = object2.toArray(new String[object2.size()]);
        }

        public final int calculatePrintedLength(int n) {
            return this.iLeft.calculatePrintedLength(n) + this.iRight.calculatePrintedLength(n);
        }

        public final void printTo(StringBuffer stringBuffer, int n) {
            this.iLeft.printTo(stringBuffer, n);
            this.iRight.printTo(stringBuffer, n);
        }

        public final String[] getAffixes() {
            return (String[])this.iLeftRightCombinations.clone();
        }
    }

    static final class PluralAffix
    extends IgnorableAffix {
        private final String iSingularText;
        private final String iPluralText;

        PluralAffix(String string, String string2) {
            this.iSingularText = string;
            this.iPluralText = string2;
        }

        public final int calculatePrintedLength(int n) {
            return (n == 1 ? this.iSingularText : this.iPluralText).length();
        }

        public final void printTo(StringBuffer stringBuffer, int n) {
            stringBuffer.append(n == 1 ? this.iSingularText : this.iPluralText);
        }

        public final String[] getAffixes() {
            return new String[]{this.iSingularText, this.iPluralText};
        }
    }

    static final class SimpleAffix
    extends IgnorableAffix {
        private final String iText;

        SimpleAffix(String string) {
            this.iText = string;
        }

        public final int calculatePrintedLength(int n) {
            return this.iText.length();
        }

        public final void printTo(StringBuffer stringBuffer, int n) {
            stringBuffer.append(this.iText);
        }

        public final String[] getAffixes() {
            return new String[]{this.iText};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class IgnorableAffix
    implements PeriodFieldAffix {
        private volatile String[] iOtherAffixes;

        IgnorableAffix() {
        }

        @Override
        public final void finish(Set<PeriodFieldAffix> set) {
            if (this.iOtherAffixes == null) {
                int n = Integer.MAX_VALUE;
                String stringArray = null;
                for (String stringArray2 : this.getAffixes()) {
                    if (stringArray2.length() >= n) continue;
                    n = stringArray2.length();
                    stringArray = stringArray2;
                }
                HashSet hashSet = new HashSet();
                for (PeriodFieldAffix periodFieldAffix : set) {
                    if (periodFieldAffix == null) continue;
                    for (String string : periodFieldAffix.getAffixes()) {
                        if (string.length() <= n && (!string.equalsIgnoreCase(stringArray) || string.equals(stringArray))) continue;
                        hashSet.add(string);
                    }
                }
                HashSet hashSet2 = hashSet;
                this.iOtherAffixes = hashSet2.toArray(new String[hashSet2.size()]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface PeriodFieldAffix {
        public int calculatePrintedLength(int var1);

        public void printTo(StringBuffer var1, int var2);

        public String[] getAffixes();

        public void finish(Set<PeriodFieldAffix> var1);
    }
}

