/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import org.joda.time.DateTimeZone;

public final class CachedDateTimeZone
extends DateTimeZone {
    private static final int cInfoCacheMask;
    private final DateTimeZone iZone;
    private final transient Info[] iInfoCache = new Info[cInfoCacheMask + 1];

    public static CachedDateTimeZone forZone(DateTimeZone dateTimeZone) {
        return new CachedDateTimeZone(dateTimeZone);
    }

    private CachedDateTimeZone(DateTimeZone dateTimeZone) {
        super(dateTimeZone.getID());
        this.iZone = dateTimeZone;
    }

    public final String getNameKey(long l) {
        return this.getInfo(l).getNameKey(l);
    }

    public final int getOffset(long l) {
        return this.getInfo(l).getOffset(l);
    }

    public final int getStandardOffset(long l) {
        return this.getInfo(l).getStandardOffset(l);
    }

    public final boolean isFixed() {
        return this.iZone.isFixed();
    }

    public final long nextTransition(long l) {
        return this.iZone.nextTransition(l);
    }

    public final long previousTransition(long l) {
        return this.iZone.previousTransition(l);
    }

    public final int hashCode() {
        return this.iZone.hashCode();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CachedDateTimeZone) {
            return this.iZone.equals(((CachedDateTimeZone)object).iZone);
        }
        return false;
    }

    private Info getInfo(long l) {
        Info[] infoArray = this.iInfoCache;
        int n = (int)(l >> 32);
        int n2 = n & cInfoCacheMask;
        Info info = infoArray[n2];
        if (info == null || (int)(info.iPeriodStart >> 32) != n) {
            infoArray[n2] = info = this.createInfo(l);
        }
        return info;
    }

    private Info createInfo(long l) {
        long l2;
        long l3 = l & 0xFFFFFFFF00000000L;
        Info info = new Info(this.iZone, l3);
        long l4 = l3 | 0xFFFFFFFFL;
        Info info2 = info;
        while ((l2 = this.iZone.nextTransition(l3)) != l3 && l2 <= l4) {
            l3 = l2;
            info2 = info2.iNextInfo = new Info(this.iZone, l3);
        }
        return info;
    }

    static {
        int n;
        Integer n2;
        try {
            n2 = Integer.getInteger("org.joda.time.tz.CachedDateTimeZone.size");
        }
        catch (SecurityException securityException) {
            n2 = null;
        }
        if (n2 == null) {
            n = 512;
        } else {
            n = n2;
            --n;
            int n3 = 0;
            while (n > 0) {
                ++n3;
                n >>= 1;
            }
            n = 1 << n3;
        }
        cInfoCacheMask = n - 1;
    }

    static final class Info {
        public final long iPeriodStart;
        private DateTimeZone iZoneRef;
        Info iNextInfo;
        private String iNameKey;
        private int iOffset = Integer.MIN_VALUE;
        private int iStandardOffset = Integer.MIN_VALUE;

        Info(DateTimeZone dateTimeZone, long l) {
            this.iPeriodStart = l;
            this.iZoneRef = dateTimeZone;
        }

        public final String getNameKey(long l) {
            while (true) {
                if (info.iNextInfo == null || l < info.iNextInfo.iPeriodStart) {
                    if (info.iNameKey == null) {
                        info.iNameKey = info.iZoneRef.getNameKey(info.iPeriodStart);
                    }
                    return info.iNameKey;
                }
                Info info = info.iNextInfo;
            }
        }

        public final int getOffset(long l) {
            while (true) {
                if (info.iNextInfo == null || l < info.iNextInfo.iPeriodStart) {
                    if (info.iOffset == Integer.MIN_VALUE) {
                        info.iOffset = info.iZoneRef.getOffset(info.iPeriodStart);
                    }
                    return info.iOffset;
                }
                Info info = info.iNextInfo;
            }
        }

        public final int getStandardOffset(long l) {
            while (true) {
                if (info.iNextInfo == null || l < info.iNextInfo.iPeriodStart) {
                    if (info.iStandardOffset == Integer.MIN_VALUE) {
                        info.iStandardOffset = info.iZoneRef.getStandardOffset(info.iPeriodStart);
                    }
                    return info.iStandardOffset;
                }
                Info info = info.iNextInfo;
            }
        }
    }
}

