/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.tz.CachedDateTimeZone;
import org.joda.time.tz.FixedDateTimeZone;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class DateTimeZoneBuilder
implements ILoggerFactory {
    public static DateTimeZone readFrom(DataInput object, String string) throws IOException {
        switch (object.readUnsignedByte()) {
            case 70: {
                object = new FixedDateTimeZone(string, object.readUTF(), (int)DateTimeZoneBuilder.readMillis((DataInput)object), (int)DateTimeZoneBuilder.readMillis((DataInput)object));
                if (((DateTimeZone)object).equals(DateTimeZone.UTC)) {
                    object = DateTimeZone.UTC;
                }
                return object;
            }
            case 67: {
                return CachedDateTimeZone.forZone(PrecalculatedZone.readFrom((DataInput)object, string));
            }
            case 80: {
                return PrecalculatedZone.readFrom((DataInput)object, string);
            }
        }
        throw new IOException("Invalid encoding");
    }

    static long readMillis(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        switch (n >> 6) {
            default: {
                n = n << 26 >> 26;
                return (long)n * 1800000L;
            }
            case 1: {
                n = n << 26 >> 2;
                n |= dataInput.readUnsignedByte() << 16;
                n |= dataInput.readUnsignedByte() << 8;
                return (long)(n |= dataInput.readUnsignedByte()) * 60000L;
            }
            case 2: {
                long l = (long)n << 58 >> 26;
                l |= (long)(dataInput.readUnsignedByte() << 24);
                l |= (long)(dataInput.readUnsignedByte() << 16);
                l |= (long)(dataInput.readUnsignedByte() << 8);
                return (l |= (long)dataInput.readUnsignedByte()) * 1000L;
            }
            case 3: 
        }
        return dataInput.readLong();
    }

    public Logger getLogger(String name) {
        return NOPLogger.NOP_LOGGER;
    }

    static final class PrecalculatedZone
    extends DateTimeZone {
        private final long[] iTransitions;
        private final int[] iWallOffsets;
        private final int[] iStandardOffsets;
        private final String[] iNameKeys;
        private final DSTZone iTailZone;

        static PrecalculatedZone readFrom(DataInput dataInput, String string) throws IOException {
            int n;
            int n2 = dataInput.readUnsignedShort();
            String[] stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = dataInput.readUTF();
            }
            n = dataInput.readInt();
            long[] lArray = new long[n];
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = DateTimeZoneBuilder.readMillis(dataInput);
                nArray[i] = (int)DateTimeZoneBuilder.readMillis(dataInput);
                nArray2[i] = (int)DateTimeZoneBuilder.readMillis(dataInput);
                try {
                    int n3 = n2 < 256 ? dataInput.readUnsignedByte() : dataInput.readUnsignedShort();
                    stringArray2[i] = stringArray[n3];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new IOException("Invalid encoding");
                }
            }
            DSTZone dSTZone = null;
            if (dataInput.readBoolean()) {
                String string2 = string;
                dSTZone = new DSTZone(string2, (int)DateTimeZoneBuilder.readMillis(dataInput), Recurrence.readFrom(dataInput), Recurrence.readFrom(dataInput));
            }
            return new PrecalculatedZone(string, lArray, nArray, nArray2, stringArray2, dSTZone);
        }

        private PrecalculatedZone(String string, long[] lArray, int[] nArray, int[] nArray2, String[] stringArray, DSTZone dSTZone) {
            super(string);
            this.iTransitions = lArray;
            this.iWallOffsets = nArray;
            this.iStandardOffsets = nArray2;
            this.iNameKeys = stringArray;
            this.iTailZone = dSTZone;
        }

        public final String getNameKey(long l) {
            long[] lArray = this.iTransitions;
            int n = Arrays.binarySearch(this.iTransitions, l);
            if (n >= 0) {
                return this.iNameKeys[n];
            }
            if ((n ^= 0xFFFFFFFF) < lArray.length) {
                if (n > 0) {
                    return this.iNameKeys[n - 1];
                }
                return "UTC";
            }
            if (this.iTailZone == null) {
                return this.iNameKeys[n - 1];
            }
            return this.iTailZone.getNameKey(l);
        }

        public final int getOffset(long l) {
            long[] lArray = this.iTransitions;
            int n = Arrays.binarySearch(this.iTransitions, l);
            if (n >= 0) {
                return this.iWallOffsets[n];
            }
            if ((n ^= 0xFFFFFFFF) < lArray.length) {
                if (n > 0) {
                    return this.iWallOffsets[n - 1];
                }
                return 0;
            }
            if (this.iTailZone == null) {
                return this.iWallOffsets[n - 1];
            }
            return this.iTailZone.getOffset(l);
        }

        public final int getStandardOffset(long l) {
            long[] lArray = this.iTransitions;
            int n = Arrays.binarySearch(this.iTransitions, l);
            if (n >= 0) {
                return this.iStandardOffsets[n];
            }
            if ((n ^= 0xFFFFFFFF) < lArray.length) {
                if (n > 0) {
                    return this.iStandardOffsets[n - 1];
                }
                return 0;
            }
            if (this.iTailZone == null) {
                return this.iStandardOffsets[n - 1];
            }
            return this.iTailZone.getStandardOffset(l);
        }

        public final boolean isFixed() {
            return false;
        }

        public final long nextTransition(long l) {
            long[] lArray = this.iTransitions;
            int n = Arrays.binarySearch(this.iTransitions, l);
            n = n >= 0 ? n + 1 : ~n;
            if (n < lArray.length) {
                return lArray[n];
            }
            if (this.iTailZone == null) {
                return l;
            }
            long l2 = lArray[lArray.length - 1];
            if (l < l2) {
                l = l2;
            }
            return this.iTailZone.nextTransition(l);
        }

        public final long previousTransition(long l) {
            long l2;
            long[] lArray = this.iTransitions;
            int n = Arrays.binarySearch(this.iTransitions, l);
            if (n >= 0) {
                if (l > Long.MIN_VALUE) {
                    return l - 1L;
                }
                return l;
            }
            if ((n ^= 0xFFFFFFFF) < lArray.length) {
                long l3;
                if (n > 0 && (l3 = lArray[n - 1]) > Long.MIN_VALUE) {
                    return l3 - 1L;
                }
                return l;
            }
            if (this.iTailZone != null && (l2 = this.iTailZone.previousTransition(l)) < l) {
                return l2;
            }
            l2 = lArray[n - 1];
            if (l2 > Long.MIN_VALUE) {
                return l2 - 1L;
            }
            return l;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof PrecalculatedZone) {
                object = (PrecalculatedZone)object;
                return this.getID().equals(((DateTimeZone)object).getID()) && Arrays.equals(this.iTransitions, ((PrecalculatedZone)object).iTransitions) && Arrays.equals(this.iNameKeys, ((PrecalculatedZone)object).iNameKeys) && Arrays.equals(this.iWallOffsets, ((PrecalculatedZone)object).iWallOffsets) && Arrays.equals(this.iStandardOffsets, ((PrecalculatedZone)object).iStandardOffsets) && (this.iTailZone == null ? ((PrecalculatedZone)object).iTailZone == null : this.iTailZone.equals(((PrecalculatedZone)object).iTailZone));
            }
            return false;
        }

        public final int hashCode() {
            return this.getID().hashCode();
        }
    }

    static final class DSTZone
    extends DateTimeZone {
        private int iStandardOffset;
        private Recurrence iStartRecurrence;
        private Recurrence iEndRecurrence;

        DSTZone(String string, int n, Recurrence recurrence, Recurrence recurrence2) {
            super(string);
            this.iStandardOffset = n;
            this.iStartRecurrence = recurrence;
            this.iEndRecurrence = recurrence2;
        }

        public final String getNameKey(long l) {
            Recurrence recurrence = this.findMatchingRecurrence(l);
            return recurrence.iNameKey;
        }

        public final int getOffset(long l) {
            Recurrence recurrence = this.findMatchingRecurrence(l);
            return this.iStandardOffset + recurrence.iSaveMillis;
        }

        public final int getStandardOffset(long l) {
            return this.iStandardOffset;
        }

        public final boolean isFixed() {
            return false;
        }

        public final long nextTransition(long l) {
            long l2;
            long l3;
            Recurrence recurrence;
            int n = this.iStandardOffset;
            Recurrence recurrence2 = this.iStartRecurrence;
            Recurrence recurrence3 = this.iEndRecurrence;
            try {
                recurrence = recurrence3;
                l3 = recurrence2.next(l, n, recurrence.iSaveMillis);
                if (l > 0L && l3 < 0L) {
                    l3 = l;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l3 = l;
            }
            catch (ArithmeticException arithmeticException) {
                l3 = l;
            }
            try {
                recurrence = recurrence2;
                l2 = recurrence3.next(l, n, recurrence.iSaveMillis);
                if (l > 0L && l2 < 0L) {
                    l2 = l;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l2 = l;
            }
            catch (ArithmeticException arithmeticException) {
                l2 = l;
            }
            if (l3 > l2) {
                return l2;
            }
            return l3;
        }

        public final long previousTransition(long l) {
            long l2;
            long l3;
            Recurrence recurrence;
            ++l;
            int n = this.iStandardOffset;
            Recurrence recurrence2 = this.iStartRecurrence;
            Recurrence recurrence3 = this.iEndRecurrence;
            try {
                recurrence = recurrence3;
                l3 = recurrence2.previous(l, n, recurrence.iSaveMillis);
                if (l < 0L && l3 > 0L) {
                    l3 = l;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l3 = l;
            }
            catch (ArithmeticException arithmeticException) {
                l3 = l;
            }
            try {
                recurrence = recurrence2;
                l2 = recurrence3.previous(l, n, recurrence.iSaveMillis);
                if (l < 0L && l2 > 0L) {
                    l2 = l;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l2 = l;
            }
            catch (ArithmeticException arithmeticException) {
                l2 = l;
            }
            return (l3 > l2 ? l3 : l2) - 1L;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof DSTZone) {
                object = (DSTZone)object;
                return this.getID().equals(((DateTimeZone)object).getID()) && this.iStandardOffset == ((DSTZone)object).iStandardOffset && this.iStartRecurrence.equals(((DSTZone)object).iStartRecurrence) && this.iEndRecurrence.equals(((DSTZone)object).iEndRecurrence);
            }
            return false;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.iStandardOffset, this.iStartRecurrence, this.iEndRecurrence});
        }

        private Recurrence findMatchingRecurrence(long l) {
            long l2;
            long l3;
            Recurrence recurrence;
            int n = this.iStandardOffset;
            Recurrence recurrence2 = this.iStartRecurrence;
            Recurrence recurrence3 = this.iEndRecurrence;
            try {
                recurrence = recurrence3;
                l3 = recurrence2.next(l, n, recurrence.iSaveMillis);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l3 = l;
            }
            catch (ArithmeticException arithmeticException) {
                l3 = l;
            }
            try {
                recurrence = recurrence2;
                l2 = recurrence3.next(l, n, recurrence.iSaveMillis);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l2 = l;
            }
            catch (ArithmeticException arithmeticException) {
                l2 = l;
            }
            if (l3 > l2) {
                return recurrence2;
            }
            return recurrence3;
        }
    }

    static final class Recurrence {
        private OfYear iOfYear;
        final String iNameKey;
        final int iSaveMillis;

        static Recurrence readFrom(DataInput dataInput) throws IOException {
            return new Recurrence(OfYear.readFrom(dataInput), dataInput.readUTF(), (int)DateTimeZoneBuilder.readMillis(dataInput));
        }

        private Recurrence(OfYear ofYear, String string, int n) {
            this.iOfYear = ofYear;
            this.iNameKey = string;
            this.iSaveMillis = n;
        }

        public final long next(long l, int n, int n2) {
            return this.iOfYear.next(l, n, n2);
        }

        public final long previous(long l, int n, int n2) {
            return this.iOfYear.previous(l, n, n2);
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Recurrence) {
                object = (Recurrence)object;
                return this.iSaveMillis == ((Recurrence)object).iSaveMillis && this.iNameKey.equals(((Recurrence)object).iNameKey) && this.iOfYear.equals(((Recurrence)object).iOfYear);
            }
            return false;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.iSaveMillis, this.iNameKey, this.iOfYear});
        }

        public final String toString() {
            return this.iOfYear + " named " + this.iNameKey + " at " + this.iSaveMillis;
        }
    }

    static final class OfYear {
        private char iMode;
        private int iMonthOfYear;
        private int iDayOfMonth;
        private int iDayOfWeek;
        private boolean iAdvance;
        private int iMillisOfDay;

        static OfYear readFrom(DataInput dataInput) throws IOException {
            return new OfYear((char)dataInput.readUnsignedByte(), dataInput.readUnsignedByte(), dataInput.readByte(), dataInput.readUnsignedByte(), dataInput.readBoolean(), (int)DateTimeZoneBuilder.readMillis(dataInput));
        }

        private OfYear(char c, int n, int n2, int n3, boolean bl, int n4) {
            if (c != 'u' && c != 'w' && c != 's') {
                throw new IllegalArgumentException("Unknown mode: " + c);
            }
            this.iMode = c;
            this.iMonthOfYear = n;
            this.iDayOfMonth = n2;
            this.iDayOfWeek = n3;
            this.iAdvance = bl;
            this.iMillisOfDay = n4;
        }

        public final long next(long l, int n, int n2) {
            if (this.iMode == 'w') {
                n += n2;
            } else if (this.iMode != 's') {
                n = 0;
            }
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            long l2 = ((Chronology)iSOChronology).monthOfYear().set(l += (long)n, this.iMonthOfYear);
            l2 = ((Chronology)iSOChronology).millisOfDay().set(l2, 0);
            l2 = ((Chronology)iSOChronology).millisOfDay().add(l2, Math.min(this.iMillisOfDay, 86399999));
            l2 = this.setDayOfMonthNext(iSOChronology, l2);
            if (this.iDayOfWeek == 0) {
                if (l2 <= l) {
                    l2 = ((Chronology)iSOChronology).year().add(l2, 1);
                    l2 = this.setDayOfMonthNext(iSOChronology, l2);
                }
            } else if ((l2 = this.setDayOfWeek(iSOChronology, l2)) <= l) {
                l2 = ((Chronology)iSOChronology).year().add(l2, 1);
                l2 = ((Chronology)iSOChronology).monthOfYear().set(l2, this.iMonthOfYear);
                l2 = this.setDayOfMonthNext(iSOChronology, l2);
                l2 = this.setDayOfWeek(iSOChronology, l2);
            }
            l2 = ((Chronology)iSOChronology).millisOfDay().set(l2, 0);
            l2 = ((Chronology)iSOChronology).millisOfDay().add(l2, this.iMillisOfDay);
            return l2 - (long)n;
        }

        public final long previous(long l, int n, int n2) {
            if (this.iMode == 'w') {
                n += n2;
            } else if (this.iMode != 's') {
                n = 0;
            }
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            long l2 = ((Chronology)iSOChronology).monthOfYear().set(l += (long)n, this.iMonthOfYear);
            l2 = ((Chronology)iSOChronology).millisOfDay().set(l2, 0);
            l2 = ((Chronology)iSOChronology).millisOfDay().add(l2, this.iMillisOfDay);
            l2 = this.setDayOfMonthPrevious(iSOChronology, l2);
            if (this.iDayOfWeek == 0) {
                if (l2 >= l) {
                    l2 = ((Chronology)iSOChronology).year().add(l2, -1);
                    l2 = this.setDayOfMonthPrevious(iSOChronology, l2);
                }
            } else if ((l2 = this.setDayOfWeek(iSOChronology, l2)) >= l) {
                l2 = ((Chronology)iSOChronology).year().add(l2, -1);
                l2 = ((Chronology)iSOChronology).monthOfYear().set(l2, this.iMonthOfYear);
                l2 = this.setDayOfMonthPrevious(iSOChronology, l2);
                l2 = this.setDayOfWeek(iSOChronology, l2);
            }
            l2 = ((Chronology)iSOChronology).millisOfDay().set(l2, 0);
            l2 = ((Chronology)iSOChronology).millisOfDay().add(l2, this.iMillisOfDay);
            return l2 - (long)n;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof OfYear) {
                object = (OfYear)object;
                return this.iMode == ((OfYear)object).iMode && this.iMonthOfYear == ((OfYear)object).iMonthOfYear && this.iDayOfMonth == ((OfYear)object).iDayOfMonth && this.iDayOfWeek == ((OfYear)object).iDayOfWeek && this.iAdvance == ((OfYear)object).iAdvance && this.iMillisOfDay == ((OfYear)object).iMillisOfDay;
            }
            return false;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{Character.valueOf(this.iMode), this.iMonthOfYear, this.iDayOfMonth, this.iDayOfWeek, this.iAdvance, this.iMillisOfDay});
        }

        public final String toString() {
            return "[OfYear]\nMode: " + this.iMode + '\n' + "MonthOfYear: " + this.iMonthOfYear + '\n' + "DayOfMonth: " + this.iDayOfMonth + '\n' + "DayOfWeek: " + this.iDayOfWeek + '\n' + "AdvanceDayOfWeek: " + this.iAdvance + '\n' + "MillisOfDay: " + this.iMillisOfDay + '\n';
        }

        private long setDayOfMonthNext(Chronology chronology, long l) {
            try {
                l = this.setDayOfMonth(chronology, l);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.iMonthOfYear == 2 && this.iDayOfMonth == 29) {
                    while (!chronology.year().isLeap(l)) {
                        l = chronology.year().add(l, 1);
                    }
                    l = this.setDayOfMonth(chronology, l);
                }
                throw illegalArgumentException;
            }
            return l;
        }

        private long setDayOfMonthPrevious(Chronology chronology, long l) {
            try {
                l = this.setDayOfMonth(chronology, l);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.iMonthOfYear == 2 && this.iDayOfMonth == 29) {
                    while (!chronology.year().isLeap(l)) {
                        l = chronology.year().add(l, -1);
                    }
                    l = this.setDayOfMonth(chronology, l);
                }
                throw illegalArgumentException;
            }
            return l;
        }

        private long setDayOfMonth(Chronology chronology, long l) {
            if (this.iDayOfMonth >= 0) {
                l = chronology.dayOfMonth().set(l, this.iDayOfMonth);
            } else {
                l = chronology.dayOfMonth().set(l, 1);
                l = chronology.monthOfYear().add(l, 1);
                l = chronology.dayOfMonth().add(l, this.iDayOfMonth);
            }
            return l;
        }

        private long setDayOfWeek(Chronology chronology, long l) {
            int n = chronology.dayOfWeek().get(l);
            if ((n = this.iDayOfWeek - n) != 0) {
                if (this.iAdvance) {
                    if (n < 0) {
                        n += 7;
                    }
                } else if (n > 0) {
                    n -= 7;
                }
                l = chronology.dayOfWeek().add(l, n);
            }
            return l;
        }
    }
}

