/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTimeZone;
import org.joda.time.tz.DateTimeZoneBuilder;
import org.joda.time.tz.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZoneInfoProvider
implements Provider {
    private final File iFileDir;
    private final String iResourcePath;
    private final ClassLoader iLoader;
    private final Map<String, Object> iZoneInfoMap;
    private final Set<String> iZoneInfoKeys;

    public ZoneInfoProvider() throws IOException {
        this("org/joda/time/tz/data");
    }

    public ZoneInfoProvider(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File directory doesn't exist: " + file);
        }
        if (!file.isDirectory()) {
            throw new IOException("File doesn't refer to a directory: " + file);
        }
        this.iFileDir = file;
        this.iResourcePath = null;
        this.iLoader = null;
        this.iZoneInfoMap = ZoneInfoProvider.loadZoneInfoMap(this.openResource("ZoneInfoMap"));
        this.iZoneInfoKeys = Collections.unmodifiableSortedSet(new TreeSet<String>(this.iZoneInfoMap.keySet()));
    }

    public ZoneInfoProvider(String string) throws IOException {
        this(string, null, false);
    }

    private ZoneInfoProvider(String string, ClassLoader classLoader, boolean bl) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("No resource path provided");
        }
        if (!string.endsWith("/")) {
            string = string + '/';
        }
        this.iFileDir = null;
        this.iResourcePath = string;
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.iLoader = classLoader;
        this.iZoneInfoMap = ZoneInfoProvider.loadZoneInfoMap(this.openResource("ZoneInfoMap"));
        this.iZoneInfoKeys = Collections.unmodifiableSortedSet(new TreeSet<String>(this.iZoneInfoMap.keySet()));
    }

    @Override
    public final DateTimeZone getZone(String string) {
        while (string != null) {
            Object object = this.iZoneInfoMap.get(string);
            if (object == null) {
                return null;
            }
            if (object instanceof SoftReference) {
                object = (SoftReference)object;
                if ((object = (DateTimeZone)((SoftReference)object).get()) != null) {
                    return object;
                }
                return this.loadZoneData(string);
            }
            if (string.equals(object)) {
                return this.loadZoneData(string);
            }
            string = (String)object;
        }
        return null;
    }

    @Override
    public final Set<String> getAvailableIDs() {
        return this.iZoneInfoKeys;
    }

    private InputStream openResource(String object) throws IOException {
        if (this.iFileDir != null) {
            object = new FileInputStream(new File(this.iFileDir, (String)object));
        } else {
            String string = this.iResourcePath.concat((String)object);
            if ((object = AccessController.doPrivileged(new PrivilegedAction<InputStream>(this, string){
                private /* synthetic */ String val$path;
                private /* synthetic */ ZoneInfoProvider this$0;
                {
                    this.this$0 = zoneInfoProvider;
                    this.val$path = string;
                }
            })) == null) {
                object = new StringBuilder(40).append("Resource not found: \"").append(string).append("\" ClassLoader: ").append(this.iLoader != null ? this.iLoader.toString() : "system");
                throw new IOException(((StringBuilder)object).toString());
            }
        }
        return object;
    }

    /*
     * Loose catch block
     */
    private DateTimeZone loadZoneData(String string) {
        InputStream inputStream = null;
        inputStream = this.openResource(string);
        String string2 = string;
        Object object = inputStream;
        object = inputStream instanceof DataInput ? DateTimeZoneBuilder.readFrom((DataInput)object, string2) : DateTimeZoneBuilder.readFrom(new DataInputStream((InputStream)object), string2);
        this.iZoneInfoMap.put(string, new SoftReference<Object>(object));
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
        return object;
        catch (IOException iOException) {
            IOException iOException2;
            try {
                iOException2 = iOException;
                iOException2 = iOException;
                iOException.printStackTrace();
                this.iZoneInfoMap.remove(string);
                iOException2 = null;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException3) {}
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException4) {}
            return iOException2;
        }
    }

    private static Map<String, Object> loadZoneInfoMap(InputStream inputStream) throws IOException {
        ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
        inputStream = new DataInputStream(inputStream);
        try {
            ZoneInfoProvider.readZoneInfoMap((DataInputStream)inputStream, concurrentHashMap);
        }
        catch (Throwable throwable) {
            try {
                ((FilterInputStream)inputStream).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((FilterInputStream)inputStream).close();
        }
        catch (IOException iOException) {}
        concurrentHashMap.put("UTC", new SoftReference<DateTimeZone>(DateTimeZone.UTC));
        return concurrentHashMap;
    }

    private static void readZoneInfoMap(DataInputStream dataInputStream, Map<String, Object> map) throws IOException {
        int n;
        int n2 = dataInputStream.readUnsignedShort();
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = dataInputStream.readUTF().intern();
        }
        n2 = dataInputStream.readUnsignedShort();
        for (n = 0; n < n2; ++n) {
            try {
                map.put(stringArray[dataInputStream.readUnsignedShort()], stringArray[dataInputStream.readUnsignedShort()]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Corrupt zone info map");
            }
        }
    }
}

