/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.core.okio;

import androidx.datastore.core.Storage;
import androidx.datastore.core.StorageConnection;
import androidx.datastore.core.okio.OkioSerializer;
import androidx.datastore.core.okio.OkioStorageConnection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import okio.Path;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u0012*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0012B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0016R\u001b\u0010\u000b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/datastore/core/okio/OkioStorage;", "T", "Landroidx/datastore/core/Storage;", "fileSystem", "Lokio/FileSystem;", "serializer", "Landroidx/datastore/core/okio/OkioSerializer;", "producePath", "Lkotlin/Function0;", "Lokio/Path;", "(Lokio/FileSystem;Landroidx/datastore/core/okio/OkioSerializer;Lkotlin/jvm/functions/Function0;)V", "canonicalPath", "getCanonicalPath", "()Lokio/Path;", "canonicalPath$delegate", "Lkotlin/Lazy;", "createConnection", "Landroidx/datastore/core/StorageConnection;", "Companion", "datastore-core-okio"})
public final class OkioStorage<T>
implements Storage<T> {
    public static final Companion Companion = new Companion(0);
    private final FileSystem fileSystem;
    private final OkioSerializer<T> serializer;
    private final Function0<Path> producePath;
    private final Lazy canonicalPath$delegate;
    private static final Set<String> activeFiles = new LinkedHashSet();
    private static final Companion.Sync activeFilesLock = new Companion.Sync();

    /*
     * WARNING - void declaration
     */
    public OkioStorage(FileSystem fileSystem, OkioSerializer<T> serializer, Function0<Path> producePath) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(producePath, (String)"producePath");
        this.fileSystem = var1_1;
        this.serializer = var2_2;
        this.producePath = var3_3;
        this.canonicalPath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this){
            private /* synthetic */ OkioStorage<T> this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }
        }));
    }

    private final Path getCanonicalPath() {
        Lazy lazy = this.canonicalPath$delegate;
        return (Path)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final StorageConnection<T> createConnection() {
        String path = this.getCanonicalPath().toString();
        Companion.Sync sync = activeFilesLock;
        synchronized (sync) {
            void var1_1;
            if (!(!activeFiles.contains(path))) {
                path = "There are multiple DataStores active for the same file: " + path + ". You should either maintain your DataStore as a singleton or confirm that there is no two DataStore's active on the same file (by confirming that the scope is cancelled).";
                throw new IllegalStateException(path.toString());
            }
            activeFiles.add((String)var1_1);
        }
        return new OkioStorageConnection<T>(this.fileSystem, this.getCanonicalPath(), this.serializer, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            private /* synthetic */ OkioStorage<T> this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ Path access$getCanonicalPath(OkioStorage $this) {
        return $this.getCanonicalPath();
    }

    public static final /* synthetic */ Set access$getActiveFiles$cp() {
        return activeFiles;
    }

    public static final /* synthetic */ Companion.Sync access$getActiveFilesLock$cp() {
        return activeFilesLock;
    }

    public static final /* synthetic */ Function0 access$getProducePath$p(OkioStorage $this) {
        return $this.producePath;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Landroidx/datastore/core/okio/OkioStorage$Companion;", "", "()V", "activeFiles", "", "", "getActiveFiles$datastore_core_okio", "()Ljava/util/Set;", "activeFilesLock", "Landroidx/datastore/core/okio/OkioStorage$Companion$Sync;", "getActiveFilesLock$datastore_core_okio", "()Landroidx/datastore/core/okio/OkioStorage$Companion$Sync;", "Sync", "datastore-core-okio"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Landroidx/datastore/core/okio/OkioStorage$Companion$Sync;", "", "Lkotlinx/atomicfu/locks/SynchronizedObject;", "()V", "datastore-core-okio"})
        public static final class Sync {
        }
    }
}

