/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.ColorType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 $2\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0019\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\fH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0005J\u0010\u0010 \u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000e\u00a8\u0006%"}, d2={"Lorg/jetbrains/skia/ColorInfo;", "", "colorType", "Lorg/jetbrains/skia/ColorType;", "alphaType", "Lorg/jetbrains/skia/ColorAlphaType;", "colorSpace", "Lorg/jetbrains/skia/ColorSpace;", "(Lorg/jetbrains/skia/ColorType;Lorg/jetbrains/skia/ColorAlphaType;Lorg/jetbrains/skia/ColorSpace;)V", "getAlphaType", "()Lorg/jetbrains/skia/ColorAlphaType;", "bytesPerPixel", "", "getBytesPerPixel", "()I", "getColorSpace", "()Lorg/jetbrains/skia/ColorSpace;", "getColorType", "()Lorg/jetbrains/skia/ColorType;", "isGammaCloseToSRGB", "", "()Z", "isOpaque", "shiftPerPixel", "getShiftPerPixel", "equals", "other", "hashCode", "toString", "", "withAlphaType", "_alphaType", "withColorSpace", "_colorSpace", "withColorType", "_colorType", "Companion", "skiko"})
public final class ColorInfo {
    public static final Companion Companion = new Companion(null);
    private final ColorType colorType;
    private final ColorAlphaType alphaType;
    private final ColorSpace colorSpace;
    private static final ColorInfo DEFAULT = new ColorInfo(ColorType.UNKNOWN, ColorAlphaType.UNKNOWN, null);

    /*
     * WARNING - void declaration
     */
    public ColorInfo(ColorType colorType, ColorAlphaType alphaType, ColorSpace colorSpace) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"colorType");
        Intrinsics.checkNotNullParameter((Object)((Object)alphaType), (String)"alphaType");
        this.colorType = var1_1;
        this.alphaType = var2_2;
        this.colorSpace = var3_3;
    }

    public final ColorType getColorType() {
        return this.colorType;
    }

    public final ColorAlphaType getAlphaType() {
        return this.alphaType;
    }

    public final ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public final boolean isOpaque() {
        return this.alphaType == ColorAlphaType.OPAQUE || this.colorType.isAlwaysOpaque();
    }

    public final int getBytesPerPixel() {
        return this.colorType.getBytesPerPixel();
    }

    public final int getShiftPerPixel() {
        return this.colorType.getShiftPerPixel();
    }

    public final boolean isGammaCloseToSRGB() {
        return this.colorSpace != null && this.colorSpace.isGammaCloseToSRGB();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (other == this) {
            return true;
        }
        if (!(other instanceof ColorInfo)) {
            return false;
        }
        if (this.colorType != ((ColorInfo)other).colorType) {
            return false;
        }
        if (this.alphaType != ((ColorInfo)other).alphaType) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.colorSpace, (Object)((ColorInfo)var1_1).colorSpace);
    }

    public final int hashCode() {
        int n = 59 + this.colorType.hashCode();
        n = n * 59 + this.alphaType.hashCode();
        ColorSpace colorSpace = this.colorSpace;
        n = n * 59 + (colorSpace != null ? ((Object)colorSpace).hashCode() : 0);
        return n;
    }

    public final String toString() {
        return "ColorInfo(_colorType=" + (Object)((Object)this.colorType) + ", _alphaType=" + (Object)((Object)this.alphaType) + ", _colorSpace=" + this.colorSpace + ')';
    }

    /*
     * WARNING - void declaration
     */
    public final ColorInfo withColorType(ColorType _colorType) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)_colorType), (String)"_colorType");
        if (this.colorType == _colorType) {
            return this;
        }
        return new ColorInfo((ColorType)var1_1, this.alphaType, this.colorSpace);
    }

    /*
     * WARNING - void declaration
     */
    public final ColorInfo withAlphaType(ColorAlphaType _alphaType) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)_alphaType), (String)"_alphaType");
        if (this.alphaType == _alphaType) {
            return this;
        }
        return new ColorInfo(this.colorType, (ColorAlphaType)var1_1, this.colorSpace);
    }

    /*
     * WARNING - void declaration
     */
    public final ColorInfo withColorSpace(ColorSpace _colorSpace) {
        void var1_1;
        if (this.colorSpace == _colorSpace) {
            return this;
        }
        return new ColorInfo(this.colorType, this.alphaType, (ColorSpace)var1_1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/skia/ColorInfo$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/skia/ColorInfo;", "getDEFAULT", "()Lorg/jetbrains/skia/ColorInfo;", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public final ColorInfo getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

