/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.skia.Matrix33Kt;
import org.jetbrains.skia.Matrix44;
import org.jetbrains.skia.Point;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0011\u0012\n\u0010\u0002\u001a\u00020\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000J\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/skia/Matrix33;", "", "mat", "", "", "([F)V", "getMat", "()[F", "asMatrix44", "Lorg/jetbrains/skia/Matrix44;", "equals", "", "other", "hashCode", "", "makeConcat", "makePreScale", "sx", "sy", "toString", "", "Companion", "skiko"})
@SourceDebugExtension(value={"SMAP\nMatrix33.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrix33.kt\norg/jetbrains/skia/Matrix33\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,274:1\n1#2:275\n*E\n"})
public final class Matrix33 {
    public static final Companion Companion = new Companion(null);
    private final float[] mat;
    private static final Matrix33 IDENTITY = Companion.makeTranslate(0.0f, 0.0f);

    /*
     * WARNING - void declaration
     */
    public Matrix33(float ... mat) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        if (!(((float[])mat).length == 9)) {
            mat = "Expected 9 elements, got " + ((float[])mat).length;
            throw new IllegalArgumentException(mat.toString());
        }
        this.mat = var1_1;
    }

    public final float[] getMat() {
        return this.mat;
    }

    /*
     * WARNING - void declaration
     */
    public final Matrix33 makePreScale(float sx, float sy) {
        void var2_2;
        void var1_1;
        float[] fArray = new float[9];
        float[] fArray2 = fArray;
        fArray[0] = this.mat[0] * sx;
        fArray2[1] = this.mat[1] * sy;
        fArray2[2] = this.mat[2];
        fArray2[3] = this.mat[3] * sx;
        fArray2[4] = this.mat[4] * sy;
        fArray2[5] = this.mat[5];
        fArray2[6] = this.mat[6] * var1_1;
        fArray2[7] = this.mat[7] * var2_2;
        fArray2[8] = this.mat[8];
        return new Matrix33(fArray2);
    }

    /*
     * WARNING - void declaration
     */
    public final Matrix33 makeConcat(Matrix33 other) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        float[] fArray = new float[9];
        float[] fArray2 = fArray;
        fArray[0] = this.mat[0] * other.mat[0] + this.mat[1] * other.mat[3] + this.mat[2] * other.mat[6];
        fArray2[1] = this.mat[0] * other.mat[1] + this.mat[1] * other.mat[4] + this.mat[2] * other.mat[7];
        fArray2[2] = this.mat[0] * other.mat[2] + this.mat[1] * other.mat[5] + this.mat[2] * other.mat[8];
        fArray2[3] = this.mat[3] * other.mat[0] + this.mat[4] * other.mat[3] + this.mat[5] * other.mat[6];
        fArray2[4] = this.mat[3] * other.mat[1] + this.mat[4] * other.mat[4] + this.mat[5] * other.mat[7];
        fArray2[5] = this.mat[3] * other.mat[2] + this.mat[4] * other.mat[5] + this.mat[5] * other.mat[8];
        fArray2[6] = this.mat[6] * other.mat[0] + this.mat[7] * other.mat[3] + this.mat[8] * other.mat[6];
        fArray2[7] = this.mat[6] * other.mat[1] + this.mat[7] * other.mat[4] + this.mat[8] * other.mat[7];
        fArray2[8] = this.mat[6] * other.mat[2] + this.mat[7] * other.mat[5] + this.mat[8] * var1_1.mat[8];
        return new Matrix33(fArray2);
    }

    public final Matrix44 asMatrix44() {
        float[] fArray = new float[16];
        float[] fArray2 = fArray;
        fArray[0] = this.mat[0];
        fArray2[1] = this.mat[1];
        fArray2[2] = 0.0f;
        fArray2[3] = this.mat[2];
        fArray2[4] = this.mat[3];
        fArray2[5] = this.mat[4];
        fArray2[6] = 0.0f;
        fArray2[7] = this.mat[5];
        fArray2[8] = 0.0f;
        fArray2[9] = 0.0f;
        fArray2[10] = 1.0f;
        fArray2[11] = 0.0f;
        fArray2[12] = this.mat[6];
        fArray2[13] = this.mat[7];
        fArray2[14] = 0.0f;
        fArray2[15] = this.mat[8];
        return new Matrix44(fArray2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (other == this) {
            return true;
        }
        if (!(other instanceof Matrix33)) {
            return false;
        }
        return Arrays.equals(this.mat, ((Matrix33)var1_1).mat);
    }

    public final int hashCode() {
        int n = 59 + Arrays.hashCode(this.mat);
        return n;
    }

    public final String toString() {
        return "Matrix33(_mat=" + this.mat + ')';
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tJ\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tJ\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/skia/Matrix33$Companion;", "", "()V", "IDENTITY", "Lorg/jetbrains/skia/Matrix33;", "getIDENTITY", "()Lorg/jetbrains/skia/Matrix33;", "makeRotate", "deg", "", "pivotx", "pivoty", "pivot", "Lorg/jetbrains/skia/Point;", "makeScale", "s", "sx", "sy", "makeSkew", "makeTranslate", "dx", "dy", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public final Matrix33 getIDENTITY() {
            return IDENTITY;
        }

        /*
         * WARNING - void declaration
         */
        public final Matrix33 makeTranslate(float dx, float dy) {
            void var2_2;
            void var1_1;
            float[] fArray = new float[9];
            float[] fArray2 = fArray;
            fArray[0] = 1.0f;
            fArray2[1] = 0.0f;
            fArray2[2] = var1_1;
            fArray2[3] = 0.0f;
            fArray2[4] = 1.0f;
            fArray2[5] = var2_2;
            fArray2[6] = 0.0f;
            fArray2[7] = 0.0f;
            fArray2[8] = 1.0f;
            return new Matrix33(fArray2);
        }

        /*
         * WARNING - void declaration
         */
        public final Matrix33 makeScale(float s) {
            void var1_1;
            void v0 = var1_1;
            return this.makeScale((float)v0, (float)v0);
        }

        /*
         * WARNING - void declaration
         */
        public final Matrix33 makeScale(float sx, float sy) {
            void var2_2;
            void var1_1;
            float[] fArray = new float[9];
            float[] fArray2 = fArray;
            fArray[0] = var1_1;
            fArray2[1] = 0.0f;
            fArray2[2] = 0.0f;
            fArray2[3] = 0.0f;
            fArray2[4] = var2_2;
            fArray2[5] = 0.0f;
            fArray2[6] = 0.0f;
            fArray2[7] = 0.0f;
            fArray2[8] = 1.0f;
            return new Matrix33(fArray2);
        }

        /*
         * WARNING - void declaration
         */
        public final Matrix33 makeRotate(float deg) {
            void var2_3;
            double rad = Matrix33Kt.toRadians(deg);
            double sin = Math.sin(rad);
            double cos = Math.cos((double)var2_3);
            if (Math.abs(sin) <= 2.44140625E-4) {
                sin = 0.0;
            }
            if (Math.abs(cos) <= 2.44140625E-4) {
                cos = 0.0;
            }
            float[] fArray = new float[9];
            float[] fArray2 = fArray;
            fArray[0] = (float)cos;
            fArray2[1] = (float)(-sin);
            fArray2[2] = 0.0f;
            fArray2[3] = (float)sin;
            fArray2[4] = (float)cos;
            fArray2[5] = 0.0f;
            fArray2[6] = 0.0f;
            fArray2[7] = 0.0f;
            fArray2[8] = 1.0f;
            return new Matrix33(fArray2);
        }

        /*
         * WARNING - void declaration
         */
        public final Matrix33 makeRotate(float deg, Point pivot) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)pivot, (String)"pivot");
            return this.makeRotate((float)var1_1, pivot.getX(), var2_2.getY());
        }

        /*
         * WARNING - void declaration
         */
        public final Matrix33 makeRotate(float deg, float pivotx, float pivoty) {
            void var2_3;
            void var3_4;
            double rad = Matrix33Kt.toRadians(deg);
            double sin = Math.sin(rad);
            double cos = Math.cos(rad);
            if (Math.abs(sin) <= 2.44140625E-4) {
                sin = 0.0;
            }
            if (Math.abs(cos) <= 2.44140625E-4) {
                cos = 0.0;
            }
            float[] fArray = new float[9];
            float[] fArray2 = fArray;
            fArray[0] = (float)cos;
            fArray2[1] = (float)(-sin);
            fArray2[2] = (float)((double)pivotx - (double)pivotx * cos + (double)pivoty * sin);
            fArray2[3] = (float)sin;
            fArray2[4] = (float)cos;
            fArray2[5] = (float)((double)pivoty - (double)var3_4 * cos - (double)var2_3 * sin);
            fArray2[6] = 0.0f;
            fArray2[7] = 0.0f;
            fArray2[8] = 1.0f;
            return new Matrix33(fArray2);
        }

        /*
         * WARNING - void declaration
         */
        public final Matrix33 makeSkew(float sx, float sy) {
            void var2_2;
            void var1_1;
            float[] fArray = new float[9];
            float[] fArray2 = fArray;
            fArray[0] = 1.0f;
            fArray2[1] = var1_1;
            fArray2[2] = 0.0f;
            fArray2[3] = var2_2;
            fArray2[4] = 1.0f;
            fArray2[5] = 0.0f;
            fArray2[6] = 0.0f;
            fArray2[7] = 0.0f;
            fArray2[8] = 1.0f;
            return new Matrix33(fArray2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

