/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia.svg;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.Point;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.svg.SVGLength;
import org.jetbrains.skia.svg.SVGLengthType;
import org.jetbrains.skia.svg.SVGLengthUnit;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u0015J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0006J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0006R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006$"}, d2={"Lorg/jetbrains/skia/svg/SVGLengthContext;", "", "size", "Lorg/jetbrains/skia/Point;", "(Lorg/jetbrains/skia/Point;)V", "width", "", "height", "dpi", "(FFF)V", "getDpi", "()F", "getHeight", "getWidth", "equals", "", "other", "hashCode", "", "resolve", "length", "Lorg/jetbrains/skia/svg/SVGLength;", "type", "Lorg/jetbrains/skia/svg/SVGLengthType;", "resolveRect", "Lorg/jetbrains/skia/Rect;", "x", "y", "toString", "", "withDpi", "_dpi", "withHeight", "_height", "withWidth", "_width", "skiko"})
public final class SVGLengthContext {
    private final float width;
    private final float height;
    private final float dpi;

    /*
     * WARNING - void declaration
     */
    public SVGLengthContext(float width2, float height2, float dpi) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.width = var1_1;
        this.height = var2_2;
        this.dpi = var3_3;
    }

    public /* synthetic */ SVGLengthContext(float f, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f3 = 90.0f;
        }
        this(f, f2, f3);
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getDpi() {
        return this.dpi;
    }

    /*
     * WARNING - void declaration
     */
    public SVGLengthContext(Point size2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        this(size2.getX(), var1_1.getY(), 90.0f);
    }

    /*
     * WARNING - void declaration
     */
    public final float resolve(SVGLength length, SVGLengthType type) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)length, (String)"length");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$1[length.getUnit().ordinal()]) {
            case 1: {
                return length.getValue();
            }
            case 2: {
                return length.getValue();
            }
            case 3: {
                void var2_2;
                switch (WhenMappings.$EnumSwitchMapping$0[var2_2.ordinal()]) {
                    case 1: {
                        return length.getValue() * this.width / 100.0f;
                    }
                    case 2: {
                        return length.getValue() * this.height / 100.0f;
                    }
                    case 3: {
                        return (float)((double)length.getValue() * Math.hypot(this.width, this.height) / Math.sqrt(2.0) / 100.0);
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 4: {
                return length.getValue() * this.dpi / 2.54f;
            }
            case 5: {
                return length.getValue() * this.dpi / 25.4f;
            }
            case 6: {
                return length.getValue() * this.dpi;
            }
            case 7: {
                return length.getValue() * this.dpi / 72.272f;
            }
            case 8: {
                return length.getValue() * this.dpi * 12.0f / 72.272f;
            }
        }
        throw new IllegalArgumentException("Unknown SVGLengthUnit: " + (Object)((Object)var1_1.getUnit()));
    }

    /*
     * WARNING - void declaration
     */
    public final Rect resolveRect(SVGLength x2, SVGLength y2, SVGLength width2, SVGLength height2) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y2, (String)"y");
        Intrinsics.checkNotNullParameter((Object)width2, (String)"width");
        Intrinsics.checkNotNullParameter((Object)height2, (String)"height");
        return Rect.Companion.makeXYWH(this.resolve((SVGLength)var1_1, SVGLengthType.HORIZONTAL), this.resolve((SVGLength)var2_2, SVGLengthType.VERTICAL), this.resolve((SVGLength)var3_3, SVGLengthType.HORIZONTAL), this.resolve(height2, SVGLengthType.VERTICAL));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (other == this) {
            return true;
        }
        if (!(other instanceof SVGLengthContext)) {
            return false;
        }
        if (Float.compare(this.width, ((SVGLengthContext)other).width) != 0) {
            return false;
        }
        if (Float.compare(this.height, ((SVGLengthContext)other).height) != 0) {
            return false;
        }
        return Float.compare(this.dpi, ((SVGLengthContext)var1_1).dpi) == 0;
    }

    public final int hashCode() {
        int n = 59 + Float.floatToIntBits(this.width);
        n = n * 59 + Float.floatToIntBits(this.height);
        n = n * 59 + Float.floatToIntBits(this.dpi);
        return n;
    }

    public final String toString() {
        return "SVGLengthContext(_width=" + this.width + ", _height=" + this.height + ", _dpi=" + this.dpi + ')';
    }

    /*
     * WARNING - void declaration
     */
    public final SVGLengthContext withWidth(float _width) {
        void var1_1;
        if (this.width == _width) {
            return this;
        }
        return new SVGLengthContext((float)var1_1, this.height, this.dpi);
    }

    /*
     * WARNING - void declaration
     */
    public final SVGLengthContext withHeight(float _height) {
        void var1_1;
        if (this.height == _height) {
            return this;
        }
        return new SVGLengthContext(this.width, (float)var1_1, this.dpi);
    }

    /*
     * WARNING - void declaration
     */
    public final SVGLengthContext withDpi(float _dpi) {
        void var1_1;
        if (this.dpi == _dpi) {
            return this;
        }
        return new SVGLengthContext(this.width, this.height, (float)var1_1);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SVGLengthType.values().length];
            try {
                nArray[SVGLengthType.HORIZONTAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SVGLengthType.VERTICAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SVGLengthType.OTHER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SVGLengthUnit.values().length];
            try {
                nArray[SVGLengthUnit.NUMBER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SVGLengthUnit.PX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SVGLengthUnit.PERCENTAGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SVGLengthUnit.CM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SVGLengthUnit.MM.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SVGLengthUnit.IN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SVGLengthUnit.PT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SVGLengthUnit.PC.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

