/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.skiko.LibraryLoadException;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.Setup;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\tH\u0002J \u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \r*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/skiko/Library;", "", "()V", "SKIKO_LIBRARY_PATH_PROPERTY", "", "cacheRoot", "getCacheRoot$skiko", "()Ljava/lang/String;", "copyDir", "Ljava/io/File;", "loaded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "skikoLibraryPath", "kotlin.jvm.PlatformType", "findAndLoad", "", "load", "loadLibraryOrCopy", "library", "unpackIfNeeded", "dest", "resourceName", "deleteOnExit", "", "skiko"})
@SourceDebugExtension(value={"SMAP\nLibrary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Library.kt\norg/jetbrains/skiko/Library\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1#2:134\n*E\n"})
public final class Library {
    public static final Library INSTANCE = new Library();
    public static final String SKIKO_LIBRARY_PATH_PROPERTY = "skiko.library.path";
    private static final String cacheRoot = System.getProperty("user.home") + "/.skiko/";
    private static final String skikoLibraryPath = System.getProperty("skiko.library.path");
    private static File copyDir;
    private static AtomicBoolean loaded;

    private Library() {
    }

    public final String getCacheRoot$skiko() {
        return cacheRoot;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadLibraryOrCopy(File library) {
        try {
            System.load(library.getAbsolutePath());
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            void var2_2;
            UnsatisfiedLinkError e = unsatisfiedLinkError;
            String string = unsatisfiedLinkError.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"already loaded in another classloader", (boolean)false, (int)2, null) : false;
            if (bl) {
                CopyOption[] copyOptionArray;
                copyDir = Files.createTempDirectory("skiko", new FileAttribute[0]).toFile();
                Intrinsics.checkNotNull((Object)copyDir);
                String string2 = library.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"library.name");
                File tempFile = FilesKt.resolve((File)copyDir, (String)string2);
                Path path = copyOptionArray.toPath();
                CopyOption[] copyOptionArray2 = new CopyOption[1];
                copyOptionArray = copyOptionArray2;
                copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
                Files.copy(path, tempFile.toPath(), copyOptionArray);
                tempFile.deleteOnExit();
                System.load(var2_2.getAbsolutePath());
                return;
            }
            throw var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final File unpackIfNeeded(File dest, String resourceName, boolean deleteOnExit) {
        File file = new File(dest, resourceName);
        if (!file.exists()) {
            void var1_1;
            CopyOption[] copyOptionArray;
            void var3_3;
            File tempFile = File.createTempFile("skiko", "", dest);
            if (var3_3 != false) {
                file.deleteOnExit();
            }
            copyOptionArray = (CopyOption[])Library.class.getResourceAsStream("/" + (String)copyOptionArray);
            Throwable throwable = null;
            try {
                CopyOption[] copyOptionArray2 = copyOptionArray;
                CopyOption[] copyOptionArray3 = copyOptionArray2;
                CopyOption[] copyOptionArray4 = new CopyOption[1];
                copyOptionArray3 = copyOptionArray4;
                copyOptionArray4[0] = StandardCopyOption.REPLACE_EXISTING;
                Files.copy((InputStream)copyOptionArray2, tempFile.toPath(), copyOptionArray3);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)copyOptionArray, (Throwable)throwable);
            }
            CopyOption[] copyOptionArray5 = new CopyOption[1];
            copyOptionArray = copyOptionArray5;
            copyOptionArray5[0] = StandardCopyOption.ATOMIC_MOVE;
            Files.move(var1_1.toPath(), file.toPath(), copyOptionArray);
        }
        return file;
    }

    public final synchronized void load() {
        if (!loaded.compareAndSet(false, true)) {
            return;
        }
        this.findAndLoad();
        Setup.init$default(Setup.INSTANCE, false, false, false, false, false, 31, null);
        try {
            org.jetbrains.skia.impl.Library.Companion._nAfterLoad();
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void findAndLoad() {
        Object it;
        String icu;
        String string = "skiko-" + OsArch_jvmKt.getHostId();
        String platformName = System.mapLibraryName(string);
        String string2 = icu = OsArch_jvmKt.getHostOs().isWindows() ? "icudtl.dat" : null;
        if (OsArch_jvmKt.getHostOs() == OS.Android) {
            System.loadLibrary("skiko-" + OsArch_jvmKt.getHostId());
            return;
        }
        if (skikoLibraryPath != null) {
            File library = new File(new File(skikoLibraryPath), platformName);
            this.loadLibraryOrCopy(library);
            if (icu != null && copyDir != null) {
                File file = copyDir;
                Intrinsics.checkNotNull((Object)file);
                this.unpackIfNeeded(file, icu, true);
            }
            return;
        }
        Object jvmFiles = new File(System.getProperty("java.home"), OsArch_jvmKt.getHostOs().isWindows() ? "bin" : "lib");
        Intrinsics.checkNotNullExpressionValue((Object)platformName, (String)"platformName");
        Serializable pathInJvm = FilesKt.resolve((File)jvmFiles, (String)platformName);
        if (pathInJvm.exists()) {
            String string3 = icu;
            if (!(string3 != null ? !FilesKt.resolve((File)jvmFiles, (String)(it = string3)).exists() : false)) {
                this.loadLibraryOrCopy((File)pathInJvm);
                return;
            }
        }
        if ((it = Library.class.getResourceAsStream("/" + platformName + ".sha256")) == null) {
            throw new LibraryLoadException("Cannot find " + platformName + ".sha256, proper native dependency missing.");
        }
        jvmFiles = it;
        jvmFiles = (Closeable)jvmFiles;
        pathInJvm = null;
        try {
            it = (InputStream)jvmFiles;
            Charset charset = Charsets.UTF_8;
            it = new InputStreamReader((InputStream)it, charset);
            it = new BufferedReader((Reader)it, 8192).readLine();
        }
        catch (Throwable throwable) {
            it = throwable;
            pathInJvm = throwable;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)jvmFiles, (Throwable)pathInJvm);
        }
        Object hash = it;
        File cacheDir = new File(new File(cacheRoot), (String)hash);
        cacheDir.mkdirs();
        File library = this.unpackIfNeeded(cacheDir, string, false);
        this.loadLibraryOrCopy(library);
        if (icu != null) {
            void var2_2;
            void var3_4;
            if (copyDir != null) {
                File file = copyDir;
                Intrinsics.checkNotNull((Object)file);
                this.unpackIfNeeded(file, icu, true);
                return;
            }
            this.unpackIfNeeded((File)var3_4, (String)var2_2, false);
        }
    }

    static {
        loaded = new AtomicBoolean(false);
    }
}

