/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import java.lang.ref.Reference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skia.impl.NativeKt;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.JvmContextHandler;
import org.jetbrains.skiko.redrawer.Direct3DRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0014J\u0019\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0082 J\b\u0010\u0019\u001a\u00020\u0014H\u0014J\b\u0010\u001a\u001a\u00020\u000eH\u0014J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\b\u0010\u001e\u001a\u00020\u000eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006!"}, d2={"Lorg/jetbrains/skiko/context/Direct3DContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "bufferCount", "", "currentHeight", "currentWidth", "directXRedrawer", "Lorg/jetbrains/skiko/redrawer/Direct3DRedrawer;", "getDirectXRedrawer", "()Lorg/jetbrains/skiko/redrawer/Direct3DRedrawer;", "isD3DInited", "", "surfaces", "", "Lorg/jetbrains/skia/Surface;", "[Lorg/jetbrains/skia/Surface;", "disposeCanvas", "", "flush", "context", "", "surface", "initCanvas", "initContext", "isSizeChanged", "width", "height", "isSurfacesNull", "rendererInfo", "", "skiko"})
@SourceDebugExtension(value={"SMAP\nDirect3DContextHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Direct3DContextHandler.kt\norg/jetbrains/skiko/context/Direct3DContextHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,105:1\n12541#2,2:106\n105#3,4:108\n140#3,4:112\n*S KotlinDebug\n*F\n+ 1 Direct3DContextHandler.kt\norg/jetbrains/skiko/context/Direct3DContextHandler\n*L\n14#1:106,2\n24#1:108,4\n28#1:112,4\n*E\n"})
public final class Direct3DContextHandler
extends JvmContextHandler {
    private final int bufferCount;
    private Surface[] surfaces;
    private int currentWidth;
    private int currentHeight;
    private boolean isD3DInited;

    /*
     * WARNING - void declaration
     */
    public Direct3DContextHandler(SkiaLayer layer) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super((SkiaLayer)var1_1);
        this.bufferCount = 2;
        this.surfaces = new Surface[this.bufferCount];
    }

    private final boolean isSurfacesNull() {
        for (Surface surface : this.surfaces) {
            Surface surface2 = surface;
            surface2 = surface;
            if (surface == null) continue;
            return false;
        }
        return true;
    }

    private final Direct3DRedrawer getDirectXRedrawer() {
        Redrawer redrawer = this.getLayer().getRedrawer$skiko();
        Intrinsics.checkNotNull((Object)redrawer);
        return (Direct3DRedrawer)redrawer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean initContext() {
        try {
            if (this.getContext() == null) {
                Object this_$iv;
                Direct3DContextHandler direct3DContextHandler = this;
                direct3DContextHandler.setContext(direct3DContextHandler.getDirectXRedrawer().makeContext());
                if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true") && ((Logger)(this_$iv = Logger.INSTANCE)).getLoggerImpl().isInfoEnabled()) {
                    this_$iv = ((Logger)this_$iv).getLoggerImpl();
                    this_$iv.info("Renderer info:\n " + this.rendererInfo());
                }
            }
        }
        catch (Exception e) {
            Logger this_$iv = Logger.INSTANCE;
            if (this_$iv.getLoggerImpl().isWarnEnabled()) {
                void var1_2;
                Throwable throwable;
                SkikoLoggerInterface skikoLoggerInterface = ((Logger)((Object)throwable)).getLoggerImpl();
                throwable = (Throwable)var1_2;
                SkikoLoggerInterface skikoLoggerInterface2 = skikoLoggerInterface;
                String string = "Failed to create Skia Direct3D context!";
                skikoLoggerInterface2.warn(throwable, string);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSizeChanged(int width2, int height2) {
        if (width2 != this.currentWidth || height2 != this.currentHeight) {
            void var2_2;
            void var1_1;
            this.currentWidth = var1_1;
            this.currentHeight = var2_2;
            return true;
        }
        return false;
    }

    @Override
    protected final void initCanvas() {
        float scale = this.getLayer().getContentScale();
        int w = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)0);
        int h = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)0);
        SurfaceProps surfaceProps = new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null);
        if (this.isSizeChanged(w, h) || this.isSurfacesNull()) {
            this.disposeCanvas();
            DirectContext directContext = this.getContext();
            if (directContext != null) {
                directContext.flush();
            }
            if (!this.isD3DInited) {
                this.getDirectXRedrawer().initSwapChain();
            } else {
                this.getDirectXRedrawer().resizeBuffers(w, h);
            }
            try {
                int bufferIndex = 0;
                int n = this.bufferCount - 1;
                if (n >= 0) {
                    while (true) {
                        Direct3DRedrawer direct3DRedrawer = this.getDirectXRedrawer();
                        DirectContext directContext2 = this.getContext();
                        Intrinsics.checkNotNull((Object)directContext2);
                        this.surfaces[bufferIndex] = direct3DRedrawer.makeSurface(NativeKt.getPtr(directContext2), w, h, surfaceProps, bufferIndex);
                        if (bufferIndex != n) {
                            ++bufferIndex;
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                DirectContext directContext3 = this.getContext();
                Intrinsics.checkNotNull((Object)directContext3);
                Reference.reachabilityFence(directContext3);
            }
            if (!this.isD3DInited) {
                this.isD3DInited = true;
                this.getDirectXRedrawer().initFence();
            }
        }
        Direct3DContextHandler direct3DContextHandler = this;
        direct3DContextHandler.setSurface(direct3DContextHandler.surfaces[this.getDirectXRedrawer().getBufferIndex()]);
        Direct3DContextHandler direct3DContextHandler2 = this;
        Surface surface = direct3DContextHandler2.getSurface();
        Intrinsics.checkNotNull((Object)surface);
        direct3DContextHandler2.setCanvas(surface.getCanvas());
    }

    @Override
    protected final void flush() {
        try {
            Direct3DContextHandler direct3DContextHandler = this;
            DirectContext directContext = direct3DContextHandler.getContext();
            Intrinsics.checkNotNull((Object)directContext);
            long l = NativeKt.getPtr(directContext);
            Surface surface = this.getSurface();
            Intrinsics.checkNotNull((Object)surface);
            direct3DContextHandler.flush(l, NativeKt.getPtr(surface));
            return;
        }
        finally {
            DirectContext directContext = this.getContext();
            Intrinsics.checkNotNull((Object)directContext);
            Reference.reachabilityFence(directContext);
            Surface surface = this.getSurface();
            Intrinsics.checkNotNull((Object)surface);
            Reference.reachabilityFence(surface);
        }
    }

    @Override
    protected final void disposeCanvas() {
        int n = this.bufferCount;
        for (int bufferIndex = 0; bufferIndex < n; ++bufferIndex) {
            Surface surface = this.surfaces[bufferIndex];
            if (surface == null) continue;
            surface.close();
        }
    }

    @Override
    public final String rendererInfo() {
        return super.rendererInfo() + "Video card: " + this.getDirectXRedrawer().getAdapterName() + "\nTotal VRAM: " + this.getDirectXRedrawer().getAdapterMemorySize() / 1024L / 1024L + " MB\n";
    }

    private final native void flush(long var1, long var3);
}

