/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.JvmContextHandler;
import org.jetbrains.skiko.redrawer.MetalRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0014J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/skiko/context/MetalContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "metalRedrawer", "Lorg/jetbrains/skiko/redrawer/MetalRedrawer;", "getMetalRedrawer", "()Lorg/jetbrains/skiko/redrawer/MetalRedrawer;", "flush", "", "initCanvas", "initContext", "", "rendererInfo", "", "skiko"})
@SourceDebugExtension(value={"SMAP\nMetalContextHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetalContextHandler.kt\norg/jetbrains/skiko/context/MetalContextHandler\n+ 2 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,67:1\n105#2,4:68\n140#2,4:72\n*S KotlinDebug\n*F\n+ 1 MetalContextHandler.kt\norg/jetbrains/skiko/context/MetalContextHandler\n*L\n18#1:68,4\n22#1:72,4\n*E\n"})
public final class MetalContextHandler
extends JvmContextHandler {
    /*
     * WARNING - void declaration
     */
    public MetalContextHandler(SkiaLayer layer) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super((SkiaLayer)var1_1);
    }

    public final MetalRedrawer getMetalRedrawer() {
        Redrawer redrawer = this.getLayer().getRedrawer$skiko();
        Intrinsics.checkNotNull((Object)redrawer);
        return (MetalRedrawer)redrawer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean initContext() {
        try {
            if (this.getContext() == null) {
                Object this_$iv;
                MetalContextHandler metalContextHandler = this;
                metalContextHandler.setContext(metalContextHandler.getMetalRedrawer().makeContext());
                if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true") && ((Logger)(this_$iv = Logger.INSTANCE)).getLoggerImpl().isInfoEnabled()) {
                    this_$iv = ((Logger)this_$iv).getLoggerImpl();
                    this_$iv.info("Renderer info:\n " + this.rendererInfo());
                }
            }
        }
        catch (Exception e) {
            Logger this_$iv = Logger.INSTANCE;
            if (this_$iv.getLoggerImpl().isWarnEnabled()) {
                void var1_2;
                Throwable throwable;
                SkikoLoggerInterface skikoLoggerInterface = ((Logger)((Object)throwable)).getLoggerImpl();
                throwable = (Throwable)var1_2;
                SkikoLoggerInterface skikoLoggerInterface2 = skikoLoggerInterface;
                String string = "Failed to create Skia Metal context!";
                skikoLoggerInterface2.warn(throwable, string);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void initCanvas() {
        this.disposeCanvas();
        float scale = this.getLayer().getContentScale();
        int w = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)0);
        int h = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)0);
        if (w > 0 && h > 0) {
            void var1_2;
            void var2_3;
            MetalContextHandler metalContextHandler = this;
            metalContextHandler.setRenderTarget(metalContextHandler.getMetalRedrawer().makeRenderTarget((int)var2_3, (int)var1_2));
            DirectContext directContext = this.getContext();
            Intrinsics.checkNotNull((Object)directContext);
            BackendRenderTarget backendRenderTarget = this.getRenderTarget();
            Intrinsics.checkNotNull((Object)backendRenderTarget);
            Surface surface = Surface.Companion.makeFromBackendRenderTarget(directContext, backendRenderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null));
            if (surface == null) {
                throw new RenderException("Cannot create surface", null, 2, null);
            }
            this.setSurface(surface);
            MetalContextHandler metalContextHandler2 = this;
            Surface surface2 = metalContextHandler2.getSurface();
            Intrinsics.checkNotNull((Object)surface2);
            metalContextHandler2.setCanvas(surface2.getCanvas());
            return;
        }
        this.setRenderTarget(null);
        this.setSurface(null);
        this.setCanvas(null);
    }

    @Override
    protected final void flush() {
        super.flush();
        Surface surface = this.getSurface();
        if (surface != null) {
            surface.flushAndSubmit();
        }
        this.getMetalRedrawer().finishFrame();
    }

    @Override
    public final String rendererInfo() {
        return super.rendererInfo() + "Video card: " + this.getMetalRedrawer().getAdapterName() + "\nTotal VRAM: " + this.getMetalRedrawer().getAdapterMemorySize() / 1024L / 1024L + " MB\n";
    }
}

