/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.JvmContextHandler;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020)H\u0014J\b\u0010+\u001a\u00020\u001aH\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006,"}, d2={"Lorg/jetbrains/skiko/context/SoftwareContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "clearColor", "", "getClearColor", "()I", "colorModel", "Ljava/awt/image/ComponentColorModel;", "getColorModel", "()Ljava/awt/image/ComponentColorModel;", "image", "Ljava/awt/image/BufferedImage;", "getImage", "()Ljava/awt/image/BufferedImage;", "setImage", "(Ljava/awt/image/BufferedImage;)V", "imageData", "", "getImageData", "()[B", "setImageData", "([B)V", "isInited", "", "()Z", "setInited", "(Z)V", "raster", "Ljava/awt/image/WritableRaster;", "getRaster", "()Ljava/awt/image/WritableRaster;", "setRaster", "(Ljava/awt/image/WritableRaster;)V", "storage", "Lorg/jetbrains/skia/Bitmap;", "getStorage", "()Lorg/jetbrains/skia/Bitmap;", "flush", "", "initCanvas", "initContext", "skiko"})
@SourceDebugExtension(value={"SMAP\nSoftwareContextHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoftwareContextHandler.kt\norg/jetbrains/skiko/context/SoftwareContextHandler\n+ 2 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,90:1\n105#2,4:91\n*S KotlinDebug\n*F\n+ 1 SoftwareContextHandler.kt\norg/jetbrains/skiko/context/SoftwareContextHandler\n*L\n42#1:91,4\n*E\n"})
public final class SoftwareContextHandler
extends JvmContextHandler {
    private final int clearColor;
    private final ComponentColorModel colorModel;
    private final Bitmap storage;
    private BufferedImage image;
    private byte[] imageData;
    private WritableRaster raster;
    private boolean isInited;

    /*
     * WARNING - void declaration
     */
    public SoftwareContextHandler(SkiaLayer layer) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super(layer);
        this.clearColor = var1_1.getTransparency() && OsArch_jvmKt.getHostOs() == OS.MacOS ? 0 : -1;
        this.colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
        this.storage = new Bitmap();
    }

    @Override
    protected final int getClearColor() {
        return this.clearColor;
    }

    public final ComponentColorModel getColorModel() {
        return this.colorModel;
    }

    public final Bitmap getStorage() {
        return this.storage;
    }

    public final BufferedImage getImage() {
        return this.image;
    }

    /*
     * WARNING - void declaration
     */
    public final void setImage(BufferedImage bufferedImage) {
        void var1_1;
        this.image = var1_1;
    }

    public final byte[] getImageData() {
        return this.imageData;
    }

    /*
     * WARNING - void declaration
     */
    public final void setImageData(byte[] byArray) {
        void var1_1;
        this.imageData = var1_1;
    }

    public final WritableRaster getRaster() {
        return this.raster;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRaster(WritableRaster writableRaster) {
        void var1_1;
        this.raster = var1_1;
    }

    public final boolean isInited() {
        return this.isInited;
    }

    /*
     * WARNING - void declaration
     */
    public final void setInited(boolean bl) {
        void var1_1;
        this.isInited = var1_1;
    }

    @Override
    protected final boolean initContext() {
        if (!this.isInited) {
            Logger this_$iv;
            if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true") && (this_$iv = Logger.INSTANCE).getLoggerImpl().isInfoEnabled()) {
                SkikoLoggerInterface skikoLoggerInterface;
                skikoLoggerInterface = ((Logger)((Object)skikoLoggerInterface)).getLoggerImpl();
                skikoLoggerInterface.info("Renderer info:\n " + this.rendererInfo());
            }
            this.isInited = true;
        }
        return this.isInited;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void initCanvas() {
        this.disposeCanvas();
        float scale = this.getLayer().getContentScale();
        int w = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)0);
        int h = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)0);
        if (this.storage.getWidth() != w || this.storage.getHeight() != h) {
            void var1_2;
            void var2_3;
            this.storage.allocPixelsFlags(ImageInfo.Companion.makeS32((int)var2_3, (int)var1_2, ColorAlphaType.PREMUL), false);
        }
        this.setCanvas(new Canvas(this.storage, new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void flush() {
        float scale = this.getLayer().getContentScale();
        int w = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)0);
        int h = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)0);
        byte[] bytes = this.storage.readPixels(this.storage.getImageInfo(), w << 2, 0, 0);
        if (bytes != null) {
            void var3_4;
            Object buffer = new DataBufferByte(bytes, bytes.length);
            DataBuffer dataBuffer = (DataBuffer)buffer;
            int[] nArray = new int[4];
            buffer = nArray;
            nArray[0] = 2;
            buffer[1] = true;
            buffer[2] = false;
            buffer[3] = 3;
            this.raster = Raster.createInterleavedRaster(dataBuffer, w, h, w << 2, 4, (int[])buffer, null);
            ColorModel colorModel = this.colorModel;
            WritableRaster writableRaster = this.raster;
            Intrinsics.checkNotNull((Object)writableRaster);
            this.image = new BufferedImage(colorModel, writableRaster, false, null);
            Graphics graphics = this.getLayer().getBackedLayer$skiko().getGraphics();
            if (!this.getLayer().getFullscreen() && this.getLayer().getTransparency() && OsArch_jvmKt.getHostOs() == OS.MacOS) {
                Graphics graphics2 = graphics;
                if (graphics2 != null) {
                    graphics2.setColor(new Color(0, 0, 0, 0));
                }
                Graphics graphics3 = graphics;
                if (graphics3 != null) {
                    void var1_2;
                    void var2_3;
                    graphics3.clearRect(0, 0, (int)var2_3, (int)var1_2);
                }
            }
            void v6 = var3_4;
            if (v6 != null) {
                BufferedImage bufferedImage = this.image;
                Intrinsics.checkNotNull((Object)bufferedImage);
                v6.drawImage(bufferedImage, 0, 0, this.getLayer().getWidth(), this.getLayer().getHeight(), null);
                return;
            }
        }
    }
}

