/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.redrawer;

import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.Version;
import org.jetbrains.skiko.redrawer.Redrawer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b \u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0084\b\u00f8\u0001\u0000J\b\u0010\u0017\u001a\u00020\u0013H\u0004J\u0012\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0004J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/skiko/redrawer/AWTRedrawer;", "Lorg/jetbrains/skiko/redrawer/Redrawer;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "graphicsApi", "Lorg/jetbrains/skiko/GraphicsApi;", "(Lorg/jetbrains/skiko/SkiaLayer;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skiko/GraphicsApi;)V", "deviceAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$DeviceAnalytics;", "<set-?>", "", "isDisposed", "()Z", "isFirstFrameRendered", "rendererAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$RendererAnalytics;", "dispose", "", "inDrawScope", "body", "Lkotlin/Function0;", "onContextInit", "onDeviceChosen", "deviceName", "", "update", "nanoTime", "", "skiko"})
@SourceDebugExtension(value={"SMAP\nAWTRedrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AWTRedrawer.kt\norg/jetbrains/skiko/redrawer/AWTRedrawer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SkiaLayer.awt.kt\norg/jetbrains/skiko/SkiaLayer\n+ 4 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,70:1\n1#2:71\n1#2:73\n569#3:72\n570#3,8:74\n578#3,5:86\n140#4,4:82\n*S KotlinDebug\n*F\n+ 1 AWTRedrawer.kt\norg/jetbrains/skiko/redrawer/AWTRedrawer\n*L\n63#1:73\n63#1:72\n63#1:74,8\n63#1:86,5\n63#1:82,4\n*E\n"})
public abstract class AWTRedrawer
implements Redrawer {
    private final SkiaLayer layer;
    private final SkiaLayerAnalytics analytics;
    private final GraphicsApi graphicsApi;
    private boolean isFirstFrameRendered;
    private final SkiaLayerAnalytics.RendererAnalytics rendererAnalytics;
    private SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics;
    private boolean isDisposed;

    /*
     * WARNING - void declaration
     */
    public AWTRedrawer(SkiaLayer layer, SkiaLayerAnalytics analytics, GraphicsApi graphicsApi) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"graphicsApi");
        this.layer = var1_1;
        this.analytics = var2_2;
        this.graphicsApi = var3_3;
        this.rendererAnalytics = this.analytics.renderer(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi);
        this.rendererAnalytics.init();
    }

    protected final boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public void dispose() {
        if (!(!this.isDisposed)) {
            String string = this.getClass() + " is disposed";
            throw new IllegalArgumentException(string.toString());
        }
        this.isDisposed = true;
    }

    /*
     * WARNING - void declaration
     */
    protected final void onDeviceChosen(String deviceName) {
        void var1_1;
        if (!(!this.isDisposed)) {
            deviceName = this.getClass() + " is disposed";
            throw new IllegalArgumentException(deviceName.toString());
        }
        if (!(this.deviceAnalytics == null)) {
            deviceName = "deviceAnalytics is not null";
            throw new IllegalArgumentException(deviceName.toString());
        }
        this.rendererAnalytics.deviceChosen();
        SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics = this.analytics.device(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi, (String)var1_1);
        if (deviceAnalytics != null) {
            deviceAnalytics.init();
            return;
        }
    }

    protected final void onContextInit() {
        if (!(!this.isDisposed)) {
            String string = this.getClass() + " is disposed";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.deviceAnalytics == null) {
            String string = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
            throw new IllegalArgumentException(string.toString());
        }
        SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
        if (deviceAnalytics != null) {
            deviceAnalytics.contextInit();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void update(long nanoTime2) {
        void var1_1;
        if (!(!this.isDisposed)) {
            String nanoTime2 = this.getClass() + " is disposed";
            throw new IllegalArgumentException(nanoTime2.toString());
        }
        this.layer.update$skiko((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected final void inDrawScope(Function0<Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        if (this.deviceAnalytics == null) {
            body = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
            throw new IllegalArgumentException(body.toString());
        }
        if (!this.isDisposed) {
            block12: {
                if (!this.isFirstFrameRendered) {
                    SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
                    if (deviceAnalytics != null) {
                        deviceAnalytics.beforeFirstFrameRender();
                    }
                }
                SkiaLayer this_$iv = this.layer;
                if (!SwingUtilities.isEventDispatchThread()) {
                    body = "Method should be called from AWT event dispatch thread";
                    throw new IllegalStateException(body.toString());
                }
                if (!(!SkiaLayer.access$isDisposed$p(this_$iv))) {
                    body = "SkiaLayer is disposed";
                    throw new IllegalStateException(body.toString());
                }
                try {
                    body.invoke();
                }
                catch (CancellationException cancellationException) {
                }
                catch (RenderException e$iv) {
                    void var2_2;
                    if (SkiaLayer.access$isDisposed$p(this_$iv)) break block12;
                    Logger this_$iv$iv = Logger.INSTANCE;
                    if (this_$iv$iv.getLoggerImpl().isWarnEnabled()) {
                        void var3_3;
                        Throwable throwable;
                        SkikoLoggerInterface skikoLoggerInterface = ((Logger)((Object)throwable)).getLoggerImpl();
                        throwable = (Throwable)var3_3;
                        SkikoLoggerInterface skikoLoggerInterface2 = skikoLoggerInterface;
                        String string = "Exception in draw scope";
                        skikoLoggerInterface2.warn(throwable, string);
                    }
                    SkiaLayer.access$findNextWorkingRenderApi(this_$iv);
                    Redrawer redrawer = var2_2.getRedrawer$skiko();
                    if (redrawer == null) break block12;
                    redrawer.redrawImmediately();
                }
            }
            if (!this.isFirstFrameRendered && !this.isDisposed) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
                if (deviceAnalytics != null) {
                    deviceAnalytics.afterFirstFrameRender();
                }
            }
            AWTRedrawer.access$setFirstFrameRendered$p(this, true);
        }
    }

    @Override
    public void syncSize() {
        Redrawer.DefaultImpls.syncSize(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setVisible(boolean isVisible) {
        void var1_1;
        Redrawer.DefaultImpls.setVisible(this, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setFirstFrameRendered$p(AWTRedrawer $this, boolean bl) {
        void var1_1;
        $this.isFirstFrameRendered = var1_1;
    }
}

