/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import io.sentry.SentryOptions;
import kotlin.Metadata;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J \u0010\f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/compose/animation/core/CubicBezierEasing;", "Landroidx/compose/animation/core/Easing;", "a", "", "b", "c", "d", "(FFFF)V", "equals", "", "other", "", "evaluateCubic", "m", "hashCode", "", "transform", "fraction", "animation-core"})
public final class CubicBezierEasing
implements SentryOptions.TracesSamplerCallback {
    private final float a;
    private final float b;
    private final float c;
    private final float d;

    /*
     * WARNING - void declaration
     */
    public CubicBezierEasing(float a, float b, float c, float d) {
        void var3_4;
        void var1_1;
        this.a = var1_1;
        this.b = 0.0f;
        this.c = var3_4;
        this.d = 1.0f;
        if (!(!Float.isNaN(this.a) && !Float.isNaN(this.b) && !Float.isNaN(this.c) && !Float.isNaN(this.d))) {
            String string = "Parameters to CubicBezierEasing cannot be NaN. Actual parameters are: " + this.a + ", " + this.b + ", " + this.c + ", " + this.d + '.';
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static float evaluateCubic(float a, float b, float m) {
        void var2_2;
        void var1_1;
        float f;
        float f2 = m;
        return 3.0f * f * (1.0f - m) * (1.0f - m) * m + 3.0f * var1_1 * (1.0f - m) * m * m + f2 * f2 * var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final float transform(float fraction) {
        void var1_1;
        if (fraction > 0.0f && fraction < 1.0f) {
            float start = 0.0f;
            float end = 1.0f;
            while (true) {
                float midpoint;
                float estimate;
                if (Math.abs(fraction - (estimate = CubicBezierEasing.evaluateCubic(this.a, this.c, midpoint = (start + end) / 2.0f))) < 0.001f) {
                    return CubicBezierEasing.evaluateCubic(this.b, this.d, midpoint);
                }
                if (estimate < fraction) {
                    start = midpoint;
                    continue;
                }
                end = midpoint;
            }
        }
        return (float)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof CubicBezierEasing && this.a == ((CubicBezierEasing)other).a && this.b == ((CubicBezierEasing)other).b && this.c == ((CubicBezierEasing)other).c && this.d == ((CubicBezierEasing)var1_1).d;
    }

    public final int hashCode() {
        return ((Float.hashCode(this.a) * 31 + Float.hashCode(this.b)) * 31 + Float.hashCode(this.c)) * 31 + Float.hashCode(this.d);
    }
}

