/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.FloatAnimationSpec;
import androidx.compose.animation.core.InfiniteRepeatableSpec;
import androidx.compose.animation.core.InfiniteTransition;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorConvertersKt;
import androidx.compose.foundation.layout.BoxWithConstraintsKt;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.DisposableEffectResult;
import androidx.compose.runtime.EffectsKt;
import androidx.compose.runtime.State;
import io.sentry.SentryOptions;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J \u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J(\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J(\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/compose/animation/core/FloatTweenSpec;", "Landroidx/compose/animation/core/FloatAnimationSpec;", "duration", "", "delay", "easing", "Landroidx/compose/animation/core/Easing;", "(IILandroidx/compose/animation/core/Easing;)V", "getDelay", "()I", "getDuration", "clampPlayTime", "", "playTime", "getDurationNanos", "initialValue", "", "targetValue", "initialVelocity", "getValueFromNanos", "playTimeNanos", "getVelocityFromNanos", "animation-core"})
@SourceDebugExtension(value={"SMAP\nInfiniteTransition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InfiniteTransition.kt\nandroidx/compose/animation/core/InfiniteTransitionKt\n+ 2 Composables.kt\nandroidx/compose/runtime/ComposablesKt\n+ 3 Composer.kt\nandroidx/compose/runtime/ComposerKt\n*L\n1#1,364:1\n25#2:365\n25#2:372\n1115#3,6:366\n1115#3,6:373\n*S KotlinDebug\n*F\n+ 1 InfiniteTransition.kt\nandroidx/compose/animation/core/InfiniteTransitionKt\n*L\n46#1:365\n263#1:372\n46#1:366,6\n263#1:373,6\n*E\n"})
public class InfiniteTransitionKt
implements FloatAnimationSpec {
    private final int duration;
    private final int delay;
    private final SentryOptions.TracesSamplerCallback easing$127a373e;

    /*
     * WARNING - void declaration
     */
    public static final <T, V extends AnimationVector> State<T> animateValue(InfiniteTransition $this$animateValue, T initialValue, T targetValue, TwoWayConverter<T, V> typeConverter, InfiniteRepeatableSpec<T> animationSpec, String label, Composer $composer, int $changed, int n) {
        void var3_3;
        InfiniteTransition infiniteTransition;
        void var2_2;
        void var1_1;
        InfiniteTransition.TransitionAnimationState<T, V> transitionAnimationState;
        InfiniteTransition.TransitionAnimationState<T, V> value$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$animateValue, (String)"<this>");
        Intrinsics.checkNotNullParameter(typeConverter, (String)"typeConverter");
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        $composer.startReplaceableGroup(-1062847727);
        if ((n & 0x10) != 0) {
            label = "ValueAnimation";
        }
        if (ComposerKt.isTraceInProgress()) {
            int n2 = $changed;
            String string = "androidx.compose.animation.core.animateValue (InfiniteTransition.kt:254)";
            $changed = -1;
            $changed = n2;
            $changed = -1062847727;
            Intrinsics.checkNotNullParameter((Object)string, (String)"info");
        }
        $composer.startReplaceableGroup(-492369756);
        Composer $this$cache$iv$iv = $composer;
        InfiniteTransition.TransitionAnimationState<T, V> it$iv$iv = $this$cache$iv$iv.rememberedValue();
        if (it$iv$iv == Composer.Companion.getEmpty()) {
            value$iv$iv = new InfiniteTransition.TransitionAnimationState<T, V>($this$animateValue, initialValue, targetValue, typeConverter, animationSpec, label);
            $this$cache$iv$iv.updateRememberedValue(value$iv$iv);
            transitionAnimationState = value$iv$iv;
        } else {
            transitionAnimationState = it$iv$iv;
        }
        value$iv$iv = transitionAnimationState;
        $composer.endReplaceableGroup();
        InfiniteTransition.TransitionAnimationState transitionAnimation = value$iv$iv;
        EffectsKt.SideEffect((Function0)((Function0)new Function0<Unit>(var1_1, transitionAnimation, var2_2, animationSpec){
            private /* synthetic */ T $initialValue;
            private /* synthetic */ InfiniteTransition.TransitionAnimationState<T, V> $transitionAnimation;
            private /* synthetic */ T $targetValue;
            private /* synthetic */ InfiniteRepeatableSpec<T> $animationSpec;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$initialValue = var1_1;
                this.$transitionAnimation = var2_2;
                this.$targetValue = var3_3;
                this.$animationSpec = $animationSpec;
                super(0);
            }
        }), (Composer)$composer, (int)0);
        EffectsKt.DisposableEffect((Object)transitionAnimation, (Function1)((Function1)new Function1<BoxWithConstraintsKt, DisposableEffectResult>(infiniteTransition, transitionAnimation){
            private /* synthetic */ InfiniteTransition $this_animateValue;
            private /* synthetic */ InfiniteTransition.TransitionAnimationState<T, V> $transitionAnimation;
            {
                void var2_2;
                void var1_1;
                this.$this_animateValue = var1_1;
                this.$transitionAnimation = var2_2;
                super(1);
            }
        }), (Composer)$composer, (int)6);
        $composer.endReplaceableGroup();
        return (State)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static final State<Float> animateFloat(InfiniteTransition $this$animateFloat, float initialValue, float targetValue, InfiniteRepeatableSpec<Float> animationSpec, String string, Composer $composer, int $changed, int n) {
        void var3_4;
        void var2_3;
        State<Float> state;
        Intrinsics.checkNotNullParameter((Object)$this$animateFloat, (String)"<this>");
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        $composer.startReplaceableGroup(-644770905);
        String label = "FloatAnimation";
        if (ComposerKt.isTraceInProgress()) {
            String string2 = "androidx.compose.animation.core.animateFloat (InfiniteTransition.kt:310)";
            int n2 = -1;
            n2 = $changed;
            n2 = -644770905;
            Intrinsics.checkNotNullParameter((Object)string2, (String)"info");
        }
        state = InfiniteTransitionKt.animateValue((InfiniteTransition)state, Float.valueOf(0.0f), Float.valueOf((float)var2_3), VectorConvertersKt.getVectorConverter(FloatCompanionObject.INSTANCE), var3_4, label, $composer, 8 | 0x70 & $changed | 0x380 & $changed | 0xE000 & $changed << 3 | 0x70000 & $changed << 3, 0);
        $composer.endReplaceableGroup();
        return state;
    }

    /*
     * WARNING - void declaration
     */
    public InfiniteTransitionKt(int duration, int delay, SentryOptions.TracesSamplerCallback easing) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)easing, (String)"easing");
        this.duration = var1_1;
        this.delay = var2_2;
        this.easing$127a373e = var3_3;
    }

    private /* synthetic */ InfiniteTransitionKt(int n, int n2, SentryOptions.TracesSamplerCallback tracesSamplerCallback, int n3) {
        tracesSamplerCallback = EasingKt.getFastOutSlowInEasing$6503073d();
        this(300, 0, tracesSamplerCallback);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getValueFromNanos(long playTimeNanos, float initialValue, float targetValue, float initialVelocity) {
        void var1_2;
        void var3_3;
        long playTimeMillis = playTimeNanos / 1000000L;
        long clampedPlayTime = this.clampPlayTime(playTimeMillis);
        float rawFraction = this.duration == 0 ? 1.0f : (float)clampedPlayTime / (float)this.duration;
        float fraction = this.easing$127a373e.transform(RangesKt.coerceIn((float)rawFraction, (float)0.0f, (float)1.0f));
        return VectorConvertersKt.lerp((float)var3_3, targetValue, (float)var1_2);
    }

    private long clampPlayTime(long playTime) {
        return RangesKt.coerceIn((long)(playTime - (long)this.delay), (long)0L, (long)this.duration);
    }

    @Override
    public long getDurationNanos(float initialValue, float targetValue, float initialVelocity) {
        return (long)(this.delay + this.duration) * 1000000L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getVelocityFromNanos(long playTimeNanos, float initialValue, float targetValue, float initialVelocity) {
        void var1_2;
        void var3_3;
        long playTimeMillis = playTimeNanos / 1000000L;
        long clampedPlayTime = this.clampPlayTime(playTimeMillis);
        if (clampedPlayTime < 0L) {
            return 0.0f;
        }
        if (clampedPlayTime == 0L) {
            return initialVelocity;
        }
        float startNum = this.getValueFromNanos((clampedPlayTime - 1L) * 1000000L, initialValue, targetValue, initialVelocity);
        float f = this.getValueFromNanos(clampedPlayTime * 1000000L, (float)var3_3, targetValue, initialVelocity);
        return (f - var1_2) * 1000.0f;
    }

    public InfiniteTransitionKt() {
        this(0, 0, null, 7);
    }
}

