/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.animation.core.ComplexDouble;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Landroidx/compose/foundation/ContextMenuItem;", "", "label", "", "onClick", "Lkotlin/Function0;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getLabel", "()Ljava/lang/String;", "getOnClick", "()Lkotlin/jvm/functions/Function0;", "equals", "", "other", "hashCode", "", "toString", "foundation"})
@SourceDebugExtension(value={"SMAP\nSpringEstimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringEstimation.kt\nandroidx/compose/animation/core/SpringEstimationKt\n*L\n1#1,318:1\n317#1:319\n317#1:320\n313#1:321\n317#1:322\n317#1:323\n313#1:324\n*S KotlinDebug\n*F\n+ 1 SpringEstimation.kt\nandroidx/compose/animation/core/SpringEstimationKt\n*L\n141#1:319\n142#1:320\n183#1:321\n211#1:322\n212#1:323\n259#1:324\n*E\n"})
public class SpringEstimationKt {
    private final String label;
    private final Function0<Unit> onClick;

    /*
     * WARNING - void declaration
     */
    public static final long estimateAnimationDurationMillis(double stiffness, double dampingRatio, double initialVelocity, double initialDisplacement, double delta) {
        void var2_3;
        double d;
        double dampingCoefficient = dampingRatio * 2.0 * Math.sqrt(stiffness);
        Pair<ComplexDouble, ComplexDouble> pair = AnimationSpecKt.complexQuadraticFormula(1.0, dampingCoefficient, d);
        return SpringEstimationKt.estimateDurationInternal(pair, (double)var2_3, initialVelocity, initialDisplacement, delta);
    }

    /*
     * WARNING - void declaration
     */
    private static final double estimateUnderDamped(Pair<ComplexDouble, ComplexDouble> roots, double p0, double v0, double delta) {
        Pair<ComplexDouble, ComplexDouble> pair;
        void var3_2;
        void var1_1;
        double r = ((ComplexDouble)roots.getFirst()).getReal();
        void c1 = var1_1;
        void c2 = (var3_2 - r * c1) / ((ComplexDouble)pair.getFirst()).getImaginary();
        void v02 = c1;
        void v1 = c2;
        double c = Math.sqrt((double)(v02 * v02 + v1 * v1));
        return Math.log(delta / c) / r;
    }

    /*
     * Unable to fully structure code
     */
    private static final double estimateCriticallyDamped(Pair<ComplexDouble, ComplexDouble> roots, double p0, double v0, double delta) {
        block8: {
            block7: {
                r = ((ComplexDouble)roots.getFirst()).getReal();
                c1 = var1_2;
                c2 = var3_3 - r * c1;
                t1 = Math.log(Math.abs(delta / c1)) / r;
                var32_9 = r;
                var34_11 = var30_10 = Math.log(Math.abs(delta / c2));
                for (var36_12 = 0; var36_12 < 6; ++var36_12) {
                    var34_11 = var30_10 - Math.log(Math.abs(var34_11 / var32_9));
                }
                t2 = var34_11 / r;
                var22_16 = var19_15 = t1;
                if ((Double.isInfinite(var19_15) == false && Double.isNaN(var22_16) == false) == false) {
                    v0 = t2;
                } else {
                    var22_16 = var19_15 = t2;
                    v0 = (Double.isInfinite(var19_15) == false && Double.isNaN(var22_16) == false) == false != false ? t1 : Math.max(t1, t2);
                }
                tCurr = v0;
                tInflection = -(r * c1 + c2) / (r * c2);
                if (!Double.isNaN(tInflection) && !(tInflection <= 0.0)) break block7;
                v1 = -delta;
                break block8;
            }
            if (!(tInflection > 0.0)) ** GOTO lbl-1000
            var36_13 = c2;
            var34_11 = tInflection;
            var32_9 = r;
            var30_10 = c1;
            if (-(v2 * Math.exp(var32_9 * var34_11) + var36_13 * var34_11 * Math.exp(var32_9 * var34_11)) < delta) {
                if (c2 < 0.0 && c1 > 0.0) {
                    tCurr = 0.0;
                }
                v1 = -delta;
            } else lbl-1000:
            // 2 sources

            {
                tCurr = var23_18 = -(2.0 / r) - c1 / c2;
                v1 = delta;
            }
        }
        signedDelta = v1;
        fn = (Function1)new Function1<Double, Double>((double)c1, (double)c2, r, signedDelta){
            private /* synthetic */ double $c1;
            private /* synthetic */ double $c2;
            private /* synthetic */ double $r;
            private /* synthetic */ double $signedDelta;
            {
                void var3_2;
                void var1_1;
                this.$c1 = var1_1;
                this.$c2 = var3_2;
                this.$r = $r;
                this.$signedDelta = $signedDelta;
                super(1);
            }
        };
        fnPrime = (Function1)new Function1<Double, Double>((double)c2, r, (double)c1){
            private /* synthetic */ double $c2;
            private /* synthetic */ double $r;
            private /* synthetic */ double $c1;
            {
                void var3_2;
                void var1_1;
                this.$c2 = var1_1;
                this.$r = var3_2;
                this.$c1 = $c1;
                super(1);
            }
        };
        tDelta = 1.7976931348623157E308;
        iterations = 0;
        while (tDelta > 0.001 && iterations < 100) {
            ++iterations;
            tLast = tCurr;
            tCurr -= ((Number)fn.invoke((Object)tCurr)).doubleValue() / ((Number)fnPrime.invoke((Object)tCurr)).doubleValue();
            tDelta = Math.abs(tLast - tCurr);
        }
        return tCurr;
    }

    /*
     * Unable to fully structure code
     */
    private static final double estimateOverDamped(Pair<ComplexDouble, ComplexDouble> roots, double p0, double v0, double delta) {
        block8: {
            block7: {
                r1 = ((ComplexDouble)roots.getFirst()).getReal();
                r2 = ((ComplexDouble)roots.getSecond()).getReal();
                c2 = (r1 * p0 - var3_3) / (r1 - r2);
                c1 = var1_2 - c2;
                t1 = Math.log(Math.abs(delta / c1)) / r1;
                t2 = Math.log(Math.abs(delta / c2)) / r2;
                var24_12 = var21_11 = t1;
                if ((Double.isInfinite(var21_11) == false && Double.isNaN(var24_12) == false) == false) {
                    v0 = t2;
                } else {
                    var24_12 = var21_11 = t2;
                    v0 = (Double.isInfinite(var21_11) == false && Double.isNaN(var24_12) == false) == false != false ? t1 : Math.max(t1, t2);
                }
                tCurr = v0;
                tInflection = Math.log((double)(c1 * r1 / (-c2 * r2))) / (r2 - r1);
                if (!Double.isNaN(tInflection) && !(tInflection <= 0.0)) break block7;
                v1 = -delta;
                break block8;
            }
            if (!(tInflection > 0.0)) ** GOTO lbl-1000
            var40_14 = r2;
            var38_15 = c2;
            var36_16 = tInflection;
            var34_17 = r1;
            var32_18 = c1;
            if (-(v2 * Math.exp(var34_17 * var36_16) + var38_15 * Math.exp(var40_14 * var36_16)) < delta) {
                if (c2 > 0.0 && c1 < 0.0) {
                    tCurr = 0.0;
                }
                v1 = -delta;
            } else lbl-1000:
            // 2 sources

            {
                tCurr = var25_19 = Math.log(-(c2 * r2 * r2) / (c1 * r1 * r1)) / (r1 - r2);
                v1 = delta;
            }
        }
        signedDelta = v1;
        fn = (Function1)new Function1<Double, Double>((double)c1, r1, c2, r2, signedDelta){
            private /* synthetic */ double $c1;
            private /* synthetic */ double $r1;
            private /* synthetic */ double $c2;
            private /* synthetic */ double $r2;
            private /* synthetic */ double $signedDelta;
            {
                void var3_3;
                void var1_1;
                this.$c1 = var1_1;
                this.$r1 = var3_3;
                this.$c2 = $c2;
                this.$r2 = $r2;
                this.$signedDelta = $signedDelta;
                super(1);
            }
        };
        fnPrime = (Function1)new Function1<Double, Double>((double)c1, r1, c2, r2){
            private /* synthetic */ double $c1;
            private /* synthetic */ double $r1;
            private /* synthetic */ double $c2;
            private /* synthetic */ double $r2;
            {
                void var3_2;
                void var1_1;
                this.$c1 = var1_1;
                this.$r1 = var3_2;
                this.$c2 = $c2;
                this.$r2 = $r2;
                super(1);
            }
        };
        if (Math.abs(((Number)fn.invoke((Object)tCurr)).doubleValue()) < 1.0E-4) {
            return tCurr;
        }
        tDelta = 1.7976931348623157E308;
        iterations = 0;
        while (tDelta > 0.001 && iterations < 100) {
            ++iterations;
            tLast = tCurr;
            tCurr -= ((Number)fn.invoke((Object)tCurr)).doubleValue() / ((Number)fnPrime.invoke((Object)tCurr)).doubleValue();
            tDelta = Math.abs(tLast - tCurr);
        }
        return tCurr;
    }

    /*
     * WARNING - void declaration
     */
    private static final long estimateDurationInternal(Pair<ComplexDouble, ComplexDouble> roots, double dampingRatio, double initialVelocity, double initialPosition, double delta) {
        Pair<ComplexDouble, ComplexDouble> pair;
        void var1_1;
        void var3_2;
        if (initialPosition == 0.0 && initialVelocity == 0.0) {
            return 0L;
        }
        double v0 = initialPosition < 0.0 ? -initialVelocity : var3_2;
        double p0 = Math.abs(initialPosition);
        return (long)((dampingRatio > 1.0 ? SpringEstimationKt.estimateOverDamped(roots, p0, v0, delta) : (var1_1 < 1.0 ? SpringEstimationKt.estimateUnderDamped(roots, p0, v0, delta) : SpringEstimationKt.estimateCriticallyDamped(pair, p0, v0, delta))) * 1000.0);
    }

    /*
     * WARNING - void declaration
     */
    public SpringEstimationKt(String label, Function0<Unit> onClick) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter(onClick, (String)"onClick");
        this.label = var1_1;
        this.onClick = var2_2;
    }

    public String getLabel() {
        return this.label;
    }

    public Function0<Unit> getOnClick() {
        return this.onClick;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.label, (Object)((SpringEstimationKt)other).label)) {
            return false;
        }
        return Intrinsics.areEqual(this.onClick, ((SpringEstimationKt)var1_1).onClick);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.label.hashCode();
        var1_1 = var1_1 * 31 + this.onClick.hashCode();
        return (int)var1_1;
    }

    public String toString() {
        return "ContextMenuItem(label='" + this.label + "')";
    }
}

