/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Animation;
import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorizedAnimationSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004BE\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\u0006\u0010\n\u001a\u00028\u0000\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\fBE\b\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\r\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\u0006\u0010\n\u001a\u00028\u0000\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\"\u001a\u00028\u00002\u0006\u0010#\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010$J\u0015\u0010%\u001a\u00028\u00012\u0006\u0010#\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020(H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0013\u0010\t\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u001a\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u000b\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001dR\u0016\u0010\n\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u001e\u0010\u0018R\u0010\u0010\u001f\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006)"}, d2={"Landroidx/compose/animation/core/TargetBasedAnimation;", "T", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/Animation;", "animationSpec", "Landroidx/compose/animation/core/AnimationSpec;", "typeConverter", "Landroidx/compose/animation/core/TwoWayConverter;", "initialValue", "targetValue", "initialVelocityVector", "(Landroidx/compose/animation/core/AnimationSpec;Landroidx/compose/animation/core/TwoWayConverter;Ljava/lang/Object;Ljava/lang/Object;Landroidx/compose/animation/core/AnimationVector;)V", "Landroidx/compose/animation/core/VectorizedAnimationSpec;", "(Landroidx/compose/animation/core/VectorizedAnimationSpec;Landroidx/compose/animation/core/TwoWayConverter;Ljava/lang/Object;Ljava/lang/Object;Landroidx/compose/animation/core/AnimationVector;)V", "getAnimationSpec$animation_core", "()Landroidx/compose/animation/core/VectorizedAnimationSpec;", "durationNanos", "", "getDurationNanos", "()J", "endVelocity", "Landroidx/compose/animation/core/AnimationVector;", "getInitialValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "initialValueVector", "isInfinite", "", "()Z", "getTargetValue", "targetValueVector", "getTypeConverter", "()Landroidx/compose/animation/core/TwoWayConverter;", "getValueFromNanos", "playTimeNanos", "(J)Ljava/lang/Object;", "getVelocityVectorFromNanos", "(J)Landroidx/compose/animation/core/AnimationVector;", "toString", "", "animation-core"})
public final class TargetBasedAnimation<T, V extends AnimationVector>
implements Animation<T, V> {
    private final VectorizedAnimationSpec<V> animationSpec;
    private final TwoWayConverter<T, V> typeConverter;
    private final T initialValue;
    private final T targetValue;
    private final V initialValueVector;
    private final V targetValueVector;
    private final V initialVelocityVector;
    private final long durationNanos;
    private final V endVelocity;

    /*
     * WARNING - void declaration
     */
    private TargetBasedAnimation(VectorizedAnimationSpec<V> animationSpec, TwoWayConverter<T, V> typeConverter, T initialValue, T targetValue, V initialVelocityVector) {
        void var3_3;
        void var2_2;
        TargetBasedAnimation targetBasedAnimation;
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        Intrinsics.checkNotNullParameter(typeConverter, (String)"typeConverter");
        this.animationSpec = targetBasedAnimation;
        this.typeConverter = var2_2;
        this.initialValue = var3_3;
        this.targetValue = targetValue;
        targetBasedAnimation = this;
        targetBasedAnimation.initialValueVector = (AnimationVector)targetBasedAnimation.typeConverter.getConvertToVector().invoke(this.initialValue);
        TargetBasedAnimation targetBasedAnimation2 = this;
        targetBasedAnimation = targetBasedAnimation2;
        targetBasedAnimation = this;
        targetBasedAnimation2.targetValueVector = (AnimationVector)targetBasedAnimation2.typeConverter.getConvertToVector().invoke(targetBasedAnimation.targetValue);
        Object object = initialVelocityVector;
        if (object == null || (object = AnimationSpecKt.copy(object)) == null) {
            targetBasedAnimation = this;
            object = AnimationSpecKt.newInstance((AnimationVector)targetBasedAnimation.typeConverter.getConvertToVector().invoke(this.initialValue));
        }
        this.initialVelocityVector = object;
        this.durationNanos = this.animationSpec.getDurationNanos(this.initialValueVector, this.targetValueVector, this.initialVelocityVector);
        this.endVelocity = this.animationSpec.getEndVelocity(this.initialValueVector, this.targetValueVector, this.initialVelocityVector);
    }

    @Override
    public final TwoWayConverter<T, V> getTypeConverter() {
        return this.typeConverter;
    }

    public final T getInitialValue() {
        return this.initialValue;
    }

    @Override
    public final T getTargetValue() {
        return this.targetValue;
    }

    /*
     * WARNING - void declaration
     */
    public TargetBasedAnimation(AnimationSpec<T> animationSpec, TwoWayConverter<T, V> typeConverter, T initialValue, T targetValue, V initialVelocityVector) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        Intrinsics.checkNotNullParameter(typeConverter, (String)"typeConverter");
        this(var1_1.vectorize(typeConverter), (TwoWayConverter<void, V>)var2_2, var3_3, (void)targetValue, initialVelocityVector);
    }

    public /* synthetic */ TargetBasedAnimation(AnimationSpec animationSpec, TwoWayConverter twoWayConverter, Object object, Object object2, AnimationVector animationVector, int n) {
        animationVector = null;
        this(animationSpec, twoWayConverter, object, object2, animationVector);
    }

    @Override
    public final boolean isInfinite() {
        return this.animationSpec.isInfinite();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final T getValueFromNanos(long playTimeNanos2) {
        if (!this.isFinishedFromNanos(playTimeNanos2)) {
            void var3_5;
            V it = this.animationSpec.getValueFromNanos(playTimeNanos2, this.initialValueVector, this.targetValueVector, this.initialVelocityVector);
            int n = ((AnimationVector)it).getSize$animation_core();
            for (int i = 0; i < n; ++i) {
                if (!Float.isNaN(((AnimationVector)it).get$animation_core(i))) continue;
                String playTimeNanos2 = "AnimationVector cannot contain a NaN. " + it + ". Animation: " + this + ", playTimeNanos: " + playTimeNanos2;
                throw new IllegalStateException(playTimeNanos2.toString());
            }
            TargetBasedAnimation targetBasedAnimation = this;
            return (T)targetBasedAnimation.typeConverter.getConvertFromVector().invoke((Object)var3_5);
        }
        TargetBasedAnimation targetBasedAnimation = this;
        return targetBasedAnimation.targetValue;
    }

    @Override
    public final long getDurationNanos() {
        return this.durationNanos;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V getVelocityVectorFromNanos(long playTimeNanos) {
        if (!this.isFinishedFromNanos(playTimeNanos)) {
            void var1_1;
            return this.animationSpec.getVelocityFromNanos((long)var1_1, this.initialValueVector, this.targetValueVector, this.initialVelocityVector);
        }
        return this.endVelocity;
    }

    public final String toString() {
        Animation<T, V> animation = this;
        StringBuilder stringBuilder = new StringBuilder("TargetBasedAnimation: ").append(this.initialValue).append(" -> ").append(((TargetBasedAnimation)animation).targetValue).append(",initial velocity: ").append(this.initialVelocityVector).append(", duration: ");
        animation = this;
        Intrinsics.checkNotNullParameter((Object)animation, (String)"<this>");
        return stringBuilder.append(animation.getDurationNanos() / 1000000L).append(" ms,animationSpec: ").append(this.animationSpec).toString();
    }
}

