/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.RepeatMode;
import androidx.compose.animation.core.VectorizedAnimationSpec;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0010\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001f\b\u0017\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB*\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ%\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J-\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ-\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rH\u0002J-\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00028\u00002\u0006\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Landroidx/compose/animation/core/VectorizedInfiniteRepeatableSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedAnimationSpec;", "animation", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "repeatMode", "Landroidx/compose/animation/core/RepeatMode;", "(Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;Landroidx/compose/animation/core/RepeatMode;)V", "initialStartOffset", "Landroidx/compose/animation/core/StartOffset;", "(Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;Landroidx/compose/animation/core/RepeatMode;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "durationNanos", "", "getDurationNanos$animation_core", "()J", "initialOffsetNanos", "isInfinite", "", "()Z", "getDurationNanos", "initialValue", "targetValue", "initialVelocity", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)J", "getValueFromNanos", "playTimeNanos", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocityFromNanos", "repetitionPlayTimeNanos", "repetitionStartVelocity", "start", "startVelocity", "end", "animation-core"})
public final class VectorizedInfiniteRepeatableSpec<V extends AnimationVector>
implements VectorizedAnimationSpec<V> {
    private final VectorizedDurationBasedAnimationSpec<V> animation;
    private final RepeatMode repeatMode;
    private final long durationNanos;
    private final long initialOffsetNanos;

    /*
     * WARNING - void declaration
     */
    private VectorizedInfiniteRepeatableSpec(VectorizedDurationBasedAnimationSpec<V> animation, RepeatMode repeatMode, long initialStartOffset) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.animation = var1_1;
        this.repeatMode = var2_2;
        this.durationNanos = (long)(this.animation.getDelayMillis() + this.animation.getDurationMillis()) * 1000000L;
        this.initialOffsetNanos = var3_3 * 1000000L;
    }

    @Override
    public final boolean isInfinite() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final long repetitionPlayTimeNanos(long playTimeNanos) {
        void var3_2;
        void var1_1;
        if (playTimeNanos + this.initialOffsetNanos <= 0L) {
            return 0L;
        }
        void postOffsetPlayTimeNanos = var1_1 + this.initialOffsetNanos;
        void repeatsCount = postOffsetPlayTimeNanos / this.durationNanos;
        if (this.repeatMode == RepeatMode.Restart || repeatsCount % 2L == 0L) {
            return (long)(postOffsetPlayTimeNanos - repeatsCount * this.durationNanos);
        }
        return (long)((repeatsCount + 1L) * this.durationNanos - var3_2);
    }

    /*
     * WARNING - void declaration
     */
    private final V repetitionStartVelocity(long playTimeNanos, V start, V startVelocity, V end) {
        if (playTimeNanos + this.initialOffsetNanos > this.durationNanos) {
            void var3_2;
            VectorizedInfiniteRepeatableSpec vectorizedInfiniteRepeatableSpec = this;
            return vectorizedInfiniteRepeatableSpec.getVelocityFromNanos(vectorizedInfiniteRepeatableSpec.durationNanos - this.initialOffsetNanos, var3_2, startVelocity, end);
        }
        return startVelocity;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V getValueFromNanos(long playTimeNanos, V initialValue, V targetValue, V initialVelocity) {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return this.animation.getValueFromNanos(this.repetitionPlayTimeNanos(playTimeNanos), (void)initialValue, (void)targetValue, this.repetitionStartVelocity((long)var1_1, var3_2, initialVelocity, targetValue));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V getVelocityFromNanos(long playTimeNanos, V initialValue, V targetValue, V initialVelocity) {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return this.animation.getVelocityFromNanos(this.repetitionPlayTimeNanos(playTimeNanos), (void)initialValue, (void)targetValue, this.repetitionStartVelocity((long)var1_1, var3_2, initialVelocity, targetValue));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getDurationNanos(V initialValue, V targetValue, V initialVelocity) {
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"targetValue");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"initialVelocity");
        return Long.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ VectorizedInfiniteRepeatableSpec(VectorizedDurationBasedAnimationSpec animation, RepeatMode repeatMode, long initialStartOffset, byte by) {
        this((VectorizedDurationBasedAnimationSpec<V>)var1_1, (RepeatMode)var2_2, (long)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }
}

