/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.VectorConvertersKt;
import androidx.compose.animation.core.VectorizedAnimationSpecKt;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import io.sentry.SentryOptions;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B7\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u00070\u0005\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ-\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J-\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\n\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u001e"}, d2={"Landroidx/compose/animation/core/VectorizedKeyframesSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "keyframes", "", "", "Lkotlin/Pair;", "Landroidx/compose/animation/core/Easing;", "durationMillis", "delayMillis", "(Ljava/util/Map;II)V", "getDelayMillis", "()I", "getDurationMillis", "valueVector", "Landroidx/compose/animation/core/AnimationVector;", "velocityVector", "getValueFromNanos", "playTimeNanos", "", "initialValue", "targetValue", "initialVelocity", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocityFromNanos", "init", "", "value", "(Landroidx/compose/animation/core/AnimationVector;)V", "animation-core"})
public final class VectorizedKeyframesSpec<V extends AnimationVector>
implements VectorizedDurationBasedAnimationSpec<V> {
    private final Map<Integer, Pair<V, SentryOptions.TracesSamplerCallback>> keyframes;
    private final int durationMillis;
    private final int delayMillis;
    private V valueVector;
    private V velocityVector;

    /*
     * WARNING - void declaration
     */
    public VectorizedKeyframesSpec(Map<Integer, ? extends Pair<? extends V, ? extends SentryOptions.TracesSamplerCallback>> keyframes, int durationMillis, int delayMillis) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(keyframes, (String)"keyframes");
        this.keyframes = var1_1;
        this.durationMillis = var2_2;
        this.delayMillis = var3_3;
    }

    @Override
    public final int getDurationMillis() {
        return this.durationMillis;
    }

    @Override
    public final int getDelayMillis() {
        return this.delayMillis;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V getValueFromNanos(long playTimeNanos, V initialValue, V targetValue, V initialVelocity) {
        void var3_3;
        void var2_9;
        void var1_2;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long playTimeMillis22 = playTimeNanos / 1000000L;
        int clampedPlayTime = (int)VectorizedAnimationSpecKt.access$clampPlayTime(this, playTimeMillis22);
        if (this.keyframes.containsKey(clampedPlayTime)) {
            return (V)((AnimationVector)((Pair)MapsKt.getValue(this.keyframes, (Object)clampedPlayTime)).getFirst());
        }
        VectorizedKeyframesSpec playTimeMillis22 = this;
        if (clampedPlayTime >= playTimeMillis22.durationMillis) {
            return targetValue;
        }
        if (clampedPlayTime <= 0) {
            return initialValue;
        }
        int startTime = 0;
        Object startVal = initialValue;
        Object endVal = targetValue;
        playTimeMillis22 = this;
        int endTime = playTimeMillis22.durationMillis;
        SentryOptions.TracesSamplerCallback easing = EasingKt.getLinearEasing$6503073d();
        for (Map.Entry<Integer, Pair<V, SentryOptions.TracesSamplerCallback>> entry : this.keyframes.entrySet()) {
            int timestamp = ((Number)entry.getKey()).intValue();
            Pair<V, SentryOptions.TracesSamplerCallback> value = entry.getValue();
            if (clampedPlayTime > timestamp && timestamp >= startTime) {
                startTime = timestamp;
                startVal = (AnimationVector)value.getFirst();
                easing = (SentryOptions.TracesSamplerCallback)value.getSecond();
                continue;
            }
            if (clampedPlayTime >= timestamp || timestamp > endTime) continue;
            endTime = timestamp;
            endVal = (AnimationVector)value.getFirst();
        }
        float fraction = easing.transform((float)(var1_2 - startTime) / (float)(endTime - var2_9));
        this.init(var3_3);
        int n = ((AnimationVector)startVal).getSize$animation_core();
        for (int i = 0; i < n; ++i) {
            V v = this.valueVector;
            if (v == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
                v = null;
            }
            ((AnimationVector)v).set$animation_core(i, VectorConvertersKt.lerp(((AnimationVector)startVal).get$animation_core(i), ((AnimationVector)endVal).get$animation_core(i), fraction));
        }
        V v = this.valueVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            v = null;
        }
        return v;
    }

    /*
     * WARNING - void declaration
     */
    private final void init(V value) {
        if (this.valueVector == null) {
            void var1_1;
            this.valueVector = AnimationSpecKt.newInstance(value);
            this.velocityVector = AnimationSpecKt.newInstance(var1_1);
        }
    }

    @Override
    public final V getVelocityFromNanos(long playTimeNanos, V initialValue, V targetValue, V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long playTimeMillis = playTimeNanos / 1000000L;
        long clampedPlayTime = VectorizedAnimationSpecKt.access$clampPlayTime(this, playTimeMillis);
        if (clampedPlayTime <= 0L) {
            return initialVelocity;
        }
        V startNum = VectorizedAnimationSpecKt.getValueFromMillis(this, clampedPlayTime - 1L, initialValue, targetValue, initialVelocity);
        V endNum = VectorizedAnimationSpecKt.getValueFromMillis(this, clampedPlayTime, initialValue, targetValue, initialVelocity);
        this.init(initialValue);
        int n = ((AnimationVector)startNum).getSize$animation_core();
        for (int i = 0; i < n; ++i) {
            V v = this.velocityVector;
            if (v == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
                v = null;
            }
            ((AnimationVector)v).set$animation_core(i, (((AnimationVector)startNum).get$animation_core(i) - ((AnimationVector)endNum).get$animation_core(i)) * 1000.0f);
        }
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            v = null;
        }
        return v;
    }
}

