/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.core;

import androidx.compose.foundation.text.KeyMapping_skikoMainKt;
import androidx.datastore.preferences.core.MutablePreferences;
import androidx.datastore.preferences.core.Preferences;
import androidx.datastore.preferences.core.PreferencesKt;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B+\b\u0000\u0012\u0018\b\u0002\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u000eH\u0016J\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0006\u0010\u0012\u001a\u00020\u0010J\u001d\u0010\u0013\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0004H\u0096\u0002J\u0013\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0096\u0002J\r\u0010\u0018\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0019J$\u0010\u001a\u001a\u0004\u0018\u0001H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0004H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0015\u0010\u001e\u001a\u00020\u00102\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0001H\u0086\u0002J\u0015\u0010\u001f\u001a\u00020\u00102\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0086\u0002J'\u0010#\u001a\u00020\u00102\u001a\u0010$\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\"0%\"\u0006\u0012\u0002\b\u00030\"\u00a2\u0006\u0002\u0010&J\u001f\u0010'\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0004\u00a2\u0006\u0002\u0010\u001bJ*\u0010(\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00042\u0006\u0010)\u001a\u0002H\u0014H\u0086\u0002\u00a2\u0006\u0002\u0010*J#\u0010+\u001a\u00020\u00102\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00042\b\u0010)\u001a\u0004\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\b,J\b\u0010-\u001a\u00020.H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006/"}, d2={"Landroidx/datastore/preferences/core/MutablePreferences;", "Landroidx/datastore/preferences/core/Preferences;", "preferencesMap", "", "Landroidx/datastore/preferences/core/Preferences$Key;", "", "startFrozen", "", "(Ljava/util/Map;Z)V", "frozen", "Landroidx/datastore/preferences/core/AtomicBoolean;", "getPreferencesMap$datastore_preferences_core", "()Ljava/util/Map;", "asMap", "", "checkNotFrozen", "", "checkNotFrozen$datastore_preferences_core", "clear", "contains", "T", "key", "equals", "other", "freeze", "freeze$datastore_preferences_core", "get", "(Landroidx/datastore/preferences/core/Preferences$Key;)Ljava/lang/Object;", "hashCode", "", "minusAssign", "plusAssign", "prefs", "pair", "Landroidx/datastore/preferences/core/Preferences$Pair;", "putAll", "pairs", "", "([Landroidx/datastore/preferences/core/Preferences$Pair;)V", "remove", "set", "value", "(Landroidx/datastore/preferences/core/Preferences$Key;Ljava/lang/Object;)V", "setUnchecked", "setUnchecked$datastore_preferences_core", "toString", "", "datastore-preferences-core"})
public final class MutablePreferences
extends Preferences {
    private final Map<Preferences.Key<?>, Object> preferencesMap;
    private final KeyMapping_skikoMainKt frozen$2679d09b;

    /*
     * WARNING - void declaration
     */
    public MutablePreferences(Map<Preferences.Key<?>, Object> preferencesMap, boolean startFrozen) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(preferencesMap, (String)"preferencesMap");
        this.preferencesMap = var1_1;
        this.frozen$2679d09b = new KeyMapping_skikoMainKt((boolean)var2_2);
    }

    public /* synthetic */ MutablePreferences(Map map, boolean bl, int n) {
        if ((n & 1) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        this(map, bl);
    }

    public final void checkNotFrozen$datastore_preferences_core() {
        if (!(!this.frozen$2679d09b.get())) {
            String string = "Do mutate preferences once returned to DataStore.";
            throw new IllegalStateException(string.toString());
        }
    }

    public final void freeze$datastore_preferences_core() {
        this.frozen$2679d09b.set(true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T get(Preferences.Key<T> key) {
        void var1_1;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Object value = this.preferencesMap.get(key);
        if (value instanceof byte[]) {
            byte[] byArray = (byte[])value;
            byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, size)");
            return (T)byArray2;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<Preferences.Key<?>, Object> asMap() {
        void var2_3;
        Iterator iterator;
        Iterable $this$associate$iv = this.preferencesMap.entrySet();
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Pair pair2;
            Object element$iv$iv = iterator.next();
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Object value = entry.getValue();
            if (value instanceof byte[]) {
                Object k = entry.getKey();
                byte[] byArray = (byte[])value;
                byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, size)");
                pair2 = new Pair(k, (Object)byArray2);
            } else {
                pair2 = new Pair(entry.getKey(), pair.getValue());
            }
            pair = pair2;
            map.put(pair.getFirst(), pair.getSecond());
        }
        iterator = var2_3;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"map");
        Map<Preferences.Key<?>, Object> map = Collections.unmodifiableMap(iterator);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(map)");
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> void set(Preferences.Key<T> key, T value) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.setUnchecked$datastore_preferences_core((Preferences.Key<?>)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnchecked$datastore_preferences_core(Preferences.Key<?> key, Object value) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.checkNotFrozen$datastore_preferences_core();
        Object object = value;
        if (object == null) {
            this.remove(key);
            return;
        }
        if (object instanceof Set) {
            this.preferencesMap.put(key, PreferencesKt.immutableCopyOfSet((Set)value));
            return;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])value;
            byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, size)");
            this.preferencesMap.put(key, byArray2);
            return;
        }
        this.preferencesMap.put((Preferences.Key<?>)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private <T> T remove(Preferences.Key<T> key) {
        void var1_1;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.checkNotFrozen$datastore_preferences_core();
        return (T)this.preferencesMap.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        if (!(other instanceof MutablePreferences)) {
            return false;
        }
        if (((MutablePreferences)other).preferencesMap == this.preferencesMap) {
            return true;
        }
        if (((MutablePreferences)other).preferencesMap.size() != this.preferencesMap.size()) {
            return false;
        }
        Map<Preferences.Key<?>, Object> $this$all$iv = ((MutablePreferences)other).preferencesMap;
        if (!$this$all$iv.isEmpty()) {
            Iterator iterator;
            for (Map.Entry otherEntry : iterator.entrySet()) {
                void var3_3;
                void var2_2;
                Object value;
                Object otherVal;
                if (this.preferencesMap.get(otherEntry.getKey()) != null ? ((otherVal = otherEntry.getValue()) instanceof byte[] ? value instanceof byte[] && Arrays.equals((byte[])otherVal, (byte[])value) : Intrinsics.areEqual((Object)var2_2, (Object)var3_3)) : false) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        Object object = this.preferencesMap.entrySet();
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            void var2_3;
            Object e = object.next();
            Map.Entry entry = (Map.Entry)e;
            int n2 = n;
            Object value = entry.getValue();
            n = value instanceof byte[] ? Arrays.hashCode((byte[])value) : var2_3.hashCode();
            n = n2 + n;
        }
        return n;
    }

    public final String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.preferencesMap.entrySet(), (CharSequence)",\n", (CharSequence)"{\n", (CharSequence)"\n}", (int)0, null, (Function1)toString.1.INSTANCE, (int)24, null);
    }

    public MutablePreferences() {
        this(null, false, 3);
    }
}

