/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CodedOutputStream;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.LazyStringList;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.PrimitiveNonBoxingCollection;
import androidx.datastore.preferences.protobuf.Schema;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractMessageLite<MessageType extends AbstractMessageLite<MessageType, BuilderType>, BuilderType extends Builder<MessageType, BuilderType>>
implements MessageLite {
    protected int memoizedHashCode = 0;

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteString toByteString() {
        try {
            ByteString.CodedBuilder out = ByteString.newCodedBuilder(this.getSerializedSize());
            this.writeTo(out.getCodedOutput());
            return out.build();
        }
        catch (IOException e) {
            void var1_2;
            String string = "ByteString";
            AbstractMessageLite abstractMessageLite = this;
            throw new RuntimeException("Serializing " + abstractMessageLite.getClass().getName() + " to a " + string + " threw an IOException (should never happen).", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeTo(OutputStream output) throws IOException {
        void var1_1;
        void var2_2;
        int bufferSize = CodedOutputStream.computePreferredBufferSize(this.getSerializedSize());
        CodedOutputStream codedOutput = CodedOutputStream.newInstance(output, (int)var2_2);
        this.writeTo(codedOutput);
        var1_1.flush();
    }

    int getMemoizedSerializedSize() {
        throw new UnsupportedOperationException();
    }

    void setMemoizedSerializedSize(int size) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    int getSerializedSize(Schema schema) {
        void var2_2;
        int memoizedSerializedSize = this.getMemoizedSerializedSize();
        if (memoizedSerializedSize == -1) {
            void var1_1;
            memoizedSerializedSize = var1_1.getSerializedSize(this);
            this.setMemoizedSerializedSize(memoizedSerializedSize);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected static <T> void addAll(Iterable<T> values, List<? super T> list) {
        void var1_1;
        Builder.addAll(values, var1_1);
    }

    public static abstract class Builder<MessageType extends AbstractMessageLite<MessageType, BuilderType>, BuilderType extends Builder<MessageType, BuilderType>>
    implements MessageLite.Builder {
        public abstract BuilderType clone();

        /*
         * WARNING - void declaration
         */
        private static <T> void addAllCheckingNulls(Iterable<T> values, List<? super T> list) {
            if (list instanceof ArrayList && values instanceof Collection) {
                ((ArrayList)list).ensureCapacity(list.size() + ((Collection)values).size());
            }
            int begin = list.size();
            values = values.iterator();
            while (values.hasNext()) {
                void var3_3;
                Object value = values.next();
                if (value == null) {
                    String string;
                    String message = "Element at index " + (list.size() - begin) + " is null.";
                    for (int i = list.size() - 1; i >= begin; --i) {
                        list.remove(i);
                    }
                    throw new NullPointerException(string);
                }
                list.add(var3_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        protected static <T> void addAll(Iterable<T> values, List<? super T> list) {
            void var1_1;
            String string;
            Internal.checkNotNull(values);
            if (values instanceof LazyStringList) {
                String lazyValues = ((LazyStringList)values).getUnderlyingElements();
                LazyStringList lazyList = (LazyStringList)list;
                int begin = list.size();
                lazyValues = lazyValues.iterator();
                while (lazyValues.hasNext()) {
                    void var3_4;
                    Object value = lazyValues.next();
                    if (value == null) {
                        String message = "Element at index " + (lazyList.size() - begin) + " is null.";
                        for (int i = lazyList.size() - 1; i >= begin; --i) {
                            lazyList.remove(i);
                        }
                        throw new NullPointerException(string);
                    }
                    if (var3_4 instanceof ByteString) {
                        lazyList.add((ByteString)var3_4);
                        continue;
                    }
                    lazyList.add((String)var3_4);
                }
                return;
            }
            if (string instanceof PrimitiveNonBoxingCollection) {
                var1_1.addAll((Collection)((Object)string));
                return;
            }
            Builder.addAllCheckingNulls(string, var1_1);
        }
    }
}

