/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.Android;
import androidx.datastore.preferences.protobuf.ByteOutput;
import androidx.datastore.preferences.protobuf.CodedInputStream;
import androidx.datastore.preferences.protobuf.CodedOutputStream;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.TextFormatEscaper;
import androidx.datastore.preferences.protobuf.Utf8;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;

public abstract class ByteString
implements Serializable,
Iterable<Byte> {
    public static final ByteString EMPTY = new LiteralByteString(Internal.EMPTY_BYTE_ARRAY);
    private static final ByteArrayCopier byteArrayCopier = Android.isOnAndroidDevice() ? new SystemByteArrayCopier(0) : new ArraysByteArrayCopier(0);
    private int hash = 0;

    ByteString() {
    }

    public abstract byte byteAt(int var1);

    abstract byte internalByteAt(int var1);

    public final ByteIterator iterator() {
        return new AbstractByteIterator(this){
            private int position = 0;
            private final int limit = this.this$0.size();
            private /* synthetic */ ByteString this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public final boolean hasNext() {
                return this.position < this.limit;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final byte nextByte() {
                void var1_1;
                int currentPos = this.position;
                if (currentPos >= this.limit) {
                    throw new NoSuchElementException();
                }
                this.position = currentPos + 1;
                return this.this$0.internalByteAt((int)var1_1);
            }
        };
    }

    public abstract int size();

    public abstract ByteString substring(int var1, int var2);

    /*
     * WARNING - void declaration
     */
    public static ByteString copyFrom(byte[] bytes, int offset, int size) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        int n = offset;
        ByteString.checkRange(n, n + size, bytes.length);
        return new LiteralByteString(byteArrayCopier.copyFrom(byArray, (int)var1_1, (int)var2_2));
    }

    public static ByteString copyFrom(byte[] bytes) {
        byte[] byArray;
        return ByteString.copyFrom(bytes, 0, byArray.length);
    }

    static ByteString wrap(byte[] bytes) {
        byte[] byArray;
        return new LiteralByteString(byArray);
    }

    public static ByteString copyFromUtf8(String text) {
        String string;
        return new LiteralByteString(string.getBytes(Internal.UTF_8));
    }

    protected abstract void copyToInternal(byte[] var1, int var2, int var3, int var4);

    /*
     * WARNING - void declaration
     */
    public final byte[] toByteArray() {
        void var2_2;
        void var1_1;
        int size = this.size();
        if (size == 0) {
            return Internal.EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[size];
        this.copyToInternal(result, 0, 0, (int)var1_1);
        return var2_2;
    }

    abstract void writeTo(ByteOutput var1) throws IOException;

    protected abstract String toStringInternal(Charset var1);

    public final String toStringUtf8() {
        Charset charset = Internal.UTF_8;
        ByteString byteString = this;
        if (byteString.size() == 0) {
            return "";
        }
        return byteString.toStringInternal(charset);
    }

    public abstract boolean isValidUtf8();

    public abstract boolean equals(Object var1);

    public final int hashCode() {
        int n;
        int h = this.hash;
        if (h == 0) {
            int size = this.size();
            n = this.partialHash(size, 0, n);
            if (n == 0) {
                n = 1;
            }
            this.hash = n;
        }
        return n;
    }

    public abstract CodedInputStream newCodedInput();

    static CodedBuilder newCodedBuilder(int size) {
        int n;
        return new CodedBuilder(n, 0);
    }

    protected final int peekCachedHashCode() {
        return this.hash;
    }

    protected abstract int partialHash(int var1, int var2, int var3);

    /*
     * WARNING - void declaration
     */
    static int checkRange(int startIndex, int endIndex, int size) {
        void var3_3;
        int length = endIndex - startIndex;
        if ((startIndex | endIndex | length | size - endIndex) < 0) {
            void var2_2;
            void var1_1;
            if (startIndex < 0) {
                throw new IndexOutOfBoundsException("Beginning index: " + startIndex + " < 0");
            }
            if (endIndex < startIndex) {
                int n;
                throw new IndexOutOfBoundsException("Beginning index larger than ending index: " + n + ", " + endIndex);
            }
            throw new IndexOutOfBoundsException("End index: " + (int)var1_1 + " >= " + (int)var2_2);
        }
        return (int)var3_3;
    }

    public final String toString() {
        ByteString byteString;
        return String.format(Locale.ROOT, "<ByteString@%s size=%d contents=\"%s\">", Integer.toHexString(System.identityHashCode(this)), this.size(), (byteString = this).size() <= 50 ? TextFormatEscaper.escapeBytes(byteString) : TextFormatEscaper.escapeBytes(byteString.substring(0, 47)) + "...");
    }

    static /* synthetic */ int access$200(byte x0) {
        byte by = x0;
        return by & 0xFF;
    }

    static {
        new Comparator<ByteString>(){};
    }

    static final class BoundedByteString
    extends LiteralByteString {
        private final int bytesOffset;
        private final int bytesLength;

        /*
         * WARNING - void declaration
         */
        BoundedByteString(byte[] bytes, int offset, int length) {
            super(bytes);
            void var3_3;
            void var2_2;
            void var1_1;
            int n = offset;
            BoundedByteString.checkRange(n, n + length, ((void)var1_1).length);
            this.bytesOffset = var2_2;
            this.bytesLength = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte byteAt(int index) {
            void var1_1;
            BoundedByteString boundedByteString = this;
            int n = index;
            int n2 = boundedByteString.bytesLength;
            if ((n | n2 - (n + 1)) < 0) {
                if (n < 0) {
                    throw new ArrayIndexOutOfBoundsException("Index < 0: " + n);
                }
                throw new ArrayIndexOutOfBoundsException("Index > length: " + n + ", " + n2);
            }
            return this.bytes[this.bytesOffset + var1_1];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final byte internalByteAt(int index) {
            void var1_1;
            return this.bytes[this.bytesOffset + var1_1];
        }

        @Override
        public final int size() {
            return this.bytesLength;
        }

        @Override
        protected final int getOffsetIntoBytes() {
            return this.bytesOffset;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
            void var1_1;
            BoundedByteString boundedByteString = this;
            System.arraycopy(this.bytes, boundedByteString.bytesOffset, var1_1, 0, numberToCopy);
        }
    }

    static class LiteralByteString
    extends LeafByteString {
        protected final byte[] bytes;

        /*
         * WARNING - void declaration
         */
        LiteralByteString(byte[] bytes) {
            void var1_1;
            if (bytes == null) {
                throw new NullPointerException();
            }
            this.bytes = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte byteAt(int index) {
            void var1_1;
            return this.bytes[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        byte internalByteAt(int index) {
            void var1_1;
            return this.bytes[var1_1];
        }

        @Override
        public int size() {
            return this.bytes.length;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteString substring(int beginIndex, int endIndex) {
            void var2_2;
            void var1_1;
            int length = LiteralByteString.checkRange(beginIndex, endIndex, this.size());
            if (length == 0) {
                return EMPTY;
            }
            return new BoundedByteString(this.bytes, this.getOffsetIntoBytes() + var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
            void var1_1;
            System.arraycopy(this.bytes, 0, var1_1, 0, numberToCopy);
        }

        @Override
        final void writeTo(ByteOutput output) throws IOException {
            output.writeLazy(this.bytes, this.getOffsetIntoBytes(), this.size());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final String toStringInternal(Charset charset) {
            void var1_1;
            return new String(this.bytes, this.getOffsetIntoBytes(), this.size(), (Charset)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean isValidUtf8() {
            void var1_1;
            int offset = this.getOffsetIntoBytes();
            void v0 = var1_1;
            return Utf8.isValidUtf8(this.bytes, (int)v0, (int)(v0 + this.size()));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object other2222) {
            void var1_1;
            if (other2222 == this) {
                return true;
            }
            if (!(other2222 instanceof ByteString)) {
                return false;
            }
            if (this.size() != ((ByteString)other2222).size()) {
                return false;
            }
            if (this.size() == 0) {
                return true;
            }
            if (other2222 instanceof LiteralByteString) {
                void var2_6;
                int n;
                LiteralByteString otherAsLiteral = (LiteralByteString)other2222;
                int thisHash = this.peekCachedHashCode();
                int thatHash = otherAsLiteral.peekCachedHashCode();
                if (thisHash != 0 && thatHash != 0 && n != var2_6) {
                    return false;
                }
                n = this.size();
                boolean other2222 = false;
                LiteralByteString literalByteString = (LiteralByteString)other2222;
                LiteralByteString other2222 = this;
                if (n > ((ByteString)literalByteString).size()) {
                    throw new IllegalArgumentException("Length too large: " + n + other2222.size());
                }
                if (n + 0 > ((ByteString)literalByteString).size()) {
                    throw new IllegalArgumentException("Ran off end of other: " + 0 + ", " + n + ", " + ((ByteString)literalByteString).size());
                }
                if (literalByteString instanceof LiteralByteString) {
                    byte[] byArray = other2222.bytes;
                    byte[] byArray2 = literalByteString.bytes;
                    n = other2222.getOffsetIntoBytes() + n;
                    int other2222 = other2222.getOffsetIntoBytes();
                    int n2 = literalByteString.getOffsetIntoBytes();
                    while (other2222 < n) {
                        if (byArray[other2222] != byArray2[n2]) {
                            return false;
                        }
                        ++other2222;
                        ++n2;
                    }
                    return true;
                }
                return ((ByteString)literalByteString).substring(0, n + 0).equals(other2222.substring(0, n));
            }
            return var1_1.equals(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final int partialHash(int h, int offset, int length) {
            void var3_3;
            return Internal.partialHash(h, this.bytes, this.getOffsetIntoBytes(), (int)var3_3);
        }

        @Override
        public final CodedInputStream newCodedInput() {
            return CodedInputStream.newInstance(this.bytes, this.getOffsetIntoBytes(), this.size(), true);
        }

        protected int getOffsetIntoBytes() {
            return 0;
        }
    }

    static final class CodedBuilder {
        private final CodedOutputStream output;
        private final byte[] buffer;

        /*
         * WARNING - void declaration
         */
        private CodedBuilder(int size) {
            void var1_1;
            this.buffer = new byte[var1_1];
            this.output = CodedOutputStream.newInstance(this.buffer);
        }

        public final ByteString build() {
            CodedOutputStream codedOutputStream = this.output;
            if (codedOutputStream.spaceLeft() != 0) {
                throw new IllegalStateException("Did not write as much data as expected.");
            }
            return new LiteralByteString(this.buffer);
        }

        public final CodedOutputStream getCodedOutput() {
            return this.output;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ CodedBuilder(int x0, byte by) {
            this((int)var1_1);
            void var1_1;
        }
    }

    static abstract class LeafByteString
    extends ByteString {
        LeafByteString() {
        }
    }

    static abstract class AbstractByteIterator
    implements ByteIterator {
        AbstractByteIterator() {
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface ByteIterator
    extends Iterator<Byte> {
        public byte nextByte();
    }

    static final class ArraysByteArrayCopier
    implements ByteArrayCopier {
        private ArraysByteArrayCopier() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] copyFrom(byte[] bytes, int offset, int size) {
            void var3_3;
            void var2_2;
            void v0 = var2_2;
            return Arrays.copyOfRange(bytes, (int)v0, (int)(v0 + var3_3));
        }

        /* synthetic */ ArraysByteArrayCopier(byte by) {
            this();
        }
    }

    static final class SystemByteArrayCopier
    implements ByteArrayCopier {
        private SystemByteArrayCopier() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] copyFrom(byte[] bytes, int offset, int size) {
            void var3_3;
            void var2_2;
            void var1_1;
            byte[] copy = new byte[size];
            System.arraycopy(var1_1, (int)var2_2, copy, 0, (int)var3_3);
            return copy;
        }

        /* synthetic */ SystemByteArrayCopier(byte by) {
            this();
        }
    }

    static interface ByteArrayCopier {
        public byte[] copyFrom(byte[] var1, int var2, int var3);
    }
}

