/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CodedInputStreamReader;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.InvalidProtocolBufferException;
import androidx.datastore.preferences.protobuf.Utf8;
import androidx.datastore.preferences.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class CodedInputStream {
    private static volatile int defaultRecursionLimit = 100;
    int recursionDepth;
    int recursionLimit = defaultRecursionLimit;
    int sizeLimit = Integer.MAX_VALUE;
    CodedInputStreamReader wrapper;

    public static CodedInputStream newInstance(InputStream input) {
        int n = 4096;
        Object object = input;
        if (object == null) {
            object = Internal.EMPTY_BYTE_ARRAY;
            int n2 = ((Object)object).length;
            boolean bl = false;
            byte[] byArray = Internal.EMPTY_BYTE_ARRAY;
            return CodedInputStream.newInstance(byArray, 0, n2, false);
        }
        return new StreamDecoder((InputStream)object, 4096, 0);
    }

    public static CodedInputStream newInstance(byte[] buf) {
        byte[] byArray;
        int n = byArray.length;
        boolean bl = false;
        byte[] byArray2 = buf;
        return CodedInputStream.newInstance(buf, 0, n, false);
    }

    /*
     * WARNING - void declaration
     */
    static CodedInputStream newInstance(byte[] buf, int off, int len, boolean bufferIsImmutable) {
        Object object;
        void var3_4;
        void var1_2;
        Object result = new ArrayDecoder(buf, (int)var1_2, len, (boolean)var3_4, 0);
        try {
            void var2_3;
            ((ArrayDecoder)result).pushLimit((int)var2_3);
        }
        catch (InvalidProtocolBufferException ex) {
            void var0_1;
            throw new IllegalArgumentException((Throwable)var0_1);
        }
        return object;
    }

    private CodedInputStream() {
    }

    public abstract int readTag() throws IOException;

    public abstract void checkLastTagWas(int var1) throws InvalidProtocolBufferException;

    public abstract boolean skipField(int var1) throws IOException;

    public abstract double readDouble() throws IOException;

    public abstract float readFloat() throws IOException;

    public abstract long readUInt64() throws IOException;

    public abstract long readInt64() throws IOException;

    public abstract int readInt32() throws IOException;

    public abstract long readFixed64() throws IOException;

    public abstract int readFixed32() throws IOException;

    public abstract boolean readBool() throws IOException;

    public abstract String readString() throws IOException;

    public abstract String readStringRequireUtf8() throws IOException;

    public abstract ByteString readBytes() throws IOException;

    public abstract int readUInt32() throws IOException;

    public abstract int readEnum() throws IOException;

    public abstract int readSFixed32() throws IOException;

    public abstract long readSFixed64() throws IOException;

    public abstract int readSInt32() throws IOException;

    public abstract long readSInt64() throws IOException;

    abstract long readRawVarint64SlowPath() throws IOException;

    public abstract int pushLimit(int var1) throws InvalidProtocolBufferException;

    public abstract void popLimit(int var1);

    public abstract boolean isAtEnd() throws IOException;

    public abstract int getTotalBytesRead();

    public static int decodeZigZag32(int n) {
        int n2;
        return n >>> 1 ^ -(n2 & 1);
    }

    public static long decodeZigZag64(long n) {
        long l;
        return n >>> 1 ^ -(l & 1L);
    }

    /* synthetic */ CodedInputStream(byte by) {
        this();
    }

    static final class StreamDecoder
    extends CodedInputStream {
        private final InputStream input;
        private final byte[] buffer;
        private int bufferSize;
        private int bufferSizeAfterLimit;
        private int pos;
        private int lastTag;
        private int totalBytesRetired;
        private int currentLimit = Integer.MAX_VALUE;
        private RefillCallback refillCallback = null;

        /*
         * WARNING - void declaration
         */
        private StreamDecoder(InputStream input, int bufferSize) {
            super((byte)0);
            void var2_2;
            void var1_1;
            Internal.checkNotNull(input, "input");
            this.input = var1_1;
            this.buffer = new byte[var2_2];
            this.bufferSize = 0;
            this.pos = 0;
            this.totalBytesRetired = 0;
        }

        /*
         * WARNING - void declaration
         */
        private static int read(InputStream input, byte[] data, int offset, int length) throws IOException {
            try {
                void var3_3;
                void var2_2;
                void var1_1;
                return input.read((byte[])var1_1, (int)var2_2, (int)var3_3);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                InvalidProtocolBufferException invalidProtocolBufferException2;
                InvalidProtocolBufferException e = invalidProtocolBufferException;
                invalidProtocolBufferException.setThrownFromInputStream();
                throw invalidProtocolBufferException2;
            }
        }

        /*
         * WARNING - void declaration
         */
        private static long skip(InputStream input, long length) throws IOException {
            try {
                void var1_1;
                return input.skip((long)var1_1);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                InvalidProtocolBufferException invalidProtocolBufferException2;
                InvalidProtocolBufferException e = invalidProtocolBufferException;
                invalidProtocolBufferException.setThrownFromInputStream();
                throw invalidProtocolBufferException2;
            }
        }

        private static int available(InputStream input) throws IOException {
            try {
                return input.available();
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                InvalidProtocolBufferException invalidProtocolBufferException2;
                InvalidProtocolBufferException e = invalidProtocolBufferException;
                invalidProtocolBufferException.setThrownFromInputStream();
                throw invalidProtocolBufferException2;
            }
        }

        @Override
        public final int readTag() throws IOException {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = this.readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void checkLastTagWas(int value) throws InvalidProtocolBufferException {
            void var1_1;
            if (this.lastTag != var1_1) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final boolean skipField(int tag) throws IOException {
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    StreamDecoder streamDecoder = this;
                    if (streamDecoder.bufferSize - streamDecoder.pos >= 10) {
                        StreamDecoder streamDecoder2 = streamDecoder;
                        for (tag = 0; tag < 10; ++tag) {
                            if (streamDecoder2.buffer[streamDecoder2.pos++] >= 0) return true;
                        }
                        throw InvalidProtocolBufferException.malformedVarint();
                    }
                    StreamDecoder streamDecoder3 = streamDecoder;
                    for (tag = 0; tag < 10; ++tag) {
                        if (streamDecoder3.readRawByte() >= 0) return true;
                    }
                    throw InvalidProtocolBufferException.malformedVarint();
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    StreamDecoder streamDecoder = this;
                    streamDecoder.skipRawBytes(streamDecoder.readRawVarint32());
                    return true;
                }
                case 3: {
                    void var1_1;
                    int n;
                    StreamDecoder streamDecoder = this;
                    while ((n = streamDecoder.readTag()) != 0 && streamDecoder.skipField(n)) {
                    }
                    this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber((int)var1_1), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public final double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public final float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public final long readUInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final long readInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final int readInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public final long readFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final boolean readBool() throws IOException {
            return this.readRawVarint64() != 0L;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String readString() throws IOException {
            void var1_1;
            int size = this.readRawVarint32();
            if (size > 0 && size <= this.bufferSize - this.pos) {
                String result = new String(this.buffer, this.pos, size, Internal.UTF_8);
                this.pos += size;
                return result;
            }
            if (size == 0) {
                return "";
            }
            if (size <= this.bufferSize) {
                void var2_3;
                this.refillBuffer(size);
                String result = new String(this.buffer, this.pos, size, Internal.UTF_8);
                this.pos += size;
                return var2_3;
            }
            return new String(this.readRawBytesSlowPath((int)var1_1, false), Internal.UTF_8);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String readStringRequireUtf8() throws IOException {
            void var1_1;
            void var3_2;
            void var2_3;
            byte[] bytes;
            int oldPos;
            int size = this.readRawVarint32();
            if (size <= this.bufferSize - (oldPos = this.pos) && size > 0) {
                bytes = this.buffer;
                this.pos = oldPos + size;
            } else {
                boolean tempPos;
                if (size == 0) {
                    return "";
                }
                if (size <= this.bufferSize) {
                    this.refillBuffer(size);
                    bytes = this.buffer;
                    tempPos = false;
                    this.pos = size + 0;
                } else {
                    bytes = this.readRawBytesSlowPath(size, false);
                    tempPos = false;
                }
            }
            return Utf8.decodeUtf8((byte[])var2_3, (int)var3_2, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ByteString readBytes() throws IOException {
            void var1_1;
            int size = this.readRawVarint32();
            if (size <= this.bufferSize - this.pos && size > 0) {
                void var2_4;
                ByteString result = ByteString.copyFrom(this.buffer, this.pos, size);
                this.pos += size;
                return var2_4;
            }
            if (size == 0) {
                return ByteString.EMPTY;
            }
            StreamDecoder streamDecoder = this;
            void var2_5 = var1_1;
            byte[] byArray = streamDecoder.readRawBytesSlowPathOneChunk((int)var2_5);
            if (byArray != null) {
                return ByteString.copyFrom(byArray);
            }
            int n = streamDecoder.pos;
            int n2 = streamDecoder.bufferSize - streamDecoder.pos;
            streamDecoder.totalBytesRetired += streamDecoder.bufferSize;
            streamDecoder.pos = 0;
            streamDecoder.bufferSize = 0;
            void var5_12 = var2_5 - n2;
            List<byte[]> list = streamDecoder.readRawBytesSlowPathRemainingChunks((int)var5_12);
            byte[] byArray2 = new byte[var2_5];
            System.arraycopy(streamDecoder.buffer, n, byArray2, 0, n2);
            int n3 = n2;
            for (byte[] byArray3 : list) {
                System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
                n3 += byArray3.length;
            }
            return ByteString.wrap(byArray2);
        }

        @Override
        public final int readUInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public final int readEnum() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public final int readSFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final long readSFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readSInt32() throws IOException {
            return StreamDecoder.decodeZigZag32(this.readRawVarint32());
        }

        @Override
        public final long readSInt64() throws IOException {
            return StreamDecoder.decodeZigZag64(this.readRawVarint64());
        }

        /*
         * WARNING - void declaration
         */
        private int readRawVarint32() throws IOException {
            block4: {
                void var3_3;
                void var1_1;
                block6: {
                    void var2_2;
                    byte[] buffer;
                    int tempPos;
                    block8: {
                        block7: {
                            block5: {
                                int x;
                                tempPos = this.pos;
                                if (this.bufferSize == tempPos) break block4;
                                buffer = this.buffer;
                                if ((x = this.buffer[tempPos++]) >= 0) {
                                    this.pos = tempPos;
                                    return x;
                                }
                                if (this.bufferSize - tempPos < 9) break block4;
                                if ((x ^= buffer[tempPos++] << 7) >= 0) break block5;
                                x ^= 0xFFFFFF80;
                                break block6;
                            }
                            if ((x ^= buffer[tempPos++] << 14) < 0) break block7;
                            x ^= 0x3F80;
                            break block6;
                        }
                        if ((x ^= buffer[tempPos++] << 21) >= 0) break block8;
                        x ^= 0xFFE03F80;
                        break block6;
                    }
                    byte y = buffer[tempPos++];
                    x ^= y << 28;
                    x ^= 0xFE03F80;
                    if (y < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && var2_2[tempPos++] < 0) break block4;
                }
                this.pos = var1_1;
                return (int)var3_3;
            }
            return (int)this.readRawVarint64SlowPath();
        }

        /*
         * WARNING - void declaration
         */
        private long readRawVarint64() throws IOException {
            block4: {
                void var3_4;
                void var1_1;
                block6: {
                    void var2_2;
                    byte[] buffer;
                    int tempPos;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    long x32;
                                    block8: {
                                        int x32;
                                        block7: {
                                            block5: {
                                                int y;
                                                tempPos = this.pos;
                                                if (this.bufferSize == tempPos) break block4;
                                                buffer = this.buffer;
                                                if ((y = this.buffer[tempPos++]) >= 0) {
                                                    this.pos = tempPos;
                                                    return y;
                                                }
                                                if (this.bufferSize - tempPos < 9) break block4;
                                                if ((y ^= buffer[tempPos++] << 7) >= 0) break block5;
                                                x32 = y ^ 0xFFFFFF80;
                                                break block6;
                                            }
                                            if ((x32 ^= buffer[tempPos++] << 14) < 0) break block7;
                                            x32 = x32 ^ 0x3F80;
                                            break block6;
                                        }
                                        if ((x32 ^= buffer[tempPos++] << 21) >= 0) break block8;
                                        x32 = x32 ^ 0xFFE03F80;
                                        break block6;
                                    }
                                    if ((x32 = (long)x32 ^ (long)buffer[tempPos++] << 28) < 0L) break block9;
                                    x32 ^= 0xFE03F80L;
                                    break block6;
                                }
                                if ((x32 ^= (long)buffer[tempPos++] << 35) >= 0L) break block10;
                                x32 ^= 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((x32 ^= (long)buffer[tempPos++] << 42) < 0L) break block11;
                            x32 ^= 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((x32 ^= (long)buffer[tempPos++] << 49) >= 0L) break block12;
                        x32 ^= 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    x32 ^= (long)buffer[tempPos++] << 56;
                    if ((x32 ^= 0xFE03F80FE03F80L) < 0L && (long)var2_2[tempPos++] < 0L) break block4;
                }
                this.pos = var1_1;
                return (long)var3_4;
            }
            return this.readRawVarint64SlowPath();
        }

        @Override
        final long readRawVarint64SlowPath() throws IOException {
            long result = 0L;
            for (int shift = 0; shift < 64; shift += 7) {
                byte b = this.readRawByte();
                result |= (long)(b & 0x7F) << shift;
                if ((b & 0x80) != 0) continue;
                return result;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        /*
         * WARNING - void declaration
         */
        private int readRawLittleEndian32() throws IOException {
            void var1_1;
            void var2_2;
            int tempPos = this.pos;
            if (this.bufferSize - tempPos < 4) {
                this.refillBuffer(4);
                tempPos = this.pos;
            }
            byte[] buffer = this.buffer;
            this.pos = tempPos + 4;
            return buffer[tempPos] & 0xFF | (buffer[tempPos + 1] & 0xFF) << 8 | (buffer[tempPos + 2] & 0xFF) << 16 | (var2_2[var1_1 + 3] & 0xFF) << 24;
        }

        /*
         * WARNING - void declaration
         */
        private long readRawLittleEndian64() throws IOException {
            void var1_1;
            void var2_2;
            int tempPos = this.pos;
            if (this.bufferSize - tempPos < 8) {
                this.refillBuffer(8);
                tempPos = this.pos;
            }
            byte[] buffer = this.buffer;
            this.pos = tempPos + 8;
            return (long)buffer[tempPos] & 0xFFL | ((long)buffer[tempPos + 1] & 0xFFL) << 8 | ((long)buffer[tempPos + 2] & 0xFFL) << 16 | ((long)buffer[tempPos + 3] & 0xFFL) << 24 | ((long)buffer[tempPos + 4] & 0xFFL) << 32 | ((long)buffer[tempPos + 5] & 0xFFL) << 40 | ((long)buffer[tempPos + 6] & 0xFFL) << 48 | ((long)var2_2[var1_1 + 7] & 0xFFL) << 56;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int pushLimit(int byteLimit) throws InvalidProtocolBufferException {
            void var2_2;
            void var1_1;
            if (byteLimit < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            int oldLimit = this.currentLimit;
            if ((byteLimit += this.totalBytesRetired + this.pos) > oldLimit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = var1_1;
            this.recomputeBufferSizeAfterLimit();
            return (int)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private void recomputeBufferSizeAfterLimit() {
            this.bufferSize += this.bufferSizeAfterLimit;
            int bufferEnd = this.totalBytesRetired + this.bufferSize;
            if (bufferEnd > this.currentLimit) {
                void var1_1;
                this.bufferSizeAfterLimit = var1_1 - this.currentLimit;
                this.bufferSize -= this.bufferSizeAfterLimit;
                return;
            }
            this.bufferSizeAfterLimit = 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void popLimit(int oldLimit) {
            void var1_1;
            this.currentLimit = var1_1;
            this.recomputeBufferSizeAfterLimit();
        }

        @Override
        public final boolean isAtEnd() throws IOException {
            return this.pos == this.bufferSize && !this.tryRefillBuffer(1);
        }

        @Override
        public final int getTotalBytesRead() {
            return this.totalBytesRetired + this.pos;
        }

        /*
         * WARNING - void declaration
         */
        private void refillBuffer(int n) throws IOException {
            if (!this.tryRefillBuffer(n)) {
                void var1_1;
                if (var1_1 > this.sizeLimit - this.totalBytesRetired - this.pos) {
                    throw InvalidProtocolBufferException.sizeLimitExceeded();
                }
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }

        /*
         * WARNING - void declaration
         */
        private boolean tryRefillBuffer(int n) throws IOException {
            while (true) {
                void var2_2;
                int bytesRead;
                if (this.pos + n <= this.bufferSize) {
                    throw new IllegalStateException("refillBuffer() called when " + n + " bytes were already available in buffer");
                }
                if (n > this.sizeLimit - this.totalBytesRetired - this.pos) {
                    return false;
                }
                if (this.totalBytesRetired + this.pos + n > this.currentLimit) {
                    return false;
                }
                int tempPos = this.pos;
                if (tempPos > 0) {
                    if (this.bufferSize > tempPos) {
                        System.arraycopy(this.buffer, tempPos, this.buffer, 0, this.bufferSize - tempPos);
                    }
                    this.totalBytesRetired += tempPos;
                    this.bufferSize -= tempPos;
                    this.pos = 0;
                }
                if ((bytesRead = StreamDecoder.read(this.input, this.buffer, this.bufferSize, Math.min(this.buffer.length - this.bufferSize, this.sizeLimit - this.totalBytesRetired - this.bufferSize))) == 0 || bytesRead < -1 || bytesRead > this.buffer.length) {
                    throw new IllegalStateException(this.input.getClass() + "#read(byte[]) returned invalid result: " + bytesRead + "\nThe InputStream implementation is buggy.");
                }
                if (bytesRead <= 0) break;
                this.bufferSize += var2_2;
                this.recomputeBufferSizeAfterLimit();
                if (this.bufferSize < n) continue;
                return true;
            }
            return false;
        }

        private byte readRawByte() throws IOException {
            if (this.pos == this.bufferSize) {
                this.refillBuffer(1);
            }
            return this.buffer[this.pos++];
        }

        /*
         * WARNING - void declaration
         */
        private byte[] readRawBytesSlowPath(int size, boolean ensureNoLeakedReferences) throws IOException {
            void var1_2;
            void var3_6;
            byte[] result = this.readRawBytesSlowPathOneChunk(size);
            if (result != null) {
                return result;
            }
            int originalBufferPos = this.pos;
            int bufferedBytes = this.bufferSize - this.pos;
            this.totalBytesRetired += this.bufferSize;
            this.pos = 0;
            this.bufferSize = 0;
            int sizeLeft = size - bufferedBytes;
            List<byte[]> chunks = this.readRawBytesSlowPathRemainingChunks(sizeLeft);
            byte[] bytes = new byte[size];
            System.arraycopy(this.buffer, originalBufferPos, bytes, 0, bufferedBytes);
            void tempPos = var3_6;
            for (byte[] chunk : chunks) {
                System.arraycopy(chunk, 0, bytes, (int)tempPos, chunk.length);
                tempPos += chunk.length;
            }
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        private byte[] readRawBytesSlowPathOneChunk(int size) throws IOException {
            if (size == 0) {
                return Internal.EMPTY_BYTE_ARRAY;
            }
            if (size < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            int currentMessageSize = this.totalBytesRetired + this.pos + size;
            if (currentMessageSize - this.sizeLimit > 0) {
                throw InvalidProtocolBufferException.sizeLimitExceeded();
            }
            if (currentMessageSize > this.currentLimit) {
                StreamDecoder streamDecoder = this;
                streamDecoder.skipRawBytes(streamDecoder.currentLimit - this.totalBytesRetired - this.pos);
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            int bufferedBytes = this.bufferSize - this.pos;
            int sizeLeft = size - bufferedBytes;
            if (sizeLeft < 4096 || sizeLeft <= StreamDecoder.available(this.input)) {
                void var3_4;
                void tempPos;
                byte[] bytes = new byte[size];
                System.arraycopy(this.buffer, this.pos, bytes, 0, bufferedBytes);
                this.totalBytesRetired += this.bufferSize;
                this.pos = 0;
                this.bufferSize = 0;
                while (tempPos < bytes.length) {
                    int n = StreamDecoder.read(this.input, bytes, (int)tempPos, size - tempPos);
                    if (n == -1) {
                        throw InvalidProtocolBufferException.truncatedMessage();
                    }
                    this.totalBytesRetired += n;
                    tempPos += n;
                }
                return var3_4;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private List<byte[]> readRawBytesSlowPathRemainingChunks(int sizeLeft) throws IOException {
            void var2_2;
            ArrayList<void> chunks = new ArrayList<void>();
            while (sizeLeft > 0) {
                void var3_3;
                int n;
                byte[] chunk = new byte[Math.min(sizeLeft, 4096)];
                for (int tempPos = 0; tempPos < chunk.length; tempPos += n) {
                    n = this.input.read(chunk, tempPos, chunk.length - tempPos);
                    if (n == -1) {
                        throw InvalidProtocolBufferException.truncatedMessage();
                    }
                    this.totalBytesRetired += n;
                }
                sizeLeft -= chunk.length;
                chunks.add(var3_3);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private void skipRawBytes(int size) throws IOException {
            void var1_1;
            if (size <= this.bufferSize - this.pos && size >= 0) {
                this.pos += size;
                return;
            }
            this.skipRawBytesSlowPath((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void skipRawBytesSlowPath(int size) throws IOException {
            void var2_3;
            if (size < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (this.totalBytesRetired + this.pos + size > this.currentLimit) {
                StreamDecoder streamDecoder = this;
                streamDecoder.skipRawBytes(streamDecoder.currentLimit - this.totalBytesRetired - this.pos);
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            int totalSkipped = 0;
            if (this.refillCallback == null) {
                this.totalBytesRetired += this.pos;
                this.bufferSize = 0;
                this.pos = 0;
                try {
                    long skipped;
                    for (totalSkipped = this.bufferSize - this.pos; totalSkipped < size; totalSkipped += (int)skipped) {
                        int toSkip = size - totalSkipped;
                        skipped = StreamDecoder.skip(this.input, toSkip);
                        if (skipped < 0L || skipped > (long)toSkip) {
                            throw new IllegalStateException(this.input.getClass() + "#skip returned invalid result: " + skipped + "\nThe InputStream implementation is buggy.");
                        }
                        if (skipped != 0L) {
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    this.totalBytesRetired += totalSkipped;
                    this.recomputeBufferSizeAfterLimit();
                }
            }
            if (var2_3 < size) {
                void var3_4;
                void var1_1;
                int tempPos = this.bufferSize - this.pos;
                this.pos = this.bufferSize;
                this.refillBuffer(1);
                while (size - tempPos > this.bufferSize) {
                    tempPos += this.bufferSize;
                    this.pos = this.bufferSize;
                    this.refillBuffer(1);
                }
                this.pos = var1_1 - var3_4;
            }
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ StreamDecoder(InputStream x0, int x1, byte by) {
            this((InputStream)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        static interface RefillCallback {
        }
    }

    static final class ArrayDecoder
    extends CodedInputStream {
        private final byte[] buffer;
        private final boolean immutable;
        private int limit;
        private int bufferSizeAfterLimit;
        private int pos;
        private int startPos;
        private int lastTag;
        private int currentLimit = Integer.MAX_VALUE;

        /*
         * WARNING - void declaration
         */
        private ArrayDecoder(byte[] buffer, int offset, int len, boolean immutable) {
            super((byte)0);
            void var2_2;
            void var3_3;
            void var1_1;
            this.buffer = var1_1;
            this.limit = offset + var3_3;
            this.startPos = this.pos = var2_2;
            this.immutable = immutable;
        }

        @Override
        public final int readTag() throws IOException {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            this.lastTag = this.readRawVarint32();
            if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void checkLastTagWas(int value) throws InvalidProtocolBufferException {
            void var1_1;
            if (this.lastTag != var1_1) {
                throw InvalidProtocolBufferException.invalidEndTag();
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final boolean skipField(int tag) throws IOException {
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    ArrayDecoder arrayDecoder = this;
                    if (arrayDecoder.limit - arrayDecoder.pos >= 10) {
                        ArrayDecoder arrayDecoder2 = arrayDecoder;
                        for (tag = 0; tag < 10; ++tag) {
                            if (arrayDecoder2.buffer[arrayDecoder2.pos++] >= 0) return true;
                        }
                        throw InvalidProtocolBufferException.malformedVarint();
                    }
                    ArrayDecoder arrayDecoder3 = arrayDecoder;
                    for (tag = 0; tag < 10; ++tag) {
                        if (arrayDecoder3.readRawByte() >= 0) return true;
                    }
                    throw InvalidProtocolBufferException.malformedVarint();
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    ArrayDecoder arrayDecoder = this;
                    arrayDecoder.skipRawBytes(arrayDecoder.readRawVarint32());
                    return true;
                }
                case 3: {
                    void var1_1;
                    int n;
                    ArrayDecoder arrayDecoder = this;
                    while ((n = arrayDecoder.readTag()) != 0 && arrayDecoder.skipField(n)) {
                    }
                    this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber((int)var1_1), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public final double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readRawLittleEndian64());
        }

        @Override
        public final float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readRawLittleEndian32());
        }

        @Override
        public final long readUInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final long readInt64() throws IOException {
            return this.readRawVarint64();
        }

        @Override
        public final int readInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public final long readFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final boolean readBool() throws IOException {
            return this.readRawVarint64() != 0L;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String readString() throws IOException {
            void var1_1;
            int size = this.readRawVarint32();
            if (size > 0 && size <= this.limit - this.pos) {
                void var2_2;
                String result = new String(this.buffer, this.pos, size, Internal.UTF_8);
                this.pos += size;
                return var2_2;
            }
            if (size == 0) {
                return "";
            }
            if (var1_1 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String readStringRequireUtf8() throws IOException {
            void var1_1;
            int size = this.readRawVarint32();
            if (size > 0 && size <= this.limit - this.pos) {
                void var2_2;
                String result = Utf8.decodeUtf8(this.buffer, this.pos, size);
                this.pos += size;
                return var2_2;
            }
            if (size == 0) {
                return "";
            }
            if (var1_1 <= 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final ByteString readBytes() throws IOException {
            byte[] byArray;
            void var1_1;
            int size = this.readRawVarint32();
            if (size > 0 && size <= this.limit - this.pos) {
                void var2_3;
                ByteString result = ByteString.copyFrom(this.buffer, this.pos, size);
                this.pos += size;
                return var2_3;
            }
            if (size == 0) {
                return ByteString.EMPTY;
            }
            void var2_4 = var1_1;
            ArrayDecoder arrayDecoder = this;
            if (var2_4 > 0 && var2_4 <= arrayDecoder.limit - arrayDecoder.pos) {
                int n = arrayDecoder.pos;
                arrayDecoder.pos += var2_4;
                byArray = Arrays.copyOfRange(arrayDecoder.buffer, n, arrayDecoder.pos);
                return ByteString.wrap(byArray);
            } else {
                if (var2_4 > 0) throw InvalidProtocolBufferException.truncatedMessage();
                if (var2_4 != false) throw InvalidProtocolBufferException.negativeSize();
                byArray = Internal.EMPTY_BYTE_ARRAY;
            }
            return ByteString.wrap(byArray);
        }

        @Override
        public final int readUInt32() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public final int readEnum() throws IOException {
            return this.readRawVarint32();
        }

        @Override
        public final int readSFixed32() throws IOException {
            return this.readRawLittleEndian32();
        }

        @Override
        public final long readSFixed64() throws IOException {
            return this.readRawLittleEndian64();
        }

        @Override
        public final int readSInt32() throws IOException {
            return ArrayDecoder.decodeZigZag32(this.readRawVarint32());
        }

        @Override
        public final long readSInt64() throws IOException {
            return ArrayDecoder.decodeZigZag64(this.readRawVarint64());
        }

        /*
         * WARNING - void declaration
         */
        private int readRawVarint32() throws IOException {
            block4: {
                void var3_3;
                void var1_1;
                block6: {
                    void var2_2;
                    byte[] buffer;
                    int tempPos;
                    block8: {
                        block7: {
                            block5: {
                                int x;
                                tempPos = this.pos;
                                if (this.limit == tempPos) break block4;
                                buffer = this.buffer;
                                if ((x = this.buffer[tempPos++]) >= 0) {
                                    this.pos = tempPos;
                                    return x;
                                }
                                if (this.limit - tempPos < 9) break block4;
                                if ((x ^= buffer[tempPos++] << 7) >= 0) break block5;
                                x ^= 0xFFFFFF80;
                                break block6;
                            }
                            if ((x ^= buffer[tempPos++] << 14) < 0) break block7;
                            x ^= 0x3F80;
                            break block6;
                        }
                        if ((x ^= buffer[tempPos++] << 21) >= 0) break block8;
                        x ^= 0xFFE03F80;
                        break block6;
                    }
                    byte y = buffer[tempPos++];
                    x ^= y << 28;
                    x ^= 0xFE03F80;
                    if (y < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && var2_2[tempPos++] < 0) break block4;
                }
                this.pos = var1_1;
                return (int)var3_3;
            }
            return (int)this.readRawVarint64SlowPath();
        }

        /*
         * WARNING - void declaration
         */
        private long readRawVarint64() throws IOException {
            block4: {
                void var3_4;
                void var1_1;
                block6: {
                    void var2_2;
                    byte[] buffer;
                    int tempPos;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    long x32;
                                    block8: {
                                        int x32;
                                        block7: {
                                            block5: {
                                                int y;
                                                tempPos = this.pos;
                                                if (this.limit == tempPos) break block4;
                                                buffer = this.buffer;
                                                if ((y = this.buffer[tempPos++]) >= 0) {
                                                    this.pos = tempPos;
                                                    return y;
                                                }
                                                if (this.limit - tempPos < 9) break block4;
                                                if ((y ^= buffer[tempPos++] << 7) >= 0) break block5;
                                                x32 = y ^ 0xFFFFFF80;
                                                break block6;
                                            }
                                            if ((x32 ^= buffer[tempPos++] << 14) < 0) break block7;
                                            x32 = x32 ^ 0x3F80;
                                            break block6;
                                        }
                                        if ((x32 ^= buffer[tempPos++] << 21) >= 0) break block8;
                                        x32 = x32 ^ 0xFFE03F80;
                                        break block6;
                                    }
                                    if ((x32 = (long)x32 ^ (long)buffer[tempPos++] << 28) < 0L) break block9;
                                    x32 ^= 0xFE03F80L;
                                    break block6;
                                }
                                if ((x32 ^= (long)buffer[tempPos++] << 35) >= 0L) break block10;
                                x32 ^= 0xFFFFFFF80FE03F80L;
                                break block6;
                            }
                            if ((x32 ^= (long)buffer[tempPos++] << 42) < 0L) break block11;
                            x32 ^= 0x3F80FE03F80L;
                            break block6;
                        }
                        if ((x32 ^= (long)buffer[tempPos++] << 49) >= 0L) break block12;
                        x32 ^= 0xFFFE03F80FE03F80L;
                        break block6;
                    }
                    x32 ^= (long)buffer[tempPos++] << 56;
                    if ((x32 ^= 0xFE03F80FE03F80L) < 0L && (long)var2_2[tempPos++] < 0L) break block4;
                }
                this.pos = var1_1;
                return (long)var3_4;
            }
            return this.readRawVarint64SlowPath();
        }

        @Override
        final long readRawVarint64SlowPath() throws IOException {
            long result = 0L;
            for (int shift = 0; shift < 64; shift += 7) {
                byte b = this.readRawByte();
                result |= (long)(b & 0x7F) << shift;
                if ((b & 0x80) != 0) continue;
                return result;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        /*
         * WARNING - void declaration
         */
        private int readRawLittleEndian32() throws IOException {
            void var1_1;
            void var2_2;
            int tempPos = this.pos;
            if (this.limit - tempPos < 4) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] buffer = this.buffer;
            this.pos = tempPos + 4;
            return buffer[tempPos] & 0xFF | (buffer[tempPos + 1] & 0xFF) << 8 | (buffer[tempPos + 2] & 0xFF) << 16 | (var2_2[var1_1 + 3] & 0xFF) << 24;
        }

        /*
         * WARNING - void declaration
         */
        private long readRawLittleEndian64() throws IOException {
            void var1_1;
            void var2_2;
            int tempPos = this.pos;
            if (this.limit - tempPos < 8) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] buffer = this.buffer;
            this.pos = tempPos + 8;
            return (long)buffer[tempPos] & 0xFFL | ((long)buffer[tempPos + 1] & 0xFFL) << 8 | ((long)buffer[tempPos + 2] & 0xFFL) << 16 | ((long)buffer[tempPos + 3] & 0xFFL) << 24 | ((long)buffer[tempPos + 4] & 0xFFL) << 32 | ((long)buffer[tempPos + 5] & 0xFFL) << 40 | ((long)buffer[tempPos + 6] & 0xFFL) << 48 | ((long)var2_2[var1_1 + 7] & 0xFFL) << 56;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int pushLimit(int byteLimit) throws InvalidProtocolBufferException {
            void var2_2;
            void var1_1;
            if (byteLimit < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if ((byteLimit += this.getTotalBytesRead()) < 0) {
                throw InvalidProtocolBufferException.parseFailure();
            }
            int oldLimit = this.currentLimit;
            if (byteLimit > oldLimit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            this.currentLimit = var1_1;
            this.recomputeBufferSizeAfterLimit();
            return (int)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private void recomputeBufferSizeAfterLimit() {
            this.limit += this.bufferSizeAfterLimit;
            int bufferEnd = this.limit - this.startPos;
            if (bufferEnd > this.currentLimit) {
                void var1_1;
                this.bufferSizeAfterLimit = var1_1 - this.currentLimit;
                this.limit -= this.bufferSizeAfterLimit;
                return;
            }
            this.bufferSizeAfterLimit = 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void popLimit(int oldLimit) {
            void var1_1;
            this.currentLimit = var1_1;
            this.recomputeBufferSizeAfterLimit();
        }

        @Override
        public final boolean isAtEnd() throws IOException {
            return this.pos == this.limit;
        }

        @Override
        public final int getTotalBytesRead() {
            return this.pos - this.startPos;
        }

        private byte readRawByte() throws IOException {
            if (this.pos == this.limit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return this.buffer[this.pos++];
        }

        /*
         * WARNING - void declaration
         */
        private void skipRawBytes(int length) throws IOException {
            void var1_1;
            if (length >= 0 && length <= this.limit - this.pos) {
                this.pos += length;
                return;
            }
            if (var1_1 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ArrayDecoder(byte[] x0, int x1, int x2, boolean x3, byte by) {
            this((byte[])var1_1, (int)var2_2, (int)var3_3, x3);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }
}

