/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.BooleanArrayList;
import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CodedInputStream;
import androidx.datastore.preferences.protobuf.DoubleArrayList;
import androidx.datastore.preferences.protobuf.ExtensionRegistryLite;
import androidx.datastore.preferences.protobuf.FloatArrayList;
import androidx.datastore.preferences.protobuf.IntArrayList;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.InvalidProtocolBufferException;
import androidx.datastore.preferences.protobuf.LazyStringList;
import androidx.datastore.preferences.protobuf.LongArrayList;
import androidx.datastore.preferences.protobuf.MapEntryLite;
import androidx.datastore.preferences.protobuf.Protobuf;
import androidx.datastore.preferences.protobuf.Reader;
import androidx.datastore.preferences.protobuf.Schema;
import androidx.datastore.preferences.protobuf.WireFormat;
import java.io.IOException;
import java.util.List;
import java.util.Map;

final class CodedInputStreamReader
implements Reader {
    private final CodedInputStream input;
    private int tag;
    private int endGroupTag;
    private int nextTag = 0;

    public static CodedInputStreamReader forCodedInput(CodedInputStream input) {
        CodedInputStream codedInputStream;
        if (input.wrapper != null) {
            return input.wrapper;
        }
        return new CodedInputStreamReader(codedInputStream);
    }

    /*
     * WARNING - void declaration
     */
    private CodedInputStreamReader(CodedInputStream input) {
        void var1_1;
        this.input = (CodedInputStream)Internal.checkNotNull(var1_1, "input");
        this.input.wrapper = this;
    }

    @Override
    public final int getFieldNumber() throws IOException {
        if (this.nextTag != 0) {
            this.tag = this.nextTag;
            this.nextTag = 0;
        } else {
            this.tag = this.input.readTag();
        }
        if (this.tag == 0 || this.tag == this.endGroupTag) {
            return Integer.MAX_VALUE;
        }
        return WireFormat.getTagFieldNumber(this.tag);
    }

    @Override
    public final int getTag() {
        return this.tag;
    }

    @Override
    public final boolean skipField() throws IOException {
        if (this.input.isAtEnd() || this.tag == this.endGroupTag) {
            return false;
        }
        return this.input.skipField(this.tag);
    }

    /*
     * WARNING - void declaration
     */
    private void requireWireType(int requiredWireType) throws IOException {
        void var1_1;
        if (WireFormat.getTagWireType(this.tag) != var1_1) {
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    @Override
    public final double readDouble() throws IOException {
        this.requireWireType(1);
        return this.input.readDouble();
    }

    @Override
    public final float readFloat() throws IOException {
        this.requireWireType(5);
        return this.input.readFloat();
    }

    @Override
    public final long readUInt64() throws IOException {
        this.requireWireType(0);
        return this.input.readUInt64();
    }

    @Override
    public final long readInt64() throws IOException {
        this.requireWireType(0);
        return this.input.readInt64();
    }

    @Override
    public final int readInt32() throws IOException {
        this.requireWireType(0);
        return this.input.readInt32();
    }

    @Override
    public final long readFixed64() throws IOException {
        this.requireWireType(1);
        return this.input.readFixed64();
    }

    @Override
    public final int readFixed32() throws IOException {
        this.requireWireType(5);
        return this.input.readFixed32();
    }

    @Override
    public final boolean readBool() throws IOException {
        this.requireWireType(0);
        return this.input.readBool();
    }

    @Override
    public final String readString() throws IOException {
        this.requireWireType(2);
        return this.input.readString();
    }

    @Override
    public final String readStringRequireUtf8() throws IOException {
        this.requireWireType(2);
        return this.input.readStringRequireUtf8();
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T readMessage(Class<T> clazz, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var2_2;
        void var1_1;
        this.requireWireType(2);
        return this.readMessage(Protobuf.getInstance().schemaFor(var1_1), (ExtensionRegistryLite)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> void mergeMessageField(T target, Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.requireWireType(2);
        this.mergeMessageFieldInternal(var1_1, (Schema<T>)var2_2, (ExtensionRegistryLite)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private <T> void mergeMessageFieldInternal(T target, Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        int size = this.input.readUInt32();
        if (this.input.recursionDepth >= this.input.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        int prevLimit = this.input.pushLimit(size);
        ++this.input.recursionDepth;
        var2_2.mergeFrom(var1_1, this, (ExtensionRegistryLite)var3_3);
        this.input.checkLastTagWas(0);
        --this.input.recursionDepth;
        this.input.popLimit(prevLimit);
    }

    /*
     * WARNING - void declaration
     */
    private <T> T readMessage(Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        T newInstance = schema.newInstance();
        this.mergeMessageFieldInternal(newInstance, schema, (ExtensionRegistryLite)var2_2);
        var1_1.makeImmutable(newInstance);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> void mergeGroupField(T target, Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.requireWireType(3);
        this.mergeGroupFieldInternal(var1_1, (Schema<T>)var2_2, (ExtensionRegistryLite)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private <T> void mergeGroupFieldInternal(T target, Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
        int prevEndGroupTag = this.endGroupTag;
        this.endGroupTag = WireFormat.makeTag(WireFormat.getTagFieldNumber(this.tag), 4);
        try {
            void var3_4;
            void var1_1;
            void var2_3;
            var2_3.mergeFrom(var1_1, this, (ExtensionRegistryLite)var3_4);
            if (this.tag != this.endGroupTag) {
                throw InvalidProtocolBufferException.parseFailure();
            }
            return;
        }
        finally {
            this.endGroupTag = prevEndGroupTag;
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> T readGroup(Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        T newInstance = schema.newInstance();
        this.mergeGroupFieldInternal(newInstance, schema, (ExtensionRegistryLite)var2_2);
        var1_1.makeImmutable(newInstance);
        return var3_3;
    }

    @Override
    public final ByteString readBytes() throws IOException {
        this.requireWireType(2);
        return this.input.readBytes();
    }

    @Override
    public final int readUInt32() throws IOException {
        this.requireWireType(0);
        return this.input.readUInt32();
    }

    @Override
    public final int readEnum() throws IOException {
        this.requireWireType(0);
        return this.input.readEnum();
    }

    @Override
    public final int readSFixed32() throws IOException {
        this.requireWireType(5);
        return this.input.readSFixed32();
    }

    @Override
    public final long readSFixed64() throws IOException {
        this.requireWireType(1);
        return this.input.readSFixed64();
    }

    @Override
    public final int readSInt32() throws IOException {
        this.requireWireType(0);
        return this.input.readSInt32();
    }

    @Override
    public final long readSInt64() throws IOException {
        this.requireWireType(0);
        return this.input.readSInt64();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readDoubleList(List<Double> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof DoubleArrayList)) break block12;
                DoubleArrayList plist = (DoubleArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.input.readUInt32();
                        CodedInputStreamReader.verifyPackedFixed64Length(bytes);
                        int endPos = this.input.getTotalBytesRead() + bytes;
                        do {
                            plist.addDouble(this.input.readDouble());
                        } while (this.input.getTotalBytesRead() < endPos);
                        break block13;
                    }
                    case 1: {
                        void var1_2;
                        int nextTag;
                        do {
                            plist.addDouble(this.input.readDouble());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((nextTag = this.input.readTag()) == this.tag);
                        this.nextTag = var1_2;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var1_1;
                    void var2_4;
                    int bytes = this.input.readUInt32();
                    CodedInputStreamReader.verifyPackedFixed64Length(bytes);
                    int endPos = this.input.getTotalBytesRead() + var2_4;
                    do {
                        var1_1.add(this.input.readDouble());
                    } while (this.input.getTotalBytesRead() < endPos);
                    return;
                }
                case 1: {
                    void var3_7;
                    int nextTag;
                    void var1_1;
                    do {
                        var1_1.add(this.input.readDouble());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((nextTag = this.input.readTag()) == this.tag);
                    this.nextTag = var3_7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readFloatList(List<Float> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof FloatArrayList)) break block12;
                FloatArrayList plist = (FloatArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.input.readUInt32();
                        CodedInputStreamReader.verifyPackedFixed32Length(bytes);
                        int endPos = this.input.getTotalBytesRead() + bytes;
                        do {
                            plist.addFloat(this.input.readFloat());
                        } while (this.input.getTotalBytesRead() < endPos);
                        break block13;
                    }
                    case 5: {
                        void var1_2;
                        int nextTag;
                        do {
                            plist.addFloat(this.input.readFloat());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((nextTag = this.input.readTag()) == this.tag);
                        this.nextTag = var1_2;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var1_1;
                    void var2_4;
                    int bytes = this.input.readUInt32();
                    CodedInputStreamReader.verifyPackedFixed32Length(bytes);
                    int endPos = this.input.getTotalBytesRead() + var2_4;
                    do {
                        var1_1.add(Float.valueOf(this.input.readFloat()));
                    } while (this.input.getTotalBytesRead() < endPos);
                    return;
                }
                case 5: {
                    void var3_7;
                    int nextTag;
                    void var1_1;
                    do {
                        var1_1.add(Float.valueOf(this.input.readFloat()));
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((nextTag = this.input.readTag()) == this.tag);
                    this.nextTag = var3_7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readUInt64List(List<Long> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof LongArrayList)) break block12;
                LongArrayList plist = (LongArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.input.readUInt32();
                        int endPos = this.input.getTotalBytesRead() + bytes;
                        do {
                            plist.addLong(this.input.readUInt64());
                        } while (this.input.getTotalBytesRead() < endPos);
                        this.requirePosition(endPos);
                        break block13;
                    }
                    case 0: {
                        void var1_2;
                        int nextTag;
                        do {
                            plist.addLong(this.input.readUInt64());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((nextTag = this.input.readTag()) == this.tag);
                        this.nextTag = var1_2;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var1_1;
                    void var2_4;
                    int bytes = this.input.readUInt32();
                    int endPos = this.input.getTotalBytesRead() + var2_4;
                    do {
                        var1_1.add(this.input.readUInt64());
                    } while (this.input.getTotalBytesRead() < endPos);
                    this.requirePosition(endPos);
                    return;
                }
                case 0: {
                    void var3_7;
                    int nextTag;
                    void var1_1;
                    do {
                        var1_1.add(this.input.readUInt64());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((nextTag = this.input.readTag()) == this.tag);
                    this.nextTag = var3_7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readInt64List(List<Long> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof LongArrayList)) break block12;
                LongArrayList plist = (LongArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.input.readUInt32();
                        int endPos = this.input.getTotalBytesRead() + bytes;
                        do {
                            plist.addLong(this.input.readInt64());
                        } while (this.input.getTotalBytesRead() < endPos);
                        this.requirePosition(endPos);
                        break block13;
                    }
                    case 0: {
                        void var1_2;
                        int nextTag;
                        do {
                            plist.addLong(this.input.readInt64());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((nextTag = this.input.readTag()) == this.tag);
                        this.nextTag = var1_2;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var1_1;
                    void var2_4;
                    int bytes = this.input.readUInt32();
                    int endPos = this.input.getTotalBytesRead() + var2_4;
                    do {
                        var1_1.add(this.input.readInt64());
                    } while (this.input.getTotalBytesRead() < endPos);
                    this.requirePosition(endPos);
                    return;
                }
                case 0: {
                    void var3_7;
                    int nextTag;
                    void var1_1;
                    do {
                        var1_1.add(this.input.readInt64());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((nextTag = this.input.readTag()) == this.tag);
                    this.nextTag = var3_7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readInt32List(List<Integer> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof IntArrayList)) break block12;
                IntArrayList plist = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.input.readUInt32();
                        int endPos = this.input.getTotalBytesRead() + bytes;
                        do {
                            plist.addInt(this.input.readInt32());
                        } while (this.input.getTotalBytesRead() < endPos);
                        this.requirePosition(endPos);
                        break block13;
                    }
                    case 0: {
                        void var1_2;
                        int nextTag;
                        do {
                            plist.addInt(this.input.readInt32());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((nextTag = this.input.readTag()) == this.tag);
                        this.nextTag = var1_2;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var1_1;
                    void var2_4;
                    int bytes = this.input.readUInt32();
                    int endPos = this.input.getTotalBytesRead() + var2_4;
                    do {
                        var1_1.add(this.input.readInt32());
                    } while (this.input.getTotalBytesRead() < endPos);
                    this.requirePosition(endPos);
                    return;
                }
                case 0: {
                    void var3_7;
                    int nextTag;
                    void var1_1;
                    do {
                        var1_1.add(this.input.readInt32());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((nextTag = this.input.readTag()) == this.tag);
                    this.nextTag = var3_7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readFixed64List(List<Long> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof LongArrayList)) break block12;
                LongArrayList plist = (LongArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.input.readUInt32();
                        CodedInputStreamReader.verifyPackedFixed64Length(bytes);
                        int endPos = this.input.getTotalBytesRead() + bytes;
                        do {
                            plist.addLong(this.input.readFixed64());
                        } while (this.input.getTotalBytesRead() < endPos);
                        break block13;
                    }
                    case 1: {
                        void var1_2;
                        int nextTag;
                        do {
                            plist.addLong(this.input.readFixed64());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((nextTag = this.input.readTag()) == this.tag);
                        this.nextTag = var1_2;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var1_1;
                    void var2_4;
                    int bytes = this.input.readUInt32();
                    CodedInputStreamReader.verifyPackedFixed64Length(bytes);
                    int endPos = this.input.getTotalBytesRead() + var2_4;
                    do {
                        var1_1.add(this.input.readFixed64());
                    } while (this.input.getTotalBytesRead() < endPos);
                    return;
                }
                case 1: {
                    void var3_7;
                    int nextTag;
                    void var1_1;
                    do {
                        var1_1.add(this.input.readFixed64());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((nextTag = this.input.readTag()) == this.tag);
                    this.nextTag = var3_7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readFixed32List(List<Integer> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof IntArrayList)) break block12;
                IntArrayList plist = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.input.readUInt32();
                        CodedInputStreamReader.verifyPackedFixed32Length(bytes);
                        int endPos = this.input.getTotalBytesRead() + bytes;
                        do {
                            plist.addInt(this.input.readFixed32());
                        } while (this.input.getTotalBytesRead() < endPos);
                        break block13;
                    }
                    case 5: {
                        void var1_2;
                        int nextTag;
                        do {
                            plist.addInt(this.input.readFixed32());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((nextTag = this.input.readTag()) == this.tag);
                        this.nextTag = var1_2;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var1_1;
                    void var2_4;
                    int bytes = this.input.readUInt32();
                    CodedInputStreamReader.verifyPackedFixed32Length(bytes);
                    int endPos = this.input.getTotalBytesRead() + var2_4;
                    do {
                        var1_1.add(this.input.readFixed32());
                    } while (this.input.getTotalBytesRead() < endPos);
                    return;
                }
                case 5: {
                    void var3_7;
                    int nextTag;
                    void var1_1;
                    do {
                        var1_1.add(this.input.readFixed32());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((nextTag = this.input.readTag()) == this.tag);
                    this.nextTag = var3_7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readBoolList(List<Boolean> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof BooleanArrayList)) break block12;
                BooleanArrayList plist = (BooleanArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.input.readUInt32();
                        int endPos = this.input.getTotalBytesRead() + bytes;
                        do {
                            plist.addBoolean(this.input.readBool());
                        } while (this.input.getTotalBytesRead() < endPos);
                        this.requirePosition(endPos);
                        break block13;
                    }
                    case 0: {
                        void var1_2;
                        int nextTag;
                        do {
                            plist.addBoolean(this.input.readBool());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((nextTag = this.input.readTag()) == this.tag);
                        this.nextTag = var1_2;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var1_1;
                    void var2_4;
                    int bytes = this.input.readUInt32();
                    int endPos = this.input.getTotalBytesRead() + var2_4;
                    do {
                        var1_1.add(this.input.readBool());
                    } while (this.input.getTotalBytesRead() < endPos);
                    this.requirePosition(endPos);
                    return;
                }
                case 0: {
                    void var3_7;
                    int nextTag;
                    void var1_1;
                    do {
                        var1_1.add(this.input.readBool());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((nextTag = this.input.readTag()) == this.tag);
                    this.nextTag = var3_7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readStringList(List<String> target) throws IOException {
        void var1_1;
        this.readStringListInternal((List<String>)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readStringListRequireUtf8(List<String> target) throws IOException {
        void var1_1;
        this.readStringListInternal((List<String>)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    private void readStringListInternal(List<String> target, boolean requireUtf8) throws IOException {
        void var3_5;
        int nextTag;
        if (WireFormat.getTagWireType(this.tag) != 2) {
            throw InvalidProtocolBufferException.invalidWireType();
        }
        if (target instanceof LazyStringList && !requireUtf8) {
            void var1_2;
            int nextTag2;
            LazyStringList lazyList = (LazyStringList)target;
            do {
                lazyList.add(this.readBytes());
                if (!this.input.isAtEnd()) continue;
                return;
            } while ((nextTag2 = this.input.readTag()) == this.tag);
            this.nextTag = var1_2;
            return;
        }
        do {
            void var1_1;
            var1_1.add(requireUtf8 ? this.readStringRequireUtf8() : this.readString());
            if (!this.input.isAtEnd()) continue;
            return;
        } while ((nextTag = this.input.readTag()) == this.tag);
        this.nextTag = var3_5;
    }

    @Override
    public final <T> void readMessageList(List<T> target, Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
        int nextTag;
        if (WireFormat.getTagWireType(this.tag) != 2) {
            throw InvalidProtocolBufferException.invalidWireType();
        }
        int listTag = this.tag;
        do {
            target.add(this.readMessage(schema, extensionRegistry));
            if (!this.input.isAtEnd() && this.nextTag == 0) continue;
            return;
        } while ((nextTag = this.input.readTag()) == listTag);
        this.nextTag = nextTag;
    }

    @Override
    @Deprecated
    public final <T> void readGroupList(List<T> target, Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
        int nextTag;
        if (WireFormat.getTagWireType(this.tag) != 3) {
            throw InvalidProtocolBufferException.invalidWireType();
        }
        int listTag = this.tag;
        do {
            target.add(this.readGroup(schema, extensionRegistry));
            if (!this.input.isAtEnd() && this.nextTag == 0) continue;
            return;
        } while ((nextTag = this.input.readTag()) == listTag);
        this.nextTag = nextTag;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readBytesList(List<ByteString> target) throws IOException {
        void var2_2;
        int nextTag;
        if (WireFormat.getTagWireType(this.tag) != 2) {
            throw InvalidProtocolBufferException.invalidWireType();
        }
        do {
            target.add(this.readBytes());
            if (!this.input.isAtEnd()) continue;
            return;
        } while ((nextTag = this.input.readTag()) == this.tag);
        this.nextTag = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readUInt32List(List<Integer> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof IntArrayList)) break block12;
                IntArrayList plist = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.input.readUInt32();
                        int endPos = this.input.getTotalBytesRead() + bytes;
                        do {
                            plist.addInt(this.input.readUInt32());
                        } while (this.input.getTotalBytesRead() < endPos);
                        this.requirePosition(endPos);
                        break block13;
                    }
                    case 0: {
                        void var1_2;
                        int nextTag;
                        do {
                            plist.addInt(this.input.readUInt32());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((nextTag = this.input.readTag()) == this.tag);
                        this.nextTag = var1_2;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var1_1;
                    void var2_4;
                    int bytes = this.input.readUInt32();
                    int endPos = this.input.getTotalBytesRead() + var2_4;
                    do {
                        var1_1.add(this.input.readUInt32());
                    } while (this.input.getTotalBytesRead() < endPos);
                    this.requirePosition(endPos);
                    return;
                }
                case 0: {
                    void var3_7;
                    int nextTag;
                    void var1_1;
                    do {
                        var1_1.add(this.input.readUInt32());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((nextTag = this.input.readTag()) == this.tag);
                    this.nextTag = var3_7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readEnumList(List<Integer> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof IntArrayList)) break block12;
                IntArrayList plist = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.input.readUInt32();
                        int endPos = this.input.getTotalBytesRead() + bytes;
                        do {
                            plist.addInt(this.input.readEnum());
                        } while (this.input.getTotalBytesRead() < endPos);
                        this.requirePosition(endPos);
                        break block13;
                    }
                    case 0: {
                        void var1_2;
                        int nextTag;
                        do {
                            plist.addInt(this.input.readEnum());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((nextTag = this.input.readTag()) == this.tag);
                        this.nextTag = var1_2;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var1_1;
                    void var2_4;
                    int bytes = this.input.readUInt32();
                    int endPos = this.input.getTotalBytesRead() + var2_4;
                    do {
                        var1_1.add(this.input.readEnum());
                    } while (this.input.getTotalBytesRead() < endPos);
                    this.requirePosition(endPos);
                    return;
                }
                case 0: {
                    void var3_7;
                    int nextTag;
                    void var1_1;
                    do {
                        var1_1.add(this.input.readEnum());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((nextTag = this.input.readTag()) == this.tag);
                    this.nextTag = var3_7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readSFixed32List(List<Integer> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof IntArrayList)) break block12;
                IntArrayList plist = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.input.readUInt32();
                        CodedInputStreamReader.verifyPackedFixed32Length(bytes);
                        int endPos = this.input.getTotalBytesRead() + bytes;
                        do {
                            plist.addInt(this.input.readSFixed32());
                        } while (this.input.getTotalBytesRead() < endPos);
                        break block13;
                    }
                    case 5: {
                        void var1_2;
                        int nextTag;
                        do {
                            plist.addInt(this.input.readSFixed32());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((nextTag = this.input.readTag()) == this.tag);
                        this.nextTag = var1_2;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var1_1;
                    void var2_4;
                    int bytes = this.input.readUInt32();
                    CodedInputStreamReader.verifyPackedFixed32Length(bytes);
                    int endPos = this.input.getTotalBytesRead() + var2_4;
                    do {
                        var1_1.add(this.input.readSFixed32());
                    } while (this.input.getTotalBytesRead() < endPos);
                    return;
                }
                case 5: {
                    void var3_7;
                    int nextTag;
                    void var1_1;
                    do {
                        var1_1.add(this.input.readSFixed32());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((nextTag = this.input.readTag()) == this.tag);
                    this.nextTag = var3_7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readSFixed64List(List<Long> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof LongArrayList)) break block12;
                LongArrayList plist = (LongArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.input.readUInt32();
                        CodedInputStreamReader.verifyPackedFixed64Length(bytes);
                        int endPos = this.input.getTotalBytesRead() + bytes;
                        do {
                            plist.addLong(this.input.readSFixed64());
                        } while (this.input.getTotalBytesRead() < endPos);
                        break block13;
                    }
                    case 1: {
                        void var1_2;
                        int nextTag;
                        do {
                            plist.addLong(this.input.readSFixed64());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((nextTag = this.input.readTag()) == this.tag);
                        this.nextTag = var1_2;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var1_1;
                    void var2_4;
                    int bytes = this.input.readUInt32();
                    CodedInputStreamReader.verifyPackedFixed64Length(bytes);
                    int endPos = this.input.getTotalBytesRead() + var2_4;
                    do {
                        var1_1.add(this.input.readSFixed64());
                    } while (this.input.getTotalBytesRead() < endPos);
                    return;
                }
                case 1: {
                    void var3_7;
                    int nextTag;
                    void var1_1;
                    do {
                        var1_1.add(this.input.readSFixed64());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((nextTag = this.input.readTag()) == this.tag);
                    this.nextTag = var3_7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readSInt32List(List<Integer> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof IntArrayList)) break block12;
                IntArrayList plist = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.input.readUInt32();
                        int endPos = this.input.getTotalBytesRead() + bytes;
                        do {
                            plist.addInt(this.input.readSInt32());
                        } while (this.input.getTotalBytesRead() < endPos);
                        this.requirePosition(endPos);
                        break block13;
                    }
                    case 0: {
                        void var1_2;
                        int nextTag;
                        do {
                            plist.addInt(this.input.readSInt32());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((nextTag = this.input.readTag()) == this.tag);
                        this.nextTag = var1_2;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var1_1;
                    void var2_4;
                    int bytes = this.input.readUInt32();
                    int endPos = this.input.getTotalBytesRead() + var2_4;
                    do {
                        var1_1.add(this.input.readSInt32());
                    } while (this.input.getTotalBytesRead() < endPos);
                    this.requirePosition(endPos);
                    return;
                }
                case 0: {
                    void var3_7;
                    int nextTag;
                    void var1_1;
                    do {
                        var1_1.add(this.input.readSInt32());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((nextTag = this.input.readTag()) == this.tag);
                    this.nextTag = var3_7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readSInt64List(List<Long> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof LongArrayList)) break block12;
                LongArrayList plist = (LongArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int bytes = this.input.readUInt32();
                        int endPos = this.input.getTotalBytesRead() + bytes;
                        do {
                            plist.addLong(this.input.readSInt64());
                        } while (this.input.getTotalBytesRead() < endPos);
                        this.requirePosition(endPos);
                        break block13;
                    }
                    case 0: {
                        void var1_2;
                        int nextTag;
                        do {
                            plist.addLong(this.input.readSInt64());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((nextTag = this.input.readTag()) == this.tag);
                        this.nextTag = var1_2;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    void var1_1;
                    void var2_4;
                    int bytes = this.input.readUInt32();
                    int endPos = this.input.getTotalBytesRead() + var2_4;
                    do {
                        var1_1.add(this.input.readSInt64());
                    } while (this.input.getTotalBytesRead() < endPos);
                    this.requirePosition(endPos);
                    return;
                }
                case 0: {
                    void var3_7;
                    int nextTag;
                    void var1_1;
                    do {
                        var1_1.add(this.input.readSInt64());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((nextTag = this.input.readTag()) == this.tag);
                    this.nextTag = var3_7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    private static void verifyPackedFixed64Length(int bytes) throws IOException {
        if ((bytes & 7) != 0) {
            throw InvalidProtocolBufferException.parseFailure();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final <K, V> void readMap(Map<K, V> target, MapEntryLite.Metadata<K, V> metadata, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.requireWireType(2);
        int size = this.input.readUInt32();
        int prevLimit = this.input.pushLimit(size);
        Object key = metadata.defaultKey;
        Object value = metadata.defaultValue;
        try {
            void var1_1;
            int number;
            block9: while ((number = this.getFieldNumber()) != Integer.MAX_VALUE && !this.input.isAtEnd()) {
                try {
                    switch (number) {
                        case 1: {
                            key = this.readField(metadata.keyType, null, null);
                            continue block9;
                        }
                        case 2: {
                            value = this.readField(metadata.valueType, metadata.defaultValue.getClass(), extensionRegistry);
                            continue block9;
                        }
                    }
                    if (this.skipField()) continue;
                    throw new InvalidProtocolBufferException("Unable to parse map entry.");
                }
                catch (InvalidProtocolBufferException.InvalidWireTypeException invalidWireTypeException) {
                    if (this.skipField()) continue;
                    throw new InvalidProtocolBufferException("Unable to parse map entry.");
                }
            }
            var1_1.put(key, value);
            return;
        }
        finally {
            this.input.popLimit(prevLimit);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object readField(WireFormat.FieldType fieldType, Class<?> messageType, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var1_1;
        switch (1.$SwitchMap$com$google$protobuf$WireFormat$FieldType[var1_1.ordinal()]) {
            case 1: {
                return this.readBool();
            }
            case 2: {
                return this.readBytes();
            }
            case 3: {
                return this.readDouble();
            }
            case 4: {
                return this.readEnum();
            }
            case 5: {
                return this.readFixed32();
            }
            case 6: {
                return this.readFixed64();
            }
            case 7: {
                return Float.valueOf(this.readFloat());
            }
            case 8: {
                return this.readInt32();
            }
            case 9: {
                return this.readInt64();
            }
            case 10: {
                void var3_3;
                void var2_2;
                return this.readMessage((Class)var2_2, (ExtensionRegistryLite)var3_3);
            }
            case 11: {
                return this.readSFixed32();
            }
            case 12: {
                return this.readSFixed64();
            }
            case 13: {
                return this.readSInt32();
            }
            case 14: {
                return this.readSInt64();
            }
            case 15: {
                return this.readStringRequireUtf8();
            }
            case 16: {
                return this.readUInt32();
            }
            case 17: {
                return this.readUInt64();
            }
        }
        throw new IllegalArgumentException("unsupported field type.");
    }

    private static void verifyPackedFixed32Length(int bytes) throws IOException {
        if ((bytes & 3) != 0) {
            throw InvalidProtocolBufferException.parseFailure();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void requirePosition(int expectedPosition) throws IOException {
        void var1_1;
        if (this.input.getTotalBytesRead() != var1_1) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
    }
}

