/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.AbstractMessageLite;
import androidx.datastore.preferences.protobuf.ByteOutput;
import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CodedOutputStreamWriter;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.LazyFieldLite;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.Schema;
import androidx.datastore.preferences.protobuf.UnsafeUtil;
import androidx.datastore.preferences.protobuf.Utf8;
import androidx.datastore.preferences.protobuf.WireFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CodedOutputStream
extends ByteOutput {
    private static final Logger logger = Logger.getLogger(CodedOutputStream.class.getName());
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = UnsafeUtil.hasUnsafeArrayOperations();
    CodedOutputStreamWriter wrapper;

    static int computePreferredBufferSize(int dataLength) {
        int n;
        if (dataLength > 4096) {
            return 4096;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static CodedOutputStream newInstance(OutputStream output, int bufferSize) {
        void var1_1;
        OutputStream outputStream;
        return new OutputStreamEncoder(outputStream, (int)var1_1);
    }

    public static CodedOutputStream newInstance(byte[] flatArray) {
        byte[] byArray;
        int n = byArray.length;
        boolean bl = false;
        byte[] byArray2 = flatArray;
        return new ArrayEncoder(byArray2, 0, n);
    }

    private CodedOutputStream() {
    }

    public abstract void writeTag(int var1, int var2) throws IOException;

    public abstract void writeInt32(int var1, int var2) throws IOException;

    public abstract void writeUInt32(int var1, int var2) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeSInt32(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeUInt32((int)var1_1, CodedOutputStream.encodeZigZag32((int)var2_2));
    }

    public abstract void writeFixed32(int var1, int var2) throws IOException;

    public abstract void writeUInt64(int var1, long var2) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeSInt64(int fieldNumber, long value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeUInt64((int)var1_1, CodedOutputStream.encodeZigZag64((long)var2_2));
    }

    public abstract void writeFixed64(int var1, long var2) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeFloat(int fieldNumber, float value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeFixed32((int)var1_1, Float.floatToRawIntBits((float)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final void writeDouble(int fieldNumber, double value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeFixed64((int)var1_1, Double.doubleToRawLongBits((double)var2_2));
    }

    public abstract void writeBool(int var1, boolean var2) throws IOException;

    public abstract void writeString(int var1, String var2) throws IOException;

    public abstract void writeBytes(int var1, ByteString var2) throws IOException;

    abstract void writeMessage(int var1, MessageLite var2, Schema var3) throws IOException;

    public abstract void writeMessageSetExtension(int var1, MessageLite var2) throws IOException;

    public abstract void writeRawMessageSetExtension(int var1, ByteString var2) throws IOException;

    public abstract void writeInt32NoTag(int var1) throws IOException;

    public abstract void writeUInt32NoTag(int var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeSInt32NoTag(int value) throws IOException {
        void var1_1;
        this.writeUInt32NoTag(CodedOutputStream.encodeZigZag32((int)var1_1));
    }

    public abstract void writeFixed32NoTag(int var1) throws IOException;

    public abstract void writeUInt64NoTag(long var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeSInt64NoTag(long value) throws IOException {
        void var1_1;
        this.writeUInt64NoTag(CodedOutputStream.encodeZigZag64((long)var1_1));
    }

    public abstract void writeFixed64NoTag(long var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeFloatNoTag(float value) throws IOException {
        void var1_1;
        this.writeFixed32NoTag(Float.floatToRawIntBits((float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void writeDoubleNoTag(double value) throws IOException {
        void var1_1;
        this.writeFixed64NoTag(Double.doubleToRawLongBits((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void writeBoolNoTag(boolean value) throws IOException {
        void var1_1;
        this.write((byte)(var1_1 != false ? 1 : 0));
    }

    public abstract void writeStringNoTag(String var1) throws IOException;

    public abstract void writeBytesNoTag(ByteString var1) throws IOException;

    public abstract void writeMessageNoTag(MessageLite var1) throws IOException;

    public abstract void write(byte var1) throws IOException;

    @Override
    public abstract void writeLazy(byte[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - void declaration
     */
    public static int computeInt32Size(int fieldNumber, int value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeInt32SizeNoTag((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeUInt32Size(int fieldNumber, int value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeUInt32SizeNoTag((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeSInt32Size(int fieldNumber, int value) {
        void var1_1;
        int n = var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeUInt32SizeNoTag(CodedOutputStream.encodeZigZag32(n));
    }

    public static int computeFixed32Size(int fieldNumber, int value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + 4;
    }

    public static int computeSFixed32Size(int fieldNumber, int value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + 4;
    }

    /*
     * WARNING - void declaration
     */
    public static int computeInt64Size(int fieldNumber, long value) {
        void var1_1;
        void var3_2 = var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeUInt64SizeNoTag((long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeUInt64Size(int fieldNumber, long value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeUInt64SizeNoTag((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeSInt64Size(int fieldNumber, long value) {
        void var1_1;
        void var3_2 = var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeUInt64SizeNoTag(CodedOutputStream.encodeZigZag64((long)var3_2));
    }

    public static int computeFixed64Size(int fieldNumber, long value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + 8;
    }

    public static int computeSFixed64Size(int fieldNumber, long value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + 8;
    }

    public static int computeFloatSize(int fieldNumber, float value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + 4;
    }

    public static int computeDoubleSize(int fieldNumber, double value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + 8;
    }

    public static int computeBoolSize(int fieldNumber, boolean value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + 1;
    }

    /*
     * WARNING - void declaration
     */
    public static int computeEnumSize(int fieldNumber, int value) {
        void var1_1;
        int n = var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeInt32SizeNoTag(n);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeStringSize(int fieldNumber, String value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeStringSizeNoTag((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeBytesSize(int fieldNumber, ByteString value) {
        void var1_3;
        void var0_1 = var1_3;
        int n = var0_1.size();
        return CodedOutputStream.computeTagSize(fieldNumber) + (CodedOutputStream.computeUInt32SizeNoTag(n) + n);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeLazyFieldSize(int fieldNumber, LazyFieldLite value) {
        void var1_3;
        void var0_1 = var1_3;
        int n = var0_1.getSerializedSize();
        return CodedOutputStream.computeTagSize(fieldNumber) + (CodedOutputStream.computeUInt32SizeNoTag(n) + n);
    }

    /*
     * WARNING - void declaration
     */
    static int computeMessageSize(int fieldNumber, MessageLite value, Schema schema) {
        void var2_2;
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeMessageSizeNoTag((MessageLite)var1_1, (Schema)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeMessageSetExtensionSize(int fieldNumber, MessageLite value) {
        void var1_1;
        int n;
        int n2 = (CodedOutputStream.computeTagSize(1) << 1) + CodedOutputStream.computeUInt32Size(2, n);
        n = 3;
        return n2 + (CodedOutputStream.computeTagSize(3) + CodedOutputStream.computeMessageSizeNoTag((MessageLite)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static int computeRawMessageSetExtensionSize(int fieldNumber, ByteString value) {
        void var1_1;
        int n;
        return (CodedOutputStream.computeTagSize(1) << 1) + CodedOutputStream.computeUInt32Size(2, n) + CodedOutputStream.computeBytesSize(3, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeLazyFieldMessageSetExtensionSize(int fieldNumber, LazyFieldLite value) {
        void var1_1;
        int n;
        return (CodedOutputStream.computeTagSize(1) << 1) + CodedOutputStream.computeUInt32Size(2, n) + CodedOutputStream.computeLazyFieldSize(3, (LazyFieldLite)var1_1);
    }

    public static int computeTagSize(int fieldNumber) {
        return CodedOutputStream.computeUInt32SizeNoTag(WireFormat.makeTag(fieldNumber, 0));
    }

    public static int computeInt32SizeNoTag(int value) {
        if (value >= 0) {
            int n;
            return CodedOutputStream.computeUInt32SizeNoTag(n);
        }
        return 10;
    }

    public static int computeUInt32SizeNoTag(int value) {
        int n;
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int computeSInt32SizeNoTag(int value) {
        return CodedOutputStream.computeUInt32SizeNoTag(CodedOutputStream.encodeZigZag32(value));
    }

    public static int computeFixed32SizeNoTag$134621() {
        return 4;
    }

    public static int computeSFixed32SizeNoTag$134621() {
        return 4;
    }

    public static int computeInt64SizeNoTag(long value) {
        return CodedOutputStream.computeUInt64SizeNoTag(value);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeUInt64SizeNoTag(long value) {
        void var2_1;
        long l;
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (value < 0L) {
            return 10;
        }
        int n = 2;
        if ((value & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            value >>>= 28;
        }
        if ((value & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            value >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return (int)var2_1;
    }

    public static int computeSInt64SizeNoTag(long value) {
        return CodedOutputStream.computeUInt64SizeNoTag(CodedOutputStream.encodeZigZag64(value));
    }

    public static int computeFixed64SizeNoTag$1349e2() {
        return 8;
    }

    public static int computeSFixed64SizeNoTag$1349e2() {
        return 8;
    }

    public static int computeFloatSizeNoTag$133ade() {
        return 4;
    }

    public static int computeDoubleSizeNoTag$13335c() {
        return 8;
    }

    public static int computeBoolSizeNoTag$1385f2() {
        return 1;
    }

    public static int computeEnumSizeNoTag(int value) {
        return CodedOutputStream.computeInt32SizeNoTag(value);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeStringSizeNoTag(String value) {
        void var1_2;
        int length;
        try {
            length = Utf8.encodedLength(value);
        }
        catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
            Object object;
            byte[] byArray = ((String)object).getBytes(Internal.UTF_8);
            object = byArray;
            length = byArray.length;
        }
        void var0_1 = var1_2;
        return CodedOutputStream.computeUInt32SizeNoTag((int)var0_1) + var0_1;
    }

    public static int computeLazyFieldSizeNoTag(LazyFieldLite value) {
        int n = value.getSerializedSize();
        return CodedOutputStream.computeUInt32SizeNoTag(n) + n;
    }

    public static int computeBytesSizeNoTag(ByteString value) {
        int n = value.size();
        return CodedOutputStream.computeUInt32SizeNoTag(n) + n;
    }

    public static int computeByteArraySizeNoTag(byte[] value) {
        int n = value.length;
        return CodedOutputStream.computeUInt32SizeNoTag(n) + n;
    }

    public static int computeMessageSizeNoTag(MessageLite value) {
        int n = value.getSerializedSize();
        return CodedOutputStream.computeUInt32SizeNoTag(n) + n;
    }

    /*
     * WARNING - void declaration
     */
    static int computeMessageSizeNoTag(MessageLite value, Schema schema) {
        void var1_2;
        int n = ((AbstractMessageLite)value).getSerializedSize((Schema)var1_2);
        return CodedOutputStream.computeUInt32SizeNoTag(n) + n;
    }

    static int computeLengthDelimitedFieldSize(int fieldLength) {
        int n;
        return CodedOutputStream.computeUInt32SizeNoTag(fieldLength) + n;
    }

    private static int encodeZigZag32(int n) {
        int n2;
        return n << 1 ^ n2 >> 31;
    }

    private static long encodeZigZag64(long n) {
        long l;
        return n << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int spaceLeft();

    abstract void writeByteArrayNoTag(byte[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - void declaration
     */
    final void inefficientWriteStringNoTag(String value, Utf8.UnpairedSurrogateException cause) throws IOException {
        void var2_3;
        logger.log(Level.WARNING, "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", (Throwable)var2_3);
        byte[] bytes = value.getBytes(Internal.UTF_8);
        try {
            this.writeUInt32NoTag(bytes.length);
            this.writeLazy(bytes, 0, bytes.length);
            return;
        }
        catch (IndexOutOfBoundsException e) {
            void var1_2;
            throw new OutOfSpaceException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    static int computeGroupSize(int fieldNumber, MessageLite value, Schema schema) {
        void var2_3;
        void var1_2;
        void v0 = var1_2;
        var1_2 = var2_3;
        void var0_1 = v0;
        return (CodedOutputStream.computeTagSize(fieldNumber) << 1) + ((AbstractMessageLite)v0).getSerializedSize((Schema)var1_2);
    }

    @Deprecated
    public static int computeGroupSizeNoTag(MessageLite value) {
        return value.getSerializedSize();
    }

    /* synthetic */ CodedOutputStream(byte by) {
        this();
    }

    static final class OutputStreamEncoder
    extends AbstractBufferedEncoder {
        private final OutputStream out;

        /*
         * WARNING - void declaration
         */
        OutputStreamEncoder(OutputStream out, int bufferSize) {
            super((int)var2_2);
            void var1_1;
            void var2_2;
            if (out == null) {
                throw new NullPointerException("out");
            }
            this.out = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeTag(int fieldNumber, int wireType) throws IOException {
            void var2_2;
            void var1_1;
            this.writeUInt32NoTag(WireFormat.makeTag((int)var1_1, (int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32(int fieldNumber, int value) throws IOException {
            void var2_3;
            void var1_1;
            this.flushIfNotAvailable(20);
            this.bufferTag((int)var1_1, 0);
            OutputStreamEncoder outputStreamEncoder = this;
            if (var2_3 >= 0) {
                outputStreamEncoder.bufferUInt32NoTag((int)var2_3);
                return;
            }
            outputStreamEncoder.bufferUInt64NoTag((long)var2_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.flushIfNotAvailable(20);
            this.bufferTag((int)var1_1, 0);
            this.bufferUInt32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.flushIfNotAvailable(14);
            this.bufferTag((int)var1_1, 5);
            this.bufferFixed32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64(int fieldNumber, long value) throws IOException {
            void var2_2;
            void var1_1;
            this.flushIfNotAvailable(20);
            this.bufferTag((int)var1_1, 0);
            this.bufferUInt64NoTag((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64(int fieldNumber, long value) throws IOException {
            void var2_2;
            void var1_1;
            this.flushIfNotAvailable(18);
            this.bufferTag((int)var1_1, 1);
            this.bufferFixed64NoTag((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBool(int fieldNumber, boolean value) throws IOException {
            void var2_2;
            void var1_1;
            this.flushIfNotAvailable(11);
            this.bufferTag((int)var1_1, 0);
            this.buffer((byte)(var2_2 != false ? 1 : 0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeString(int fieldNumber, String value) throws IOException {
            void var2_2;
            void var1_1;
            this.writeTag((int)var1_1, 2);
            this.writeStringNoTag((String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytes(int fieldNumber, ByteString value) throws IOException {
            void var2_2;
            void var1_1;
            this.writeTag((int)var1_1, 2);
            this.writeBytesNoTag((ByteString)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytesNoTag(ByteString value) throws IOException {
            void var1_1;
            this.writeUInt32NoTag(value.size());
            var1_1.writeTo(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteArrayNoTag(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var1_1;
            this.writeUInt32NoTag(length);
            this.write((byte[])var1_1, 0, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeMessage(int fieldNumber, MessageLite value, Schema schema) throws IOException {
            void var3_4;
            void var2_3;
            void var1_1;
            this.writeTag((int)var1_1, 2);
            OutputStreamEncoder outputStreamEncoder = this;
            outputStreamEncoder.writeUInt32NoTag(((AbstractMessageLite)var2_3).getSerializedSize((Schema)var3_4));
            var3_4.writeTo(var2_3, outputStreamEncoder.wrapper);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessageSetExtension(int fieldNumber, MessageLite value) throws IOException {
            void var2_3;
            int n;
            this.writeTag(1, 3);
            this.writeUInt32(2, n);
            n = 3;
            OutputStreamEncoder outputStreamEncoder = this;
            outputStreamEncoder.writeTag(3, 2);
            outputStreamEncoder.writeMessageNoTag((MessageLite)var2_3);
            this.writeTag(1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeRawMessageSetExtension(int fieldNumber, ByteString value) throws IOException {
            void var2_2;
            void var1_1;
            this.writeTag(1, 3);
            this.writeUInt32(2, (int)var1_1);
            this.writeBytes(3, (ByteString)var2_2);
            this.writeTag(1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessageNoTag(MessageLite value) throws IOException {
            void var1_1;
            this.writeUInt32NoTag(value.getSerializedSize());
            var1_1.writeTo(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte value) throws IOException {
            void var1_1;
            if (this.position == this.limit) {
                this.doFlush();
            }
            this.buffer((byte)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32NoTag(int value) throws IOException {
            void var1_1;
            if (value >= 0) {
                this.writeUInt32NoTag(value);
                return;
            }
            this.writeUInt64NoTag((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt32NoTag(int value) throws IOException {
            void var1_1;
            this.flushIfNotAvailable(5);
            this.bufferUInt32NoTag((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32NoTag(int value) throws IOException {
            void var1_1;
            this.flushIfNotAvailable(4);
            this.bufferFixed32NoTag((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64NoTag(long value) throws IOException {
            void var1_1;
            this.flushIfNotAvailable(10);
            this.bufferUInt64NoTag((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64NoTag(long value) throws IOException {
            void var1_1;
            this.flushIfNotAvailable(8);
            this.bufferFixed64NoTag((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeStringNoTag(String value) throws IOException {
            try {
                int actualLength22;
                int maxLength = value.length() * 3;
                int maxLengthVarIntSize2 = OutputStreamEncoder.computeUInt32SizeNoTag(maxLength);
                if (maxLengthVarIntSize2 + maxLength > this.limit) {
                    byte[] encodedBytes22 = new byte[maxLength];
                    actualLength22 = Utf8.encode(value, encodedBytes22, 0, maxLength);
                    this.writeUInt32NoTag(actualLength22);
                    int n = actualLength22;
                    int encodedBytes22 = 0;
                    byte[] maxLengthVarIntSize2 = encodedBytes22;
                    OutputStreamEncoder actualLength22 = this;
                    actualLength22.write(maxLengthVarIntSize2, encodedBytes22, n);
                    return;
                }
                if (maxLengthVarIntSize2 + actualLength22 > this.limit - this.position) {
                    this.doFlush();
                }
                int minLengthVarIntSize = OutputStreamEncoder.computeUInt32SizeNoTag(value.length());
                int oldPosition = this.position;
                try {
                    void var3_5;
                    int length;
                    if (minLengthVarIntSize == maxLengthVarIntSize2) {
                        this.position = oldPosition + minLengthVarIntSize;
                        int newPosition = Utf8.encode(value, this.buffer, this.position, this.limit - this.position);
                        this.position = oldPosition;
                        length = newPosition - oldPosition - minLengthVarIntSize;
                        this.bufferUInt32NoTag(length);
                        this.position = newPosition;
                    } else {
                        length = Utf8.encodedLength(value);
                        this.bufferUInt32NoTag(length);
                        this.position = Utf8.encode(value, this.buffer, this.position, length);
                    }
                    this.totalBytesWritten += var3_5;
                }
                catch (Utf8.UnpairedSurrogateException e) {
                    this.totalBytesWritten -= this.position - oldPosition;
                    this.position = oldPosition;
                    throw e;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new OutOfSpaceException(e);
                }
            }
            catch (Utf8.UnpairedSurrogateException e) {
                void var2_4;
                void var1_1;
                this.inefficientWriteStringNoTag((String)var1_1, (Utf8.UnpairedSurrogateException)var2_4);
            }
        }

        @Override
        public final void flush() throws IOException {
            if (this.position > 0) {
                this.doFlush();
            }
        }

        /*
         * WARNING - void declaration
         */
        private void write(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            if (this.limit - this.position >= length) {
                System.arraycopy(value, offset, this.buffer, this.position, length);
                this.position += length;
            } else {
                int bytesWritten = this.limit - this.position;
                System.arraycopy(value, offset, this.buffer, this.position, bytesWritten);
                offset += bytesWritten;
                this.position = this.limit;
                this.totalBytesWritten += bytesWritten;
                this.doFlush();
                if ((length -= bytesWritten) <= this.limit) {
                    System.arraycopy(value, offset, this.buffer, 0, length);
                    this.position = length;
                } else {
                    void var2_2;
                    void var1_1;
                    this.out.write((byte[])var1_1, (int)var2_2, length);
                }
            }
            this.totalBytesWritten += var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            this.write((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        private void flushIfNotAvailable(int requiredSize) throws IOException {
            void var1_1;
            if (this.limit - this.position < var1_1) {
                this.doFlush();
            }
        }

        private void doFlush() throws IOException {
            this.out.write(this.buffer, 0, this.position);
            this.position = 0;
        }
    }

    static abstract class AbstractBufferedEncoder
    extends CodedOutputStream {
        final byte[] buffer;
        final int limit;
        int position;
        int totalBytesWritten;

        /*
         * WARNING - void declaration
         */
        AbstractBufferedEncoder(int bufferSize) {
            super((byte)0);
            void var1_1;
            if (bufferSize < 0) {
                throw new IllegalArgumentException("bufferSize must be >= 0");
            }
            this.buffer = new byte[Math.max((int)var1_1, 20)];
            this.limit = this.buffer.length;
        }

        @Override
        public final int spaceLeft() {
            throw new UnsupportedOperationException("spaceLeft() can only be called on CodedOutputStreams that are writing to a flat array or ByteBuffer.");
        }

        /*
         * WARNING - void declaration
         */
        final void buffer(byte value) {
            void var1_1;
            this.buffer[this.position++] = var1_1;
            ++this.totalBytesWritten;
        }

        /*
         * WARNING - void declaration
         */
        final void bufferTag(int fieldNumber, int wireType) {
            void var2_2;
            void var1_1;
            this.bufferUInt32NoTag(WireFormat.makeTag((int)var1_1, (int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        final void bufferUInt32NoTag(int value) {
            void var1_1;
            if (HAS_UNSAFE_ARRAY_OPERATIONS) {
                void var2_2;
                long originalPos = this.position;
                while (true) {
                    if ((value & 0xFFFFFF80) == 0) break;
                    UnsafeUtil.putByte(this.buffer, this.position++, (byte)(value & 0x7F | 0x80));
                    value >>>= 7;
                }
                UnsafeUtil.putByte(this.buffer, this.position++, (byte)value);
                int delta = (int)((long)this.position - var2_2);
                this.totalBytesWritten += var1_1;
                return;
            }
            while (true) {
                if ((var1_1 & 0xFFFFFF80) == 0) {
                    this.buffer[this.position++] = (byte)var1_1;
                    ++this.totalBytesWritten;
                    return;
                }
                this.buffer[this.position++] = (byte)(var1_1 & 0x7F | 0x80);
                ++this.totalBytesWritten;
                var1_1 >>>= 7;
            }
        }

        /*
         * WARNING - void declaration
         */
        final void bufferUInt64NoTag(long value) {
            if (HAS_UNSAFE_ARRAY_OPERATIONS) {
                void var1_2;
                void var3_3;
                long originalPos = this.position;
                while (true) {
                    if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) break;
                    UnsafeUtil.putByte(this.buffer, this.position++, (byte)((int)value & 0x7F | 0x80));
                    value >>>= 7;
                }
                UnsafeUtil.putByte(this.buffer, this.position++, (byte)value);
                int delta = (int)((long)this.position - var3_3);
                this.totalBytesWritten += var1_2;
                return;
            }
            while (true) {
                void var1_1;
                if ((var1_1 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    this.buffer[this.position++] = (byte)var1_1;
                    ++this.totalBytesWritten;
                    return;
                }
                this.buffer[this.position++] = (byte)((int)var1_1 & 0x7F | 0x80);
                ++this.totalBytesWritten;
                var1_1 >>>= 7;
            }
        }

        /*
         * WARNING - void declaration
         */
        final void bufferFixed32NoTag(int value) {
            void var1_1;
            this.buffer[this.position++] = (byte)value;
            this.buffer[this.position++] = (byte)(value >> 8);
            this.buffer[this.position++] = (byte)(value >> 16);
            this.buffer[this.position++] = (byte)(var1_1 >>> 24);
            this.totalBytesWritten += 4;
        }

        /*
         * WARNING - void declaration
         */
        final void bufferFixed64NoTag(long value) {
            void var1_1;
            this.buffer[this.position++] = (byte)(value & 0xFFL);
            this.buffer[this.position++] = (byte)(value >> 8 & 0xFFL);
            this.buffer[this.position++] = (byte)(value >> 16 & 0xFFL);
            this.buffer[this.position++] = (byte)(value >> 24 & 0xFFL);
            this.buffer[this.position++] = (byte)(value >> 32);
            this.buffer[this.position++] = (byte)(value >> 40);
            this.buffer[this.position++] = (byte)(value >> 48);
            this.buffer[this.position++] = (byte)(var1_1 >> 56);
            this.totalBytesWritten += 8;
        }
    }

    static final class ArrayEncoder
    extends CodedOutputStream {
        private final byte[] buffer;
        private final int limit;
        private int position;

        /*
         * WARNING - void declaration
         */
        ArrayEncoder(byte[] buffer, int offset, int length) {
            super((byte)0);
            void var3_3;
            void var2_2;
            void var1_1;
            if (buffer == null) {
                throw new NullPointerException("buffer");
            }
            if ((offset | length | buffer.length - (offset + length)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", buffer.length, offset, length));
            }
            this.buffer = var1_1;
            this.position = offset;
            this.limit = var2_2 + var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeTag(int fieldNumber, int wireType) throws IOException {
            void var2_2;
            void var1_1;
            this.writeUInt32NoTag(WireFormat.makeTag((int)var1_1, (int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.writeTag((int)var1_1, 0);
            this.writeInt32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.writeTag((int)var1_1, 0);
            this.writeUInt32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            this.writeTag((int)var1_1, 5);
            this.writeFixed32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64(int fieldNumber, long value) throws IOException {
            void var2_2;
            void var1_1;
            this.writeTag((int)var1_1, 0);
            this.writeUInt64NoTag((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64(int fieldNumber, long value) throws IOException {
            void var2_2;
            void var1_1;
            this.writeTag((int)var1_1, 1);
            this.writeFixed64NoTag((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBool(int fieldNumber, boolean value) throws IOException {
            void var2_2;
            void var1_1;
            this.writeTag((int)var1_1, 0);
            this.write((byte)(var2_2 != false ? 1 : 0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeString(int fieldNumber, String value) throws IOException {
            void var2_2;
            void var1_1;
            this.writeTag((int)var1_1, 2);
            this.writeStringNoTag((String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytes(int fieldNumber, ByteString value) throws IOException {
            void var2_2;
            void var1_1;
            this.writeTag((int)var1_1, 2);
            this.writeBytesNoTag((ByteString)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytesNoTag(ByteString value) throws IOException {
            void var1_1;
            this.writeUInt32NoTag(value.size());
            var1_1.writeTo(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteArrayNoTag(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var1_1;
            this.writeUInt32NoTag(length);
            this.write((byte[])var1_1, 0, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void writeMessage(int fieldNumber, MessageLite value, Schema schema) throws IOException {
            void var2_2;
            void var3_3;
            void var1_1;
            this.writeTag((int)var1_1, 2);
            this.writeUInt32NoTag(((AbstractMessageLite)value).getSerializedSize(schema));
            var3_3.writeTo(var2_2, this.wrapper);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessageSetExtension(int fieldNumber, MessageLite value) throws IOException {
            void var2_3;
            int n;
            this.writeTag(1, 3);
            this.writeUInt32(2, n);
            n = 3;
            ArrayEncoder arrayEncoder = this;
            arrayEncoder.writeTag(3, 2);
            arrayEncoder.writeMessageNoTag((MessageLite)var2_3);
            this.writeTag(1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeRawMessageSetExtension(int fieldNumber, ByteString value) throws IOException {
            void var2_2;
            void var1_1;
            this.writeTag(1, 3);
            this.writeUInt32(2, (int)var1_1);
            this.writeBytes(3, (ByteString)var2_2);
            this.writeTag(1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessageNoTag(MessageLite value) throws IOException {
            void var1_1;
            this.writeUInt32NoTag(value.getSerializedSize());
            var1_1.writeTo(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte value) throws IOException {
            try {
                this.buffer[this.position++] = value;
                return;
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32NoTag(int value) throws IOException {
            void var1_1;
            if (value >= 0) {
                this.writeUInt32NoTag(value);
                return;
            }
            this.writeUInt64NoTag((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt32NoTag(int value) throws IOException {
            try {
                while (true) {
                    if ((value & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)value;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(value & 0x7F | 0x80);
                    value >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32NoTag(int value) throws IOException {
            try {
                this.buffer[this.position++] = (byte)value;
                this.buffer[this.position++] = (byte)(value >> 8);
                this.buffer[this.position++] = (byte)(value >> 16);
                this.buffer[this.position++] = (byte)(value >>> 24);
                return;
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64NoTag(long value) throws IOException {
            if (HAS_UNSAFE_ARRAY_OPERATIONS && this.spaceLeft() >= 10) {
                while (true) {
                    if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        UnsafeUtil.putByte(this.buffer, this.position++, (byte)value);
                        return;
                    }
                    UnsafeUtil.putByte(this.buffer, this.position++, (byte)((int)value & 0x7F | 0x80));
                    value >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)value;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)value & 0x7F | 0x80);
                    value >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64NoTag(long value) throws IOException {
            try {
                this.buffer[this.position++] = (byte)value;
                this.buffer[this.position++] = (byte)(value >> 8);
                this.buffer[this.position++] = (byte)(value >> 16);
                this.buffer[this.position++] = (byte)(value >> 24);
                this.buffer[this.position++] = (byte)(value >> 32);
                this.buffer[this.position++] = (byte)(value >> 40);
                this.buffer[this.position++] = (byte)(value >> 48);
                this.buffer[this.position++] = (byte)(value >> 56);
                return;
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void write(byte[] value, int offset, int length) throws IOException {
            try {
                void var2_3;
                System.arraycopy(value, (int)var2_3, this.buffer, this.position, length);
                this.position += length;
                return;
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                void var3_4;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, (int)var3_4), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            this.write((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeStringNoTag(String value) throws IOException {
            int oldPosition = this.position;
            try {
                int n = value.length() * 3;
                int maxLengthVarIntSize = ArrayEncoder.computeUInt32SizeNoTag(n);
                int minLengthVarIntSize = ArrayEncoder.computeUInt32SizeNoTag(value.length());
                if (minLengthVarIntSize != maxLengthVarIntSize) {
                    int length = Utf8.encodedLength(value);
                    this.writeUInt32NoTag(length);
                    this.position = Utf8.encode(value, this.buffer, this.position, this.spaceLeft());
                    return;
                }
                this.position = oldPosition + minLengthVarIntSize;
                int newPosition = Utf8.encode(value, this.buffer, this.position, this.spaceLeft());
                this.position = oldPosition;
                int length = newPosition - oldPosition - minLengthVarIntSize;
                this.writeUInt32NoTag(length);
                this.position = newPosition;
            }
            catch (Utf8.UnpairedSurrogateException e) {
                void var1_1;
                void var2_2;
                this.position = var2_2;
                this.inefficientWriteStringNoTag((String)var1_1, e);
                return;
            }
            catch (IndexOutOfBoundsException e) {
                void var3_5;
                throw new OutOfSpaceException((Throwable)var3_5);
            }
        }

        @Override
        public final void flush() {
        }

        @Override
        public final int spaceLeft() {
            return this.limit - this.position;
        }
    }

    public static final class OutOfSpaceException
    extends IOException {
        OutOfSpaceException() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        /*
         * WARNING - void declaration
         */
        OutOfSpaceException(Throwable cause) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", (Throwable)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        OutOfSpaceException(String explanationMessage, Throwable cause) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.: " + (String)var1_1, (Throwable)var2_2);
            void var2_2;
            void var1_1;
        }
    }
}

