/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CodedOutputStream;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.LazyStringList;
import androidx.datastore.preferences.protobuf.MapEntryLite;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.Schema;
import androidx.datastore.preferences.protobuf.Writer;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class CodedOutputStreamWriter
implements Writer {
    private final CodedOutputStream output;

    public static CodedOutputStreamWriter forCodedOutput(CodedOutputStream output) {
        CodedOutputStream codedOutputStream;
        if (output.wrapper != null) {
            return output.wrapper;
        }
        return new CodedOutputStreamWriter(codedOutputStream);
    }

    /*
     * WARNING - void declaration
     */
    private CodedOutputStreamWriter(CodedOutputStream output) {
        void var1_1;
        this.output = (CodedOutputStream)Internal.checkNotNull(var1_1, "output");
        this.output.wrapper = this;
    }

    @Override
    public final Writer.FieldOrder fieldOrder() {
        return Writer.FieldOrder.ASCENDING;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSFixed32(int fieldNumber, int value) throws IOException {
        void var1_1;
        void var2_3;
        void var3_4 = var2_3;
        var2_3 = var1_1;
        CodedOutputStream codedOutputStream = this.output;
        codedOutputStream.writeFixed32((int)var2_3, (int)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeInt64(int fieldNumber, long value) throws IOException {
        void var1_1;
        void var2_3;
        void var6_5 = var2_3;
        void var2_4 = var1_1;
        CodedOutputStream codedOutputStream = this.output;
        codedOutputStream.writeUInt64((int)var2_4, (long)var6_5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSFixed64(int fieldNumber, long value) throws IOException {
        void var1_1;
        void var2_3;
        void var6_5 = var2_3;
        void var2_4 = var1_1;
        CodedOutputStream codedOutputStream = this.output;
        codedOutputStream.writeFixed64((int)var2_4, (long)var6_5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeFloat(int fieldNumber, float value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeFloat((int)var1_1, (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeDouble(int fieldNumber, double value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeDouble((int)var1_1, (double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeEnum(int fieldNumber, int value) throws IOException {
        void var1_1;
        void var2_3;
        void var3_4 = var2_3;
        var2_3 = var1_1;
        CodedOutputStream codedOutputStream = this.output;
        codedOutputStream.writeInt32((int)var2_3, (int)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeUInt64(int fieldNumber, long value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeUInt64((int)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeInt32(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeInt32((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeFixed64(int fieldNumber, long value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeFixed64((int)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeFixed32(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeFixed32((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeBool(int fieldNumber, boolean value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeBool((int)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeString(int fieldNumber, String value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeString((int)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeBytes(int fieldNumber, ByteString value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeBytes((int)var1_1, (ByteString)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeUInt32(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeUInt32((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSInt32(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeSInt32((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSInt64(int fieldNumber, long value) throws IOException {
        void var2_2;
        void var1_1;
        this.output.writeSInt64((int)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeMessage(int fieldNumber, Object value, Schema schema) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.output.writeMessage((int)var1_1, (MessageLite)var2_2, (Schema)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeGroup(int fieldNumber, Object value, Schema schema) throws IOException {
        void var1_1;
        void var2_3;
        Object object;
        MessageLite messageLite = object;
        object = (MessageLite)var2_3;
        void var2_4 = var1_1;
        CodedOutputStream codedOutputStream = this.output;
        codedOutputStream.writeTag((int)var2_4, 3);
        void var5_7 = messageLite;
        messageLite = object;
        object = codedOutputStream;
        var5_7.writeTo(messageLite, ((CodedOutputStream)object).wrapper);
        codedOutputStream.writeTag((int)var2_4, 4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final void writeStartGroup(int fieldNumber) throws IOException {
        void var1_1;
        this.output.writeTag((int)var1_1, 3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final void writeEndGroup(int fieldNumber) throws IOException {
        void var1_1;
        this.output.writeTag((int)var1_1, 4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeMessageSetItem(int fieldNumber, Object value) throws IOException {
        void var2_2;
        void var1_1;
        if (value instanceof ByteString) {
            this.output.writeRawMessageSetExtension(fieldNumber, (ByteString)value);
            return;
        }
        this.output.writeMessageSetExtension((int)var1_1, (MessageLite)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeInt32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeInt32SizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeInt32NoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeInt32((int)var1_1, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeFixed32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                value.get(i).intValue();
                dataSize += CodedOutputStream.computeFixed32SizeNoTag$134621();
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeFixed32NoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeFixed32((int)var1_1, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeInt64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeInt64SizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                long l = value.get(i);
                CodedOutputStream codedOutputStream = this.output;
                codedOutputStream.writeUInt64NoTag(l);
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            long l = value.get(i);
            void var7_7 = var1_1;
            CodedOutputStream codedOutputStream = this.output;
            codedOutputStream.writeUInt64((int)var7_7, l);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeUInt64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeUInt64SizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeUInt64NoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeUInt64((int)var1_1, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeFixed64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                value.get(i).longValue();
                dataSize += CodedOutputStream.computeFixed64SizeNoTag$1349e2();
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeFixed64NoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeFixed64((int)var1_1, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeFloatList(int fieldNumber, List<Float> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                value.get(i).floatValue();
                dataSize += CodedOutputStream.computeFloatSizeNoTag$133ade();
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeFloatNoTag(value.get(i).floatValue());
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeFloat((int)var1_1, value.get(i).floatValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeDoubleList(int fieldNumber, List<Double> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                value.get(i).doubleValue();
                dataSize += CodedOutputStream.computeDoubleSizeNoTag$13335c();
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeDoubleNoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeDouble((int)var1_1, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeEnumList(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeEnumSizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                int n = value.get(i);
                CodedOutputStream codedOutputStream = this.output;
                codedOutputStream.writeInt32NoTag(n);
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            int n = value.get(i);
            void var5_7 = var1_1;
            CodedOutputStream codedOutputStream = this.output;
            codedOutputStream.writeInt32((int)var5_7, n);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeBoolList(int fieldNumber, List<Boolean> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                value.get(i).booleanValue();
                dataSize += CodedOutputStream.computeBoolSizeNoTag$1385f2();
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeBoolNoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeBool((int)var1_1, value.get(i));
        }
    }

    @Override
    public final void writeStringList(int fieldNumber, List<String> value) throws IOException {
        if (value instanceof LazyStringList) {
            LazyStringList lazyList = (LazyStringList)value;
            for (int i = 0; i < value.size(); ++i) {
                Object object = lazyList.getRaw(i);
                int n = fieldNumber;
                CodedOutputStreamWriter codedOutputStreamWriter = this;
                if (object instanceof String) {
                    codedOutputStreamWriter.output.writeString(n, (String)object);
                    continue;
                }
                codedOutputStreamWriter.output.writeBytes(n, (ByteString)object);
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            this.output.writeString(fieldNumber, value.get(i));
        }
    }

    @Override
    public final void writeBytesList(int fieldNumber, List<ByteString> value) throws IOException {
        for (int i = 0; i < value.size(); ++i) {
            this.output.writeBytes(fieldNumber, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeUInt32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeUInt32SizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeUInt32NoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeUInt32((int)var1_1, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSFixed32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                value.get(i).intValue();
                dataSize += CodedOutputStream.computeSFixed32SizeNoTag$134621();
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                int n = value.get(i);
                CodedOutputStream codedOutputStream = this.output;
                codedOutputStream.writeFixed32NoTag(n);
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            int n = value.get(i);
            void var5_7 = var1_1;
            CodedOutputStream codedOutputStream = this.output;
            codedOutputStream.writeFixed32((int)var5_7, n);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSFixed64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                value.get(i).longValue();
                dataSize += CodedOutputStream.computeSFixed64SizeNoTag$1349e2();
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                long l = value.get(i);
                CodedOutputStream codedOutputStream = this.output;
                codedOutputStream.writeFixed64NoTag(l);
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            long l = value.get(i);
            void var7_7 = var1_1;
            CodedOutputStream codedOutputStream = this.output;
            codedOutputStream.writeFixed64((int)var7_7, l);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSInt32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeSInt32SizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeSInt32NoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeSInt32((int)var1_1, value.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeSInt64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int i;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i = 0; i < value.size(); ++i) {
                dataSize += CodedOutputStream.computeSInt64SizeNoTag(value.get(i));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i = 0; i < value.size(); ++i) {
                this.output.writeSInt64NoTag(value.get(i));
            }
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            void var1_1;
            this.output.writeSInt64((int)var1_1, value.get(i));
        }
    }

    @Override
    public final void writeMessageList(int fieldNumber, List<?> value, Schema schema) throws IOException {
        for (int i = 0; i < value.size(); ++i) {
            this.writeMessage(fieldNumber, value.get(i), schema);
        }
    }

    @Override
    public final void writeGroupList(int fieldNumber, List<?> value, Schema schema) throws IOException {
        for (int i = 0; i < value.size(); ++i) {
            this.writeGroup(fieldNumber, value.get(i), schema);
        }
    }

    @Override
    public final <K, V> void writeMap(int fieldNumber, MapEntryLite.Metadata<K, V> metadata, Map<K, V> map) throws IOException {
        Iterator iterator;
        CodedOutputStream codedOutputStream = this.output;
        for (Map.Entry entry : iterator.entrySet()) {
            this.output.writeTag(fieldNumber, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, entry.getKey(), entry.getValue()));
            MapEntryLite.writeTo(this.output, metadata, entry.getKey(), entry.getValue());
        }
    }
}

