/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CodedOutputStream;
import androidx.datastore.preferences.protobuf.GeneratedMessageLite;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.LazyField;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.MessageLiteOrBuilder;
import androidx.datastore.preferences.protobuf.SmallSortedMap;
import androidx.datastore.preferences.protobuf.WireFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class FieldSet<T extends FieldDescriptorLite<T>> {
    private final SmallSortedMap<T, Object> fields;
    private boolean isImmutable;
    private boolean hasLazyField;
    private static final FieldSet DEFAULT_INSTANCE = new FieldSet(0);

    private FieldSet() {
        this.fields = SmallSortedMap.newFieldMap(16);
    }

    private FieldSet(byte by) {
        this(SmallSortedMap.newFieldMap(0));
        this.makeImmutable();
    }

    /*
     * WARNING - void declaration
     */
    private FieldSet(SmallSortedMap<T, Object> fields) {
        void var1_1;
        this.fields = var1_1;
        this.makeImmutable();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> emptySet() {
        return DEFAULT_INSTANCE;
    }

    final boolean isEmpty() {
        return this.fields.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final void makeImmutable() {
        if (this.isImmutable) {
            return;
        }
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            void var2_2;
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            if (!(entry.getValue() instanceof GeneratedMessageLite)) continue;
            ((GeneratedMessageLite)var2_2.getValue()).makeImmutable();
        }
        this.fields.makeImmutable();
        this.isImmutable = true;
    }

    public final boolean isImmutable() {
        return this.isImmutable;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldSet)) {
            return false;
        }
        FieldSet other = (FieldSet)o;
        return this.fields.equals(var1_1.fields);
    }

    public final int hashCode() {
        return this.fields.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public final FieldSet<T> clone() {
        void var1_1;
        FieldSet<FieldDescriptorLite> clone = new FieldSet<FieldDescriptorLite>();
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            clone.setField((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            void var3_4;
            clone.setField((FieldDescriptorLite)entry.getKey(), var3_4.getValue());
        }
        clone.hasLazyField = this.hasLazyField;
        return var1_1;
    }

    public final Iterator<Map.Entry<T, Object>> iterator() {
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.entrySet().iterator());
        }
        return this.fields.entrySet().iterator();
    }

    final Iterator<Map.Entry<T, Object>> descendingIterator() {
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.descendingEntrySet().iterator());
        }
        return this.fields.descendingEntrySet().iterator();
    }

    /*
     * WARNING - void declaration
     */
    public final Object getField(T descriptor) {
        void var1_1;
        Object o = this.fields.get(descriptor);
        if (o instanceof LazyField) {
            LazyField lazyField = (LazyField)o;
            throw null;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setField(T descriptor, Object value) {
        void var2_2;
        void var1_1;
        if (descriptor.isRepeated()) {
            void var3_3;
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
            ArrayList newList = new ArrayList();
            newList.addAll((List)((Object)value));
            for (Object element : newList) {
                FieldSet.verifyType(descriptor, element);
            }
            value = var3_3;
        } else {
            FieldSet.verifyType(descriptor, value);
        }
        if (value instanceof LazyField) {
            this.hasLazyField = true;
        }
        this.fields.put(var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void verifyType(T descriptor, Object value) {
        if (!FieldSet.isValidType(descriptor.getLiteType(), value)) {
            void var1_1;
            Object t;
            throw new IllegalArgumentException(String.format("Wrong object type used with protocol message reflection.\nField number: %d, field java type: %s, value type: %s\n", new Object[]{descriptor.getNumber(), t.getLiteType().getJavaType(), var1_1.getClass().getName()}));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isValidType(WireFormat.FieldType type, Object value) {
        WireFormat.FieldType fieldType;
        Internal.checkNotNull(value);
        switch (fieldType.getJavaType()) {
            case INT: {
                return value instanceof Integer;
            }
            case LONG: {
                return value instanceof Long;
            }
            case FLOAT: {
                return value instanceof Float;
            }
            case DOUBLE: {
                return value instanceof Double;
            }
            case BOOLEAN: {
                return value instanceof Boolean;
            }
            case STRING: {
                return value instanceof String;
            }
            case BYTE_STRING: {
                return value instanceof ByteString || value instanceof byte[];
            }
            case ENUM: {
                return value instanceof Integer || value instanceof Internal.EnumLite;
            }
            case MESSAGE: {
                void var1_1;
                return value instanceof MessageLite || var1_1 instanceof LazyField;
            }
        }
        return false;
    }

    public final boolean isInitialized() {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            if (FieldSet.isInitialized(this.fields.getArrayEntryAt(i))) continue;
            return false;
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            if (FieldSet.isInitialized(entry)) continue;
            return false;
        }
        return true;
    }

    private static <T extends FieldDescriptorLite<T>> boolean isInitialized(Map.Entry<T, Object> entry) {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            Object e2;
            if (e2.isRepeated()) {
                for (Object e2 : (List)entry.getValue()) {
                    if (FieldSet.isMessageFieldValueInitialized(e2)) continue;
                    return false;
                }
            } else {
                Map.Entry<T, Object> entry2;
                return FieldSet.isMessageFieldValueInitialized(entry2.getValue());
            }
        }
        return true;
    }

    private static boolean isMessageFieldValueInitialized(Object value) {
        Object object;
        if (value instanceof MessageLiteOrBuilder) {
            return ((MessageLiteOrBuilder)value).isInitialized();
        }
        if (object instanceof LazyField) {
            return true;
        }
        throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
    }

    /*
     * WARNING - void declaration
     */
    public final void mergeFrom(FieldSet<T> other) {
        for (int i = 0; i < other.fields.getNumArrayEntries(); ++i) {
            this.mergeFromField(other.fields.getArrayEntryAt(i));
        }
        for (Map.Entry<T, Object> entry : other.fields.getOverflowEntries()) {
            void var1_1;
            this.mergeFromField((Map.Entry<T, Object>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Object cloneIfMutable(Object value) {
        Object object;
        if (value instanceof byte[]) {
            void var1_1;
            byte[] byArray = (byte[])value;
            Object bytes = byArray;
            byte[] copy = new byte[byArray.length];
            System.arraycopy(bytes, 0, copy, 0, ((Object)object).length);
            return var1_1;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void mergeFromField(Map.Entry<T, Object> entry) {
        void var3_4;
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        Iterator otherValue = entry.getValue();
        if (otherValue instanceof LazyField) {
            LazyField lazyField = (LazyField)((Object)otherValue);
            throw null;
        }
        if (descriptor.isRepeated()) {
            ArrayList value = this.getField(descriptor);
            if (value == null) {
                value = new ArrayList();
            }
            otherValue = ((List)((Object)otherValue)).iterator();
            while (true) {
                if (!otherValue.hasNext()) {
                    this.fields.put((T)descriptor, (Object)value);
                    return;
                }
                Object element = otherValue.next();
                ((List)value).add(FieldSet.cloneIfMutable(element));
            }
        }
        if (descriptor.getLiteJavaType() != WireFormat.JavaType.MESSAGE) {
            void var1_1;
            void var2_2;
            this.fields.put(var2_2, FieldSet.cloneIfMutable(var1_1));
            return;
        }
        Object value = this.getField(descriptor);
        if (value == null) {
            this.fields.put((T)descriptor, FieldSet.cloneIfMutable(otherValue));
            return;
        }
        value = descriptor.internalMergeFrom(((MessageLite)value).toBuilder(), (MessageLite)((Object)otherValue)).build();
        this.fields.put((T)descriptor, (Object)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    static void writeElement(CodedOutputStream output, WireFormat.FieldType type, int number2, Object value) throws IOException {
        byte[] byArray;
        void var3_5;
        Object object;
        void var2_2;
        if (type == WireFormat.FieldType.GROUP) {
            CodedOutputStream codedOutputStream = output;
            output = (MessageLite)value;
            int n = number2;
            CodedOutputStream number2 = codedOutputStream;
            codedOutputStream.writeTag(n, 3);
            Object object2 = output;
            output = number2;
            object2.writeTo((CodedOutputStream)output);
            number2.writeTag(n, 4);
            return;
        }
        boolean bl = false;
        Object object3 = type;
        ((CodedOutputStream)output).writeTag((int)var2_2, ((WireFormat.FieldType)((Object)object3)).getWireType());
        CodedOutputStream codedOutputStream = object;
        object = var3_5;
        void var4_8 = byArray;
        object3 = codedOutputStream;
        switch (1.$SwitchMap$com$google$protobuf$WireFormat$FieldType[var4_8.ordinal()]) {
            case 1: {
                ((CodedOutputStream)object3).writeDoubleNoTag((Double)object);
                return;
            }
            case 2: {
                ((CodedOutputStream)object3).writeFloatNoTag(((Float)object).floatValue());
                return;
            }
            case 3: {
                long l = (Long)object;
                object = object3;
                object.writeUInt64NoTag(l);
                return;
            }
            case 4: {
                ((CodedOutputStream)object3).writeUInt64NoTag((Long)object);
                return;
            }
            case 5: {
                ((CodedOutputStream)object3).writeInt32NoTag((Integer)object);
                return;
            }
            case 6: {
                ((CodedOutputStream)object3).writeFixed64NoTag((Long)object);
                return;
            }
            case 7: {
                ((CodedOutputStream)object3).writeFixed32NoTag((Integer)object);
                return;
            }
            case 8: {
                ((CodedOutputStream)object3).writeBoolNoTag((Boolean)object);
                return;
            }
            case 9: {
                MessageLite messageLite = (MessageLite)object;
                object = object3;
                messageLite.writeTo((CodedOutputStream)object);
                return;
            }
            case 10: {
                ((CodedOutputStream)object3).writeMessageNoTag((MessageLite)object);
                return;
            }
            case 11: {
                if (object instanceof ByteString) {
                    ((CodedOutputStream)object3).writeBytesNoTag((ByteString)object);
                    return;
                }
                ((CodedOutputStream)object3).writeStringNoTag((String)object);
                return;
            }
            case 12: {
                if (object instanceof ByteString) {
                    ((CodedOutputStream)object3).writeBytesNoTag((ByteString)object);
                    return;
                }
                byArray = (byte[])object;
                object = object3;
                object.writeByteArrayNoTag(byArray, 0, byArray.length);
                return;
            }
            case 13: {
                ((CodedOutputStream)object3).writeUInt32NoTag((Integer)object);
                return;
            }
            case 14: {
                int n = (Integer)object;
                object = object3;
                object.writeFixed32NoTag(n);
                return;
            }
            case 15: {
                long l = (Long)object;
                object = object3;
                object.writeFixed64NoTag(l);
                return;
            }
            case 16: {
                ((CodedOutputStream)object3).writeSInt32NoTag((Integer)object);
                return;
            }
            case 17: {
                ((CodedOutputStream)object3).writeSInt64NoTag((Long)object);
                return;
            }
            case 18: {
                if (object instanceof Internal.EnumLite) {
                    int n = ((Internal.EnumLite)object).getNumber();
                    object = object3;
                    object.writeInt32NoTag(n);
                    return;
                }
                int n = (Integer)object;
                object = object3;
                object.writeInt32NoTag(n);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getSerializedSize() {
        void var1_1;
        int size = 0;
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            size += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            void var3_4;
            size += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), var3_4.getValue());
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final int getMessageSetSerializedSize() {
        void var1_1;
        int size = 0;
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            size += FieldSet.getMessageSetSerializedSize(this.fields.getArrayEntryAt(i));
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            void var3_4;
            size += FieldSet.getMessageSetSerializedSize(var3_4);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int getMessageSetSerializedSize(Map.Entry<T, Object> entry) {
        void var2_2;
        void var1_1;
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        Object value = entry.getValue();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !descriptor.isRepeated() && !descriptor.isPacked()) {
            Map.Entry entry2;
            if (value instanceof LazyField) {
                return CodedOutputStream.computeLazyFieldMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (LazyField)value);
            }
            return CodedOutputStream.computeMessageSetExtensionSize(((FieldDescriptorLite)entry2.getKey()).getNumber(), (MessageLite)value);
        }
        return FieldSet.computeFieldSize(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static int computeElementSize(WireFormat.FieldType type, int number, Object value) {
        void var2_2;
        WireFormat.FieldType fieldType;
        void var1_1;
        int tagSize = CodedOutputStream.computeTagSize(number);
        if (type == WireFormat.FieldType.GROUP) {
            tagSize <<= 1;
        }
        return (int)(var1_1 + FieldSet.computeElementSizeNoTag(fieldType, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private static int computeElementSizeNoTag(WireFormat.FieldType type, Object value) {
        WireFormat.FieldType fieldType;
        switch (fieldType) {
            case DOUBLE: {
                ((Double)value).doubleValue();
                return CodedOutputStream.computeDoubleSizeNoTag$13335c();
            }
            case FLOAT: {
                ((Float)value).floatValue();
                return CodedOutputStream.computeFloatSizeNoTag$133ade();
            }
            case INT64: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)value);
            }
            case UINT64: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)value);
            }
            case INT32: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)value);
            }
            case FIXED64: {
                ((Long)value).longValue();
                return CodedOutputStream.computeFixed64SizeNoTag$1349e2();
            }
            case FIXED32: {
                ((Integer)value).intValue();
                return CodedOutputStream.computeFixed32SizeNoTag$134621();
            }
            case BOOL: {
                ((Boolean)value).booleanValue();
                return CodedOutputStream.computeBoolSizeNoTag$1385f2();
            }
            case GROUP: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)value);
            }
            case BYTES: {
                if (value instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value);
                }
                return CodedOutputStream.computeByteArraySizeNoTag((byte[])value);
            }
            case STRING: {
                if (value instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value);
                }
                return CodedOutputStream.computeStringSizeNoTag((String)value);
            }
            case UINT32: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)value);
            }
            case SFIXED32: {
                ((Integer)value).intValue();
                return CodedOutputStream.computeSFixed32SizeNoTag$134621();
            }
            case SFIXED64: {
                ((Long)value).longValue();
                return CodedOutputStream.computeSFixed64SizeNoTag$1349e2();
            }
            case SINT32: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)value);
            }
            case SINT64: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)value);
            }
            case MESSAGE: {
                if (value instanceof LazyField) {
                    return CodedOutputStream.computeLazyFieldSizeNoTag((LazyField)value);
                }
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)value);
            }
            case ENUM: {
                void var1_1;
                if (value instanceof Internal.EnumLite) {
                    return CodedOutputStream.computeEnumSizeNoTag(((Internal.EnumLite)value).getNumber());
                }
                return CodedOutputStream.computeEnumSizeNoTag((Integer)var1_1);
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    /*
     * WARNING - void declaration
     */
    private static int computeFieldSize(FieldDescriptorLite<?> descriptor, Object value) {
        void var1_3;
        void var3_5;
        void var2_4;
        WireFormat.FieldType type = descriptor.getLiteType();
        int number = descriptor.getNumber();
        if (descriptor.isRepeated()) {
            void var0_2;
            if (descriptor.isPacked()) {
                int dataSize = 0;
                for (Object element : (List)((Object)value)) {
                    dataSize += FieldSet.computeElementSizeNoTag(type, element);
                }
                return dataSize + CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeUInt32SizeNoTag(dataSize);
            }
            int size = 0;
            for (Object element : (List)((Object)value)) {
                size += FieldSet.computeElementSize(type, number, element);
            }
            return (int)var0_2;
        }
        return FieldSet.computeElementSize((WireFormat.FieldType)var2_4, (int)var3_5, var1_3);
    }

    public static interface FieldDescriptorLite<T extends FieldDescriptorLite<T>>
    extends Comparable<T> {
        public int getNumber();

        public WireFormat.FieldType getLiteType();

        public WireFormat.JavaType getLiteJavaType();

        public boolean isRepeated();

        public boolean isPacked();

        public MessageLite.Builder internalMergeFrom(MessageLite.Builder var1, MessageLite var2);
    }
}

