/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.AbstractProtobufList;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.Internal$FloatList;
import androidx.datastore.preferences.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class FloatArrayList
extends AbstractProtobufList<Float>
implements Internal$FloatList,
PrimitiveNonBoxingCollection,
RandomAccess {
    private static final FloatArrayList EMPTY_LIST = new FloatArrayList(new float[0], 0);
    private float[] array;
    private int size;

    FloatArrayList() {
        this(new float[10], 0);
    }

    /*
     * WARNING - void declaration
     */
    private FloatArrayList(float[] other, int size) {
        void var2_2;
        void var1_1;
        this.array = var1_1;
        this.size = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void removeRange(int fromIndex, int toIndex) {
        void var1_1;
        void var2_2;
        this.ensureIsMutable();
        if (toIndex < fromIndex) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, toIndex, this.array, fromIndex, this.size - toIndex);
        this.size -= var2_2 - var1_1;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FloatArrayList)) {
            return super.equals(o);
        }
        FloatArrayList other = (FloatArrayList)o;
        if (this.size != other.size) {
            return false;
        }
        float[] arr = other.array;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.array[i]) == Float.floatToIntBits(arr[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int hashCode() {
        void var1_1;
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            result = result * 31 + Float.floatToIntBits(this.array[i]);
        }
        return (int)var1_1;
    }

    @Override
    public final int indexOf(Object element) {
        if (!(element instanceof Float)) {
            return -1;
        }
        float unboxedElement = ((Float)element).floatValue();
        int numElems = this.size();
        for (int i = 0; i < numElems; ++i) {
            if (this.array[i] != unboxedElement) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object element) {
        void var1_1;
        return this.indexOf(var1_1) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final void addFloat(float element) {
        void var1_1;
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            void var2_3;
            int n = this.size * 3 / 2 + 1;
            float[] newArray = new float[n];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = var2_3;
        }
        this.array[this.size++] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        void var1_1;
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof FloatArrayList)) {
            return super.addAll(collection);
        }
        FloatArrayList list = (FloatArrayList)collection;
        if (list.size == 0) {
            return false;
        }
        int n = Integer.MAX_VALUE - this.size;
        if (n < list.size) {
            throw new OutOfMemoryError();
        }
        int newSize = this.size + list.size;
        if (newSize > this.array.length) {
            this.array = Arrays.copyOf(this.array, newSize);
        }
        System.arraycopy(list.array, 0, this.array, this.size, var1_1.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureIndexInRange(int index) {
        if (index < 0 || index >= this.size) {
            void var1_1;
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage((int)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private String makeOutOfBoundsExceptionMessage(int index) {
        void var1_1;
        return "Index:" + (int)var1_1 + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

