/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.AbstractProtobufList;
import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.LazyStringList;
import androidx.datastore.preferences.protobuf.UnmodifiableLazyStringList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public final class LazyStringArrayList
extends AbstractProtobufList<String>
implements LazyStringList,
RandomAccess {
    private static final LazyStringArrayList EMPTY_LIST = new LazyStringArrayList();
    private final List<Object> list;

    public LazyStringArrayList() {
        this(10);
    }

    /*
     * WARNING - void declaration
     */
    public LazyStringArrayList(int initialCapacity) {
        this(new ArrayList<Object>((int)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private LazyStringArrayList(ArrayList<Object> list) {
        void var1_1;
        this.list = var1_1;
    }

    @Override
    public final int size() {
        return this.list.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<? extends String> c) {
        void var1_1;
        LazyStringArrayList lazyStringArrayList = this;
        return lazyStringArrayList.addAll(lazyStringArrayList.size(), (Collection<? extends String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(int index, Collection<? extends String> c) {
        void var1_1;
        void var2_2;
        void collection;
        this.ensureIsMutable();
        collection = c instanceof LazyStringList ? ((LazyStringList)c).getUnderlyingElements() : collection;
        boolean ret = this.list.addAll(index, (Collection<Object>)var2_2);
        ++this.modCount;
        return (boolean)var1_1;
    }

    @Override
    public final void clear() {
        this.ensureIsMutable();
        this.list.clear();
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void add(ByteString element) {
        void var1_1;
        this.ensureIsMutable();
        this.list.add(var1_1);
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object getRaw(int index) {
        void var1_1;
        return this.list.get((int)var1_1);
    }

    private static String asString(Object o) {
        Object object;
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof ByteString) {
            return ((ByteString)o).toStringUtf8();
        }
        return Internal.toStringUtf8((byte[])object);
    }

    @Override
    public final List<?> getUnderlyingElements() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public final LazyStringList getUnmodifiableView() {
        LazyStringArrayList lazyStringArrayList = this;
        if (super.isModifiable()) {
            return new UnmodifiableLazyStringList(this);
        }
        return this;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

