/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.LazyStringArrayList;
import androidx.datastore.preferences.protobuf.LazyStringList;
import androidx.datastore.preferences.protobuf.PrimitiveNonBoxingCollection;
import androidx.datastore.preferences.protobuf.UnmodifiableLazyStringList;
import androidx.datastore.preferences.protobuf.UnsafeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class ListFieldSchema {
    private static final ListFieldSchema FULL_INSTANCE = new ListFieldSchemaFull(0);
    private static final ListFieldSchema LITE_INSTANCE = new ListFieldSchemaLite(0);

    private ListFieldSchema() {
    }

    abstract <L> List<L> mutableListAt(Object var1, long var2);

    abstract void makeImmutableListAt(Object var1, long var2);

    abstract <L> void mergeListsAt(Object var1, Object var2, long var3);

    static ListFieldSchema full() {
        return FULL_INSTANCE;
    }

    static ListFieldSchema lite() {
        return LITE_INSTANCE;
    }

    /* synthetic */ ListFieldSchema(byte by) {
        this();
    }

    static final class ListFieldSchemaLite
    extends ListFieldSchema {
        private ListFieldSchemaLite() {
            super((byte)0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final <L> List<L> mutableListAt(Object message, long offset) {
            Internal.ProtobufList list = ListFieldSchemaLite.getProtobufList(message, offset);
            if (!list.isModifiable()) {
                void var2_2;
                void var1_1;
                int size = list.size();
                list = list.mutableCopyWithCapacity(size == 0 ? 10 : size << 1);
                UnsafeUtil.putObject(var1_1, (long)var2_2, list);
            }
            return list;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void makeImmutableListAt(Object message, long offset) {
            void var2_2;
            Internal.ProtobufList protobufList = ListFieldSchemaLite.getProtobufList(message, (long)var2_2);
            protobufList.makeImmutable();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final <E> void mergeListsAt(Object msg, Object otherMsg, long offset) {
            void var2_2;
            void var3_3;
            void var1_1;
            Internal.ProtobufList<E> merged;
            Internal.ProtobufList<E> mine = ListFieldSchemaLite.getProtobufList(msg, offset);
            Internal.ProtobufList<E> other = ListFieldSchemaLite.getProtobufList(otherMsg, offset);
            int size = mine.size();
            int otherSize = other.size();
            if (size > 0 && otherSize > 0) {
                if (!mine.isModifiable()) {
                    mine = mine.mutableCopyWithCapacity(size + otherSize);
                }
                mine.addAll(other);
            }
            merged = size > 0 ? mine : merged;
            UnsafeUtil.putObject(var1_1, (long)var3_3, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private static <E> Internal.ProtobufList<E> getProtobufList(Object message, long offset) {
            void var1_1;
            return (Internal.ProtobufList)UnsafeUtil.getObject(message, (long)var1_1);
        }

        /* synthetic */ ListFieldSchemaLite(byte by) {
            this();
        }
    }

    static final class ListFieldSchemaFull
    extends ListFieldSchema {
        private static final Class<?> UNMODIFIABLE_LIST_CLASS = Collections.unmodifiableList(Collections.emptyList()).getClass();

        private ListFieldSchemaFull() {
            super((byte)0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final <L> List<L> mutableListAt(Object message, long offset) {
            void var2_2;
            return ListFieldSchemaFull.mutableListAt(message, (long)var2_2, 10);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void makeImmutableListAt(Object message, long offset) {
            void var2_2;
            void var1_1;
            List immutable;
            List list = (List)UnsafeUtil.getObject(message, offset);
            if (list instanceof LazyStringList) {
                immutable = ((LazyStringList)list).getUnmodifiableView();
            } else {
                if (UNMODIFIABLE_LIST_CLASS.isAssignableFrom(immutable.getClass())) {
                    return;
                }
                if (immutable instanceof PrimitiveNonBoxingCollection && immutable instanceof Internal.ProtobufList) {
                    if (((Internal.ProtobufList)immutable).isModifiable()) {
                        ((Internal.ProtobufList)immutable).makeImmutable();
                    }
                    return;
                }
                immutable = Collections.unmodifiableList(immutable);
            }
            UnsafeUtil.putObject(var1_1, (long)var2_2, immutable);
        }

        /*
         * WARNING - void declaration
         */
        private static <L> List<L> mutableListAt(Object message, long offset, int additionalCapacity) {
            List list = ListFieldSchemaFull.getList(message, offset);
            if (list.isEmpty()) {
                list = list instanceof LazyStringList ? new LazyStringArrayList(additionalCapacity) : (list instanceof PrimitiveNonBoxingCollection && list instanceof Internal.ProtobufList ? ((Internal.ProtobufList)list).mutableCopyWithCapacity(additionalCapacity) : new ArrayList(additionalCapacity));
                UnsafeUtil.putObject(message, offset, list);
            } else if (UNMODIFIABLE_LIST_CLASS.isAssignableFrom(list.getClass())) {
                ArrayList newList = new ArrayList(list.size() + additionalCapacity);
                newList.addAll(list);
                list = newList;
                UnsafeUtil.putObject(message, offset, list);
            } else if (list instanceof UnmodifiableLazyStringList) {
                void var3_4;
                void newList;
                LazyStringArrayList newList2 = new LazyStringArrayList(list.size() + newList);
                newList2.addAll((UnmodifiableLazyStringList)list);
                list = var3_4;
                UnsafeUtil.putObject(message, offset, list);
            } else if (list instanceof PrimitiveNonBoxingCollection && list instanceof Internal.ProtobufList && !((Internal.ProtobufList)list).isModifiable()) {
                void var1_1;
                Object object;
                void var3_2;
                list = ((Internal.ProtobufList)list).mutableCopyWithCapacity(list.size() + var3_2);
                UnsafeUtil.putObject(object, (long)var1_1, list);
            }
            return list;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final <E> void mergeListsAt(Object msg, Object otherMsg, long offset) {
            void var2_2;
            void var3_3;
            void var1_1;
            List merged;
            List<E> other = ListFieldSchemaFull.getList(otherMsg, offset);
            List mine = ListFieldSchemaFull.mutableListAt(msg, offset, other.size());
            int size = mine.size();
            int otherSize = other.size();
            if (size > 0 && otherSize > 0) {
                mine.addAll(other);
            }
            merged = size > 0 ? mine : merged;
            UnsafeUtil.putObject(var1_1, (long)var3_3, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private static <E> List<E> getList(Object message, long offset) {
            void var1_1;
            return (List)UnsafeUtil.getObject(message, (long)var1_1);
        }

        /* synthetic */ ListFieldSchemaFull(byte by) {
            this();
        }
    }
}

