/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ExtensionSchemas;
import androidx.datastore.preferences.protobuf.GeneratedMessageInfoFactory;
import androidx.datastore.preferences.protobuf.GeneratedMessageLite;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.ListFieldSchema;
import androidx.datastore.preferences.protobuf.MapFieldSchemas;
import androidx.datastore.preferences.protobuf.MessageInfo;
import androidx.datastore.preferences.protobuf.MessageInfoFactory;
import androidx.datastore.preferences.protobuf.MessageSchema;
import androidx.datastore.preferences.protobuf.MessageSetSchema;
import androidx.datastore.preferences.protobuf.NewInstanceSchemas;
import androidx.datastore.preferences.protobuf.ProtoSyntax;
import androidx.datastore.preferences.protobuf.Schema;
import androidx.datastore.preferences.protobuf.SchemaFactory;
import androidx.datastore.preferences.protobuf.SchemaUtil;

final class ManifestSchemaFactory
implements SchemaFactory {
    private final MessageInfoFactory messageInfoFactory;
    private static final MessageInfoFactory EMPTY_FACTORY = new MessageInfoFactory(){

        @Override
        public final boolean isSupported(Class<?> clazz) {
            return false;
        }

        @Override
        public final MessageInfo messageInfoFor(Class<?> clazz) {
            throw new IllegalStateException("This should never be called.");
        }
    };

    public ManifestSchemaFactory() {
        this(new CompositeMessageInfoFactory(GeneratedMessageInfoFactory.getInstance(), ManifestSchemaFactory.getDescriptorMessageInfoFactory()));
    }

    /*
     * WARNING - void declaration
     */
    private ManifestSchemaFactory(MessageInfoFactory messageInfoFactory) {
        void var1_1;
        this.messageInfoFactory = (MessageInfoFactory)Internal.checkNotNull(var1_1, "messageInfoFactory");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final <T> Schema<T> createSchema(Class<T> messageType) {
        MessageSchema messageSchema;
        void var2_2;
        void var1_1;
        SchemaUtil.requireGeneratedMessage(messageType);
        MessageInfo messageInfo = this.messageInfoFactory.messageInfoFor(messageType);
        if (messageInfo.isMessageSetWireFormat()) {
            if (!GeneratedMessageLite.class.isAssignableFrom(messageType)) return MessageSetSchema.newSchema(SchemaUtil.proto2UnknownFieldSetSchema(), ExtensionSchemas.full(), messageInfo.getDefaultInstance());
            return MessageSetSchema.newSchema(SchemaUtil.unknownFieldSetLiteSchema(), ExtensionSchemas.lite(), messageInfo.getDefaultInstance());
        }
        if (GeneratedMessageLite.class.isAssignableFrom((Class<?>)var1_1)) {
            if (!ManifestSchemaFactory.isProto2((MessageInfo)var2_2)) return MessageSchema.newSchema$10b86a8e((MessageInfo)var2_2, NewInstanceSchemas.lite(), ListFieldSchema.lite(), SchemaUtil.unknownFieldSetLiteSchema(), null, MapFieldSchemas.lite());
            messageSchema = MessageSchema.newSchema$10b86a8e((MessageInfo)var2_2, NewInstanceSchemas.lite(), ListFieldSchema.lite(), SchemaUtil.unknownFieldSetLiteSchema(), ExtensionSchemas.lite(), MapFieldSchemas.lite());
            return messageSchema;
        } else {
            if (ManifestSchemaFactory.isProto2((MessageInfo)var2_2)) {
                return MessageSchema.newSchema$10b86a8e((MessageInfo)var2_2, NewInstanceSchemas.full(), ListFieldSchema.full(), SchemaUtil.proto2UnknownFieldSetSchema(), ExtensionSchemas.full(), MapFieldSchemas.full());
            }
            messageSchema = MessageSchema.newSchema$10b86a8e((MessageInfo)var2_2, NewInstanceSchemas.full(), ListFieldSchema.full(), SchemaUtil.proto3UnknownFieldSetSchema(), null, MapFieldSchemas.full());
        }
        return messageSchema;
    }

    private static boolean isProto2(MessageInfo messageInfo) {
        return messageInfo.getSyntax() == ProtoSyntax.PROTO2;
    }

    private static MessageInfoFactory getDescriptorMessageInfoFactory() {
        try {
            Class<?> clazz = Class.forName("androidx.datastore.preferences.protobuf.DescriptorMessageInfoFactory");
            return (MessageInfoFactory)clazz.getDeclaredMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return EMPTY_FACTORY;
        }
    }

    static final class CompositeMessageInfoFactory
    implements MessageInfoFactory {
        private MessageInfoFactory[] factories;

        /*
         * WARNING - void declaration
         */
        CompositeMessageInfoFactory(MessageInfoFactory ... factories) {
            void var1_1;
            this.factories = var1_1;
        }

        @Override
        public final boolean isSupported(Class<?> clazz) {
            MessageInfoFactory[] messageInfoFactoryArray = this.factories;
            int n = this.factories.length;
            for (int i = 0; i < n; ++i) {
                MessageInfoFactory messageInfoFactory = messageInfoFactoryArray[i];
                if (!messageInfoFactory.isSupported(clazz)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final MessageInfo messageInfoFor(Class<?> clazz) {
            void var1_1;
            MessageInfoFactory[] messageInfoFactoryArray = this.factories;
            int n = this.factories.length;
            for (int i = 0; i < n; ++i) {
                MessageInfoFactory factory = messageInfoFactoryArray[i];
                if (!factory.isSupported(clazz)) continue;
                return factory.messageInfoFor(clazz);
            }
            throw new UnsupportedOperationException("No factory is available for message type: " + var1_1.getName());
        }
    }
}

