/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.Internal;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class MapFieldLite<K, V>
extends LinkedHashMap<K, V> {
    private boolean isMutable = true;
    private static final MapFieldLite<?, ?> EMPTY_MAP_FIELD = new MapFieldLite();

    private MapFieldLite() {
    }

    /*
     * WARNING - void declaration
     */
    private MapFieldLite(Map<K, V> mapData) {
        super(var1_1);
        void var1_1;
    }

    public static <K, V> MapFieldLite<K, V> emptyMapField() {
        return EMPTY_MAP_FIELD;
    }

    /*
     * WARNING - void declaration
     */
    public final void mergeFrom(MapFieldLite<K, V> other) {
        this.ensureMutable();
        if (!other.isEmpty()) {
            void var1_1;
            this.putAll((Map<? extends K, ? extends V>)var1_1);
        }
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        return super.entrySet();
    }

    @Override
    public final void clear() {
        this.ensureMutable();
        super.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V put(K key, V value) {
        void var2_2;
        void var1_1;
        this.ensureMutable();
        Internal.checkNotNull(key);
        Internal.checkNotNull(value);
        return super.put(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        void var1_1;
        this.ensureMutable();
        Map<K, V> map = m;
        for (K k : map.keySet()) {
            Internal.checkNotNull(k);
            Internal.checkNotNull(map.get(k));
        }
        super.putAll(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V remove(Object key) {
        void var1_1;
        this.ensureMutable();
        return super.remove(var1_1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean equals(Object object) {
        Object v;
        Map.Entry entry;
        if (!(object instanceof Map)) return false;
        Object object2 = this;
        Map map = (Map)object2;
        if (object2 == map) return true;
        if (object2.size() != map.size()) {
            return false;
        }
        object2 = object2.entrySet().iterator();
        do {
            if (!object2.hasNext()) return true;
            entry = (Map.Entry)object2.next();
            if (!map.containsKey(entry.getKey())) {
                return false;
            }
            v = map.get(entry.getKey());
        } while ((entry = entry.getValue()) instanceof byte[] && v instanceof byte[] ? Arrays.equals((byte[])entry, (byte[])v) : ((Object)entry).equals(v));
        return false;
    }

    private static int calculateHashCodeForObject(Object a) {
        Object object;
        if (a instanceof byte[]) {
            return Internal.hashCode((byte[])a);
        }
        if (a instanceof Internal.EnumLite) {
            throw new UnsupportedOperationException();
        }
        return object.hashCode();
    }

    @Override
    public final int hashCode() {
        MapFieldLite mapFieldLite = this;
        int n = 0;
        for (Map.Entry entry : mapFieldLite.entrySet()) {
            n += MapFieldLite.calculateHashCodeForObject(entry.getKey()) ^ MapFieldLite.calculateHashCodeForObject(entry.getValue());
        }
        return n;
    }

    public final MapFieldLite<K, V> mutableCopy() {
        if (this.isEmpty()) {
            return new MapFieldLite<K, V>();
        }
        return new MapFieldLite<K, V>(this);
    }

    public final void makeImmutable() {
        this.isMutable = false;
    }

    public final boolean isMutable() {
        return this.isMutable;
    }

    private void ensureMutable() {
        MapFieldLite mapFieldLite = this;
        if (!mapFieldLite.isMutable) {
            throw new UnsupportedOperationException();
        }
    }

    static {
        MapFieldLite mapFieldLite = EMPTY_MAP_FIELD;
        EMPTY_MAP_FIELD.isMutable = false;
    }
}

