/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.GeneratedMessageLite;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.TextFormatEscaper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

final class MessageLiteToString {
    private static final char[] INDENT_BUFFER = new char[80];

    /*
     * WARNING - void declaration
     */
    static String toString(MessageLite messageLite, String commentString) {
        void var2_2;
        MessageLite messageLite2;
        void var1_1;
        StringBuilder buffer = new StringBuilder();
        buffer.append("# ").append((String)var1_1);
        MessageLiteToString.reflectivePrintWithIndent(messageLite2, buffer, 0);
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void reflectivePrintWithIndent(MessageLite messageLite, StringBuilder buffer, int indent) {
        Iterator<Map.Entry<GeneratedMessageLite.ExtensionDescriptor, Object>> iter;
        HashSet<String> setters = new HashSet<String>();
        HashMap<String, Method> hazzers = new HashMap<String, Method>();
        TreeMap<String, Method> getters = new TreeMap<String, Method>();
        for (Method method : messageLite.getClass().getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getName().length() < 3) continue;
            if (method.getName().startsWith("set")) {
                setters.add(method.getName());
                continue;
            }
            if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
            if (method.getName().startsWith("has")) {
                hazzers.put(method.getName(), method);
                continue;
            }
            if (!method.getName().startsWith("get")) continue;
            getters.put(method.getName(), method);
        }
        for (Map.Entry entry : getters.entrySet()) {
            boolean bl;
            Method mapMethod;
            Method listMethod;
            String suffix = ((String)entry.getKey()).substring(3);
            if (suffix.endsWith("List") && !suffix.endsWith("OrBuilderList") && !suffix.equals("List") && (listMethod = (Method)entry.getValue()) != null && listMethod.getReturnType().equals(List.class)) {
                MessageLiteToString.printField(buffer, indent, suffix.substring(0, suffix.length() - 4), GeneratedMessageLite.invokeOrDie(listMethod, messageLite, new Object[0]));
                continue;
            }
            if (suffix.endsWith("Map") && !suffix.equals("Map") && (mapMethod = (Method)entry.getValue()) != null && mapMethod.getReturnType().equals(Map.class) && !mapMethod.isAnnotationPresent(Deprecated.class) && Modifier.isPublic(mapMethod.getModifiers())) {
                MessageLiteToString.printField(buffer, indent, suffix.substring(0, suffix.length() - 3), GeneratedMessageLite.invokeOrDie(mapMethod, messageLite, new Object[0]));
                continue;
            }
            if (!setters.contains("set" + suffix) || suffix.endsWith("Bytes") && getters.containsKey("get" + suffix.substring(0, suffix.length() - 5))) continue;
            Method getMethod = (Method)entry.getValue();
            Method method = (Method)hazzers.get("has" + suffix);
            if (getMethod == null) continue;
            Object value = GeneratedMessageLite.invokeOrDie(getMethod, messageLite, new Object[0]);
            if (method == null) {
                boolean bl2;
                Object object = value;
                if (object instanceof Boolean) {
                    bl2 = !((Boolean)object).booleanValue();
                } else if (object instanceof Integer) {
                    bl2 = (Integer)object == 0;
                } else if (object instanceof Float) {
                    bl2 = Float.floatToRawIntBits(((Float)object).floatValue()) == 0;
                } else if (object instanceof Double) {
                    bl2 = Double.doubleToRawLongBits((Double)object) == 0L;
                } else if (object instanceof String) {
                    bl2 = object.equals("");
                } else if (object instanceof ByteString) {
                    bl2 = object.equals(ByteString.EMPTY);
                } else if (object instanceof MessageLite) {
                    Object object2 = object;
                    bl2 = object2 == ((MessageLite)object2).getDefaultInstanceForType();
                } else {
                    bl2 = object instanceof Enum ? ((Enum)object).ordinal() == 0 : false;
                }
                bl = !bl2;
            } else {
                boolean bl3;
                bl = bl3 = ((Boolean)GeneratedMessageLite.invokeOrDie(method, messageLite, new Object[0])).booleanValue();
            }
            if (!bl) continue;
            MessageLiteToString.printField(buffer, indent, suffix, value);
        }
        if (messageLite instanceof GeneratedMessageLite.ExtendableMessage && (iter = ((GeneratedMessageLite.ExtendableMessage)messageLite).extensions.iterator()).hasNext()) {
            Map.Entry<GeneratedMessageLite.ExtensionDescriptor, Object> entry = iter.next();
            StringBuilder stringBuilder = buffer;
            int n = indent;
            StringBuilder stringBuilder2 = new StringBuilder("[");
            Object object = messageLite = entry.getKey();
            throw null;
        }
        if (((GeneratedMessageLite)messageLite).unknownFields != null) {
            void var2_2;
            void var1_1;
            MessageLite messageLite2;
            ((GeneratedMessageLite)messageLite2).unknownFields.printWithIndent((StringBuilder)var1_1, (int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void printField(StringBuilder buffer, int indent, String name, Object object) {
        StringBuilder stringBuilder;
        void var3_3;
        String string;
        String string2;
        if (object instanceof List) {
            object = (List)((Object)object);
            object = object.iterator();
            while (object.hasNext()) {
                Map.Entry entry = object.next();
                MessageLiteToString.printField(buffer, indent, name, entry);
            }
            return;
        }
        if (object instanceof Map) {
            object = (Map)((Object)object);
            for (Map.Entry entry : object.entrySet()) {
                MessageLiteToString.printField(buffer, indent, name, entry);
            }
            return;
        }
        buffer.append('\n');
        MessageLiteToString.indent(indent, buffer);
        if (string2.isEmpty()) {
            string = string2;
        } else {
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append(Character.toLowerCase(string2.charAt(0)));
            for (int i = 1; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (Character.isUpperCase(c)) {
                    stringBuilder2.append("_");
                }
                stringBuilder2.append(Character.toLowerCase(c));
            }
            string = stringBuilder2.toString();
        }
        buffer.append(string);
        if (object instanceof String) {
            string2 = (String)((Object)object);
            buffer.append(": \"").append(TextFormatEscaper.escapeBytes(ByteString.copyFromUtf8(string2))).append('\"');
            return;
        }
        if (object instanceof ByteString) {
            buffer.append(": \"").append(TextFormatEscaper.escapeBytes((ByteString)((Object)object))).append('\"');
            return;
        }
        if (object instanceof GeneratedMessageLite) {
            buffer.append(" {");
            MessageLiteToString.reflectivePrintWithIndent((GeneratedMessageLite)((Object)object), buffer, indent + 2);
            buffer.append("\n");
            MessageLiteToString.indent(indent, buffer);
            buffer.append("}");
            return;
        }
        if (object instanceof Map.Entry) {
            void var1_1;
            buffer.append(" {");
            Map.Entry entry = (Map.Entry)((Object)object);
            MessageLiteToString.printField(buffer, indent + 2, "key", entry.getKey());
            MessageLiteToString.printField(buffer, indent + 2, "value", var3_3.getValue());
            buffer.append("\n");
            MessageLiteToString.indent((int)var1_1, buffer);
            buffer.append("}");
            return;
        }
        stringBuilder.append(": ").append(var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void indent(int indent, StringBuilder buffer) {
        while (indent > 0) {
            void var2_2;
            int partialIndent = indent;
            if (partialIndent > INDENT_BUFFER.length) {
                partialIndent = INDENT_BUFFER.length;
            }
            buffer.append(INDENT_BUFFER, 0, partialIndent);
            indent -= var2_2;
        }
    }

    static {
        Arrays.fill(INDENT_BUFFER, ' ');
    }
}

