/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.AbstractProtobufList;
import java.util.Arrays;
import java.util.RandomAccess;

final class ProtobufArrayList<E>
extends AbstractProtobufList<E>
implements RandomAccess {
    private static final ProtobufArrayList<Object> EMPTY_LIST = new ProtobufArrayList<Object>(new Object[0], 0);
    private E[] array;
    private int size;

    public static <E> ProtobufArrayList<E> emptyList() {
        return EMPTY_LIST;
    }

    ProtobufArrayList() {
        this(new Object[10], 0);
    }

    /*
     * WARNING - void declaration
     */
    private ProtobufArrayList(E[] array, int size) {
        void var2_2;
        void var1_1;
        this.array = var1_1;
        this.size = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(E element) {
        void var1_1;
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            void var2_3;
            int length = this.size * 3 / 2 + 1;
            E[] newArray = Arrays.copyOf(this.array, length);
            this.array = var2_3;
        }
        this.array[this.size++] = var1_1;
        ++this.modCount;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void add(int index, E element) {
        void var2_2;
        this.ensureIsMutable();
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        } else {
            void var3_4;
            int n = this.size * 3 / 2 + 1;
            int n2 = n;
            n2 = n;
            Object[] newArray = new Object[n];
            System.arraycopy(this.array, 0, newArray, 0, index);
            System.arraycopy(this.array, index, newArray, index + 1, this.size - index);
            this.array = var3_4;
        }
        this.array[var1_1] = var2_2;
        ++this.size;
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E get(int index) {
        void var1_1;
        this.ensureIndexInRange(index);
        return this.array[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E remove(int index) {
        void var2_2;
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        E value = this.array[index];
        if (index < this.size - 1) {
            void var1_1;
            System.arraycopy(this.array, index + 1, this.array, index, this.size - var1_1 - 1);
        }
        --this.size;
        ++this.modCount;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E set(int index, E element) {
        void var3_3;
        void var2_2;
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        E toReturn = this.array[index];
        this.array[var1_1] = var2_2;
        ++this.modCount;
        return var3_3;
    }

    @Override
    public final int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureIndexInRange(int index) {
        if (index < 0 || index >= this.size) {
            void var1_1;
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage((int)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private String makeOutOfBoundsExceptionMessage(int index) {
        void var1_1;
        return "Index:" + (int)var1_1 + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

