/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CodedOutputStream;
import androidx.datastore.preferences.protobuf.ExtensionSchema;
import androidx.datastore.preferences.protobuf.FieldSet;
import androidx.datastore.preferences.protobuf.GeneratedMessageLite;
import androidx.datastore.preferences.protobuf.IntArrayList;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.LazyFieldLite;
import androidx.datastore.preferences.protobuf.LazyStringList;
import androidx.datastore.preferences.protobuf.LongArrayList;
import androidx.datastore.preferences.protobuf.MapFieldSchema;
import androidx.datastore.preferences.protobuf.MessageLite;
import androidx.datastore.preferences.protobuf.Schema;
import androidx.datastore.preferences.protobuf.UnknownFieldSchema;
import androidx.datastore.preferences.protobuf.UnknownFieldSetLiteSchema;
import androidx.datastore.preferences.protobuf.UnsafeUtil;
import androidx.datastore.preferences.protobuf.Writer;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

final class SchemaUtil {
    private static final Class<?> GENERATED_MESSAGE_CLASS = SchemaUtil.getGeneratedMessageClass();
    private static final UnknownFieldSchema<?, ?> PROTO2_UNKNOWN_FIELD_SET_SCHEMA = SchemaUtil.getUnknownFieldSetSchema(false);
    private static final UnknownFieldSchema<?, ?> PROTO3_UNKNOWN_FIELD_SET_SCHEMA = SchemaUtil.getUnknownFieldSetSchema(true);
    private static final UnknownFieldSchema<?, ?> UNKNOWN_FIELD_SET_LITE_SCHEMA = new UnknownFieldSetLiteSchema();

    public static void requireGeneratedMessage(Class<?> messageType) {
        Class<?> clazz;
        if (!GeneratedMessageLite.class.isAssignableFrom(messageType) && GENERATED_MESSAGE_CLASS != null && !GENERATED_MESSAGE_CLASS.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Message classes must extend GeneratedMessageV3 or GeneratedMessageLite");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeDoubleList(int fieldNumber, List<Double> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeDoubleList(n, (List<Double>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeFloatList(int fieldNumber, List<Float> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeFloatList(n, (List<Float>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeInt64List(int fieldNumber, List<Long> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeInt64List(n, (List<Long>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeUInt64List(int fieldNumber, List<Long> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeUInt64List(n, (List<Long>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeSInt64List(int fieldNumber, List<Long> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeSInt64List(n, (List<Long>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeFixed64List(int fieldNumber, List<Long> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeFixed64List(n, (List<Long>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeSFixed64List(int fieldNumber, List<Long> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeSFixed64List(n, (List<Long>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeInt32List(int fieldNumber, List<Integer> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeInt32List(n, (List<Integer>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeUInt32List(int fieldNumber, List<Integer> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeUInt32List(n, (List<Integer>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeSInt32List(int fieldNumber, List<Integer> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeSInt32List(n, (List<Integer>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeFixed32List(int fieldNumber, List<Integer> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeFixed32List(n, (List<Integer>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeSFixed32List(int fieldNumber, List<Integer> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeSFixed32List(n, (List<Integer>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeEnumList(int fieldNumber, List<Integer> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeEnumList(n, (List<Integer>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeBoolList(int fieldNumber, List<Boolean> value, Writer writer, boolean packed) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeBoolList(n, (List<Boolean>)var1_1, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeStringList(int fieldNumber, List<String> value, Writer writer) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeStringList(n, (List<String>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeBytesList(int fieldNumber, List<ByteString> value, Writer writer) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeBytesList(n, (List<ByteString>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeMessageList(int fieldNumber, List<?> value, Writer writer, Schema schema) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeMessageList(n, (List<?>)var1_1, (Schema)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeGroupList(int fieldNumber, List<?> value, Writer writer, Schema schema) throws IOException {
        if (value != null && !value.isEmpty()) {
            void var3_3;
            void var1_1;
            int n;
            void var2_2;
            var2_2.writeGroupList(n, (List<?>)var1_1, (Schema)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeInt64ListNoTag(List<Long> list) {
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof LongArrayList) {
            LongArrayList primitiveList = (LongArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeInt64SizeNoTag(primitiveList.getLong(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                List<Long> list2;
                size += CodedOutputStream.computeInt64SizeNoTag(list2.get(i));
            }
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeInt64List(int fieldNumber, List<Long> list, boolean packed) {
        int n;
        void var1_1;
        int n2 = list.size();
        if (n2 == 0) {
            return 0;
        }
        n2 = SchemaUtil.computeSizeInt64ListNoTag(list);
        return n2 + var1_1.size() * CodedOutputStream.computeTagSize(n);
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeUInt64ListNoTag(List<Long> list) {
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof LongArrayList) {
            LongArrayList primitiveList = (LongArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeUInt64SizeNoTag(primitiveList.getLong(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                List<Long> list2;
                size += CodedOutputStream.computeUInt64SizeNoTag(list2.get(i));
            }
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeUInt64List(int fieldNumber, List<Long> list, boolean packed) {
        int n;
        void var2_3;
        void var1_1;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int n2 = SchemaUtil.computeSizeUInt64ListNoTag((List<Long>)var1_1);
        return n2 + var2_3 * CodedOutputStream.computeTagSize(n);
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeSInt64ListNoTag(List<Long> list) {
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof LongArrayList) {
            LongArrayList primitiveList = (LongArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeSInt64SizeNoTag(primitiveList.getLong(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                List<Long> list2;
                size += CodedOutputStream.computeSInt64SizeNoTag(list2.get(i));
            }
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeSInt64List(int fieldNumber, List<Long> list, boolean packed) {
        int n;
        void var2_3;
        void var1_1;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int n2 = SchemaUtil.computeSizeSInt64ListNoTag((List<Long>)var1_1);
        return n2 + var2_3 * CodedOutputStream.computeTagSize(n);
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeEnumListNoTag(List<Integer> list) {
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof IntArrayList) {
            IntArrayList primitiveList = (IntArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeEnumSizeNoTag(primitiveList.getInt(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                List<Integer> list2;
                size += CodedOutputStream.computeEnumSizeNoTag(list2.get(i));
            }
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeEnumList(int fieldNumber, List<Integer> list, boolean packed) {
        int n;
        void var2_3;
        void var1_1;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int n2 = SchemaUtil.computeSizeEnumListNoTag((List<Integer>)var1_1);
        return n2 + var2_3 * CodedOutputStream.computeTagSize(n);
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeInt32ListNoTag(List<Integer> list) {
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof IntArrayList) {
            IntArrayList primitiveList = (IntArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeInt32SizeNoTag(primitiveList.getInt(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                List<Integer> list2;
                size += CodedOutputStream.computeInt32SizeNoTag(list2.get(i));
            }
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeInt32List(int fieldNumber, List<Integer> list, boolean packed) {
        int n;
        void var2_3;
        void var1_1;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int n2 = SchemaUtil.computeSizeInt32ListNoTag((List<Integer>)var1_1);
        return n2 + var2_3 * CodedOutputStream.computeTagSize(n);
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeUInt32ListNoTag(List<Integer> list) {
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof IntArrayList) {
            IntArrayList primitiveList = (IntArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeUInt32SizeNoTag(primitiveList.getInt(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                List<Integer> list2;
                size += CodedOutputStream.computeUInt32SizeNoTag(list2.get(i));
            }
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeUInt32List(int fieldNumber, List<Integer> list, boolean packed) {
        int n;
        void var2_3;
        void var1_1;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int n2 = SchemaUtil.computeSizeUInt32ListNoTag((List<Integer>)var1_1);
        return n2 + var2_3 * CodedOutputStream.computeTagSize(n);
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeSInt32ListNoTag(List<Integer> list) {
        void var2_3;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        if (list instanceof IntArrayList) {
            IntArrayList primitiveList = (IntArrayList)list;
            for (int i = 0; i < length; ++i) {
                size += CodedOutputStream.computeSInt32SizeNoTag(primitiveList.getInt(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                List<Integer> list2;
                size += CodedOutputStream.computeSInt32SizeNoTag(list2.get(i));
            }
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeSInt32List(int fieldNumber, List<Integer> list, boolean packed) {
        int n;
        void var2_3;
        void var1_1;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int n2 = SchemaUtil.computeSizeSInt32ListNoTag((List<Integer>)var1_1);
        return n2 + var2_3 * CodedOutputStream.computeTagSize(n);
    }

    static int computeSizeFixed32ListNoTag(List<?> list) {
        return list.size() << 2;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeFixed32List(int fieldNumber, List<?> list, boolean packed) {
        int n;
        void var1_2;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        return (int)(var1_2 * CodedOutputStream.computeFixed32Size(n, 0));
    }

    static int computeSizeFixed64ListNoTag(List<?> list) {
        return list.size() << 3;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeFixed64List(int fieldNumber, List<?> list, boolean packed) {
        int n;
        void var1_2;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        return (int)(var1_2 * CodedOutputStream.computeFixed64Size(n, 0L));
    }

    static int computeSizeBoolListNoTag(List<?> list) {
        return list.size();
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeBoolList(int fieldNumber, List<?> list, boolean packed) {
        int n;
        void var1_2;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        return (int)(var1_2 * CodedOutputStream.computeBoolSize(n, true));
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeStringList(int fieldNumber, List<?> list) {
        int n;
        void var1_1;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = length * CodedOutputStream.computeTagSize(fieldNumber);
        if (list instanceof LazyStringList) {
            LazyStringList lazyList = (LazyStringList)list;
            for (int i = 0; i < length; ++i) {
                Object value = lazyList.getRaw(i);
                if (value instanceof ByteString) {
                    size += CodedOutputStream.computeBytesSizeNoTag((ByteString)value);
                    continue;
                }
                size += CodedOutputStream.computeStringSizeNoTag((String)var1_1);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                Object value = var1_1.get(i);
                if (value instanceof ByteString) {
                    size += CodedOutputStream.computeBytesSizeNoTag((ByteString)value);
                    continue;
                }
                size += CodedOutputStream.computeStringSizeNoTag((String)value);
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    static int computeSizeMessage(int fieldNumber, Object value, Schema schema) {
        void var2_2;
        void var1_1;
        int n;
        if (value instanceof LazyFieldLite) {
            return CodedOutputStream.computeLazyFieldSize(fieldNumber, (LazyFieldLite)value);
        }
        return CodedOutputStream.computeMessageSize(n, (MessageLite)var1_1, (Schema)var2_2);
    }

    static int computeSizeMessageList(int fieldNumber, List<?> list, Schema schema) {
        int n;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = length * CodedOutputStream.computeTagSize(fieldNumber);
        for (int i = 0; i < length; ++i) {
            Object value = list.get(i);
            if (value instanceof LazyFieldLite) {
                size += CodedOutputStream.computeLazyFieldSizeNoTag((LazyFieldLite)value);
                continue;
            }
            size += CodedOutputStream.computeMessageSizeNoTag((MessageLite)value, schema);
        }
        return n;
    }

    static int computeSizeByteStringList(int fieldNumber, List<ByteString> list) {
        int n;
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = length * CodedOutputStream.computeTagSize(fieldNumber);
        for (int i = 0; i < list.size(); ++i) {
            size += CodedOutputStream.computeBytesSizeNoTag(list.get(i));
        }
        return n;
    }

    static int computeSizeGroupList(int fieldNumber, List<MessageLite> list, Schema schema) {
        int length = list.size();
        if (length == 0) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < length; ++i) {
            size += CodedOutputStream.computeGroupSize(fieldNumber, list.get(i), schema);
        }
        return size;
    }

    public static UnknownFieldSchema<?, ?> proto2UnknownFieldSetSchema() {
        return PROTO2_UNKNOWN_FIELD_SET_SCHEMA;
    }

    public static UnknownFieldSchema<?, ?> proto3UnknownFieldSetSchema() {
        return PROTO3_UNKNOWN_FIELD_SET_SCHEMA;
    }

    public static UnknownFieldSchema<?, ?> unknownFieldSetLiteSchema() {
        return UNKNOWN_FIELD_SET_LITE_SCHEMA;
    }

    /*
     * WARNING - void declaration
     */
    private static UnknownFieldSchema<?, ?> getUnknownFieldSetSchema(boolean proto3) {
        try {
            boolean bl;
            void var1_1;
            Class<?> clz = SchemaUtil.getUnknownFieldSetSchemaClass();
            if (clz == null) {
                return null;
            }
            return (UnknownFieldSchema)var1_1.getConstructor(Boolean.TYPE).newInstance(bl);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class<?> getGeneratedMessageClass() {
        try {
            return Class.forName("androidx.datastore.preferences.protobuf.GeneratedMessageV3");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class<?> getUnknownFieldSetSchemaClass() {
        try {
            return Class.forName("androidx.datastore.preferences.protobuf.UnknownFieldSetSchema");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static boolean safeEquals(Object a, Object b) {
        void var1_1;
        Object object;
        return a == b || a != null && object.equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <T> void mergeMap(MapFieldSchema mapFieldSchema, T message, T o, long offset) {
        Object object;
        void var3_3;
        void var1_1;
        void var2_2;
        Object merged = mapFieldSchema.mergeFrom(UnsafeUtil.getObject(message, offset), UnsafeUtil.getObject(var2_2, offset));
        UnsafeUtil.putObject(var1_1, (long)var3_3, object);
    }

    /*
     * WARNING - void declaration
     */
    static <T, FT extends FieldSet.FieldDescriptorLite<FT>> void mergeExtensions(ExtensionSchema<FT> schema, T message, T other) {
        FieldSet<FT> otherExtensions = schema.getExtensions(other);
        if (!otherExtensions.isEmpty()) {
            void var2_2;
            void var1_1;
            FieldSet<FT> fieldSet;
            fieldSet = ((ExtensionSchema)((Object)fieldSet)).getMutableExtensions(var1_1);
            fieldSet.mergeFrom((FieldSet<FT>)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    static <T, UT, UB> void mergeUnknownFields(UnknownFieldSchema<UT, UB> schema, T message, T other) {
        void var2_2;
        void var1_1;
        UnknownFieldSchema<UT, UB> unknownFieldSchema;
        void var3_3;
        UT messageUnknowns = schema.getFromMessage(message);
        UT otherUnknowns = schema.getFromMessage(other);
        void merged = schema.merge(var3_3, otherUnknowns);
        unknownFieldSchema.setToMessage(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static <UT, UB> UB filterUnknownEnumList(Object containerMessage, int number, List<Integer> enumList, Internal.EnumVerifier enumVerifier, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        if (enumVerifier == null) {
            return unknownFields;
        }
        if (enumList instanceof RandomAccess) {
            int writePos = 0;
            int size = enumList.size();
            for (int readPos = 0; readPos < size; ++readPos) {
                int enumValue = enumList.get(readPos);
                if (enumVerifier.isInRange$134632()) {
                    if (readPos != writePos) {
                        enumList.set(writePos, enumValue);
                    }
                    ++writePos;
                    continue;
                }
                unknownFields = SchemaUtil.storeUnknownEnum(containerMessage, number, enumValue, unknownFields, unknownFieldSchema);
            }
            if (writePos != size) {
                enumList.subList(writePos, size).clear();
            }
        } else {
            void var2_2;
            Iterator it = var2_2.iterator();
            while (it.hasNext()) {
                int enumValue = (Integer)it.next();
                if (enumVerifier.isInRange$134632()) continue;
                unknownFields = SchemaUtil.storeUnknownEnum(containerMessage, number, enumValue, unknownFields, unknownFieldSchema);
                it.remove();
            }
        }
        return unknownFields;
    }

    /*
     * WARNING - void declaration
     */
    static <UT, UB> UB storeUnknownEnum(Object containerMessage, int number, int enumValue, UB unknownFields, UnknownFieldSchema<UT, UB> unknownFieldSchema) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (unknownFields == null) {
            Object object;
            unknownFields = unknownFieldSchema.getBuilderFromMessage(object);
        }
        unknownFieldSchema.addVarint(unknownFields, (int)var1_1, (long)var2_2);
        return var3_3;
    }
}

