/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.FieldSet;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

class SmallSortedMap<K extends Comparable<K>, V>
extends AbstractMap<K, V> {
    private final int maxArraySize;
    private List<Entry> entryList;
    private Map<K, V> overflowEntries;
    private boolean isImmutable;
    private volatile EntrySet lazyEntrySet;
    private Map<K, V> overflowEntriesDescending;
    private volatile DescendingEntrySet lazyDescendingEntrySet;

    static <FieldDescriptorType extends FieldSet.FieldDescriptorLite<FieldDescriptorType>> SmallSortedMap<FieldDescriptorType, Object> newFieldMap(int arraySize) {
        int n;
        return new SmallSortedMap<FieldDescriptorType, Object>(n){
            {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void makeImmutable() {
                if (!this.isImmutable()) {
                    List value;
                    for (int i = 0; i < this.getNumArrayEntries(); ++i) {
                        Map.Entry entry = this.getArrayEntryAt(i);
                        if (!((FieldSet.FieldDescriptorLite)entry.getKey()).isRepeated()) continue;
                        value = (List)entry.getValue();
                        entry.setValue(Collections.unmodifiableList(value));
                    }
                    for (Map.Entry entry : this.getOverflowEntries()) {
                        void var3_6;
                        if (!((FieldSet.FieldDescriptorLite)entry.getKey()).isRepeated()) continue;
                        value = (List)entry.getValue();
                        entry.setValue(Collections.unmodifiableList(var3_6));
                    }
                }
                super.makeImmutable();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private SmallSortedMap(int arraySize) {
        void var1_1;
        this.maxArraySize = var1_1;
        this.entryList = Collections.emptyList();
        this.overflowEntries = Collections.emptyMap();
        this.overflowEntriesDescending = Collections.emptyMap();
    }

    public void makeImmutable() {
        if (!this.isImmutable) {
            this.overflowEntries = this.overflowEntries.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.overflowEntries);
            this.overflowEntriesDescending = this.overflowEntriesDescending.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.overflowEntriesDescending);
            this.isImmutable = true;
        }
    }

    public final boolean isImmutable() {
        return this.isImmutable;
    }

    public final int getNumArrayEntries() {
        return this.entryList.size();
    }

    /*
     * WARNING - void declaration
     */
    public final Map.Entry<K, V> getArrayEntryAt(int index) {
        void var1_1;
        return this.entryList.get((int)var1_1);
    }

    public final Iterable<Map.Entry<K, V>> getOverflowEntries() {
        if (this.overflowEntries.isEmpty()) {
            return EmptySet.iterable();
        }
        return this.overflowEntries.entrySet();
    }

    @Override
    public int size() {
        return this.entryList.size() + this.overflowEntries.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object o) {
        void var1_1;
        Comparable key = (Comparable)o;
        return this.binarySearchInArray(key) >= 0 || this.overflowEntries.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(Object o) {
        void var1_1;
        Comparable key = (Comparable)o;
        int index = this.binarySearchInArray(key);
        if (index >= 0) {
            void var2_2;
            return this.entryList.get((int)var2_2).getValue();
        }
        return this.overflowEntries.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V put(K key, V value) {
        void var2_2;
        void var1_1;
        void var3_3;
        int insertionPoint;
        this.checkMutable();
        int index = this.binarySearchInArray(key);
        if (index >= 0) {
            return this.entryList.get(index).setValue(value);
        }
        SmallSortedMap smallSortedMap = this;
        smallSortedMap.checkMutable();
        if (smallSortedMap.entryList.isEmpty() && !(smallSortedMap.entryList instanceof ArrayList)) {
            smallSortedMap.entryList = new ArrayList<Entry>(smallSortedMap.maxArraySize);
        }
        if ((insertionPoint = -(index + 1)) >= this.maxArraySize) {
            return this.getOverflowEntriesMutable().put(key, value);
        }
        if (this.entryList.size() == this.maxArraySize) {
            Entry lastEntryInArray = this.entryList.remove(this.maxArraySize - 1);
            this.getOverflowEntriesMutable().put(lastEntryInArray.getKey(), lastEntryInArray.getValue());
        }
        this.entryList.add((int)var3_3, new Entry(this, (Comparable)var1_1, (Object)var2_2));
        return null;
    }

    @Override
    public void clear() {
        this.checkMutable();
        if (!this.entryList.isEmpty()) {
            this.entryList.clear();
        }
        if (!this.overflowEntries.isEmpty()) {
            this.overflowEntries.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(Object o) {
        void var1_1;
        this.checkMutable();
        Comparable key = (Comparable)o;
        int index = this.binarySearchInArray(key);
        if (index >= 0) {
            void var2_2;
            return this.removeArrayEntryAt((int)var2_2);
        }
        if (this.overflowEntries.isEmpty()) {
            return null;
        }
        return this.overflowEntries.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private V removeArrayEntryAt(int index) {
        void var1_2;
        this.checkMutable();
        Object removed = this.entryList.remove(index).getValue();
        if (!this.overflowEntries.isEmpty()) {
            void var2_3;
            Iterator<Map.Entry<K, V>> iterator = this.getOverflowEntriesMutable().entrySet().iterator();
            this.entryList.add(new Entry(this, iterator.next()));
            var2_3.remove();
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private int binarySearchInArray(K key) {
        void var2_2;
        int left = 0;
        int right = this.entryList.size() - 1;
        if (right >= 0) {
            int cmp = key.compareTo((Object)this.entryList.get(right).getKey());
            if (cmp > 0) {
                return -(right + 2);
            }
            if (cmp == 0) {
                return right;
            }
        }
        while (left <= right) {
            int mid = (left + right) / 2;
            int cmp = key.compareTo((Object)this.entryList.get(mid).getKey());
            if (cmp < 0) {
                right = mid - 1;
                continue;
            }
            if (cmp > 0) {
                left = mid + 1;
                continue;
            }
            return mid;
        }
        return (int)(-(var2_2 + true));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.lazyEntrySet == null) {
            this.lazyEntrySet = new EntrySet(this, 0);
        }
        return this.lazyEntrySet;
    }

    final Set<Map.Entry<K, V>> descendingEntrySet() {
        if (this.lazyDescendingEntrySet == null) {
            this.lazyDescendingEntrySet = new DescendingEntrySet(this, 0);
        }
        return this.lazyDescendingEntrySet;
    }

    private void checkMutable() {
        if (this.isImmutable) {
            throw new UnsupportedOperationException();
        }
    }

    private SortedMap<K, V> getOverflowEntriesMutable() {
        this.checkMutable();
        if (this.overflowEntries.isEmpty() && !(this.overflowEntries instanceof TreeMap)) {
            this.overflowEntries = new TreeMap();
            this.overflowEntriesDescending = ((TreeMap)this.overflowEntries).descendingMap();
        }
        return (SortedMap)this.overflowEntries;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        void var2_2;
        void var3_3;
        if (this == o) {
            return true;
        }
        if (!(o instanceof SmallSortedMap)) {
            return super.equals(o);
        }
        SmallSortedMap other = (SmallSortedMap)o;
        int size = this.size();
        if (size != other.size()) {
            return false;
        }
        int numArrayEntries = this.getNumArrayEntries();
        if (numArrayEntries != other.getNumArrayEntries()) {
            return this.entrySet().equals(other.entrySet());
        }
        for (int i = 0; i < numArrayEntries; ++i) {
            if (this.getArrayEntryAt(i).equals(other.getArrayEntryAt(i))) continue;
            return false;
        }
        if (var3_3 != var2_2) {
            void var1_1;
            return this.overflowEntries.equals(var1_1.overflowEntries);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int h = 0;
        int listSize = this.getNumArrayEntries();
        for (int i = 0; i < listSize; ++i) {
            h += this.entryList.get(i).hashCode();
        }
        SmallSortedMap smallSortedMap = this;
        if (smallSortedMap.overflowEntries.size() > 0) {
            h += this.overflowEntries.hashCode();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ SmallSortedMap(int x0, byte by) {
        this((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$800(SmallSortedMap x0, int x1) {
        void var1_1;
        return x0.removeArrayEntryAt((int)var1_1);
    }

    static final class EmptySet {
        private static final Iterator<Object> ITERATOR = new Iterator<Object>(){

            @Override
            public final boolean hasNext() {
                return false;
            }

            @Override
            public final Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException();
            }
        };
        private static final Iterable<Object> ITERABLE = new Iterable<Object>(){

            @Override
            public final Iterator<Object> iterator() {
                return ITERATOR;
            }
        };

        static <T> Iterable<T> iterable() {
            return ITERABLE;
        }
    }

    final class DescendingEntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private int pos;
        private Iterator<Map.Entry<K, V>> lazyOverflowIterator;
        private /* synthetic */ SmallSortedMap this$0;

        private DescendingEntryIterator(SmallSortedMap smallSortedMap) {
            this.this$0 = smallSortedMap;
            this.pos = this.this$0.entryList.size();
        }

        @Override
        public final boolean hasNext() {
            return this.pos > 0 && this.pos <= this.this$0.entryList.size() || this.getOverflowIterator().hasNext();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        private Iterator<Map.Entry<K, V>> getOverflowIterator() {
            if (this.lazyOverflowIterator == null) {
                this.lazyOverflowIterator = this.this$0.overflowEntriesDescending.entrySet().iterator();
            }
            return this.lazyOverflowIterator;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ DescendingEntryIterator(SmallSortedMap x0, byte by) {
            this((SmallSortedMap)var1_1);
            void var1_1;
        }
    }

    final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private int pos = -1;
        private boolean nextCalledBeforeRemove;
        private Iterator<Map.Entry<K, V>> lazyOverflowIterator;
        private /* synthetic */ SmallSortedMap this$0;

        private EntryIterator(SmallSortedMap smallSortedMap) {
            this.this$0 = smallSortedMap;
        }

        @Override
        public final boolean hasNext() {
            return this.pos + 1 < this.this$0.entryList.size() || !this.this$0.overflowEntries.isEmpty() && this.getOverflowIterator().hasNext();
        }

        @Override
        public final void remove() {
            if (!this.nextCalledBeforeRemove) {
                throw new IllegalStateException("remove() was called before next()");
            }
            this.nextCalledBeforeRemove = false;
            this.this$0.checkMutable();
            if (this.pos < this.this$0.entryList.size()) {
                SmallSortedMap.access$800(this.this$0, this.pos--);
                return;
            }
            this.getOverflowIterator().remove();
        }

        private Iterator<Map.Entry<K, V>> getOverflowIterator() {
            if (this.lazyOverflowIterator == null) {
                this.lazyOverflowIterator = this.this$0.overflowEntries.entrySet().iterator();
            }
            return this.lazyOverflowIterator;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ EntryIterator(SmallSortedMap x0, byte by) {
            this((SmallSortedMap)var1_1);
            void var1_1;
        }
    }

    final class DescendingEntrySet
    extends EntrySet {
        private /* synthetic */ SmallSortedMap this$0;

        private DescendingEntrySet(SmallSortedMap smallSortedMap) {
            this.this$0 = smallSortedMap;
            super(smallSortedMap, (byte)0);
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new DescendingEntryIterator(this.this$0, 0);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ DescendingEntrySet(SmallSortedMap x0, byte by) {
            this((SmallSortedMap)var1_1);
            void var1_1;
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private /* synthetic */ SmallSortedMap this$0;

        private EntrySet(SmallSortedMap smallSortedMap) {
            this.this$0 = smallSortedMap;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.this$0, 0);
        }

        @Override
        public int size() {
            return this.this$0.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            void var2_2;
            Object value;
            Map.Entry entry = (Map.Entry)o;
            Object existing = this.this$0.get(entry.getKey());
            return existing == (value = entry.getValue()) || existing != null && var2_2.equals(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            Map.Entry entry = (Map.Entry)o;
            if (this.contains(entry)) {
                void var1_1;
                this.this$0.remove(var1_1.getKey());
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            this.this$0.clear();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ EntrySet(SmallSortedMap x0, byte by) {
            this((SmallSortedMap)var1_1);
            void var1_1;
        }
    }

    final class Entry
    implements Comparable<Entry>,
    Map.Entry<K, V> {
        private final K key;
        private V value;
        private /* synthetic */ SmallSortedMap this$0;

        /*
         * WARNING - void declaration
         */
        Entry(SmallSortedMap smallSortedMap, Map.Entry<K, V> copy) {
            this(smallSortedMap, (Comparable)copy.getKey(), var2_2.getValue());
            void var2_2;
        }

        /*
         * WARNING - void declaration
         */
        Entry(K key, V value) {
            void var3_3;
            void var2_2;
            this.this$0 = var1_1;
            this.key = var2_2;
            this.value = var3_3;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V setValue(V newValue) {
            void var2_2;
            void var1_1;
            this.this$0.checkMutable();
            Object oldValue = this.value;
            this.value = var1_1;
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object o) {
            void var1_1;
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)o;
            return Entry.equals(this.key, other.getKey()) && Entry.equals(this.value, var1_1.getValue());
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }

        /*
         * WARNING - void declaration
         */
        private static boolean equals(Object o1, Object o2) {
            void var1_1;
            Object object;
            if (o1 == null) {
                return o2 == null;
            }
            return object.equals(var1_1);
        }
    }
}

