/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.ByteString;
import androidx.datastore.preferences.protobuf.CodedOutputStream;
import androidx.datastore.preferences.protobuf.InvalidProtocolBufferException;
import androidx.datastore.preferences.protobuf.MessageLiteToString;
import androidx.datastore.preferences.protobuf.WireFormat;
import androidx.datastore.preferences.protobuf.Writer;
import java.io.IOException;
import java.util.Arrays;

public final class UnknownFieldSetLite {
    private static final UnknownFieldSetLite DEFAULT_INSTANCE = new UnknownFieldSetLite(0, new int[0], new Object[0], false);
    private int count;
    private int[] tags;
    private Object[] objects;
    private int memoizedSerializedSize = -1;
    private boolean isMutable;

    public static UnknownFieldSetLite getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    static UnknownFieldSetLite newInstance() {
        return new UnknownFieldSetLite();
    }

    /*
     * WARNING - void declaration
     */
    static UnknownFieldSetLite mutableCopyOf(UnknownFieldSetLite first, UnknownFieldSetLite second) {
        void var3_3;
        void var2_2;
        void var1_1;
        UnknownFieldSetLite unknownFieldSetLite;
        int count = first.count + second.count;
        int[] tags = Arrays.copyOf(first.tags, count);
        System.arraycopy(second.tags, 0, tags, first.count, second.count);
        Object[] objects = Arrays.copyOf(first.objects, count);
        System.arraycopy(second.objects, 0, objects, unknownFieldSetLite.count, var1_1.count);
        return new UnknownFieldSetLite((int)var2_2, (int[])var3_3, objects, true);
    }

    private UnknownFieldSetLite() {
        this(0, new int[8], new Object[8], true);
    }

    /*
     * WARNING - void declaration
     */
    private UnknownFieldSetLite(int count, int[] tags, Object[] objects, boolean isMutable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.count = var1_1;
        this.tags = var2_2;
        this.objects = var3_3;
        this.isMutable = isMutable;
    }

    public final void makeImmutable() {
        this.isMutable = false;
    }

    private void checkMutable() {
        if (!this.isMutable) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - void declaration
     */
    final void writeAsMessageSetTo(Writer writer) throws IOException {
        if (writer.fieldOrder() == Writer.FieldOrder.DESCENDING) {
            for (int i = this.count - 1; i >= 0; --i) {
                int fieldNumber = WireFormat.getTagFieldNumber(this.tags[i]);
                writer.writeMessageSetItem(fieldNumber, this.objects[i]);
            }
            return;
        }
        for (int i = 0; i < this.count; ++i) {
            void var3_5;
            int fieldNumber = WireFormat.getTagFieldNumber(this.tags[i]);
            writer.writeMessageSetItem((int)var3_5, this.objects[i]);
        }
    }

    public final void writeTo(Writer writer) throws IOException {
        if (this.count == 0) {
            return;
        }
        if (writer.fieldOrder() == Writer.FieldOrder.ASCENDING) {
            for (int i = 0; i < this.count; ++i) {
                UnknownFieldSetLite.writeField(this.tags[i], this.objects[i], writer);
            }
            return;
        }
        for (int i = this.count - 1; i >= 0; --i) {
            UnknownFieldSetLite.writeField(this.tags[i], this.objects[i], writer);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void writeField(int tag, Object object, Writer writer) throws IOException {
        int n;
        int fieldNumber = WireFormat.getTagFieldNumber(tag);
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                writer.writeInt64(fieldNumber, (Long)object);
                return;
            }
            case 5: {
                writer.writeFixed32(fieldNumber, (Integer)object);
                return;
            }
            case 1: {
                writer.writeFixed64(fieldNumber, (Long)object);
                return;
            }
            case 2: {
                writer.writeBytes(fieldNumber, (ByteString)object);
                return;
            }
            case 3: {
                void var3_3;
                void var2_2;
                void var1_1;
                if (writer.fieldOrder() == Writer.FieldOrder.ASCENDING) {
                    writer.writeStartGroup(fieldNumber);
                    ((UnknownFieldSetLite)object).writeTo(writer);
                    writer.writeEndGroup(fieldNumber);
                    return;
                }
                writer.writeEndGroup(fieldNumber);
                ((UnknownFieldSetLite)var1_1).writeTo(writer);
                var2_2.writeStartGroup((int)var3_3);
                return;
            }
        }
        throw new RuntimeException(InvalidProtocolBufferException.invalidWireType());
    }

    /*
     * WARNING - void declaration
     */
    public final int getSerializedSizeAsMessageSet() {
        void var1_1;
        int size = this.memoizedSerializedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        for (int i = 0; i < this.count; ++i) {
            int n = this.tags[i];
            int fieldNumber = WireFormat.getTagFieldNumber(n);
            size += CodedOutputStream.computeRawMessageSetExtensionSize(n, (ByteString)this.objects[i]);
        }
        this.memoizedSerializedSize = size;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final int getSerializedSize() {
        void var1_1;
        int size = this.memoizedSerializedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        block7: for (int i = 0; i < this.count; ++i) {
            void var3_3;
            int tag = this.tags[i];
            int fieldNumber = WireFormat.getTagFieldNumber(tag);
            switch (WireFormat.getTagWireType((int)var3_3)) {
                case 0: {
                    size += CodedOutputStream.computeUInt64Size(fieldNumber, (Long)this.objects[i]);
                    continue block7;
                }
                case 5: {
                    size += CodedOutputStream.computeFixed32Size(fieldNumber, (Integer)this.objects[i]);
                    continue block7;
                }
                case 1: {
                    size += CodedOutputStream.computeFixed64Size(fieldNumber, (Long)this.objects[i]);
                    continue block7;
                }
                case 2: {
                    size += CodedOutputStream.computeBytesSize(fieldNumber, (ByteString)this.objects[i]);
                    continue block7;
                }
                case 3: {
                    size += (CodedOutputStream.computeTagSize(fieldNumber) << 1) + ((UnknownFieldSetLite)this.objects[i]).getSerializedSize();
                    continue block7;
                }
                default: {
                    throw new IllegalStateException(InvalidProtocolBufferException.invalidWireType());
                }
            }
        }
        this.memoizedSerializedSize = size;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        block11: {
            block10: {
                boolean bl;
                block9: {
                    void var1_1;
                    boolean bl2;
                    int n;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    block8: {
                        if (this == obj) {
                            return true;
                        }
                        if (obj == null) {
                            return false;
                        }
                        if (!(obj instanceof UnknownFieldSetLite)) {
                            return false;
                        }
                        UnknownFieldSetLite other = (UnknownFieldSetLite)obj;
                        if (this.count != other.count) break block10;
                        n2 = this.count;
                        objectArray2 = other.tags;
                        objectArray = this.tags;
                        for (n = 0; n < n2; ++n) {
                            if (objectArray[n] == objectArray2[n]) continue;
                            bl2 = false;
                            break block8;
                        }
                        bl2 = true;
                    }
                    if (!bl2) break block10;
                    n2 = this.count;
                    objectArray2 = var1_1.objects;
                    objectArray = this.objects;
                    for (n = 0; n < n2; ++n) {
                        if (objectArray[n].equals(objectArray2[n])) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
                if (bl) break block11;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_3;
        int n;
        int hashCode322 = 527 + this.count;
        int n2 = this.count;
        int[] hashCode322 = this.tags;
        int n3 = 17;
        for (n = 0; n < n2; ++n) {
            n3 = n3 * 31 + hashCode322[n];
        }
        int hashCode322 = hashCode322 * 31 + n3;
        void v0 = var1_3 * 31;
        n2 = this.count;
        Object[] objectArray = this.objects;
        n3 = 17;
        for (n = 0; n < n2; ++n) {
            n3 = n3 * 31 + objectArray[n].hashCode();
        }
        void var1_5 = v0 + n3;
        return (int)var1_5;
    }

    final void printWithIndent(StringBuilder buffer, int indent) {
        for (int i = 0; i < this.count; ++i) {
            int fieldNumber = WireFormat.getTagFieldNumber(this.tags[i]);
            MessageLiteToString.printField(buffer, indent, String.valueOf(fieldNumber), this.objects[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    final void storeField(int tag, Object value) {
        void var2_2;
        void var1_1;
        this.checkMutable();
        UnknownFieldSetLite unknownFieldSetLite = this;
        unknownFieldSetLite.ensureCapacity(unknownFieldSetLite.count + 1);
        this.tags[this.count] = var1_1;
        this.objects[this.count] = var2_2;
        ++this.count;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureCapacity(int minCapacity) {
        if (minCapacity > this.tags.length) {
            void var2_2;
            int newCapacity = this.count + this.count / 2;
            if (newCapacity < minCapacity) {
                void var1_1;
                newCapacity = var1_1;
            }
            if (newCapacity < 8) {
                newCapacity = 8;
            }
            this.tags = Arrays.copyOf(this.tags, newCapacity);
            this.objects = Arrays.copyOf(this.objects, (int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    final UnknownFieldSetLite mergeFrom(UnknownFieldSetLite other) {
        void var2_2;
        void var1_1;
        if (other.equals(DEFAULT_INSTANCE)) {
            return this;
        }
        this.checkMutable();
        int newCount = this.count + other.count;
        this.ensureCapacity(newCount);
        System.arraycopy(other.tags, 0, this.tags, this.count, other.count);
        System.arraycopy(other.objects, 0, this.objects, this.count, var1_1.count);
        this.count = var2_2;
        return this;
    }
}

