/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.Android;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Unsafe;

final class UnsafeUtil {
    private static final Unsafe UNSAFE = UnsafeUtil.getUnsafe();
    private static final Class<?> MEMORY_CLASS = Android.getMemoryClass();
    private static final boolean IS_ANDROID_64 = UnsafeUtil.determineAndroidSupportByAddressSize(Long.TYPE);
    private static final boolean IS_ANDROID_32 = UnsafeUtil.determineAndroidSupportByAddressSize(Integer.TYPE);
    private static final MemoryAccessor MEMORY_ACCESSOR = UNSAFE == null ? null : (Android.isOnAndroidDevice() ? (IS_ANDROID_64 ? new Android64MemoryAccessor(UNSAFE) : (IS_ANDROID_32 ? new Android32MemoryAccessor(UNSAFE) : null)) : new JvmMemoryAccessor(UNSAFE));
    private static final boolean HAS_UNSAFE_BYTEBUFFER_OPERATIONS = MEMORY_ACCESSOR == null ? false : MEMORY_ACCESSOR.supportsUnsafeByteBufferOperations();
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = MEMORY_ACCESSOR == null ? false : MEMORY_ACCESSOR.supportsUnsafeArrayOperations();
    static final long BYTE_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(byte[].class);
    static final boolean IS_BIG_ENDIAN;

    private UnsafeUtil() {
    }

    static boolean hasUnsafeArrayOperations() {
        return HAS_UNSAFE_ARRAY_OPERATIONS;
    }

    static boolean hasUnsafeByteBufferOperations() {
        return HAS_UNSAFE_BYTEBUFFER_OPERATIONS;
    }

    /*
     * WARNING - void declaration
     */
    static <T> T allocateInstance(Class<T> clazz) {
        try {
            return (T)UNSAFE.allocateInstance(clazz);
        }
        catch (InstantiationException e) {
            void var0_1;
            throw new IllegalStateException((Throwable)var0_1);
        }
    }

    private static int arrayBaseOffset(Class<?> clazz) {
        if (HAS_UNSAFE_ARRAY_OPERATIONS) {
            MemoryAccessor memoryAccessor;
            Class<?> clazz2 = memoryAccessor;
            memoryAccessor = MEMORY_ACCESSOR;
            return memoryAccessor.unsafe.arrayBaseOffset(clazz2);
        }
        return -1;
    }

    private static int arrayIndexScale(Class<?> clazz) {
        if (HAS_UNSAFE_ARRAY_OPERATIONS) {
            MemoryAccessor memoryAccessor;
            Class<?> clazz2 = memoryAccessor;
            memoryAccessor = MEMORY_ACCESSOR;
            return memoryAccessor.unsafe.arrayIndexScale(clazz2);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    static int getInt(Object target, long offset) {
        void var1_1;
        Object object;
        return MEMORY_ACCESSOR.getInt(object, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putInt(Object target, long offset, int value) {
        void var3_2;
        void var1_1;
        Object object;
        MEMORY_ACCESSOR.putInt(object, (long)var1_1, (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static long getLong(Object target, long offset) {
        void var1_1;
        Object object;
        return MEMORY_ACCESSOR.getLong(object, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putLong(Object target, long offset, long value) {
        void var3_2;
        void var1_1;
        Object object;
        MEMORY_ACCESSOR.putLong(object, (long)var1_1, (long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static boolean getBoolean(Object target, long offset) {
        void var1_1;
        Object object;
        return MEMORY_ACCESSOR.getBoolean(object, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putBoolean(Object target, long offset, boolean value) {
        void var3_2;
        void var1_1;
        Object object;
        MEMORY_ACCESSOR.putBoolean(object, (long)var1_1, (boolean)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static float getFloat(Object target, long offset) {
        void var1_1;
        Object object;
        return MEMORY_ACCESSOR.getFloat(object, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putFloat(Object target, long offset, float value) {
        void var3_2;
        void var1_1;
        Object object;
        MEMORY_ACCESSOR.putFloat(object, (long)var1_1, (float)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static double getDouble(Object target, long offset) {
        void var1_1;
        Object object;
        return MEMORY_ACCESSOR.getDouble(object, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putDouble(Object target, long offset, double value) {
        void var3_2;
        void var1_1;
        Object object;
        MEMORY_ACCESSOR.putDouble(object, (long)var1_1, (double)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static Object getObject(Object target, long offset) {
        Object object;
        void var1_1;
        void var5_3 = var1_1;
        Object object2 = object;
        object = MEMORY_ACCESSOR;
        return ((MemoryAccessor)object).unsafe.getObject(object2, (long)var5_3);
    }

    /*
     * WARNING - void declaration
     */
    static void putObject(Object target, long offset, Object value) {
        Object object;
        void var1_1;
        void var3_3;
        void var2_4 = var3_3;
        void var6_5 = var1_1;
        Object object2 = object;
        object = MEMORY_ACCESSOR;
        ((MemoryAccessor)object).unsafe.putObject(object2, (long)var6_5, var2_4);
    }

    /*
     * WARNING - void declaration
     */
    static byte getByte(byte[] target, long index) {
        void var1_1;
        byte[] byArray;
        return MEMORY_ACCESSOR.getByte(byArray, BYTE_ARRAY_BASE_OFFSET + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putByte(byte[] target, long index, byte value) {
        void var3_2;
        void var1_1;
        byte[] byArray;
        MEMORY_ACCESSOR.putByte(byArray, BYTE_ARRAY_BASE_OFFSET + var1_1, (byte)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static Unsafe getUnsafe() {
        void var0;
        Unsafe unsafe = null;
        try {
            unsafe = AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){});
        }
        catch (Throwable throwable) {}
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean determineAndroidSupportByAddressSize(Class<?> addressClass) {
        if (!Android.isOnAndroidDevice()) {
            return false;
        }
        try {
            Class<?> clazz;
            void var1_1;
            Class<?> clazz2 = MEMORY_CLASS;
            clazz2.getMethod("peekLong", addressClass, Boolean.TYPE);
            clazz2.getMethod("pokeLong", addressClass, Long.TYPE, Boolean.TYPE);
            clazz2.getMethod("pokeInt", addressClass, Integer.TYPE, Boolean.TYPE);
            clazz2.getMethod("peekInt", addressClass, Boolean.TYPE);
            clazz2.getMethod("pokeByte", addressClass, Byte.TYPE);
            clazz2.getMethod("peekByte", addressClass);
            clazz2.getMethod("pokeByteArray", addressClass, byte[].class, Integer.TYPE, Integer.TYPE);
            var1_1.getMethod("peekByteArray", clazz, byte[].class, Integer.TYPE, Integer.TYPE);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Field bufferAddressField() {
        Field field;
        if (Android.isOnAndroidDevice() && (field = UnsafeUtil.field(Buffer.class, "effectiveDirectAddress")) != null) {
            return field;
        }
        field = UnsafeUtil.field(Buffer.class, "address");
        if (field != null && field.getType() == Long.TYPE) {
            void var0;
            return var0;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Field field(Class<?> clazz, String fieldName) {
        AnnotatedElement annotatedElement;
        AnnotatedElement field;
        try {
            void var1_1;
            field = clazz.getDeclaredField((String)var1_1);
        }
        catch (Throwable throwable) {
            field = null;
        }
        return annotatedElement;
    }

    /*
     * WARNING - void declaration
     */
    private static byte getByteBigEndian(Object target, long offset) {
        void var1_1;
        return (byte)(UnsafeUtil.getInt(target, offset & 0xFFFFFFFFFFFFFFFCL) >>> (int)(((var1_1 ^ 0xFFFFFFFFFFFFFFFFL) & 3L) << 3));
    }

    /*
     * WARNING - void declaration
     */
    private static byte getByteLittleEndian(Object target, long offset) {
        void var1_1;
        return (byte)(UnsafeUtil.getInt(target, offset & 0xFFFFFFFFFFFFFFFCL) >>> (int)((var1_1 & 3L) << 3));
    }

    /*
     * WARNING - void declaration
     */
    private static void putByteBigEndian(Object target, long offset, byte value) {
        void var3_2;
        void var1_1;
        Object object;
        int intValue = UnsafeUtil.getInt(target, offset & 0xFFFFFFFFFFFFFFFCL);
        int shift = (~((int)offset) & 3) << 3;
        int output = intValue & ~(255 << shift) | (0xFF & value) << shift;
        UnsafeUtil.putInt(object, (long)(var1_1 & 0xFFFFFFFFFFFFFFFCL), (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void putByteLittleEndian(Object target, long offset, byte value) {
        void var3_2;
        void var1_1;
        Object object;
        int intValue = UnsafeUtil.getInt(target, offset & 0xFFFFFFFFFFFFFFFCL);
        int shift = ((int)offset & 3) << 3;
        int output = intValue & ~(255 << shift) | (0xFF & value) << shift;
        UnsafeUtil.putInt(object, (long)(var1_1 & 0xFFFFFFFFFFFFFFFCL), (int)var3_2);
    }

    static /* synthetic */ void access$000(Throwable x0) {
        Throwable throwable = x0;
        Logger.getLogger(UnsafeUtil.class.getName()).log(Level.WARNING, "platform method missing - proto runtime falling back to safer methods: " + throwable);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ byte access$200(Object x0, long x1) {
        void var1_1;
        return UnsafeUtil.getByteBigEndian(x0, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ byte access$300(Object x0, long x1) {
        void var1_1;
        return UnsafeUtil.getByteLittleEndian(x0, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(Object x0, long x1, byte x2) {
        void var3_2;
        void var1_1;
        UnsafeUtil.putByteBigEndian(x0, (long)var1_1, (byte)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$500(Object x0, long x1, byte x2) {
        void var3_2;
        void var1_1;
        UnsafeUtil.putByteLittleEndian(x0, (long)var1_1, (byte)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$600(Object x0, long x1) {
        void var1_1;
        Object object = x0;
        void var4_2 = var1_1;
        return UnsafeUtil.getByteBigEndian(object, (long)var4_2) != 0;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$700(Object x0, long x1) {
        void var1_1;
        Object object = x0;
        void var4_2 = var1_1;
        return UnsafeUtil.getByteLittleEndian(object, (long)var4_2) != 0;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$800(Object x0, long x1, boolean x2) {
        void var1_1;
        void var3_3;
        void var1_2 = var3_3;
        void var5_4 = var1_1;
        Object object = x0;
        UnsafeUtil.putByteBigEndian(object, (long)var5_4, (byte)(var1_2 != false ? 1 : 0));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$900(Object x0, long x1, boolean x2) {
        void var1_1;
        void var3_3;
        void var1_2 = var3_3;
        void var5_4 = var1_1;
        Object object = x0;
        UnsafeUtil.putByteLittleEndian(object, (long)var5_4, (byte)(var1_2 != false ? 1 : 0));
    }

    static {
        UnsafeUtil.arrayBaseOffset(boolean[].class);
        UnsafeUtil.arrayIndexScale(boolean[].class);
        UnsafeUtil.arrayBaseOffset(int[].class);
        UnsafeUtil.arrayIndexScale(int[].class);
        UnsafeUtil.arrayBaseOffset(long[].class);
        UnsafeUtil.arrayIndexScale(long[].class);
        UnsafeUtil.arrayBaseOffset(float[].class);
        UnsafeUtil.arrayIndexScale(float[].class);
        UnsafeUtil.arrayBaseOffset(double[].class);
        UnsafeUtil.arrayIndexScale(double[].class);
        UnsafeUtil.arrayBaseOffset(Object[].class);
        UnsafeUtil.arrayIndexScale(Object[].class);
        Field field = UnsafeUtil.bufferAddressField();
        long l = field == null || MEMORY_ACCESSOR == null ? -1L : MEMORY_ACCESSOR.objectFieldOffset(field);
        IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    }

    static final class Android32MemoryAccessor
    extends MemoryAccessor {
        /*
         * WARNING - void declaration
         */
        Android32MemoryAccessor(Unsafe unsafe) {
            super((Unsafe)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte getByte(Object target, long offset) {
            void var2_2;
            void var1_1;
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.access$200(target, offset);
            }
            return UnsafeUtil.access$300(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putByte(Object target, long offset, byte value) {
            void var2_2;
            void var1_1;
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.access$400(target, offset, value);
                return;
            }
            UnsafeUtil.access$500(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean getBoolean(Object target, long offset) {
            void var2_2;
            void var1_1;
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.access$600(target, offset);
            }
            return UnsafeUtil.access$700(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putBoolean(Object target, long offset, boolean value) {
            void var2_2;
            void var1_1;
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.access$800(target, offset, value);
                return;
            }
            UnsafeUtil.access$900(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final float getFloat(Object target, long offset) {
            void var2_2;
            void var1_1;
            return Float.intBitsToFloat(this.getInt(var1_1, (long)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putFloat(Object target, long offset, float value) {
            void var2_2;
            void var1_1;
            this.putInt(var1_1, (long)var2_2, Float.floatToIntBits(value));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final double getDouble(Object target, long offset) {
            void var2_2;
            void var1_1;
            return Double.longBitsToDouble(this.getLong(var1_1, (long)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putDouble(Object target, long offset, double value) {
            void var2_2;
            void var1_1;
            this.putLong(var1_1, (long)var2_2, Double.doubleToLongBits(value));
        }

        @Override
        public final boolean supportsUnsafeByteBufferOperations() {
            return false;
        }
    }

    static final class Android64MemoryAccessor
    extends MemoryAccessor {
        /*
         * WARNING - void declaration
         */
        Android64MemoryAccessor(Unsafe unsafe) {
            super((Unsafe)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte getByte(Object target, long offset) {
            void var2_2;
            void var1_1;
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.access$200(target, offset);
            }
            return UnsafeUtil.access$300(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putByte(Object target, long offset, byte value) {
            void var2_2;
            void var1_1;
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.access$400(target, offset, value);
                return;
            }
            UnsafeUtil.access$500(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean getBoolean(Object target, long offset) {
            void var2_2;
            void var1_1;
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.access$600(target, offset);
            }
            return UnsafeUtil.access$700(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putBoolean(Object target, long offset, boolean value) {
            void var2_2;
            void var1_1;
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.access$800(target, offset, value);
                return;
            }
            UnsafeUtil.access$900(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final float getFloat(Object target, long offset) {
            void var2_2;
            void var1_1;
            return Float.intBitsToFloat(this.getInt(var1_1, (long)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putFloat(Object target, long offset, float value) {
            void var2_2;
            void var1_1;
            this.putInt(var1_1, (long)var2_2, Float.floatToIntBits(value));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final double getDouble(Object target, long offset) {
            void var2_2;
            void var1_1;
            return Double.longBitsToDouble(this.getLong(var1_1, (long)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putDouble(Object target, long offset, double value) {
            void var2_2;
            void var1_1;
            this.putLong(var1_1, (long)var2_2, Double.doubleToLongBits(value));
        }

        @Override
        public final boolean supportsUnsafeByteBufferOperations() {
            return false;
        }
    }

    static final class JvmMemoryAccessor
    extends MemoryAccessor {
        /*
         * WARNING - void declaration
         */
        JvmMemoryAccessor(Unsafe unsafe) {
            super((Unsafe)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean supportsUnsafeArrayOperations() {
            if (!super.supportsUnsafeArrayOperations()) {
                return false;
            }
            try {
                void var1_1;
                Class<?> clazz = this.unsafe.getClass();
                clazz.getMethod("getByte", Object.class, Long.TYPE);
                clazz.getMethod("putByte", Object.class, Long.TYPE, Byte.TYPE);
                clazz.getMethod("getBoolean", Object.class, Long.TYPE);
                clazz.getMethod("putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
                clazz.getMethod("getFloat", Object.class, Long.TYPE);
                clazz.getMethod("putFloat", Object.class, Long.TYPE, Float.TYPE);
                clazz.getMethod("getDouble", Object.class, Long.TYPE);
                var1_1.getMethod("putDouble", Object.class, Long.TYPE, Double.TYPE);
                return true;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                UnsafeUtil.access$000(throwable);
                return false;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte getByte(Object target, long offset) {
            void var2_2;
            void var1_1;
            return this.unsafe.getByte(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putByte(Object target, long offset, byte value) {
            void var2_2;
            void var1_1;
            this.unsafe.putByte(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean getBoolean(Object target, long offset) {
            void var2_2;
            void var1_1;
            return this.unsafe.getBoolean(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putBoolean(Object target, long offset, boolean value) {
            void var2_2;
            void var1_1;
            this.unsafe.putBoolean(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final float getFloat(Object target, long offset) {
            void var2_2;
            void var1_1;
            return this.unsafe.getFloat(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putFloat(Object target, long offset, float value) {
            void var2_2;
            void var1_1;
            this.unsafe.putFloat(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final double getDouble(Object target, long offset) {
            void var2_2;
            void var1_1;
            return this.unsafe.getDouble(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putDouble(Object target, long offset, double value) {
            void var2_2;
            void var1_1;
            this.unsafe.putDouble(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean supportsUnsafeByteBufferOperations() {
            if (!super.supportsUnsafeByteBufferOperations()) {
                return false;
            }
            try {
                void var1_1;
                Class<?> clazz = this.unsafe.getClass();
                clazz.getMethod("getByte", Long.TYPE);
                clazz.getMethod("putByte", Long.TYPE, Byte.TYPE);
                clazz.getMethod("getInt", Long.TYPE);
                clazz.getMethod("putInt", Long.TYPE, Integer.TYPE);
                clazz.getMethod("getLong", Long.TYPE);
                clazz.getMethod("putLong", Long.TYPE, Long.TYPE);
                clazz.getMethod("copyMemory", Long.TYPE, Long.TYPE, Long.TYPE);
                var1_1.getMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
                return true;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                UnsafeUtil.access$000(throwable);
                return false;
            }
        }
    }

    static abstract class MemoryAccessor {
        Unsafe unsafe;

        /*
         * WARNING - void declaration
         */
        MemoryAccessor(Unsafe unsafe) {
            void var1_1;
            this.unsafe = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final long objectFieldOffset(Field field) {
            void var1_1;
            return this.unsafe.objectFieldOffset((Field)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public boolean supportsUnsafeArrayOperations() {
            if (this.unsafe == null) {
                return false;
            }
            try {
                void var1_1;
                Class<?> clazz = this.unsafe.getClass();
                clazz.getMethod("objectFieldOffset", Field.class);
                clazz.getMethod("arrayBaseOffset", Class.class);
                clazz.getMethod("arrayIndexScale", Class.class);
                clazz.getMethod("getInt", Object.class, Long.TYPE);
                clazz.getMethod("putInt", Object.class, Long.TYPE, Integer.TYPE);
                clazz.getMethod("getLong", Object.class, Long.TYPE);
                clazz.getMethod("putLong", Object.class, Long.TYPE, Long.TYPE);
                clazz.getMethod("getObject", Object.class, Long.TYPE);
                var1_1.getMethod("putObject", Object.class, Long.TYPE, Object.class);
                return true;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                UnsafeUtil.access$000(throwable);
                return false;
            }
        }

        public abstract byte getByte(Object var1, long var2);

        public abstract void putByte(Object var1, long var2, byte var4);

        /*
         * WARNING - void declaration
         */
        public final int getInt(Object target, long offset) {
            void var2_2;
            void var1_1;
            return this.unsafe.getInt(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final void putInt(Object target, long offset, int value) {
            void var2_2;
            void var1_1;
            this.unsafe.putInt(var1_1, (long)var2_2, value);
        }

        /*
         * WARNING - void declaration
         */
        public final long getLong(Object target, long offset) {
            void var2_2;
            void var1_1;
            return this.unsafe.getLong(var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final void putLong(Object target, long offset, long value) {
            void var2_2;
            void var1_1;
            this.unsafe.putLong(var1_1, (long)var2_2, value);
        }

        public abstract boolean getBoolean(Object var1, long var2);

        public abstract void putBoolean(Object var1, long var2, boolean var4);

        public abstract float getFloat(Object var1, long var2);

        public abstract void putFloat(Object var1, long var2, float var4);

        public abstract double getDouble(Object var1, long var2);

        public abstract void putDouble(Object var1, long var2, double var4);

        /*
         * WARNING - void declaration
         */
        public boolean supportsUnsafeByteBufferOperations() {
            if (this.unsafe == null) {
                return false;
            }
            try {
                void var1_1;
                Class<?> clazz = this.unsafe.getClass();
                clazz.getMethod("objectFieldOffset", Field.class);
                var1_1.getMethod("getLong", Object.class, Long.TYPE);
                return UnsafeUtil.bufferAddressField() != null;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                UnsafeUtil.access$000(throwable);
                return false;
            }
        }
    }
}

