/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.Android;
import androidx.datastore.preferences.protobuf.Internal;
import androidx.datastore.preferences.protobuf.InvalidProtocolBufferException;
import androidx.datastore.preferences.protobuf.UnsafeUtil;
import java.util.Arrays;

final class Utf8 {
    private static final Processor processor = UnsafeUtil.hasUnsafeArrayOperations() && UnsafeUtil.hasUnsafeByteBufferOperations() && !Android.isOnAndroidDevice() ? new UnsafeProcessor() : new SafeProcessor();

    static boolean isValidUtf8(byte[] bytes) {
        byte[] byArray;
        return processor.isValidUtf8(bytes, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    static boolean isValidUtf8(byte[] bytes, int index, int limit) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        return processor.isValidUtf8(byArray, (int)var1_1, (int)var2_2);
    }

    private static int incompleteStateFor(int byte1) {
        int n;
        if (byte1 > -12) {
            return -1;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static int incompleteStateFor(int byte1, int byte2) {
        void var1_1;
        int n;
        if (byte1 > -12 || byte2 > -65) {
            return -1;
        }
        return n ^ var1_1 << 8;
    }

    /*
     * WARNING - void declaration
     */
    private static int incompleteStateFor(int byte1, int byte2, int byte3) {
        void var2_2;
        void var1_1;
        int n;
        if (byte1 > -12 || byte2 > -65 || byte3 > -65) {
            return -1;
        }
        return n ^ var1_1 << 8 ^ var2_2 << 16;
    }

    /*
     * WARNING - void declaration
     */
    static int encodedLength(CharSequence sequence) {
        void var2_2;
        void var1_1;
        int i;
        int utf16Length;
        int utf8Length = utf16Length = sequence.length();
        for (i = 0; i < utf16Length && sequence.charAt(i) < '\u0080'; ++i) {
        }
        while (i < utf16Length) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                int n = utf8Length;
                utf8Length = i;
                i = sequence.length();
                int n2 = 0;
                while (utf8Length < i) {
                    int n3 = sequence.charAt(utf8Length);
                    if (n3 < 2048) {
                        n2 += 127 - n3 >>> 31;
                    } else {
                        n2 += 2;
                        if (55296 <= n3 && n3 <= 57343) {
                            n3 = Character.codePointAt(sequence, utf8Length);
                            if (n3 < 65536) {
                                throw new UnpairedSurrogateException(utf8Length, i);
                            }
                            ++utf8Length;
                        }
                    }
                    ++utf8Length;
                }
                utf8Length = n + n2;
                break;
            }
            ++i;
        }
        if (utf8Length < var1_1) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)utf8Length + 0x100000000L));
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int encode(CharSequence in, byte[] out, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        return processor.encodeUtf8(charSequence, (byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static String decodeUtf8(byte[] bytes, int index, int size) throws InvalidProtocolBufferException {
        void var2_2;
        void var1_1;
        byte[] byArray;
        return processor.decodeUtf8(byArray, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$000(int x0, int x1) {
        void var1_1;
        return Utf8.incompleteStateFor(x0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$100(int x0, int x1, int x2) {
        void var2_2;
        void var1_1;
        return Utf8.incompleteStateFor(x0, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$1100(byte[] x0, int x1, int x2) {
        void var2_2;
        void var1_1;
        byte[] byArray = x0;
        byte by = x0[var1_1 - true];
        switch (var2_2 - var1_1) {
            case 0: {
                return Utf8.incompleteStateFor(by);
            }
            case 1: {
                return Utf8.incompleteStateFor(by, byArray[var1_1]);
            }
            case 2: {
                return Utf8.incompleteStateFor(by, byArray[var1_1], byArray[var1_1 + true]);
            }
        }
        throw new AssertionError();
    }

    static final class DecodeUtil {
        private static boolean isNotTrailingByte(byte b) {
            return b > -65;
        }

        static /* synthetic */ boolean access$400(byte x0) {
            byte by = x0;
            return by >= 0;
        }

        static /* synthetic */ void access$500(byte x0, char[] x1, int x2) {
            byte by = x0;
            var1_1[var2_2] = (char)by;
        }

        static /* synthetic */ boolean access$600(byte x0) {
            byte by = x0;
            return by < -32;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$700(byte x0, byte x1, char[] x2, int x3) throws InvalidProtocolBufferException {
            void var1_1;
            byte by = x0;
            if (by < -62 || DecodeUtil.isNotTrailingByte((byte)var1_1)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            int n = (by & 0x1F) << 6;
            by = var1_1;
            var2_2[var3_3] = (char)(n | by & 0x3F);
        }

        static /* synthetic */ boolean access$800(byte x0) {
            byte by = x0;
            return by < -16;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$900(byte x0, byte x1, byte x2, char[] x3, int x4) throws InvalidProtocolBufferException {
            void var2_2;
            void var1_1;
            int n = x4;
            byte by = x0;
            if (DecodeUtil.isNotTrailingByte((byte)var1_1) || by == -32 && var1_1 < -96 || by == -19 && var1_1 >= -96 || DecodeUtil.isNotTrailingByte((byte)var2_2)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            int n2 = (by & 0xF) << 12;
            void v1 = var1_1;
            by = v1;
            by = var2_2;
            var3_3[n] = (char)(n2 | (v1 & 0x3F) << 6 | by & 0x3F);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$1000(byte x0, byte x1, byte x2, byte x3, char[] x4, int x5) throws InvalidProtocolBufferException {
            void var3_3;
            void var2_2;
            byte by;
            int n = x5;
            char[] cArray = x4;
            byte by2 = x0;
            if (DecodeUtil.isNotTrailingByte(by) || (by2 << 28) + (by - -112) >> 30 != 0 || DecodeUtil.isNotTrailingByte((byte)var2_2) || DecodeUtil.isNotTrailingByte((byte)var3_3)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            int n2 = (by2 & 7) << 18;
            void v1 = by;
            by2 = v1;
            void v2 = var2_2;
            by2 = v2;
            by2 = var3_3;
            by = by2 = (byte)(n2 | (v1 & 0x3F) << 12 | (v2 & 0x3F) << 6 | by2 & 0x3F);
            cArray[n] = (char)(55232 + (by >>> 10));
            by = by2;
            cArray[n + 1] = (char)(56320 + (by & 0x3FF));
        }
    }

    static final class UnsafeProcessor
    extends Processor {
        UnsafeProcessor() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int partialIsValidUtf8(int state, byte[] bytes, int index, int limit) {
            void var2_2;
            void var3_3;
            if ((index | limit | bytes.length - limit) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("Array length=%d, index=%d, limit=%d", bytes.length, index, limit));
            }
            long offset = (long)var3_3;
            long offsetLimit = limit;
            return UnsafeProcessor.partialIsValidUtf8((byte[])var2_2, offset, (int)(offsetLimit - offset));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final String decodeUtf8(byte[] bytes, int index, int size) throws InvalidProtocolBufferException {
            void var3_3;
            void var1_1;
            void var2_2;
            String s = new String(bytes, index, size, Internal.UTF_8);
            if (!s.contains("\ufffd")) {
                return s;
            }
            void v0 = var2_2;
            if (Arrays.equals(s.getBytes(Internal.UTF_8), Arrays.copyOfRange((byte[])var1_1, (int)v0, (int)(v0 + var3_3)))) {
                return s;
            }
            throw InvalidProtocolBufferException.invalidUtf8();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int encodeUtf8(CharSequence in, byte[] out, int offset, int length) {
            char c;
            int inIx;
            long outIx = offset;
            long outLimit = outIx + (long)length;
            int inLimit = in.length();
            if (inLimit > length || out.length - length < offset) {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + in.charAt(inLimit - 1) + " at index " + (offset + length));
            }
            for (inIx = 0; inIx < inLimit && (c = in.charAt(inIx)) < '\u0080'; ++inIx) {
                UnsafeUtil.putByte(out, outIx++, (byte)c);
            }
            if (inIx == inLimit) {
                return (int)outIx;
            }
            while (inIx < inLimit) {
                c = in.charAt(inIx);
                if (c < '\u0080' && outIx < outLimit) {
                    UnsafeUtil.putByte(out, outIx++, (byte)c);
                } else if (c < '\u0800' && outIx <= outLimit - 2L) {
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x3C0 | c >>> 6));
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & c));
                } else if ((c < '\ud800' || '\udfff' < c) && outIx <= outLimit - 3L) {
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x1E0 | c >>> 12));
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & c >>> 6));
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & c));
                } else if (outIx <= outLimit - 4L) {
                    char low;
                    if (inIx + 1 == inLimit || !Character.isSurrogatePair(c, low = in.charAt(++inIx))) {
                        throw new UnpairedSurrogateException(inIx - 1, inLimit);
                    }
                    int codePoint = Character.toCodePoint(c, low);
                    UnsafeUtil.putByte(out, outIx++, (byte)(0xF0 | codePoint >>> 18));
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & codePoint));
                } else {
                    void var4_4;
                    if (!(55296 > var4_4 || var4_4 > 57343 || inIx + 1 != inLimit && Character.isSurrogatePair((char)var4_4, in.charAt(inIx + 1)))) {
                        throw new UnpairedSurrogateException(inIx, inLimit);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + (char)var4_4 + " at index " + outIx);
                }
                ++inIx;
            }
            return (int)outIx;
        }

        private static int partialIsValidUtf8(byte[] bytes, long offset, int remaining) {
            int n;
            block14: {
                int n2 = remaining;
                long l = offset;
                byte[] byArray = bytes;
                if (n2 < 16) {
                    n = 0;
                } else {
                    int n3;
                    int n4 = 8 - ((int)l & 7);
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (UnsafeUtil.getByte(byArray, l++) >= 0) continue;
                        n = n3;
                        break block14;
                    }
                    while (n3 + 8 <= n2 && (UnsafeUtil.getLong(byArray, UnsafeUtil.BYTE_ARRAY_BASE_OFFSET + l) & 0x8080808080808080L) == 0L) {
                        l += 8L;
                        n3 += 8;
                    }
                    while (n3 < n2) {
                        if (UnsafeUtil.getByte(byArray, l++) < 0) {
                            n = n3;
                            break block14;
                        }
                        ++n3;
                    }
                    n = n2;
                }
            }
            int skipped = n;
            remaining -= skipped;
            offset += (long)skipped;
            while (true) {
                byte byte2;
                int byte1 = 0;
                while (remaining > 0) {
                    byte by = UnsafeUtil.getByte(bytes, offset++);
                    byte1 = by;
                    if (by < 0) break;
                    --remaining;
                }
                if (remaining == 0) {
                    return 0;
                }
                --remaining;
                if (byte1 < -32) {
                    if (remaining == 0) {
                        return byte1;
                    }
                    --remaining;
                    if (byte1 >= -62 && UnsafeUtil.getByte(bytes, offset++) <= -65) continue;
                    return -1;
                }
                if (byte1 < -16) {
                    if (remaining < 2) {
                        return UnsafeProcessor.unsafeIncompleteStateFor(bytes, byte1, offset, remaining);
                    }
                    remaining -= 2;
                    if (!((byte2 = UnsafeUtil.getByte(bytes, offset++)) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96) && UnsafeUtil.getByte(bytes, offset++) <= -65) continue;
                    return -1;
                }
                if (remaining < 3) {
                    return UnsafeProcessor.unsafeIncompleteStateFor(bytes, byte1, offset, remaining);
                }
                remaining -= 3;
                if ((byte2 = UnsafeUtil.getByte(bytes, offset++)) > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || UnsafeUtil.getByte(bytes, offset++) > -65 || UnsafeUtil.getByte(bytes, offset++) > -65) break;
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        private static int unsafeIncompleteStateFor(byte[] bytes, int byte1, long offset, int remaining) {
            switch (remaining) {
                case 0: {
                    return Utf8.incompleteStateFor(byte1);
                }
                case 1: {
                    return Utf8.access$000(byte1, UnsafeUtil.getByte(bytes, offset));
                }
                case 2: {
                    void var2_2;
                    byte[] byArray;
                    void var1_1;
                    return Utf8.access$100((int)var1_1, UnsafeUtil.getByte(bytes, offset), UnsafeUtil.getByte(byArray, (long)(var2_2 + 1L)));
                }
            }
            throw new AssertionError();
        }
    }

    static final class SafeProcessor
    extends Processor {
        SafeProcessor() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int partialIsValidUtf8(int state, byte[] bytes, int index, int limit) {
            void var2_4;
            int n;
            void v0 = n;
            n = limit;
            byte[] byArray = bytes;
            for (var2_4 = v46684; var2_4 < n && byArray[var2_4] >= 0; ++var2_4) {
            }
            if (var2_4 >= n) {
                return 0;
            }
            while (true) {
                byte by;
                byte by2;
                if (var2_4 >= n) {
                    return 0;
                }
                if ((by2 = byArray[var2_4++]) >= 0) continue;
                if (by2 < -32) {
                    if (var2_4 >= n) {
                        return by2;
                    }
                    if (by2 >= -62 && byArray[var2_4++] <= -65) continue;
                    return -1;
                }
                if (by2 < -16) {
                    if (var2_4 >= n - 1) {
                        return Utf8.access$1100(byArray, (int)var2_4, n);
                    }
                    if (!((by = byArray[var2_4++]) > -65 || by2 == -32 && by < -96 || by2 == -19 && by >= -96) && byArray[var2_4++] <= -65) continue;
                    return -1;
                }
                if (var2_4 >= n - 2) {
                    return Utf8.access$1100(byArray, (int)var2_4, n);
                }
                if ((by = byArray[var2_4++]) > -65 || (by2 << 28) + (by - -112) >> 30 != 0 || byArray[var2_4++] > -65 || byArray[var2_4++] > -65) break;
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final String decodeUtf8(byte[] bytes, int index, int size) throws InvalidProtocolBufferException {
            void var3_4;
            byte b;
            int offset;
            if ((index | size | bytes.length - index - size) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, index=%d, size=%d", bytes.length, index, size));
            }
            int limit = offset + size;
            char[] resultArr = new char[size];
            int resultPos = 0;
            for (offset = index; offset < limit && DecodeUtil.access$400(b = bytes[offset]); ++offset) {
                DecodeUtil.access$500(b, resultArr, resultPos++);
            }
            while (offset < limit) {
                void var6_7;
                byte byte1;
                if (DecodeUtil.access$400(byte1 = bytes[offset++])) {
                    DecodeUtil.access$500(byte1, resultArr, resultPos++);
                    while (offset < limit && DecodeUtil.access$400(b = bytes[offset])) {
                        ++offset;
                        DecodeUtil.access$500(b, resultArr, resultPos++);
                    }
                    continue;
                }
                if (DecodeUtil.access$600((byte)var6_7)) {
                    if (offset >= limit) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.access$700((byte)var6_7, bytes[offset++], resultArr, resultPos++);
                    continue;
                }
                if (DecodeUtil.access$800((byte)var6_7)) {
                    if (offset >= limit - 1) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.access$900((byte)var6_7, bytes[offset++], bytes[offset++], resultArr, resultPos++);
                    continue;
                }
                if (offset >= limit - 2) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.access$1000((byte)var6_7, bytes[offset++], bytes[offset++], bytes[offset++], resultArr, resultPos++);
                ++resultPos;
            }
            return new String((char[])var3_4, 0, resultPos);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int encodeUtf8(CharSequence in, byte[] out, int offset, int length) {
            char c;
            int i;
            int utf16Length = in.length();
            int j = offset;
            int limit = offset + length;
            for (i = 0; i < utf16Length && i + j < limit && (c = in.charAt(i)) < '\u0080'; ++i) {
                out[j + i] = (byte)c;
            }
            if (i == utf16Length) {
                return j + utf16Length;
            }
            j += i;
            while (i < utf16Length) {
                c = in.charAt(i);
                if (c < '\u0080' && j < limit) {
                    out[j++] = (byte)c;
                } else if (c < '\u0800' && j <= limit - 2) {
                    out[j++] = (byte)(0x3C0 | c >>> 6);
                    out[j++] = (byte)(0x80 | 0x3F & c);
                } else if ((c < '\ud800' || '\udfff' < c) && j <= limit - 3) {
                    out[j++] = (byte)(0x1E0 | c >>> 12);
                    out[j++] = (byte)(0x80 | 0x3F & c >>> 6);
                    out[j++] = (byte)(0x80 | 0x3F & c);
                } else if (j <= limit - 4) {
                    char low;
                    if (i + 1 == in.length() || !Character.isSurrogatePair(c, low = in.charAt(++i))) {
                        throw new UnpairedSurrogateException(i - 1, utf16Length);
                    }
                    int codePoint = Character.toCodePoint(c, low);
                    out[j++] = (byte)(0xF0 | codePoint >>> 18);
                    out[j++] = (byte)(0x80 | 0x3F & codePoint >>> 12);
                    out[j++] = (byte)(0x80 | 0x3F & codePoint >>> 6);
                    out[j++] = (byte)(0x80 | 0x3F & codePoint);
                } else {
                    void var4_4;
                    if (!(55296 > var4_4 || var4_4 > 57343 || i + 1 != in.length() && Character.isSurrogatePair((char)var4_4, in.charAt(i + 1)))) {
                        throw new UnpairedSurrogateException(i, utf16Length);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + (char)var4_4 + " at index " + j);
                }
                ++i;
            }
            return j;
        }
    }

    static abstract class Processor {
        Processor() {
        }

        /*
         * WARNING - void declaration
         */
        final boolean isValidUtf8(byte[] bytes, int index, int limit) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.partialIsValidUtf8(0, (byte[])var1_1, (int)var2_2, (int)var3_3) == 0;
        }

        abstract int partialIsValidUtf8(int var1, byte[] var2, int var3, int var4);

        abstract String decodeUtf8(byte[] var1, int var2, int var3) throws InvalidProtocolBufferException;

        abstract int encodeUtf8(CharSequence var1, byte[] var2, int var3, int var4);
    }

    static final class UnpairedSurrogateException
    extends IllegalArgumentException {
        /*
         * WARNING - void declaration
         */
        UnpairedSurrogateException(int index, int length) {
            super("Unpaired surrogate at index " + (int)var1_1 + " of " + (int)var2_2);
            void var2_2;
            void var1_1;
        }
    }
}

