/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 72\u00020\u0001:\u00017B\u001a\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006B\"\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001aH&J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\bH&J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\bH&J\b\u0010#\u001a\u00020\bH\u0016J\b\u0010$\u001a\u00020\u0003H\u0016J%\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u001cH\u0010\u00a2\u0006\u0002\b*J\u001e\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u001cJ\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001aH&J%\u0010/\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u001cH\u0010\u00a2\u0006\u0002\b0J@\u00101\u001a\u0002022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\u0000H\u0010\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b5\u00106R\u0011\u0010\n\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u001c\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00068"}, d2={"Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "", "name", "", "model", "Landroidx/compose/ui/graphics/colorspace/ColorModel;", "(Ljava/lang/String;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "id", "", "(Ljava/lang/String;JILkotlin/jvm/internal/DefaultConstructorMarker;)V", "componentCount", "getComponentCount", "()I", "getId$ui_graphics", "isSrgb", "", "()Z", "isWideGamut", "getModel-xdoWZVw", "()J", "J", "getName", "()Ljava/lang/String;", "equals", "other", "fromXyz", "", "x", "", "y", "z", "v", "getMaxValue", "component", "getMinValue", "hashCode", "toString", "toXy", "", "v0", "v1", "v2", "toXy$ui_graphics", "toXyz", "r", "g", "b", "toZ", "toZ$ui_graphics", "xyzaToColor", "Landroidx/compose/ui/graphics/Color;", "a", "colorSpace", "xyzaToColor-JlNiLsg$ui_graphics", "(FFFFLandroidx/compose/ui/graphics/colorspace/ColorSpace;)J", "Companion", "ui-graphics"})
@SourceDebugExtension(value={"SMAP\nColorSpace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorSpace.kt\nandroidx/compose/ui/graphics/colorspace/ColorSpace\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,796:1\n25#2,3:797\n*S KotlinDebug\n*F\n+ 1 ColorSpace.kt\nandroidx/compose/ui/graphics/colorspace/ColorSpace\n*L\n288#1:797,3\n*E\n"})
public abstract class ColorSpace {
    private final String name;
    private final long model;
    private final int id;

    /*
     * WARNING - void declaration
     */
    private ColorSpace(String name, long model, int id) {
        void var2_2;
        void var1_1;
        this.name = var1_1;
        this.model = var2_2;
        this.id = id;
        if (((CharSequence)this.name).length() == 0) {
            throw new IllegalArgumentException("The name of a color space cannot be null and must contain at least 1 character");
        }
        if (this.id < -1 || this.id > 63) {
            throw new IllegalArgumentException("The id must be between -1 and 63");
        }
    }

    public final String getName() {
        return this.name;
    }

    public final long getModel-xdoWZVw() {
        return this.model;
    }

    public final int getId$ui_graphics() {
        return this.id;
    }

    public final int getComponentCount() {
        return ColorModel.getComponentCount-impl(this.model);
    }

    public boolean isSrgb() {
        return false;
    }

    public abstract float getMinValue(int var1);

    public abstract float getMaxValue(int var1);

    /*
     * WARNING - void declaration
     */
    private float[] toXyz(float r, float g, float b) {
        void var3_3;
        void var2_2;
        void var1_1;
        float[] fArray = new float[3];
        float[] fArray2 = fArray;
        fArray[0] = var1_1;
        fArray2[1] = var2_2;
        fArray2[2] = var3_3;
        return this.toXyz(fArray2);
    }

    public abstract float[] toXyz(float[] var1);

    /*
     * WARNING - void declaration
     */
    public long toXy$ui_graphics(float v0, float v1, float v2) {
        void var1_3;
        void var2_4;
        void var3_5;
        float[] xyz = this.toXyz(v0, v1, (float)var3_5);
        v1 = xyz[0];
        float val2$iv = xyz[1];
        long v1$iv = Float.floatToIntBits((float)var2_4);
        long v2$iv = Float.floatToIntBits((float)var1_3);
        return v1$iv << 32 | v2$iv & 0xFFFFFFFFL;
    }

    /*
     * WARNING - void declaration
     */
    public float toZ$ui_graphics(float v0, float v1, float v2) {
        void var3_4;
        void var2_3;
        void var1_1;
        float[] fArray = this.toXyz((float)var1_1, (float)var2_3, (float)var3_4);
        return fArray[2];
    }

    /*
     * WARNING - void declaration
     */
    public long xyzaToColor-JlNiLsg$ui_graphics(float x2, float y, float z, float a, ColorSpace colorSpace) {
        void var1_2;
        float f;
        void var3_4;
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        void var6_7 = var3_4;
        var3_4 = f;
        f = x2;
        ColorSpace x2 = this;
        float[] fArray = new float[ColorModel.getComponentCount-impl(x2.model)];
        float[] fArray2 = fArray;
        fArray[0] = f;
        fArray2[1] = var3_4;
        fArray2[2] = var6_7;
        float[] colors = x2.fromXyz(fArray2);
        return ColorKt.Color(colors[0], colors[1], (float)var1_2[2], a, colorSpace);
    }

    public abstract float[] fromXyz(float[] var1);

    public String toString() {
        return this.name + " (id=" + this.id + ", model=" + ColorModel.toString-impl(this.model) + ')';
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ColorSpace that = (ColorSpace)other;
        if (this.id != that.id) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)that.name)) {
            return false;
        }
        return ColorModel.equals-impl0(this.model, var1_1.model);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.name.hashCode();
        result = result * 31 + ColorModel.hashCode-impl(this.model);
        var1_1 = var1_1 * 31 + this.id;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ ColorSpace(String name, long model, int id, byte by) {
        this((String)var1_1, (long)var2_2, id);
        void var2_2;
        void var1_1;
    }

    static {
        new Companion(0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/compose/ui/graphics/colorspace/ColorSpace$Companion;", "", "()V", "MaxId", "", "MinId", "ui-graphics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

