/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.internal.CharArrayPool;
import kotlinx.serialization.json.internal.JsonWriter;
import kotlinx.serialization.json.internal.StringOpsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\b\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\fH\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkotlinx/serialization/json/internal/JsonToStringWriter;", "Lkotlinx/serialization/json/internal/JsonWriter;", "()V", "array", "", "size", "", "appendStringSlowPath", "", "firstEscapedChar", "currentSize", "string", "", "ensureAdditionalCapacity", "expected", "ensureTotalCapacity", "oldSize", "additional", "release", "toString", "write", "text", "writeChar", "char", "", "writeLong", "value", "", "writeQuoted", "kotlinx-serialization-json"})
public final class JsonToStringWriter
implements JsonWriter {
    private char[] array = CharArrayPool.INSTANCE.take();
    private int size;

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeLong(long value) {
        void var1_1;
        this.write(String.valueOf((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeChar(char c) {
        void var1_1;
        this.ensureAdditionalCapacity(1);
        int n = this.size;
        this.size = n + 1;
        this.array[n] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(String text) {
        void var2_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int length = text.length();
        if (length == 0) {
            return;
        }
        this.ensureAdditionalCapacity(length);
        String string = text;
        char[] cArray = this.array;
        int n = this.size;
        int n2 = var1_1.length();
        string.getChars(0, n2, cArray, n);
        this.size += var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeQuoted(String text) {
        void var3_4;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.ensureAdditionalCapacity(((String)text).length() + 2);
        char[] arr2 = this.array;
        int sz = this.size;
        arr2[sz++] = 34;
        int length2 = ((String)text).length();
        String string = text;
        string.getChars(0, length2, arr2, sz);
        int n = sz + length2;
        for (int i = sz; i < n; ++i) {
            char ch = arr2[i];
            if (ch >= StringOpsKt.getESCAPE_MARKERS().length || StringOpsKt.getESCAPE_MARKERS()[ch] == 0) continue;
            int n2 = i - sz;
            String length2 = text;
            sz = i;
            int arr2 = n2;
            text = this;
            i = length2.length();
            while (arr2 < i) {
                byte by;
                sz = super.ensureTotalCapacity(sz, 2);
                char c = length2.charAt(arr2);
                n = c;
                if (c < StringOpsKt.getESCAPE_MARKERS().length && (by = StringOpsKt.getESCAPE_MARKERS()[n]) != 0) {
                    if (by == 1) {
                        String string2;
                        Intrinsics.checkNotNull((Object)StringOpsKt.getESCAPE_STRINGS()[n]);
                        sz = super.ensureTotalCapacity(sz, string2.length());
                        String string3 = string2;
                        char[] cArray = ((JsonToStringWriter)text).array;
                        int n3 = string2.length();
                        string3.getChars(0, n3, cArray, sz);
                        ((JsonToStringWriter)text).size = sz += string2.length();
                    } else {
                        ((JsonToStringWriter)text).array[sz] = 92;
                        ((JsonToStringWriter)text).array[sz + 1] = (char)by;
                        ((JsonToStringWriter)text).size = sz += 2;
                    }
                } else {
                    ((JsonToStringWriter)text).array[sz++] = (char)n;
                }
                ++arr2;
            }
            sz = super.ensureTotalCapacity(sz, 1);
            ((JsonToStringWriter)text).array[sz++] = 34;
            ((JsonToStringWriter)text).size = sz;
            return;
        }
        sz += length2;
        var2_2[sz++] = 34;
        this.size = var3_4;
    }

    public final void release() {
        CharArrayPool.INSTANCE.release(this.array);
    }

    public final String toString() {
        return new String(this.array, 0, this.size);
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureAdditionalCapacity(int expected) {
        void var1_1;
        JsonToStringWriter jsonToStringWriter = this;
        jsonToStringWriter.ensureTotalCapacity(jsonToStringWriter.size, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final int ensureTotalCapacity(int oldSize, int additional) {
        void var1_1;
        int newSize = oldSize + additional;
        if (this.array.length <= newSize) {
            void var2_2;
            char[] cArray = Arrays.copyOf(this.array, RangesKt.coerceAtLeast((int)var2_2, (int)(oldSize << 1)));
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"copyOf(this, newSize)");
            this.array = cArray;
        }
        return (int)var1_1;
    }
}

