/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import androidx.compose.animation.core.AnimationSpecKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.AbstractJsonLexer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J3\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\b2!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u000f0\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0019H\u0016J\b\u0010\u001c\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lkotlinx/serialization/json/internal/StringJsonLexer;", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "source", "", "(Ljava/lang/String;)V", "getSource", "()Ljava/lang/String;", "canConsumeValue", "", "consumeKeyString", "consumeLeadingMatchingValue", "keyToMatch", "isLenient", "consumeNextToken", "", "", "expected", "", "consumeStringChunked", "consumeChunk", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "stringChunk", "prefetchOrEof", "", "position", "skipWhitespaces", "tryConsumeComma", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nStringJsonLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringJsonLexer.kt\nkotlinx/serialization/json/internal/StringJsonLexer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1855#2,2:123\n*S KotlinDebug\n*F\n+ 1 StringJsonLexer.kt\nkotlinx/serialization/json/internal/StringJsonLexer\n*L\n101#1:123,2\n*E\n"})
public final class StringJsonLexer
extends AbstractJsonLexer {
    private final String source;

    /*
     * WARNING - void declaration
     */
    public StringJsonLexer(String source) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int prefetchOrEof(int position) {
        StringJsonLexer stringJsonLexer = this;
        if (position < stringJsonLexer.source.length()) {
            void var1_1;
            return (int)var1_1;
        }
        return -1;
    }

    @Override
    public final byte consumeNextToken() {
        StringJsonLexer stringJsonLexer = this;
        String source = stringJsonLexer.source;
        while (this.currentPosition != -1 && this.currentPosition < source.length()) {
            byte by = this.currentPosition;
            this.currentPosition = by + 1;
            char c = source.charAt(by);
            by = (byte)c;
            byte by2 = AnimationSpecKt.charToTokenClass((char)c);
            by = by2;
            if (by2 == 3) continue;
            return by;
        }
        return 10;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean tryConsumeComma() {
        void var1_1;
        int current = this.skipWhitespaces();
        StringJsonLexer stringJsonLexer = this;
        if (current == stringJsonLexer.source.length() || current == -1) {
            return false;
        }
        stringJsonLexer = this;
        if (stringJsonLexer.source.charAt((int)var1_1) == ',') {
            ++this.currentPosition;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean canConsumeValue() {
        void var1_1;
        block2: {
            void var2_2;
            int current = this.currentPosition;
            if (current == -1) {
                return false;
            }
            while (true) {
                StringJsonLexer stringJsonLexer = this;
                if (current >= stringJsonLexer.source.length()) break block2;
                stringJsonLexer = this;
                char c = stringJsonLexer.source.charAt(current);
                if (c != ' ' && c != '\n' && c != '\r' && c != '\t') break;
                ++current;
            }
            this.currentPosition = current;
            void v0 = var2_2;
            current = v0;
            current = v0;
            return !(((v0 == 125 ? true : current == 93) ? true : current == 58) ? true : current == 44);
        }
        this.currentPosition = var1_1;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int skipWhitespaces() {
        void var1_1;
        int current = this.currentPosition;
        if (current == -1) {
            return current;
        }
        while (true) {
            void var2_2;
            StringJsonLexer stringJsonLexer = this;
            if (current >= stringJsonLexer.source.length()) break;
            stringJsonLexer = this;
            char c = stringJsonLexer.source.charAt(current);
            if (c != ' ' && c != '\n' && c != '\r' && var2_2 != 9) break;
            ++current;
        }
        this.currentPosition = current;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void consumeNextToken(char expected) {
        void var1_1;
        if (this.currentPosition == -1) {
            this.unexpectedToken(expected);
        }
        StringJsonLexer stringJsonLexer = this;
        String source = stringJsonLexer.source;
        while (this.currentPosition < source.length()) {
            int n = this.currentPosition;
            this.currentPosition = n + 1;
            char c = source.charAt(n);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') continue;
            if (n == expected) {
                return;
            }
            this.unexpectedToken(expected);
        }
        this.unexpectedToken((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String consumeKeyString() {
        void var2_3;
        void var1_1;
        this.consumeNextToken('\"');
        int current = this.currentPosition;
        StringJsonLexer stringJsonLexer = this;
        int closingQuote = StringsKt.indexOf$default((CharSequence)stringJsonLexer.source, (char)'\"', (int)current, (boolean)false, (int)4, null);
        if (closingQuote == -1) {
            this.fail$kotlinx_serialization_json((byte)1);
            throw new KotlinNothingValueException();
        }
        for (int i = current; i < closingQuote; ++i) {
            stringJsonLexer = this;
            if (stringJsonLexer.source.charAt(i) != '\\') continue;
            stringJsonLexer = this;
            return stringJsonLexer.consumeString(stringJsonLexer.source, this.currentPosition, i);
        }
        this.currentPosition = closingQuote + 1;
        stringJsonLexer = this;
        String string = stringJsonLexer.source.substring((int)var1_1, (int)var2_3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String consumeLeadingMatchingValue(String keyToMatch, boolean isLenient) {
        String string;
        int positionSnapshot;
        block5: {
            void var2_2;
            block6: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)keyToMatch, (String)"keyToMatch");
                    positionSnapshot = this.currentPosition;
                    try {
                        if (this.consumeNextToken() == 6) break block4;
                        String string2 = null;
                        this.currentPosition = positionSnapshot;
                        return string2;
                    }
                    catch (Throwable throwable) {
                        void var3_3;
                        this.currentPosition = var3_3;
                        throw throwable;
                    }
                }
                String string3 = isLenient ? this.consumeKeyString() : this.consumeStringLenientNotNull();
                if (!Intrinsics.areEqual((Object)string3, (Object)string)) break block5;
                if (this.consumeNextToken() == 5) break block6;
                string = null;
                this.currentPosition = positionSnapshot;
                return string;
            }
            string = var2_2 != false ? this.consumeString() : this.consumeStringLenientNotNull();
            string = string;
            this.currentPosition = positionSnapshot;
            return string;
        }
        string = null;
        this.currentPosition = positionSnapshot;
        return string;
    }
}

